      subroutine depth_iso (d,fval,f,z,im,jm,km,spval)
c
c=======================================================================
c  Copyright (c) 1998 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This routine computes the depth of requested isosurface.          ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     d        Depths of isosurface (m).                             ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     fval     Isosurface value (real scalar).                       ===
c     f        Field to process (real array).                        ===
c     z        Depths of field (real array; m).                      ===
c     im       Number of points in the XI-direction.                 ===
c     jm       Number of points in the ETA-direction.                ===
c     km       Number of points in the S-direction.                  ===
c     spval    Special value for missing data.                       ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local variables.
c-----------------------------------------------------------------------
c
      integer i, im, j, jm, k, km
      real c1, delta, fac1, fac2, fval, spval
      real d(im,jm), f(im,jm,km), z(im,jm,km)
      parameter (c1=1.0)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
c  Initialize depths with special values.
c
      do j=1,jm
        do i=1,im
          d(i,j)=spval
        enddo
      enddo
c
c  Find depths of isosurfave via interpolation starting from the bottom.
c
      do j=1,jm
        do i=1,im
          do k=1,km-1
            if ((f(i,j,k).ge.fval).and.(fval.gt.f(i,j,k+1))) then
              delta=c1/(f(i,j,k)-f(i,j,k+1))
              fac1=(fval-f(i,j,k+1))*delta
              fac2=(f(i,j,k)-fval)*delta
              d(i,j)=fac1*z(i,j,k)+fac2*z(i,j,k+1)
              goto 10
            elseif ((f(i,j,k).lt.fval).and.(fval.le.f(i,j,k+1))) then
              delta=c1/(f(i,j,k+1)-f(i,j,k))
              fac1=(f(i,j,k+1)-fval)*delta
              fac2=(fval-f(i,j,k))*delta
              d(i,j)=fac1*z(i,j,k)+fac2*z(i,j,k+1)
              goto 10
            endif
          enddo
  10      continue
        enddo
      enddo
      return
      end
