      subroutine datestr (iyear,yday,hour,datelab)
c
c=======================================================================
c  Copyright (c) 1996 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This routine sets a date label given the year IYEAR and the       ===
c  year day YDAY.                                                    ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define local data.
c-----------------------------------------------------------------------
c
      implicit none
      integer ileap, imonth, ihour, it, iyear, jyr, max
      integer iyd(13), iydl(13)
      real hour, minute, yday
      character*3   month(12)
      character*19  datelab
      parameter (max=600)
      data iyd  /1,32,60,91,121,152,182,213,244,274,305,335,366/
      data iydl /1,32,61,92,122,153,183,214,245,275,306,336,367/
      data month /'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
     &            'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec' /
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      it=nint(yday)
      jyr=iyear
      if ((it.le.0).or.(it.ge.max)) then
        write(datelab,1) it
  1     format(10a1,i4)
        return
      endif
      imonth=0
c
  100 continue
      ileap=mod(jyr,4)
      if (ileap.eq.0) then
  105   imonth=imonth+1
        if (imonth.eq.14) then
          jyr=jyr+1
          it=it-366
          imonth=0
          goto 100
        endif
        if (it.ge.iydl(imonth)) goto 105
        imonth=imonth-1
        it=it-iydl(imonth)+1
      else
  107   imonth=imonth+1
        if (imonth.eq.14) then
          jyr=jyr+1
          it=it-365
          imonth=0
          goto 100
        endif
        if (it.ge.iyd(imonth)) goto 107
        imonth=imonth-1
        it=it-iyd(imonth)+1
      endif
c 
c  Build date label.
c
      if ((1.le.imonth).and.(imonth.le.12)) then
        ihour=int(hour)
        minute=(hour-aint(hour))*60.0
        write(datelab,2) it, month(imonth), jyr, ihour, int(minute)
 2      format(i2,1x,a3,1x,i4,1x,'-',1x,i2.2,':',i2.2)
      endif
      return
      end
