      subroutine cvector (u,v, im,jm,km, uu,imu,jmu, vv,imv,jmv,
     &                                     igrid, ncid, gotangle)
!
! Compute vector components at density-points or streamfunction points
! from their values at staggered locations.
!
! Input:  km    Number of vertical levels.
!         uu    Vector component in the XI-direction at U-points.
!         imu   Size of "uu" inner dimension.
!         jmu   Size of "uu" outer dimension.
!         vv    Vector component in the ETA-direction at V-points.
!         imv   Size of "vv" inner dimension.
!         jmv   Size of "vv" outer dimension.
!         igrid Staggered C-grid location:
!                       igrid=2  => streamfunction points.
!                       igrid=7  => interior density points.
!         ncid  netCDF ID for input file (integer).
!
! Output: u   Vector component in the XI-direction at RHO/PSI-points.
!         v   Vector component in the ETA-direction at RHO/PSI-points.
!         im       Size of "u" and "v" inner dimension.
!         jm       Size of "u" and "v" outer dimension.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      logical gotangle
      integer im,jm,km, imu,jmu, imv,jmv, igrid, ncid
      real u(*), v(*), uu(imu,jmu,km), vv(imv,jmv,km)

      character angnam*8
      real CSA,SNA, angle, spv, uxi, veta
      integer imr,jmr, irgrid, angid, i,j,k, ij

#include "param.h"
#include "fields.h"
#include "pltfld.h"
#if VERBOSE > 2 
      write(*,'(1x,A,I1,1x,A,L1,A)') 'Enter cvector: igrid =',
     &                   igrid, 'gotangle = ', gotangle, '...'
#endif
!
! Vector components in the XI- and ETA-directions.
! If appropriate, rotate vectors from (XI,ETA) to (lon,lat).
!
      if (spherical .and. gotangle) then
        angnam='angle'
        call get_nc2dat (theta, NH, imr,jmr, ncid, 0, angnam, 0,
     &                                        irgrid,angid, spv)
        if (igrid.eq.7) then
          im=imu-1                      ! Curvilinear coordinates,
          jm=jmv-1                      ! interpolate to "interior"
          do j=1,jm                     ! RHO-points and rotate.
            do i=1,im
              ij=i+1+im*j
              CSA=cos(theta(ij))
              SNA=sin(theta(ij))
              do k=1,km
                uxi =0.5*(uu(i,j+1,k)+uu(i+1,j+1,k))
                veta=0.5*(vv(i+1,j,k)+vv(i+1,j+1,k))
                ij=i+im*(j-1+jm*(k-1))
                u(ij)=CSA*uxi-SNA*veta
                v(ij)=SNA*uxi+CSA*veta
              enddo
            enddo
          enddo
        elseif (igrid.eq.2) then        ! Curvilinear coordinates,   
          im=imu                        ! interpolate to PSI-points
          jm=jmv                        ! and rotate.
          do j=1,jm
            do i=1,im
              ij=i+im*(j-1)
              angle=0.25*( theta(ij  )+theta(ij  +imr)
     &                    +theta(ij+1)+theta(ij+1+imr))
              CSA=cos(angle)
              SNA=sin(angle)
              do k=1,km
                uxi =0.5*(uu(i,j,k)+uu(i,j+1,k))
                veta=0.5*(vv(i,j,k)+vv(i+1,j,k))
                ij=i+im*(j-1+jm*(k-1))
                u(ij)=CSA*uxi-SNA*veta
                v(ij)=SNA*uxi+CSA*veta
              enddo
            enddo
          enddo
        endif
      elseif (igrid.eq.7) then          ! Cartezian coordinates:
        im=imu-1                        ! interpolate to RHO-points.
        jm=jmv-1
        do k=1,km
          do j=1,jm
            do i=1,im
              ij=i+im*(j-1+jm*(k-1))
              u(ij)=0.5*(uu(i,j+1,k)+uu(i+1,j+1,k))
              v(ij)=0.5*(vv(i+1,j,k)+vv(i+1,j+1,k))
            enddo
          enddo
        enddo
      elseif (igrid.eq.2) then          ! Cartezian coordinates:
        im=imu                          ! interpolate to PSI-points.
        jm=jmv
        do k=1,km
          do j=1,jm
            do i=1,im
              ij=i+im*(j-1+jm*(k-1))
              u(ij)=0.5*(uu(i,j,k)+uu(i,j+1,k))
              v(ij)=0.5*(vv(i,j,k)+vv(i+1,j,k))
            enddo
          enddo
        enddo
      endif
#if VERBOSE > 2
      write(*,'(1x,A)') '...return from cvector.'
#endif
      return
      end
