      subroutine curlz (curl,L,M,u,v,pm,pn)
c
c=======================================================================
c  Copyright (c) 1997 Rutgers University                             ===
c=======================================================================
c                                                                    ===
c  This routine computes the vertical curl of a 2d vector field.     ===
c                                                                    ===
c  On Input:                                                         ===
c                                                                    ===
c     L        Number of grid points in the XI-direction.            ===
c     M        Number of grid points in the ETA-direction.           ===
c     u        Field component in the XI-direction.                  ===
c     v        Field component in the ETA-direction.                 ===
c     pm       Coordinate transformation metric "m" (1/meters)       ===
c              associated with the differential distances in XI.     ===
c     pn       Coordinate transformation metric "n" (1/meters)       ===
c              associated with the differential distances in ETA.    ===
c                                                                    ===
c  On Output:                                                        ===
c                                                                    ===
c     curl     Vertical curl of field.                               ===
c                                                                    ===
c=======================================================================
c
c-----------------------------------------------------------------------
c  Define global variables.
c-----------------------------------------------------------------------
c
      implicit none
#include "domdat.h"
c
c-----------------------------------------------------------------------
c  Define local variables.
c-----------------------------------------------------------------------
c
      integer L, Lm, M, Mm, i, j
      real p5
      real curl(L-1,M-1), pm(0:L,0:M), pn(0:L,0:M), u(L,0:M), v(0:L,M)
      parameter (p5=0.5)
c
c=======================================================================
c  Begin executable code.
c=======================================================================
c
      Lm=L-1
      Mm=M-1
c
c-----------------------------------------------------------------------
c  Compute vertical curl.
c-----------------------------------------------------------------------
c
      do j=2,Mm
        do i=2,Lm
          curl(i,j)=pm(i,j)*pn(i,j)*
     &              ((v(i  ,j)/(p5*(pn(i  ,j)+pn(i  ,j-1)))- 
     &                v(i-1,j)/(p5*(pn(i-1,j)+pn(i-1,j-1))))-
     &               (u(i,j  )/(p5*(pm(i,j  )+pm(i-1,j  )))- 
     &                u(i,j-1)/(p5*(pm(i,j-1)+pm(i-1,j-1)))))
        enddo
      enddo
c
c  Pad out vaules at the edges.
c
      do j=2,Mm
        curl(1,j)=curl(2,j)
      enddo
      do i=2,Lm
        curl(i,1)=curl(i,2)
      enddo
      curl(1,1)=p5*(curl(2,1 )+curl(1,2))
      return
      end
