!
! Plot vertical section of the desired field(s) at the given 
! time(s) using NCAR GKS plotting package. Unified code for COLOR
! or MONOCHROME versions.
!
! Copyright (c) 1996 Rutgers University
!
#ifdef MONOCHROME 
      program sec
#else
      program csec
#endif
      implicit none
      real*8 day
      real isopyc, lev, fmin,fmax, favg, frms, fsdv,
     &                  cmin,cmax, cint, cntint
      integer ipos, imask, icolor, i, ictime, igrid,
     &                     page_number,  indx, np
      parameter (isopyc=20000., ipos=1, imask=0,
#ifdef MONOCHROME
     &                                  icolor=0)
#else
     &                                  icolor=1)
#endif

#include "ndimen.h"
#include "param.h"
#include "pconst.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltio.h"
#include "pltncar.h"
#include "secbath.h"
#include "secpos.h"
#include "cntwkspa.h"
                                   ! Set switch for plot type.
      plttyp=secplt                ! Read in plot job parameters,
      call read_inputs(iwrk)       ! default settings, and variable
      page_number=0                ! IDs. Reset page number counter,
      ipltpg=0                     ! counter of plots within the page
      gks_open=.false.             ! and and gks_open flag to signal
      ictime=1                     ! that NCAR GKS is not in active
      day=frstd                    ! state yet. Set level to zero to
      lev=0.                       ! process all available levels.

      do while (frstd.le.day .and. day.le.lastd)
        call get_pltday (day, ictime)
        do indx=1,nfields
          if (.not.gks_open) then
            gks_open=.true.
            call gks_init (postscript, page_number, icolor,ifill)
          endif
!
! Read in primary field at specified time:
!===== == ======= ======= ========== =====
!
          timedepend=.false.
          call get_3dfld (day,  x,y,z, f1,f2, np,  igrid, 1,
     &                                       fldid(indx), lev)
          if (iref.eq.3) then
            call get_3dfld (day,  x,y,z,  f3,f4, np, igrid, 2,
     &                                       fldid(indx), lev)
            do i=1,np
              f1(i)=f1(i)-f3(i)
              f2(i)=f2(i)-f4(i)
            enddo
          elseif (iref.eq.4) then
            call get_3dfld (frstd, x,y,z, f3,f4, np, igrid, 1,
     &                                       fldid(indx), lev)
            do i=1,np
              f1(i)=f3(i)-f1(i)
              f2(i)=f4(i)-f2(i)
            enddo
          endif
!
! Get section coordinates, then extract/interpolate the requested
! section for primary field. If plotting a vector component, process
! the other component, then rotate to section coordinates. Notice
! that X- and Y-position are saved in this case, since arrays "x,y"
! are over-written by "xsection".
!
          call get_scoor (x,y, im,jm)
          if (vcode(fldid(indx)) .eq. 'IDUTOT' .or.
     &        vcode(fldid(indx)) .eq. 'IDVTOT'  .or.
     &        vcode(fldid(indx)) .eq. 'IDUCLI'  .or.
     &        vcode(fldid(indx)) .eq. 'IDVCLI') then
            do i=1,np
              f3(i)=x(i)
              f4(i)=y(i)
            enddo
            call xsection (f6, ims,kms, f1,f3,f4,z, im,jm,km,
     &                                      vintrp,   spval1)
            call xsection (f1, ims,kms, f2,f3,f4,z, im,jm,km,
     &                                      vintrp,   spval1)
            call sec_rotvec (f2,f6,f1, ims,kms, fldid(indx),
     &                                                spval1)
          else
            call xsection (f2, ims,kms, f1,x, y, z, im,jm,km,
     &                                      vintrp,   spval1)
          endif
!                                            ! Set area mask, if any
! Plot primary field:                        ! then set section frame 
!----- ------- ------                        ! and contour primary 
!                                            ! scalar field.
          plot1=scalar
          lland=.false.
          call sec_set_frame (icolor, ipos)

          call fdiag (f2, ims,kms, fldid(indx), day, isopyc,
     &                            fmin,fmax, favg, frms,fsdv)
          if (pmin(indx).ne.0. .or. pmax(indx).ne.0.) then
            cmin=pmin(indx)
            cmax=pmax(indx)
          elseif (sdv_fac.eq.0.) then
            cmin=fmin
            cmax=fmax
          else
            cmin=max(fmin, favg-sdv_fac*fsdv)
            cmax=min(fmax, favg+sdv_fac*fsdv)
          endif
#ifdef MONOCHROME
          if (cntval(indx).ne.0.) then
            cint=cntval(indx)
          else
            cint=cntint(fldid(indx),1,cmin,cmax, cont,cfld,clev)
          endif
          call cntpack (f2,ims,ims,kms,cmin,cmax,cint,imask,icolor)
#else
          call cntcolor (f2, ims,ims,kms, cmin,cmax)
          if (lclrbar) call colorbar (cmin,cmax, ipos)
#endif
!
! Read in overlay field, if needed:
!===== == ======= ====== == =======
!
          if ((iref.eq.1 .or. iref.eq.2) .and.idover(indx).ne.0) then
            call get_3dfld (day, x,y,z, f3,f4, np, igrid, iref,
     &                                         idover(indx), lev)
!
! Get section coordinates and extract/interpolate requested section
! for primary field.
!
            call get_scoor (x,y, im,jm)
            call xsection (f4,ims,kms, f3,x,y,z, im,jm,km,
     &                                     vintrp,   spval1)
          endif
!                               ! Note that if iref=3 or 4, overlay 
! Plot overlay field:           ! field is already computed above as
!----- ------- ------           ! as the difference from reference
!                               ! field.
          if (iref.ne.0) then
            plot2=scalar
            call fdiag (f4, ims,kms, idover(indx), day, isopyc,
     &                                fmin,fmax, favg, frms,fsdv)
            if (rmin(indx).ne.0. .or. rmax(indx).ne.0.) then
              cmin=rmin(indx)
              cmax=rmax(indx)
            elseif (sdv_fac.eq.0.) then
              cmin=fmin
              cmax=fmax
            else
              cmin=max(fmin,favg-sdv_fac*fsdv)
              cmax=min(fmax,favg+sdv_fac*fsdv)
            endif
            cint=cntint (idover(indx),1, cmin,cmax,cont,cfld,clev)
            call cntpack (f4, ims,ims,kms,  cmin,cmax, cint, imask,
#ifdef MONOCHROME
     &                                                      icolor)
#else
     &                                                    icolor+1)
            fmin=cmin
            fmax=cmax
#endif
          endif                      ! Draw vertical background and
                                     ! advance frame when appropriate
          call sec_end_frame (im,jm)
          call maptitles (day, cint, fmin,fmax,frms,
     &                   icolor, fldid(indx), 0., ipos)
          if (close_page) then
            call frame
            if (postscript) then     ! PostScript file sequence:
              call gdawk(1)          ! Close NCAR GKS completely,
              call gclwk(1)          ! be reopen and new file
              call gclks             ! with different name will be 
              gks_open=.false.       ! created for the next page.
            endif 
          endif
        enddo
      enddo                          ! Close GKS software
      call crash ('DONE',1)          ! and datasets.
      stop
      end

