      subroutine crash (string, ierr)
!
! Terminate execution during normal or abnormal computations.
! All output units are properly flushed and closed.
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer ierr
      character*(*) string
#include "param.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltncar.h"
#include "netcdf.inc"

      if (gks_open) then
        if (postscript) then
          gks_open=.false.
          call gdawk(1)
          call gclwk(1)
          call gclks
        else
          call clsgks           ! Close GKS software.
        endif
      endif

      ierr=nf_close(ncid1)      ! Close input netCDF files.
      if (iref.eq.2 .or. iref.eq.3) ierr=nf_close(ncid2)

      if (string(1:4).eq.'DONE') then
        write(*,'(/A/)') string
      else
        write(*,'(/A21,1x,A21,1x,A)') ' Execution abnormally',
     &                        'terminated in module:', string
      endif
      stop
      end

      subroutine close_to_reopen (ierr) 
      implicit none
      integer ierr
#include "param.h"
#include "ncinfo.h"
#include "pltio.h"
#include "netcdf.inc"
      ierr=nf_close(ncid1)      ! Close input netCDF files.
      if (grid(1:4) .ne. 'none') ierr=nf_close(ncgrd)
      if (reference(1)(1:4) .ne. 'none') ierr=nf_close(ncid2)
      return
      end

