      subroutine cpmpxy (imap, xinp,yinp, xotp,yotp)
!
! WARNING: This subroutine is not called directly by the plotting
!          package, but rather called internally from NCAR Graphics
!          library (basically it overwrites an internal NCAR library
!          routine. NAME OF THIS SUBROUTINE AS WELL AS NUMBER AND
!          ORDER OF ITS ARGUMENTS MUST NOT BE CHANGED UNDER ANY
!          CIRCUMSTANCES.
!
! Locate contours in the map defined by the user.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
#include "fields.h"
#include "secpos.h"
      integer imap, i,j, ip
      real xinp,yinp, xotp,yotp, cffX,cffY 

c**   write(*,'(1x,A,I2,$)') 'Enter cpmpxy (cpmpxz2d.F)...', imap
!
! The incoming XINP and YINP coordinates are assumed to represent
! longitude and latitude, respectively.  The EZMAP routine MAPTRN
! is called to find the X- and Y-coordinates of the projection of
! the specified point on the globe,  and those coordinates are
! returned as the outgoing XOTP and YOTP.
!
      if (imap.eq.1) then
        call maptrn (yinp,xinp, xotp,yotp)
!
! The incoming XINP and YINP coordinates are assumed to represent
! RHO and THETA (in degrees) in polar coordinates. The output XINP
! and YINP coordinates are computed from these.
!
      elseif (imap.eq.2) then
        xotp=xinp*cos(0.017453292519943*yinp)
        yotp=xinp*sin(0.017453292519943*yinp)
!
! User coordinate mapping. Interpolate from User grid.
!
      elseif (imap.eq.3 .or. imap.eq.4) then
        i=int(xinp)
        j=int(yinp)
        cffX=xinp-aint(xinp)
        cffY=yinp-aint(yinp)
        ip=i+(j-1)*ims
        xotp=(1.-cffY)*((1.-cffX)*x(ip    ) + cffX*x(ip    +1))
     &          +cffY *((1.-cffX)*x(ip+ims) + cffX*x(ip+ims+1))

        yotp=(1.-cffY)*((1.-cffX)*y(ip    ) + cffX*y(ip    +1))
     &          +cffY *((1.-cffX)*y(ip+ims) + cffX*y(ip+ims+1))

      else                         ! If IMAP is anything else,
        xotp=xinp                  ! input coordinates XINP and
        yotp=yinp                  ! YINP are simply returned.
      endif
c**   write(*,'(A)') '...return from cpmpxy'
      return
      end
