      subroutine cpmpxy (imap, xinp,yinp, xotp,yotp)
!
! WARNING: This subroutine is not called directly by the plotting
!          package, but rather called internally from NCAR Graphics
!          library (basically it overwrites an internal NCAR library
!          routine. NAME OF THIS SUBROUTINE AS WELL AS NUMBER AND
!          ORDER OF ITS ARGUMENTS MUST NOT BE CHANGED UNDER ANY
!          CIRCUMSTANCES.
!
! Locate contours in the map defined by the user.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "param.h"
#include "fields.h"
#include "ndimen.h"

      integer imap, i,j, ip
      real xinp,yinp, xotp,yotp, u,v, x1,x2,x3,x4, y1,y2,y3,y4
!
! The incoming XINP and YINP coordinates are assumed to represent
! longitude and latitude, respectively.  The EZMAP routine MAPTRN
! is called to find the X- and Y-coordinates of the projection of
! the specified point on the globe,  and those coordinates are
! returned as the outgoing XOTP and YOTP.
!
      if (imap.eq.1) then
        call maptrn(yinp,xinp,xotp,yotp)
!
! The incoming XINP and YINP coordinates are assumed to represent
! RHO and THETA (in degrees) in polar coordinates. The output XOTP
! and YOTP coordinates are computed from these.
!
      elseif(imap.eq.2) then
        xotp=xinp*cos(0.017453292519943*yinp)
        yotp=xinp*sin(0.017453292519943*yinp)
!
! User spherical coordinate mapping. Interpolate from User grid.
!
      elseif(imap.eq.3) then
        i=int(xinp)
        j=int(yinp)
        u=xinp-aint(xinp)
        v=yinp-aint(yinp)
        ip=i+(j-1)*im
        call maptrn(y(ip),x(ip),x1,y1)
        call maptrn(y(ip+1),x(ip+1),x2,y2)
        call maptrn(y(ip+im+1),x(ip+im+1),x3,y3)
        call maptrn(y(ip+im),x(ip+im),x4,y4)
        xotp=(1.-u)*(1.-v)*x1+u*(1.-v)*x2+u*v*x3+v*(1.-u)*x4
        yotp=(1.-u)*(1.-v)*y1+u*(1.-v)*y2+u*v*y3+v*(1.-u)*y4
!
! User Cartesian coordinate mapping.  Interpolate from User grid.
!
      elseif(imap.eq.4) then
        i=int(xinp)
        j=int(yinp)
        u=xinp-aint(xinp)
        v=yinp-aint(yinp)
        ip=i+(j-1)*im
        x1=x(ip)
        x2=x(ip+1)
        x3=x(ip+im+1)
        x4=x(ip+im)
        y1=y(ip)
        y2=y(ip+1)
        y3=y(ip+im+1)
        y4=y(ip+im)
        xotp=(1.-u)*(1.-v)*x1+u*(1.-v)*x2+u*v*x3+v*(1.-u)*x4
        yotp=(1.-u)*(1.-v)*y1+u*(1.-v)*y2+u*v*y3+v*(1.-u)*y4
!
! If IMAP is anything else, the input XINP and YINP coordinates are
! simply returned.
!
      else
        xotp=xinp
        yotp=yinp
      endif
      return
      end
