      SUBROUTINE CPCLDR (ZDAT,RWRK,IWRK)
!
! WARNING: Since this subroutine is a part of NCAR Graphics Library,
!          the order of placement of variables into common blocks
!          should not be changed under any circumstances.
!
! This subroutine was modified in two places in order to make contour
! line labels visible on small plots.
!          

      DIMENSION ZDAT(IZD1,*),RWRK(*),IWRK(*)
!
! This routine draws contour lines.
!
! ZDAT is the user data array.
! RWRK is the user real workspace array.
! IWRK is the user integer workspace array.
!
! Declare all of the CONPACK common blocks.
! CPCOM1 contains integer and real variables.
!
      COMMON /CPCOM1/ ANCF,ANHL,ANIL,ANLL,CDMX,CHWM,CINS,CINT(10)
      COMMON /CPCOM1/ CINU,CLDB(256),CLDL(256),CLDR(256)
      COMMON /CPCOM1/ CLDT(256),CLEV(256),CLWA(259),CXCF
      COMMON /CPCOM1/ CXIL,CYCF,CYIL,DBLF,DBLM,DBLN,DBLV,DFLD,DOPT
      COMMON /CPCOM1/ EPSI,FNCM,GRAV,GRSD,GSDM,HCHL,HCHS,IAIA(259)
      COMMON /CPCOM1/ IAIB(256),IBCF,IBHL,IBIL,IBLL,ICAF,ICCF
      COMMON /CPCOM1/ ICCL(259),ICFF,ICHI,ICHL,ICIL,ICLL(256)
      COMMON /CPCOM1/ ICLO,ICLP(256),ICLS,ICLU(259),ICLV,ICLW
      COMMON /CPCOM1/ IDUF,IGCL,IGLB,IGRM,IGRN,IGVS,IHCF,IHLE,IHLX
      COMMON /CPCOM1/ IHLY,IIWS(2),IIWU,ILBC,IMPF,INCX(8),INCY(8)
      COMMON /CPCOM1/ INHL,INIL,INIT,INLL,IOCF,IOHL,IOLL,IPAI,IPCF
      COMMON /CPCOM1/ IPIC,IPIE,IPIL,IPLL,IRWS(4),IRWU,ISET,IWSO
      COMMON /CPCOM1/ IZD1,IZDM,IZDN,IZDS,JODP,JOMA,JOTZ,LCTM,LEA1
      COMMON /CPCOM1/ LEA2,LEA3,LEE1,LEE2,LEE3,LINS,LINT(10),LINU
      COMMON /CPCOM1/ LIWK,LIWM,LIWS(2),LNLG,LRWC,LRWG,LRWK
      COMMON /CPCOM1/ LRWM,LRWS(4),LSDD,LSDL,LSDM,LTCF,LTHI
      COMMON /CPCOM1/ LTIL,LTLO,MIRO,NCLB(256),NCLV,NDGL,NEXL
      COMMON /CPCOM1/ NEXT,NEXU,NLBS,NLSD,NLZF,NOMF,NOVS,NR04,NSDL
      COMMON /CPCOM1/ NSDR,OORV,PITH,SCFS,SCFU,SEGL,SVAL,T2DS,T3DS
      COMMON /CPCOM1/ UCMN,UCMX,UVPB,UVPL,UVPR,UVPS,UVPT,UWDB,UWDL
      COMMON /CPCOM1/ UWDR,UWDT,UXA1,UXAM,UYA1,UYAN,WCCF,WCHL,WCIL
      COMMON /CPCOM1/ WCLL,WLCF,WLHL,WLIL,WLLL,WOCH,WODA,WTCD,WTGR
      COMMON /CPCOM1/ WTNC,WTOD,WWCF,WWHL,WWIL,WWLL,XAT1,XATM,XLBC
      COMMON /CPCOM1/ XVPL,XVPR,XWDL,XWDR,YAT1,YATN,YLBC,YVPB,YVPT
      COMMON /CPCOM1/ YWDB,YWDT,ZDVL,ZMAX,ZMIN
      EQUIVALENCE (IIWS(1),II01),(LIWS(1),LI01)
      EQUIVALENCE (IIWS(2),II02),(LIWS(2),LI02)
      EQUIVALENCE (IRWS(1),IR01),(LRWS(1),LR01)
      EQUIVALENCE (IRWS(2),IR02),(LRWS(2),LR02)
      EQUIVALENCE (IRWS(3),IR03),(LRWS(3),LR03)
      EQUIVALENCE (IRWS(4),IR04),(LRWS(4),LR04)
      SAVE   /CPCOM1/
!
! CPCOM2 holds character parameters.
!
      COMMON /CPCOM2/ CHEX,CLBL(256),CLDP(259),CTMA,CTMB,FRMT
      COMMON /CPCOM2/ TXCF,TXHI,TXIL,TXLO
      CHARACTER*13 CHEX
      CHARACTER*64 CLBL
      CHARACTER*128 CLDP
      CHARACTER*500 CTMA,CTMB
      CHARACTER*8 FRMT
      CHARACTER*64 TXCF
      CHARACTER*32 TXHI
      CHARACTER*128 TXIL
      CHARACTER*32 TXLO
      SAVE   /CPCOM2/
!
! Declare the dash-package common block which contains the smoothing
! flag, so that it may be temporarily turned off as needed.
!
      COMMON /SMFLAG/ ISMO
!
! Declare local variables in which to manipulate DASHPACK parameters.
!
      CHARACTER*1 CHRB,CHRG,CHRS
      CHARACTER*16 CDPS
      CHARACTER*256 CHDP
!
! Check for an uncleared prior error. Also check if initialization
! has not been done, log an error and quit.
!
      IF (ICFELL('CPCLDR - UNCLEARED PRIOR ERROR',1).NE.0) RETURN
      IF (INIT.EQ.0) THEN
        call SETER ('CPCLDR - initialization call not done',2,1)
        RETURN
      END IF
!
! Do the proper SET call.
!
      call SET (XVPL,XVPR,YVPB,YVPT, XWDL,XWDR,YWDB,YWDT, LNLG)
      IF (ICFELL('CPCLDR',3).NE.0) RETURN
!
! If no contour levels are defined, try to pick a set of levels.
!
      IF (NCLV.LE.0) THEN
        CALL CPPKCL (ZDAT,RWRK,IWRK)
        IF (ICFELL('CPCLDR',4).NE.0) RETURN
      END IF
!
! Get indices for the contour levels in ascending order.
!
      IF (NCLV.GT.0) CALL CPSORT (CLEV,NCLV,ICLP)
!
! Initialize whichever dash package (if any) is to be used.
!
      IF (IDUF.LT.0) THEN
        CALL DPGETC ('CRB',CHRB)
        IF (ICFELL('CPCLDR',5).NE.0) RETURN
        CALL DPGETC ('CRG',CHRG)
        IF (ICFELL('CPCLDR',6).NE.0) RETURN
        CALL DPGETC ('CRS',CHRS)
        IF (ICFELL('CPCLDR',7).NE.0) RETURN
        CALL DPGETI ('DPL',IDPL)
        IF (ICFELL('CPCLDR',8).NE.0) RETURN
        CALL DPGETI ('DPS',IDPS)
        IF (ICFELL('CPCLDR',9).NE.0) RETURN
        CALL DPGETC ('DPT',CHDP)
        IF (ICFELL('CPCLDR',10).NE.0) RETURN
        CALL DPGETR ('TCS',RTCS)
        IF (ICFELL('CPCLDR',11).NE.0) RETURN
        CALL DPGETR ('WOC',RWOC)
        IF (ICFELL('CPCLDR',12).NE.0) RETURN
        CALL DPGETR ('WOG',RWOG)
        IF (ICFELL('CPCLDR',13).NE.0) RETURN
        CALL DPGETR ('WOS',RWOS)
        IF (ICFELL('CPCLDR',14).NE.0) RETURN

        CALL DPSETI ('DPS',0)
        IF (ICFELL('CPCLDR',15).NE.0) RETURN
        CDPS=CHRS/ /CHRS/ /CHRS/ /CHRS/ /CHRS/ /CHRS/ /CHRS/ /CHRS
     +    / /CHRS/ /CHRS/ /CHRS/ /CHRS/ /CHRS/ /CHRS/ /CHRS/ /CHRS
        CALL DPSETC ('DPT',CDPS)
        IF (ICFELL('CPCLDR',16).NE.0) RETURN
        CALL DPSETR ('TCS',-1.)
        IF (ICFELL('CPCLDR',17).NE.0) RETURN
        CALL DPSETR ('WOC',CHWM*WOCH*(XVPR-XVPL))
        IF (ICFELL('CPCLDR',18).NE.0) RETURN
        CALL DPSETR ('WOG',CHWM*WODA*(XVPR-XVPL))
        IF (ICFELL('CPCLDR',19).NE.0) RETURN
        CALL DPSETR ('WOS',CHWM*WODA*(XVPR-XVPL))
        IF (ICFELL('CPCLDR',20).NE.0) RETURN
      ELSEIF (IDUF.GT.0) THEN
        CALL GETSI (IP2X,IP2Y)
        IF (ICFELL('CPCLDR',21).NE.0) RETURN
        ILDA=MAX(1,INT(CHWM*WODA*(XVPR-XVPL)*(2.**IP2X-1.)+.5))
        ILCH=MAX(4,INT(CHWM*WOCH*(XVPR-XVPL)*(2.**IP2X-1.)+.5))
        CALL DASHDC ('$$$$$$$$$$$$$$$$',ILDA,ILCH)
        IF (ICFELL('CPCLDR',22).NE.0) RETURN
        ISMS=ISMO
        ISMO=1
      ENDIF
!
! If the constant-field flag is set, just output a warning message.
! Otherwise, draw contours.
!
      if (ICFF.NE.0) then
        CALL CPCFLB (1,RWRK,IWRK)
        IF (ICFELL('CPCLDR',23).NE.0) RETURN
      else
!
! If labels are being written by the dash package, make sure the
! labels are completely defined.
!
        if (ABS(IPLL).EQ.1) then
          CALL CPPKLB (ZDAT,RWRK,IWRK)
          IF (ICFELL('CPCLDR',24).NE.0) RETURN
          CALL CPSTLS (ZDAT,RWRK,IWRK)
          IF (ICFELL('CPCLDR',25).NE.0) RETURN
        endif
!
! Loop through the selected contour levels, drawing contour lines for
! the appropriate ones.
!
        do ICLV=1,NCLV

          if (CLEV(ICLV).GT.ZMIN .and. CLEV(ICLV).LT.ZMAX) then 
!
! If dash patterns are in use, find the length of the dash pattern
! at this contour level.
!
            if (IDUF.NE.0) call find_lenght (CLDP(ICLV), LCLD)
!
! If only the line is being drawn, the dash-pattern-use flag
! determines whether it will be done using CURVE, DPCURV, or CURVED.
!
            if (MOD(ICLU(ICLV),4) .eq. 1) then
              if (IDUF .lt. 0) then
                call DPSETC ('DPT',CLDP(ICLV)(1:LCLD))
                if (ICFELL('CPCLDR',26).NE.0) RETURN
              elseif (IDUF .gt. 0) then
                call DASHDC (CLDP(ICLV)(1:LCLD),ILDA,ILCH)
                if (ICFELL('CPCLDR',27).NE.0) RETURN
              endif
!
! If only the labels are being drawn, it can be handled here only if
! the dash-pattern use flag indicates that DPCURV or CURVED is to be
! used and the label-positioning flag implies that the labels are to
! be incorporated into the dash pattern.
!
            elseif (MOD(ICLU(ICLV),4) .eq. 2) then
              if (ABS(IPLL).eq.1 .and. IDUF.ne.0) then
                NCHL=NCLB(ICLV)
                NCHD=MAX(1,MIN(ABS(IDUF)*LCLD,500-NCHL))
                CTMA=' '
                if (IDUF .lt. 0) then
                  do ICHD=1,NCHD
                    CTMA(ICHD:ICHD)=CHRG
                  enddo
                  LCTM=NCHD+NCHL
                  CTMA(NCHD+1:LCTM)=CLBL(ICLV)(1:NCHL)
                  call DPSETC ('DPT',CTMA(1:LCTM))
                  if (ICFELL('CPCLDR',28).NE.0) RETURN
                elseif (IDUF .gt. 0) then
                  do ICHD=1,NCHD
                    CTMA(ICHD:ICHD)=''''
                  enddo
                  LCTM=NCHD+NCHL
                  CTMA(NCHD+1:LCTM)=CLBL(ICLV)(1:NCHL)
                  call DASHDC (CTMA(1:LCTM),ILDA,ILCH)
                  if (ICFELL('CPCLDR',29).NE.0) RETURN
                endif
              endif
!
! If both lines and labels are being drawn, there are various cases,
! depending on whether dashed lines are being used and how labels are
! being positioned.
!
            elseif (MOD(ICLU(ICLV),4) .eq. 3) then
              if (IDUF .ne. 0) then
                if (ABS(IPLL) .eq. 1) then
                  NCHL=NCLB(ICLV)
                  NCHD=MAX(1,MIN(ABS(IDUF)*LCLD,500-NCHL))
                  CTMA=' '
                  do ICHD=1,NCHD
                    JCHD=MOD(ICHD-1,LCLD)+1
                    CTMA(ICHD:ICHD)=CLDP(ICLV)(JCHD:JCHD)
                  enddo
                  LCTM=NCHD+NCHL
                  CTMA(NCHD+1:LCTM)=CLBL(ICLV)(1:NCHL)
                  if (IDUF .lt. 0) then
                    call DPSETC ('DPT', CTMA(1:LCTM))
                    if (ICFELL('CPCLDR',30).NE.0) RETURN
                  else
c**
c**                ! Alexander Shchepetkin:  This segment was to
          ILCH=15  ! modified to increase size of  contour labels
c**                ! to make them ! visible (default was 9)
c**
                    call DASHDC (CTMA(1:LCTM),ILDA,ILCH)
                    if (ICFELL('CPCLDR',31).NE.0) RETURN
                  endif
                else
                  if (IDUF.LT.0) then
                    call DPSETC ('DPT',CLDP(ICLV)(1:LCLD))
                    if (ICFELL('CPCLDR',32).NE.0) RETURN
                  else
                    call DASHDC (CLDP(ICLV)(1:LCLD),ILDA,ILCH)
                    if (ICFELL('CPCLDR',33).NE.0) RETURN
                  endif
                endif
              endif
            endif
!
! The following code segment calls CPTRCL to draw the contour line
! at a given level.  The user-change routine is called before and
! after the calls to CPTRCL.
! 
            if (MOD(ICLU(ICLV),4).ne.2 .or. (ABS(IPLL).eq.1
     &                                .and. IDUF.ne.0)) then
#include "set_line_color_width.h"
              IJMP=0
  1           call CPTRCL (ZDAT, RWRK, IWRK, CLEV(ICLV), IJMP,
     &                                       IRW1, IRW2, NRWK)
c             write(*,*) 'calling CPTRCL',1,MOD(ICLU(ICLV),4)
              if (ICFELL('CPCLDR',55).NE.0) RETURN
              if (IJMP .ne. 0) then
c**
c** Alexander Shchepetkin: The following segment was modified in
c** order to increase thickness labelled contour lines relatively
c** to non-labelled lines. The line width will be reset back to
c** normal approximately 15 lines below.
c**
                if (MOD(ICLU(ICLV),4).eq.3) call gslwsc(2.5)

                call CPDRSG (RWRK, IRW1, IRW2, NRWK)
/*
! Code inside this segment in equivalent to internal code
! inside CPDRSG.
!
                if (IDUF.lt.0) then
                  call DPCURV (RWRK(IRW1+1),RWRK(IRW2+1),NRWK)
                  if (ICFELL('CPDRSG',2).NE.0) return 
                elseif (IDUF.gt.0) then
                  call CURVED (RWRK(IRW1+1),RWRK(IRW2+1),NRWK)
                  if (ICFELL('CPDRSG',3).NE.0) return 
                else
                  call CURVE (RWRK(IRW1+1),RWRK(IRW2+1),NRWK)
                  if (ICFELL('CPDRSG',1).NE.0) return 
                endif
*/
c**
c** Set line width back to normal
c**     
                if (MOD(ICLU(ICLV),4).eq.3) call gslwsc(1.2)
c**
                if (ICFELL('CPCLDR',56).NE.0) RETURN
                if (IHCF .ne. 0) then
                  call CPHCHR (RWRK, IRW1, IRW2, NRWK)
                  if (ICFELL('CPCLDR',57).NE.0) RETURN
                endif 
                goto 1
              endif
#include "reset_line_color_width.h"
            endif
          endif
        enddo
      endif

!
! Draw boundaries for areas filled with special values.
!
      if (ICLU(258).NE.0) then
        ICLV=258
        if (IDUF .ne. 0) then
          call find_lenght (CLDP(ICLV), LCLD)
          if (IDUF .lt. 0) then
            call DPSETC ('DPT',CLDP(ICLV)(1:LCLD))
            if (ICFELL('CPCLDR',34).NE.0) RETURN
          else
            call DASHDC (CLDP(ICLV)(1:LCLD),ILDA,ILCH)
            if (ICFELL('CPCLDR',35).NE.0) RETURN
          endif
        endif

#include "set_line_color_width.h"
        IJMP=0
        IAIC=-9
  2     call CPTRES (ZDAT,RWRK,IWRK,IJMP,IAIC,IRW1,IRW2,NRWK)
        write(*,*) 'calling CPTRES', 2 
        if (ICFELL('CPCLDR',36).NE.0) RETURN
        if (IJMP.ne.0) then
          call CPDRSG (RWRK,IRW1,IRW2,NRWK)
          if (ICFELL('CPCLDR',37).NE.0) RETURN
          goto 2 
        endif
#include "reset_line_color_width.h"
      endif

!
! Draw boundaries for areas which are invisible.
!
      if (ICLU(259).NE.0 .and. IMPF.NE.0 .and. OORV.NE.0.) then
        TST1=REAL(IMPF)
        TST2=0.
        call HLUCPMPXY (0,TST1,TST2,TST3,TST4)
        IF (ICFELL('CPCLDR',38).NE.0) RETURN
        ICLV=259
        if (IDUF.NE.0) then
          call find_lenght (CLDP(ICLV), LCLD)
          if (IDUF.LT.0) then
            call DPSETC ('DPT',CLDP(ICLV)(1:LCLD))
            if (ICFELL('CPCLDR',39).NE.0) RETURN
          else
            call DASHDC (CLDP(ICLV)(1:LCLD),ILDA,ILCH)
            if (ICFELL('CPCLDR',40).NE.0) RETURN
          endif
        endif

#include "set_line_color_width.h"
        IJMP=0
        IAIC=-9
  3     if (TST2.NE.2..and. TST2.NE.3.) then
          call CPTREV (ZDAT,RWRK,IWRK,IJMP,IAIC,IRW1,IRW2,NRWK)
          write(*,*) 'calling CPTREV', 3
          if (ICFELL('CPCLDR',41).NE.0) RETURN
        else
          call CPTRVE (ZDAT,RWRK,IWRK,IJMP,IAIC,IRW1,IRW2,NRWK)
          write(*,*) 'calling CPTRVE', 3
          if (ICFELL('CPCLDR',42).NE.0) RETURN
        endif
        if (IJMP.ne.0) then
          call CPDRSG (RWRK,IRW1,IRW2,NRWK)
          if (ICFELL('CPCLDR',43).NE.0) RETURN
          goto 3
        endif
#include "reset_line_color_width.h"
      endif
!
! Draw the edge of the grid.
!
      if (ICLU(257).NE.0) then
        ICLV=257
        if (IDUF .ne. 0) then
          call find_lenght (CLDP(ICLV), LCLD)
          IF (IDUF .lt. 0) then
            call DPSETC ('DPT',CLDP(ICLV)(1:LCLD))
            if (ICFELL('CPCLDR',44).NE.0) RETURN
          else
            call DASHDC (CLDP(ICLV)(1:LCLD),ILDA,ILCH)
            if (ICFELL('CPCLDR',45).NE.0) RETURN
          endif
        endif

#include "set_line_color_width.h"
        IJMP=0
        IAIC=-9
  4     call CPTREG (ZDAT,RWRK,IWRK,IJMP,IAIC,IRW1,IRW2,NRWK)
        write(*,*) 'calling CPTREG', 4 
        if (ICFELL('CPCLDR',46).NE.0) RETURN
        if (IJMP .ne. 0) then
          call CPDRSG (RWRK,IRW1,IRW2,NRWK)
          if (ICFELL('CPCLDR',47).NE.0) RETURN
          goto 4
        endif 
#include "reset_line_color_width.h"
      endif
!
! Restore the state of the dash package (if any) that was used.
!
      if (IDUF.lt.0) then
        call DPSETI ('DPS',IDPS)
        IF (ICFELL('CPCLDR',48).NE.0) RETURN
        call DPSETC ('DPT',CHDP(1:IDPL))
        IF (ICFELL('CPCLDR',49).NE.0) RETURN
        call DPSETR ('TCS',RTCS)
        IF (ICFELL('CPCLDR',50).NE.0) RETURN
        call DPSETR ('WOC',RWOC)
        IF (ICFELL('CPCLDR',51).NE.0) RETURN
        call DPSETR ('WOG',RWOG)
        IF (ICFELL('CPCLDR',52).NE.0) RETURN
        call DPSETR ('WOS',RWOS)
        IF (ICFELL('CPCLDR',53).NE.0) RETURN
      elseif (IDUF.gt.0) then 
        call DASHDC ('$$$$$$$$$$$$$$$$',ILDA,ILCH)
        IF (ICFELL('CPCLDR',54).NE.0) RETURN
        ISMO=ISMS
      endif
                !
      return    ! DONE. 
      end       !
!
! The following internal procedure finds the length of a dash 
! pattern for a particular contour level. Should be called as
! call find_lenght (CLDP(ICLV), LCLD)
!
      subroutine find_lenght (CLDP, LCLD)
      implicit none
      character*128 CLDP
      integer LCLD, i
      do i=1,128
        if (CLDP(i:i) .ne. ' ') LCLD=i
      enddo
      return
      end
