      subroutine colram (xam,yam, nam, ai,ag, nai)
!
! The arrays XAM and YAM, for indices 1 to NAM, contain the X and Y
! coordinates of points defining a polygon. The area identifiers in
! the array AI, each with an associated group identifier in the array
! AG, tell us whether the polygon is to be color-filled or not.
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer nam, nai, ai(nai), ag(nai), ierr, i, indx,
     &                             ai1, ai3, ici, mapaci
      real xam(nam), yam(nam)  
#include "pltncar.h"
#include "cntwkspa.h"
                                   ! Check whether declared size
      ierr=0                       ! of scratch array is sufficient
      if (nai.gt.mai) then
        write(*,'(/1x,A,1x,A,2I6)') 'ERROR in colram:',
     &     'underdimensioned arrays AI, AG', mai, nai 
        ierr=ierr+1
      endif
      if (nam.gt.mcs) then
        write(*,'(/1x,A,1x,A,2I6)') 'ERROR in colram:',
     &    'underdimensioned arrays XAM, YAM', mcs,nam
        ierr=ierr+1
      endif
      if (ierr.gt.0) stop

      ai1=-1                       ! Find area identifiers for the
      ai3=-1                       ! realtively to groups 1 and 3.
      do i=1,nai                   ! The first of these tells whether
        if (ag(i).eq.1) then       ! the area is over land or water,
          ai1=ai(i)                ! and the second tells what
        elseif (ag(i).eq.3) then   ! contour band the area is in.
          ai3=ai(i)
        endif
      enddo              
      ici=mapaci(ai1)
      if (1.le.ai3 .and. ai3.le.ncl .and. ici.ne.1) ici=1

      if (.not.lland) ai1=-1       ! Reset flags if not color 
                                   ! masking land and water
      if (ai3.gt.0) then
        indx=ai3+1
#if VERBOSE > 4 
c        write(*,'(5(2x,A,I4))') 'colram: water: npts =', nam,
c     &  'ici =', ici, 'ai1 =', ai1,  'ai3 =', ai3,  'indx =', indx
#endif
      elseif (ai1.gt.0 .and. ici.ne.1) then
        indx=ncl+2
#if VERBOSE > 4
c        write(*,'(5(2x,A,I4))')  'colram: land: npts =', nam,
c     &  'ici =', ici, 'ai1 =', ai1,  'ai3 =', ai3,  'indx =', indx
#endif
      else
        indx=0                     ! Fill the area with color
      endif                        ! using gray for any area over
      if (indx .ne. 0) then        ! land, a color from palette,
        call gsfaci (indx)         ! depending on the contour level,
        call gfa (nam-1, xam,yam)  ! or blue for any area over water
      endif                        ! elsewhere.
      return
      end
