      subroutine colorbar (fmin,fmax, ipos)
!
! Draw color bar at the bottom (IPOS=0) or at the right (IPOS=1)
! of the map.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer ipos,   pwr, iter,i, lstr,lenstr
      real fmin,      fontsize,  scale,   sizeX, xlab, xb(4),
     &     fmax,      delta, max_abs, sizeY, ylab, yb(4)
      character frmt*6, label*5, string*16
#include "pltncar.h"
#if VERBOSE > 2
      write(*,'(1x,2A,I2,2E12.4,$)') 'Enter colorbar, ',
     &               'ipos,fmin,fmax =', ipos,fmin,fmax
#endif
      call gsclip(0)
      fontsize=0.009*basesize
      sizeX=ur-ul                   ! Depending on the position of
      sizeY=ut-ub                   ! color bar, vertical (ipops=1)
                                    ! or horizontal (ipos=0), set 
      if (ipos.eq.1) then           ! coordinates (either horizontal 
        xb(1)=ur  +0.01*sizeX       ! or vertical) which are the same 
        xb(3)=xb(1)+0.05*sizeX      ! for all color boxes. Also set 
        xlab=xb(3)+0.001*sizeX      ! increment delta which is either 
        delta=sizeY/float(ncl)      ! height or width of color box. 
      elseif (ipos.eq.0) then
        yb(3)=ub-0.035*sizeY
        if (plttyp.eq.secplt .and. ltmarks)
     &       yb(3)=yb(3)-0.0125*sizeY*basesize
        yb(1)=yb(3)-0.055*sizeY
        ylab=yb(1)-sizeY*fontsize/(ft-fb)
        delta=sizeX/float(ncl)
      else
        write(6,'(/A,I4/)') ' COLORBAR: illegal position, IPOS=',ipos
      endif

      pwr=0                               ! Determine where there
      scale=1.                            ! is a need for scaling
      max_abs=max(abs(fmin),abs(fmax))
      do while (max_abs.gt.10.)
        pwr=pwr+1
        scale=0.1*scale
        max_abs=0.1*max_abs
      enddo
      if (max_abs.gt.0.) then             ! WARNING!!!! omission of
        do while (max_abs.lt.1.)          ! this if statement causes 
          pwr=pwr-1                       ! causes dead loop.
          scale=10.*scale
          max_abs=10.*max_abs
        enddo
      endif

      if (pwr.eq.2) then                  ! Set format for color bar
        pwr=0                             ! labels depending on the
        scale=1.                          ! expected magnitude of
        frmt='(F5.0)'                     ! values.
      elseif (pwr.eq.1) then
        pwr=0
        scale=1.
        frmt='(F5.1)'
      else
        frmt='(F5.2)'
      endif
                                          ! Draw color bar. This
      do iter=1,2                         ! is done in two phases: 
        do i=1,ncl                        ! during the first pass,
          if (ipos.eq.1) then             ! iter=1, fill color boxes,
            yb(1)=ub+delta*float(i-1)     ! but do not draw any lines
            yb(3)=yb(1)+delta             ! or labels, which happens
            ylab=yb(3)                    ! only during the second
          else                            ! pass. This prevents lines
            xb(1)=ul+delta*float(i-1)     ! from being overpainted
            xb(3)=xb(1)+delta             ! by color filling of the
            xlab=xb(3)                    ! next color box.
          endif
          if (iter.eq.1) then
            xb(2)=xb(3)                   ! Close the rectangle, then
            yb(2)=yb(1)                   ! set appropriate color and
            xb(4)=xb(1)                   ! fill the box with color;
            yb(4)=yb(3)                   ! Alternatively draw line
            call gsfaci (i+1)             ! which separates adjacent
            call gfa (4, xb,yb)           ! boxes.
          else
            if (ipos.eq.1) then
              call line (xb(1),yb(3), xb(3),yb(3))
            else
              call line (xb(3),yb(1), xb(3),yb(3))
            endif
            if ((allbarlab .and.( mod(i,2).eq.0 .or.( ncl.lt.20 
     &             .and. i.le.ncl-1 ))) .or. .not.allbarlab .and.
     &               (i.eq.1 .or. i.eq.ncl/4 .or. i.eq.ncl/2 .or.
     &                        i.eq.3*ncl/4 .or. i.eq.ncl-1)) then
              if (ipos.eq.1 .or. xlab.lt.ul+0.96*sizeX) then
                write(label,frmt) clv(i)*scale 
                lstr=5
                if (label(lstr:lstr).eq.'.') lstr=lstr-1
                call plchhq(xlab,ylab, label(1:lstr), fontsize,
     &                                         0.,-float(ipos))
              endif
            endif
          endif
        enddo
      enddo 

      if (pwr.ne.0) then                  ! Write scaling label
        if (ipos.eq.1) then               ! (if needed).
          xlab=xb(1)
          ylab=ub-1.5*sizeY*fontsize/(ft-fb)
c**       ylab=ub-0.005*sizeY
        else
          xlab=ur-0.01*sizeX
          ylab=ylab-2.*(yb(1)-ylab)
        endif
        write(string,'(I4)') pwr
        lstr=lenstr (string)
        string=':L1:410:S:' / / string(1:lstr)
        call plchhq (xlab,ylab, string(1:lstr+10), fontsize,
     &                                         0.,1.-2*ipos)
      endif

      if (ipos.eq.1) then                 ! Draw box around
        yb(1)=ub                          ! the color bar.
        yb(3)=ut
      else
        xb(1)=ul
        xb(3)=ur
      endif
      call gslwsc (thick_line)
      call line (xb(1),yb(1), xb(3),yb(1))
      call line (xb(3),yb(1), xb(3),yb(3))
      call line (xb(3),yb(3), xb(1),yb(3))
      call line (xb(1),yb(3), xb(1),yb(1))
      call gslwsc (medium_line)
      call gsclip (1)
#if VERBOSE > 2
      write(*,'(1x,A)') '...return.'
#endif
      return
      end            
