      subroutine cntpack (f, mm,m,n, fmin,fmax, cint,imask,icolor)
!
! This routine uses NCAR CONPACK utility to contour the grided
! field F(M,N). It assumes that the user has call FRAME previously
! for properly positioning of the color levels.
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer mm,m,n, imask, icolor
      real f(mm,n), fmin,fmax, cint

      integer i,iclu,isu, liwku,lrwku, nocl, radx,rady
      parameter (radx=2,rady=2)
      real c_lev(2000)
      data c_lev /2000*0./
      external drawcl, cpdrpl

#include "pconst.h"
#include "cntwkspa.h"
#include "pltfld.h"
#include "pltncar.h"
!
! Reset all CONPACK parameters to their default values to facilitate
! overlays and prevent CONPACK from setting the viewport internally. 
!
      call cprset
      call cpseti ('SET - do-set-call flag',0)
      if (spherical) then                        ! Select user
        call cpseti ('MAP - mapping flag',3)     ! provided mapping
      else
        call cpseti ('MAP - mapping flag',4)
      endif
!
! Set special value feature.
!
      call cpsetr ('SPV - special value',spval1)
!
! Set contour interval and specify the interval between labelled
! contours.
!
      call cpsetr('CMN - contour minimum',fmin)
      call cpsetr('CMX - contour maximum',fmax)
      call cpsetr('CIS - contour interval selector',abs(cint))
      call cpseti('LIS - label interval specifier',4)
!
! Set high/low label information.
!
      if (lhiglow) then
        call cpsetc ('HIT - High label test string','D$B$$ZDVU$m$E$')
        call cpsetc ('LOT - Low label text string','S$B$$ZDVU$m$E$')
        call cpsetr ('HLS - High/Low label size', 0.009)
        call cpsetr ('HLW - High/Low white space width', 0.0025)
        call cpseti ('HLX - High/Low search radius in x',radx)
        call cpseti ('HLY - High/Low search radius in y',rady)
      endif
!
! Make PLOTCHAR use high-quality character.
!
      call pcseti ('QU - quality flag',0)
!
! Make all CONPACK-written characters a little bigger.
!
      call cpsetr ('CWM - character width multiplier',1.25)
!
! Provide more room for X and Y coordinates defining contours lines.
!
      call cpseti ('RWC - real workspace for contours',300)
!
! Set up color of contours.
!
      if (icolor.eq.2) then
        call gsplci (ncl+4)
      endif
!
! Initialize the drawing of the contour plot.
!
      call cprect (f, mm,m,n, rwrk,lrwk,iwrk,liwk)
!
! Set contour levels.
!---- ------- -------
!
      call cppkcl (f,rwrk,iwrk)
      call cpgeti ('NCL - number of contour levels',nocl)
      call cpgetr ('CIU - contour interval used',cint)
      do i=1,nocl
        call cpseti ('PAI - parameter array index',i)
        call cpgetr ('CLV - contour level value',c_lev(i))
!
! If requested, omit the drawing of zero-contour lines.
!
        if (lnozero .and. c_lev(i).eq.0.) then
          call cpseti ('CLU - contour level use flags',0)
        endif
!
! Set solid lines for positive contour levels and dash pattern
! for negative contour levels.
!
        if (c_lev(i).ge.0) then
          call cpseti ('CLD - contour line solid pattern',65535)
        else
          call cpseti ('CLD - contour line dash pattern',43690)
        endif
!
! Do not label contours levels.
!
        if (.not.lcntlab) then
          call cpseti ('CLU - contour-line line width',1)
        endif
!
! Set width of labeled contour lines.
!
        if (lcntlab) then     
          call cpgeti ('CLU - contour level use flag',iclu)
          if (iclu.eq.3) then
            call cpseti ('CLL - contour-line line width',cnt_cll)
          endif
        endif
      enddo
!
! Get contour interval used for information purposes.
!
      if (cint.eq.0.) then
        cint=abs(c_lev(2)-c_lev(1))
      endif
!
! Draw masked or unmasked contour lines.      ! Initialize area map, 
!----- ------ -- -------- ------- ------      ! define land mask area
!                                             ! edges, pre-process
      if (imask.eq.1) then                    ! the area map, and
        call arinam (iam, lam)                ! draw masked countour
        call aredam (iam, xcs,ycs,nxy,5,0,-1) ! lines
        call arpram (iam,0,0,0)
        call cpcldm (f,rwrk,iwrk,iam,drawcl)
      elseif (imask.lt.0) then                ! Draw regular contour
        call arinam (iam,lam)                 ! lines, but bock the
        call cplbdr (f,rwrk,iwrk)             ! drawing through High/
        call cplbam (f,rwrk,iwrk,iam)         ! Low labels.
        call arpram (iam,0,0,0)
        call cpcldm (f,rwrk,iwrk,iam,cpdrpl)  ! Draw regular
      else                                    !        contour lines 
        call cprect (f, mm,m,n, rwrk,lrwk, iwrk,liwk)
        call cpcldr (f,rwrk,iwrk)
      endif
                                              ! Set polyline color
      if (icolor.eq.2) call gsplci (1)        ! back to foreground
!                                             ! foreground color.
! Give the work space used.
!
      call cpgeti ('RWU - real workspace usage',    lrwku)
      call cpgeti ('IWU - integer workspace usage', liwku)
#ifdef VERBOSE
      write(*,'(1x,A,I8,5x,A,I8/9x,A,I8,5x,A,I8)') 
     &   'CONPACK - real   workspace   used:', lrwku, 'given:', lrwk,
     &           '- integer  workspace used:', liwku, 'given:', liwk
      if (imask.gt.0) then
        isu=lam-(iam(6)-iam(5)-1)
        write(*,'(9x,A,I8,5x,A,I8)')
     &           '- space used in area mask:',   isu, 'given:', lam
      endif
#endif
      return
      end
