      real function cntint (ifield, level, fmin,fmax,cont,iflds,ilevs)
!
! Determine contour interval.
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer ifield,level, iflds, ilevs,  ncl, nl
      real fmin, fmax, cont(iflds,ilevs),  cint,cintsgn,fint,  p
!
! Compute contour interval: about NCL contour lines.
!
      ncl=10
      fint=(fmax-fmin)/float(ncl)
      if (fint.ne.0.) then
        p=10**(ifix(alog10(fint)+5000.)-5000.)
        fint=max(aint(fint/p),1.)*p
      else
        fint=0.
      endif
!
! Extract contour interval from provided plot data file.
!
      if (level.ge.1 .and. level.le.ilevs) then
        cint=cont(ifield,level)
      else
        cint=cont(ifield,1)
      endif
!
! If the specified contour interval needs to be modified,
! activate the no drawing of zero-contour lines (set
! negative contour interval), if requested.
!
      cintsgn=1.
      if (cint.lt.0.) cintsgn=-1.
!
! Select contour interval: computed or provided.
!
      if (cint.ne.0.) then
        nl=int((fmax-fmin)/abs(cint))+1
      else
        nl=2*ncl
      endif
      if (nl.ge.2*ncl) then
        cntint=fint
c       cntint=fint*cintsgn
      else
        cntint=cint
      endif
      return
      end
