      subroutine cntcolor (f, mm,m,n, fmin,fmax)
!
!  This routine contours in color (solid fill) and draws color bar.
!  It assumes  that the user has call SET previously for properly
!  positioning of the color map.  Color palette is selected by the
!  user and stored in common block COLPAL.
!
      implicit none
#include "param.h"
#include "pconst.h"
#include "cntwkspa.h"
#include "fmask.h"
#include "pltfld.h"
#include "pltncar.h"

      integer i, isu, liwku, lrwku, m, mm,n
      real f(mm,n), cint, fmax, fmin, zmn, zmx
      external colram
#if VERBOSE > 4
      write(*,*) 'Enter CNTCOLOR: mm,m,n,fmin,fmax =', mm,m,n,fmin,fmax
#endif


c      if (lland) then
c        call arinam (iam,lam)
c        call landmask
c        call arpram (iam,0,0,0)
c        call arscam (iam,xcs,ycs,mcs,iai,iag,mai,colram)
c      endif

!
! Initialize area map.
!
      call arinam (iam,lam)

c      if (lland) call landmask (iam)
!
! Set CONPACK options.
!---------------------
!
! Prevent CONPACK from setting the viewport.
!
      call cpseti ('SET - do-set-call flag', 0)
!
! Set mapping to that provided by the User.
!
      if (spherical) then
        call cpseti ('MAP - mapping flag', 3)
      else
        call cpseti ('MAP - mapping flag', 4)
      endif
!
! Set special value feature.
!
      call cpsetr ('SPV - special value',spval1)
!
! Set  NCL-1  contour levels,  splitting the range into NCL equal
! bands, one for each of the NCL colors available.  Specify those
! levels, and define exactly what is to be done at each level.
!
      call cpseti ('CLS - contour level selector',0)
      call cpseti ('NCL - number of contour levels',ncl-1)

      if (logscale) then
        if (fmax.gt.0. .and. fmin.gt.0) then
          cint=(dble(fmax)/dble(fmin))**(1.D0/float(ncl))
          clv(1)=fmin*cint
          do i=2,ncl
            clv(i)=clv(i-1)*cint
          enddo
        else
          write(*,'(/1x,2A)') 'ERROR: logscale=T, but ',
     &                     'fmin,fmax are not positive.'
          stop
        endif
      else
        cint=(fmax-fmin)/float(ncl)
        do i=1,ncl
          clv(i)=fmin+cint*float(i)
        enddo
      endif

      do i=1,ncl-1
c**     write(*,*) 'cntcolor: ', i, clv(i)
        call cpseti ('PAI - parameter index array',i)
        call cpsetr ('CLV - contour level',clv(i))
        call cpseti ('CLU - contour level use',1)
        call cpseti ('AIB - area indentifier below level',i)
        call cpseti ('AIA - area indentifier above level',i+1)
      enddo
!
! Provide more room for X and Y coordinates defining contours lines.
!
      call cpseti ('RWC - real workspace for contours', 300)
!
! Initialize the drawing of the contour plot.
!
      call cprect (f,mm,m,n,rwrk,lrwk,iwrk,liwk)
      call cpgetr ('ZMN - minimum value found', zmn)
      call cpgetr ('ZMX - maximum value found', zmx)
!
! Put contour lines into area map.
!
c      write(*,*) 'before cpclam'
      call cpclam (f, rwrk, iwrk, iam)
c      write(*,*) 'after cpclam'
!
! Color the map.
!
      call arpram (iam,0,0,0)
      call arscam (iam,xcs,ycs,mcs,iai,iag,mai,colram)
!
! Put contour lines over the color map.
!
      if (icnt.eq.1) then
        call gsplci (1)
        call cpcldr (f,rwrk,iwrk)
      endif
!
! If land masking, retrieve, project, and add the selected
! coastlines to a new area map and then paint land areas.
! Notice that the area  map is re-initialized.
!
c      if (lland.gt.0) then
c        call arinam (iam,lam)
c        call landmask
c        call arpram (iam,0,0,0)
c        call arscam (iam,xcs,ycs,mcs,iai,iag,mai,colram)
c      endif
!
! Report the work space used.
!
      call cpgeti ('RWU - real workspace usage',lrwku)
      call cpgeti ('IWU - integer workspace usage',liwku)
      isu=lam-(iam(6)-iam(5)-1)
#ifdef VERBOSE
      write(6,'(/1x,A,I10,5x,A,I10,2(/10x,A,I10,5x,A,I10)/)')
     & 'CNTCOLOR - real   workspace   used:', lrwku, 'given:', lrwk,
     &          '- integer  workspace used:', liwku, 'given:', liwk,
     &          '- space used in area mask:', isu,   'given:', lam
#endif
!
! Zero-out contour level array to facilitate overlays, if any.
! Set back defaults.
!
      do i=1,ncl-1
        call cpseti ('PAI - parameter index array',i)
        call cpsetr ('CLV - contour level',0.)
      enddo
#if VERBOSE > 4
      write(*,*) 'return from CNTCOLOR.'
#endif

      return
      end
