      subroutine cnt_set_frame (im,jm, icolor, ipos)
!
! Set viewport space for the current map on the page.
!
      implicit none
      integer im,jm,  icolor,ipos,  i,j, shft,   firstmap
      real Xbar,Ybar, SizeX,SizeY,  Xphys,Yphys, xc(4),yc(4),
     &                         dh,  vl,vr,vb,vt, plot_area(2)

      data firstmap/0/  ! here firstmap is a trigger which sets off
      save firstmap     ! initialization of land map during the first
      external fill989  ! Subsequently initialization is avoided.
      logical auto_limit, square_map

#include "param.h"
#include "pltio.h"
#include "fields.h"
#include "domdat.h"
#include "pconst.h"
#include "pltfld.h"
#include "pltncar.h"
#include "cntwkspa.h"
#include "landmap.h"

c--#define VERBOSE 10

      call viewport (icolor, Xbar,Ybar)

      if (spherical) then
#if VERBOSE > 2
        write(*,'(1x,2A,1x,A,3F10.4)') 'Enter cnt_frame: proj = ',
     &                  proj, 'plon,plat,rota =', plon,plat,rota
#endif
!
! Spherical projection is controlled by parameters which logically
! belong to two groups:
!
! (1) proj,plon,plat,rota,sath -- which control projection type,
!     georraphic coordinates of the projection pole, rotation angle
!     and satelite altitude (Satelite View 'SV' projection only). 
!
! (2) plim1....plim4 -- corners of the segment of the map, which
!     essentially extract the area of interest.
!
! User may specify all these parameters, some of them, or none at
! all. Depending on the situation, missing parameters are generated
! internally by this code to achieve the best view. If needed, this
! is done in two states:
!
! [auto]centering, i.e., determining optimal projection pole based
!                  upon either geographic boundaries of either the
!                  whole model domain, or area of interest spefified 
!                  by parameters plim1....plim4 (if they are set). 
!
! [auto]bounding,  i.e., selecting optimum bounds ul....ut of the
!                  projected coordinates to get maximum size picture 
!                  of the designated area. 
!
! The first stage can be done independently from the second, but not
! otherwise, since NCAR graphics library map transformation routine
! "maptrn" (which us used to project perimeter of the grid in order
! to determine its extents) has meaning only if after projection is
! initialized by "mapset-->mapint" call sequence. Once it is done,
! chose the strategy of setting user coordinate bounds "ul,ur,ub,ut".
! There are essentially three ways of doing this:
!
! (i) If user supplied no limiting values for the map, initialize
!     map with "maximum useful area" option first, then determine
!     bounds by projectiong perimiter of the whole model domain and
!     determine its left-right and bottom-top extends. After which
!     "crop" the map by cutting out the desired portion of the map.
!     This appears as "auto_limit" option in the code below.
!
! (ii) Similarly, if the limiting values designate a rectangular
!      subdomain on the sperical surface (with sides along lon-lat),
!      use the same approach as (i), except that instead of perimeter
!      of the grid use analytically generated perimeter of the
!      subdomain of interest.  This is "square_map" option.
!
! (iii) Use 4-corner option of mapset, if limiting values correspond
!       to a general four points.
!

c**     write(*,'(2(4x,2F9.4))') plim2(1),plim3(1), plim4(2),plim3(2)
c**     write(*,'(2(4x,2F9.4))') plim1(1),plim4(1), plim1(2),plim2(2)

        auto_limit=.false.
        square_map=.false.
        if (plim1(1).eq.spvgeo .or. plim1(2).eq.spvgeo .or.
     &      plim2(1).eq.spvgeo .or. plim2(2).eq.spvgeo  .or.
     &      plim3(1).eq.spvgeo .or. plim3(2).eq.spvgeo  .or.
     &      plim4(1).eq.spvgeo .or. plim4(2).eq.spvgeo) then
          auto_limit=.true.
        elseif (plim1(1).eq.plim2(1) .and. plim1(2).eq.plim4(2) .and.
     &          plim3(1).eq.plim4(1) .and. plim2(2).eq.plim3(2)) then
          square_map=.true.
        endif
!
! Decide what to do about projection pole, then set map projection.
! Set satelite hight (in earth radii) for Satelite view projection. 
! Note: the sequence of calls "mapstr ('SA', sath) --> maproj" vs.
! the opposite order does not make any difference.
!
        if (rota.eq.spvgeo) rota=0.
        if (plon.eq.spvgeo .or. plat.eq.spvgeo) then
          if (auto_limit) then
#if VERBOSE > 2
            write(*,*) 'Autocentering pole by grid perimeter.'
#endif
            call perim_bounds (im,jm, x,y, vl,vr,vb,vt)
          else
#if VERBOSE > 2
            write(*,*) 'Autocentering pole by spefified map bounds.'
#endif
            vb=0.5*(plim1(1)+plim2(1))
            vr=0.5*(plim2(2)+plim3(2))
            vt=0.5*(plim3(1)+plim4(1))
            vl=0.5*(plim4(2)+plim1(2))
          endif
          plon=0.5*(vr+vl)
          if (proj.eq.'ME') then
            plat=0.
          elseif (proj.eq.'LC') then
            plat=0.45*(vt+vb)
            rota=0.55*(vt+vb)
          else
            plat=0.5*(vt+vb)
          endif 
        endif
#if VERBOSE > 2
        write(*,'(1x,A,1x,A,3F10.4)') 'Finally accepted values of',
     &                          'plon,plat,rota =', plon,plat,rota
#endif
        if (proj.eq.'SV') call mapstr ('SA', sath)
        call maproj (proj, plat,plon,rota)
        if (auto_limit .or. square_map) then
          call mapset ('MA - maximum useful area', 0.,0.,0.,0.)
        else
          call mapset ('PO - four corners', plim1,plim2,plim3,plim4)
        endif
!
! Note that call to mapint below causes internal calls to set, so
! that four viewport parameters vl,vr,vb,vt are set to their default
! values, to approximately occupy the whole page in such a way that
! that aspect ratio is respected, while ul,ur,ub,ut are set according
! to the projection type in order to keep the desired aspect ratio.
! Basically it is guaranteed that ratio (vt-vb)/(vr-vl) is the same 
! as (ut-ub)/(ur-ul). The procedure below is designed to retrieve all
! the eight numbers and then adjust fl,fr,fb,ft in such a way that
! the resultant plot occupies the desired part of the page, while
! respecting physical aspect ratio. 
! 
#if VERBOSE > 2
        call getset (vl,vr,vb,vt, ul,ur,ub,ut, i)
        write(*,'(12x,A,1x,A,4F9.4/27x,A,4F9.4)')  'Before mapint:',
     &   'vl,vr,vb,vt =', vl,vr,vb,vt, 'ul,ur,ub,ut =', ul,ur,ub,ut
#endif
        call mapint
        call getset (vl,vr,vb,vt, ul,ur,ub,ut, i)
#if VERBOSE > 2
        write(*,'(12x,A,2x,A,4F9.4/27x,A,4F9.4)')  'After mapint:',
     &   'vl,vr,vb,vt =', vl,vr,vb,vt, 'ul,ur,ub,ut =', ul,ur,ub,ut
        write(*,*) 'checking aspect ratios', (ut-ub)/(ur-ul),
     &                       (vt-vb)/(vr-vl), (ft-fb)/(fr-fl)
#endif
!
! Save perimeter of model domain/perimeter of designated rectangular
! area into contour array as a continuous contour.
!
        if (auto_limit) then
          call domain_contour (spherical, im,jm, x,y, xra,yra)
        elseif (square_map) then
          dh=(plim2(2)-plim1(2))/float(im-1)
          do i=1,im-1
            call maptrn (plim1(1), plim1(2)+dh*float(i-1),
     &                                     xra(i), yra(i))
          enddo

          dh=(plim3(1)-plim2(1))/float(jm-1)
          shft=im-1
          do j=1,jm-1
            call maptrn (plim2(1)+dh*float(j-1), plim2(2),
     &                           xra(shft+j), yra(shft+j))
          enddo

          dh=(plim3(2)-plim4(2))/float(im-1)
          shft=2*im+jm-1
          do i=im,2,-1
            call maptrn (plim4(1), plim4(2)+dh*float(i-1),
     &                           xra(shft-i), yra(shft-i))
          enddo

          dh=(plim4(1)-plim1(1))/float(jm-1)
          shft=2*(im+jm-1)
          do j=jm,2,-1
            call maptrn (plim1(1)+dh*float(j-1), plim1(2),
     &                            xra(shft-j), yra(shft-j))
          enddo
        endif
!
! Determine left-right and bottom-top extends of the perimeter.
! In searching for minimum and maximum avoid non-projectable points.
! It should be noted that NCAR graphics library projection routine
! maptrn sets xra(i) to a large value (like 1.0E+12 or so), if input
! point is not prijectable. The criterion to reject non-projectable
! points used here is to see whether the point belongs to the default
! user-coordiane bounds set by the preceeding mapset->mapint->getset.
! Since these were "maximum useful area", any projectable point
! should be within. 
! 
        if (auto_limit .or. square_map) then
          vl=+spval1
          vr=-spval1                    ! Use temporal variables for
          vb=+spval1                    ! bounds, then copy them to
          vt=-spval1                    ! ul...ut. In principle it is
          do i=1,2*(im+jm-2)
            if (ul.le.xra(i) .and. xra(i).le.ur .and.
     &          ub.le.yra(i) .and. yra(i).le.ut) then 
              vl=min(vl, xra(i))
              vr=max(vr, xra(i))        ! possible that none of the
              vb=min(vb, yra(i))        ! perimeter points "xra,yra"
              vt=max(vt, yra(i))        ! is projectable, so that  
            else                        ! the bounds cannot be
              xra(i)=spval1             ! determined. In this case,
              yra(i)=spval1             ! ul...ut remain as they 
            endif                       ! are set before, i.e.
          enddo
          if (vl.lt.vr .and. vb.lt.vt) then
            ul=vl
            ur=vr                       ! corresponding to the
            ub=vb                       ! "maximum useful area".
            ut=vt
          endif
#if VERBOSE > 2
          write(*,'(12x,A,3x,A,4F9.4/12x,A,F8.4)')
     &            'Auto limits:',  'ul,ur,ub,ut =',   ul,ur,ub,ut,
     &            'Aspect ratio of useful area =', (ut-ub)/(ur-ul)
#endif
        endif
        Xphys=abs(ur-ul)            ! Geometric sizes of the domain 
        Yphys=abs(ut-ub)            ! needed to preserve aspect ratio 
      else
#if VERBOSE > 2
        write(*,'(1x,A)') 'CNT_FRAME: Cartezian mapping.'
#endif
        ul=x(1)                     !
        ur=x(im)                    ! Set Cartesian map viewport.
        ub=y(1)                     !==== ========= === =========
        ut=y(1+(jm-1)*im)
        Xphys=xbasin         
        Yphys=ybasin
      endif

      if (keep_asp_ratio) then      ! Adjust viewport to fit color
        do i=1,2                    ! bar, keep physical aspect ratio
          xc(i)=fl                  ! of the domain, and, at the same 
          if (i.eq.1) then          ! time, make the size of the plot
            xc(i+2)=fr              ! as large as possible.
            yc(i)=fb+Ybar
          else                      ! To achieve that, try both
            xc(i+2)=fr-Xbar         ! options for position of color 
            yc(i)=fb                ! bar, horizontal (i=1) or 
          endif                     ! vertical (i=2). Whichever  
          yc(i+2)=ft                ! results in the larger area of
          SizeX=xc(i+2)-xc(i)       ! the plot is is accepted.  
          SizeY=yc(i+2)-yc(i)

          dh=SizeX*Yphys-SizeY*Xphys
          if (dh.gt.0.) then
            dh=0.5*dh/Yphys
            xc(i  )=xc(i  )+dh
            xc(i+2)=xc(i+2)-dh
          else
            dh=-0.5*dh/Xphys
            yc(i  )=yc(i  )+dh
            yc(i+2)=yc(i+2)-dh
          endif
          plot_area(i)=(xc(i+2)-xc(i))*(yc(i+2)-yc(i))
        enddo

        if (ipref.eq.0 .or. ipref.eq.1) then
          ipos=ipref
        elseif (plot_area(1) .gt. plot_area(2)) then
          ipos=0 
        else
          ipos=1
        endif

        fl=xc(ipos+1)
        fr=xc(ipos+3)
        fb=yc(ipos+1)
        ft=yc(ipos+3)

#if VERBOSE > 2
        write(*,'(8x,A,I2)') 'Preserving aspect ratio, ipos =', ipos
#endif
      elseif (ipos.eq.1) then      ! Create margin on the
        fr=fr-Xbar                 ! right or near the bottom 
      elseif (ipos.eq.0) then      ! to accomodate color bar.
        fb=fb+Ybar
      endif
!
! Report viewport information and set plotting frame..
!
#if VERBOSE > 2
        write(*,'(12x,A,2x,A,4F9.4/27x,A,4F9.4)')  'Final values:',
     &   'fl,fr,fb,ft =', fl,fr,fb,ft, 'ul,ur,ub,ut =', ul,ur,ub,ut
#elif VERBOSE > 1
      write(6,'(/2x,A,I3,13x,A,I3,4(/14x,A,F10.4,6x,A,F10.4)/)')
     & 'CNT_FRAME - plots/page       =', npage, 'current ipltpg  =',
     & ipltpg,'frame left    fl =', fl,   'frame right  fr =', fr,
     &        'frame bottom  fb =', fb,   'frame top    ft =', ft,
     &        'box Xmin      ul =', ul,   'box Xmax     ur =', ur,
     &        'box Ymin      ub =', ub,   'box Ymax     ut =', ut
#endif
      call set (fl,fr,fb,ft, ul,ur,ub,ut, 1)

      if (lwater .and. icolor.ne.0) then
#if VERBOSE > 2 
        write(*,*) 'Filling model domain with water.'
#endif
        if (.not.auto_limit) then
          call domain_contour (spherical, im,jm, x,y, xra,yra)
        endif
        call gsfaci (ncl+3)
        call gfa (2*(im+jm-2), xra,yra)
      elseif (lview .and. icolor.ne.0) then
#if VERBOSE > 2
        write(*,*) 'Filling viewport with water.'
#endif
        xc(1)=ul
        yc(1)=ub
        xc(2)=ur
        yc(2)=ub
        xc(3)=ur
        yc(3)=ut
        xc(4)=ul
        yc(4)=ut
        call gsfaci (ncl+3)
        call gfa (4, xra,yra)
      endif
!
! The following code segment fills continents with land color. If
! no coastline data file is supplied, NCAR Graphics Library Ezmap A
! or B datasets and utilities are used. EzmapA is older, coarse
! resolution dataset. EzmapB is a new one, created in 1998. It has
! much finer resolution and, consequently creates greater files.
! NOTE: filling algorithms are non-robust, especially in PostScript
! mode, when coastline is too complex (hence "B" is more subjected
! to it), resulting in area misidentification and missed colors.
! To fix the problem, areas are broken into vertical stripes, which
! are filled separately. The number of strips is controlled by
! parameter 'VS' (see code segment below). The downside is that
! stripes are visible.
!
      if (lland .and. spherical) then
#if VERBOSE > 2
        write(*,'(1x,A$)') 'Filling continents...'
#endif
        if (firstmap.eq.0) then
#if VERBOSE > 2
        write(*,'(1x,3A$)') 'creating area map ''',earthdat(1:8),''''
#endif
          call arinam (landmap,lmap)
          if (coastline(1:4) .ne. 'none') then
c**         call landmask (landmap)
          elseif (earthdat(1:7) .eq. 'Earth..') then
            call mapsti ('VS',64)
            call mapsti ('G1', 1)
            call mapsti ('G2', 2)
            call mapbla (landmap)
            call mplnam (earthdat, 1, landmap)
          else    
            call mapsti ('VS', 0)
            call mapsti ('G1', 1)
            call mapsti ('G2', 0)
            call mapbla (landmap)
          endif
        endif
        call arpram (landmap,0,0,0)
        if (icolor.eq.0) then 
          dh=0.8
          call gscr (1, ncl+2, dh,dh,dh)
        endif
        call gsfaci (ncl+2)
#if VERBOSE > 2
        write(*,'(1x,A$)') 'drawing...'
#endif
        call arscam (landmap, xcs,ycs,mcs, iai,iag,mai, fill989)
#if VERBOSE > 2
        write(*,'(1x,A)') 'done.'
#endif
      endif

c**      call landfill (x,y, im,jm, f6, f6(2*(im+jm)))

      if (lframe) then
        call gslwsc (thin_line)         ! Outline viewport
        call line (ul,ub, ul,ut)        ! box, if needed.
        call line (ul,ut, ur,ut)
        call line (ur,ut, ur,ub)
        call line (ur,ub, ul,ub)
        call gslwsc (medium_line)
      endif
#if VERBOSE > 2
      write(*,*) 'return from cnt_frame.'
#endif
      firstmap=1
      return
      end

      subroutine fill989 (xcra,ycra,ncra, iai,iag,ngps)
      implicit none
      integer ncra,ngps,             i,    itm
      integer iai(ngps),iag(ngps),   iclr, mapaci
      real xcra(ncra), ycra(ncra)
      logical visible, shade 
#include "pltncar.h"
                                                 ! Fill area with
      itm=-1                                     ! identifier 989,
      visible=.true.                             ! with respect to
      do i=1,ngps                                ! group 1.
        if (iai(i).lt.0) then
          visible=.false. 
        elseif (iai(i).gt.itm) then
          itm=iai(i)
        endif
      enddo
      if (visible .and. itm.gt.0) then
        shade=.false. 
        iclr=mapaci(itm)
        if (earthdat(1:7) .eq. 'Earth..') then
          if (itm.eq.989) shade=.true.
c**       if (iclr.ne. 6) shade=.true.
        else
          if (iclr.eq.2) shade=.true.
        endif
        if (shade) then
          i=1
          do while (i.lt.ncra) 
            if (xcra(i).gt.fl .and. xcra(i).lt.fr .and.
     &          ycra(i).gt.fb .and. ycra(i).lt.ft) then    
              i=ncra+1
            else
              i=i+1
            endif
          enddo
c          if (i.eq.ncra+1) then
c            do i=1,ncra
c              if (xcra(i).lt.fl) xcra(i)=fl
c              if (xcra(i).gt.fr) xcra(i)=fr 
c              if (ycra(i).lt.fb) ycra(i)=fb
c              if (ycra(i).gt.ft) ycra(i)=ft
c              if (i.gt.1) call line (xcra(i),xcra(i),
c     &                     xcra(i-1),xcra(i-1))
c            enddo



          call gsclip (1)
c        call gsfaci (1)
c        call curved (xcra,ycra, ncra)
c        call line (fl,fb, fl,ft)
c        call line (fl,ft, fr,ft)
c        call line (fr,ft, fr,fb)
c        call line (fr,fb, fl,fb)
c        call line (fl,fb, fr,ft)
c        call line (fl,ft, fr,fb)


c          call set (fl,fr,fb,ft, fl,fr,fb,ft, 1)
          call gsclip (1)


c**       call gsfaci (iclr)
          call gsfaci (ncl+2)
          call gfa (ncra-1,xcra,ycra)

c          call set (fl,fr,fb,ft, ul,ur,ub,ut, 1)
         

c          endif
        endif
      endif
c**   write(*,'(I3,5(2x,2I5))') ngps, (iag(i),iai(i), i=1,ngps),
c**  &                                                ncra, iclr
      return
      end

