      subroutine cnt_end_frame (icolor)
!
! Draw background plot like grid, coastlines, top and bottom titles
! and various overlays.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer icolor, ierr, i, lstr, lenstr
      real xg, delta, delmin, xpt, x1,x2, xl,xr, lon, xlab, sizeX,
     &      fontsize, delmaj, ypt, y1,y2, yb,yt, lat, ylab, sizeY
      logical floats
      character*6 string

#include "pltio.h"
#include "pltlab.h"
#include "pltfld.h"
#include "pltncar.h"
#include "pconst.h"
#include "landmap.h"
#include "cities.h"

      fontsize=0.01*basesize
      sizeX=ur-ul
      sizeY=ut-ub
!
! Set line pattern: solid lines (65535) or dash lines (43690).
!
      call dashdb (43690)
!
! Draw spherical grid and label it.
!===== ========= ==== === ===== ===
!
      if (spherical .and. (proj.eq.'CE' .or. proj.eq.'ME') .and.
     &       plim1(1).lt.plim3(1) .and. plim1(2).lt.plim3(2)) then
        if (ltmarks) then
          call maptrn (plim1(1),plim1(2), xl,yb)
          call maptrn (plim3(1),plim3(2), xr,yt)
!
! Determine if axis labels are integer or floats.
!
          delta=abs(lgrid)-float(int(abs(lgrid)))
          floats=.false.
          if (delta.gt.0.) floats=.true.
!
! Draw iso-latitude grid-lines and write labels.
!
          xlab=ul-0.0075*sizeX
          if (mod(plim3(1)-plim1(1),abs(lgrid)).eq.0.) then
            lat=plim1(1)
          else
            lat=plim1(1)-mod(plim1(1),abs(lgrid))
          endif
          call maptrn (lat,plim1(2), xpt,ypt)
          do while (ypt.le.yt)
            if (ypt.ge.yb) then
              call maptrn (lat,plim1(2), x1,y1)
              call maptrn (lat,plim3(2), x2,y2)
              call gslwsc (thin_line)
              call lined (x1,y1, x2,y2)
              call gslwsc (medium_line)
              ylab=y1

              if (fr-2.*fl.gt.0.) then
                if (floats) then
                  write(string,'(F6.1)') lat
                else
                  write(string,'(I6)') int(lat)
                endif
                lstr=lenstr (string)
                call plchhq (xlab,ylab, string(1:lstr),
     &                                  fontsize,0.,+1.)
              endif
            endif
            lat=lat+abs(lgrid)
            call maptrn (lat,plim1(2), xpt,ypt)
          enddo
!
! Draw iso-longitude grid-lines and write labels.
!
          if (lgrid.gt.0.) then
            ylab=ut+0.015*sizeY
          else
            ylab=ut+0.0075*sizeY
          endif
          if (mod(plim3(2)-plim1(2),abs(lgrid)) .eq. 0.) then
            lon=plim1(2)
          else
            lon=plim1(2)-mod(plim1(2),abs(lgrid))
          endif
          call maptrn (plim1(1),lon, xpt,ypt)
          do while (xpt.le.xr)
            if (xpt.ge.xl) then
              call maptrn (plim1(1),lon, x1,y1)
              call maptrn (plim3(1),lon, x2,y2)
              call gslwsc (thin_line)
              call lined (x1,y1, x2,y2)
              call gslwsc (medium_line)

              if (2.*ft-fb.gt.1.) then
                if (xpt.gt.180.) then
                  xg=xpt-360.
                else
                  xg=lon
                endif
                if (floats) then
                  write(string,'(F6.1)') xg
                else
                  write(string,'(I6)') int(xg)
                endif
                lstr=lenstr (string)

                xlab=x2
                if (lgrid.gt.0.) then
                  if (xg.lt.0) lstr=lstr+1
                  call plchhq (xlab,ylab, string(1:lstr),
     &                                    fontsize, 0., 0.)
                else
                  call plchhq (xlab,ylab, string(1:lstr),
     &                                    fontsize,90.,-1.)
                endif
              endif
            endif
            lon=lon+abs(lgrid)
            call maptrn (plim1(1),lon, xpt,ypt)
          enddo
        endif

      elseif (spherical) then
!
! Use EZMAP package to draw grid and continent outlines in the case
! of sophisticated spherical projections. The meaning of these calls
! is as follows: "mapgrd" draws lon-lat grid on the surface of the
! sphere;  "maplbl" puts labels;
!
#if VERBOSE > 2
        write(*,'(1x,2A)') 'Calling EZMAP grid drawing, proj=',proj
#endif

c**     if (icolor.eq.0) then
c**       call mapsti ('DA - solid dash patern for grids', 65535)
c**     elseif (icolor.eq.1) then
          call mapstl ('DL - draw dotted lines', .true.)
          call mapsti ('DD - distance between dots',  4)
c**     endif
        call mapstc ('OU - outline data set', 'CO')
        call mapsti ('VS - vertical stripping', 0)
        call mapstr ('GR - grid spacing in degrees', lgrid)
        call mapstl ('PE - draw map perimeter', .false.)

        call mapgrd
        call maplbl
      elseif (ltmarks) then
!
! Draw Cartesian grid.                    ! Determine increments
!===== ========= =====                    ! for X-axis major and
!                                         ! minor tick marks.
        if (int((ur-ul)/5.).le.10) then 
          delmin=5.
          delmaj=25.
        elseif (int((ur-ul)/10.).le.10) then
          delmin=10.
          delmaj=50.
        elseif (int((ur-ul)/100.).le.5) then
          delmin=20.
          delmaj=100.
        elseif (int((ur-ul)/200.).le.5) then
          delmin=50.
          delmaj=200.
        elseif (int((ur-ul)/500.).le.5) then
          delmin=100.
          delmaj=500.
        elseif (int((ur-ul)/1000.).le.5) then
          delmin=200.
          delmaj=1000.
        else
          delmin=500.
          delmaj=5000.
        endif

        yt=ut-0.01*sizeY                  ! Draw minor tick marks.
        yb=ub+0.01*sizeY
        xpt=0.
        do while (xpt+delmin.le.ur)
          xpt=xpt+delmin
          if (xpt.ge.ul) then
            call line (xpt,ut, xpt,yt)
            call line (xpt,ub, xpt,yb)
          endif
        enddo

        xlab=ut+0.015*sizeY             ! Label horizontal X-axis
        yt=ut-0.025*sizeY               ! and draw its associated
        yb=ub+0.025*sizeY               ! major tick marks.
        xpt=0.
        do while (xpt.le.ur)            ! Do not label, if more
          if (xpt.ge.ul) then           ! than one plot per page
            call line (xpt,ut, xpt,yt)  ! and the edge of the
            call line (xpt,ub, xpt,yb)  ! plot not near the edge
            if (2.*ft-fb.gt.1.) then    ! of the page. 
              if (xpt.eq.0.) then
                string='0 km'
              else
                write(string,'(I6)') int(xpt)
              endif
              lstr=lenstr (string)
              call plchhq (xpt,xlab,string(1:lstr),fontsize,0.,0.)
            endif
          endif
          xpt=xpt+delmaj
        enddo                           ! Determine increments
                                          ! for X-axis major and
        if (int((ut-ub)/5.).le.10) then ! minor tick marks. 
          delmin=5.
          delmaj=25.
        elseif (int((ut-ub)/10.).le.10) then
          delmin=10.
          delmaj=50.
        elseif (int((ut-ub)/100.).le.5) then
          delmin=20.
          delmaj=100.
        elseif (int((ut-ub)/200.).le.5) then
          delmin=50.
          delmaj=200.
        elseif (int((ut-ub)/500.).le.5) then
          delmin=100.
          delmaj=500.
        else
          delmin=200.
          delmaj=1000.
        endif
        xl=ul+0.01*sizeX                ! Draw minor tick marks.
        xr=ur-0.01*sizeX
        ypt=0.
        do while (ypt+delmin.le.ut)
          ypt=ypt+delmin
          if (ypt.ge.ub) then
            call line (ul,ypt, xl,ypt)
            call line (ur,ypt, xr,ypt)
          endif
        enddo

        xl=ul+0.025*sizeX               ! Label horizontal Y-axis
        xr=ur-0.025*sizeX               ! and draw its associated
        ylab=ul-0.015*sizeX             ! major tick marks.
        ypt=0.
        do while (ypt.le.ut)
          if (ypt.ge.ub) then
            call line (ul,ypt, xl,ypt)
            call line (ur,ypt, xr,ypt)
            if (fr-2.*fl.gt.0.) then
              if (ypt.eq.0.) then
                string='0 km'
              else
                write(string,'(I6)') int(ypt)
              endif
              lstr=lenstr (string) 
              call plchhq (ylab,ypt,string(1:lstr),fontsize,90.,0.)
            endif
          endif
          ypt=ypt+delmaj
        enddo
      endif
      call dashdb (65535)
!
! The following code segment draws coastline. As in the case of
! shading land areas, see "cnt_set_frame.F", there are three options:
!
!    (i) read user supplied coastline data file, if it is available; 
!
!   (ii) otherwise use internal NCAR library data sets. There are
!        two of them, the "new" one, known as Ezmap B (since 1998).
!        This option is activated by setting earthdat='Earth..1',
!        '..2' or '..3';
!
!  (iii) if parameter earthdat is not set, use "old" Ezmap A dataset.
!       
! In the case of user supplied file: because the data file is stored
! in a very unefficient format, i.e., each record contains only two
! numbers, while the total number of point (lines in the file) may
! easily reach 50000), the file is only read only once. Subsequently,
! costline is drawn from already extracted and processed data stored
! in the arrays xcst,ycst. During the first pass the read data file
! point by point, convert lon,lat coordinate into user coordinates,
! extract and save coordinates of points which fall within the
! viewport ul,ur,ub,ut. In addition to that, detect and save indices
! in that arrays at which the coast line breaks. Breaking occurs
! because the data is labelled by special value "spvgeo" separating
! closed segments in the datafile, as well as because the line leaves
! viewport, or the associated points are non-projectable. Once, the
! whole file is read, draw the coastline. 
!
      if (spherical) then
#if VERBOSE > 1
        write(*,'(1x,A$)') 'Drawing coastline...'
#endif
        if (coastline(1:4).ne.'none') then
          if (ncst.eq.0) then            ! Read the costline file.
            nsgcst=1                     ! Note that "ncst" - total
            isgcst(nsgcst)=0             ! number of points - is used
#if VERBOSE > 1
            write(*,'(1x,A$)') 'reading file:'  ! as flag here, which
#endif
            read(inpcst,*,iostat=ierr) lat,lon  ! triggers reading.
            do while (ierr.eq.0)
              if (lon.ne.spvgeo .and. lat.ne.spvgeo) then
                call maptrn (lat,lon, xpt,ypt)
                if (xpt.ge.ul .and. xpt.le.ur .and.
     &              ypt.ge.ub .and. ypt.le.ut) then
                  ncst=ncst+1
                  xcst(ncst)=xpt
                  ycst(ncst)=ypt
                elseif (isgcst(nsgcst).lt.ncst) then
                  nsgcst=nsgcst+1
                  isgcst(nsgcst)=ncst
                endif
              elseif (isgcst(nsgcst).lt.ncst) then
                nsgcst=nsgcst+1
                isgcst(nsgcst)=ncst
              endif
              if (ncst.eq.ncstmax) then
                write(*,'(/1x,A,I6,A)') 'ERROR: parameter ncstmax =',
     &           ncstmax, ' is too small. Increase it and recompile.'
                stop
              endif
              if (nsgcst.eq.nsgmax) then
                write(*,'(/1x,A,I6,A)') 'ERROR: parameter nsgmax =',
     &           nsgmax, ' is too small. Increase it and recompile.'
                stop
              endif
              read(inpcst,*,iostat=ierr) lat,lon
            enddo
            if (isgcst(nsgcst).lt.ncst) then
              nsgcst=nsgcst+1
              isgcst(nsgcst)=ncst
            endif
            rewind (inpcst)
#if VERBOSE > 1
            write(*,'(2(1x,A,I6)$)') 'ncst =',ncst, 'nsgcst =',nsgcst
#endif
          endif                         ! Draw the coast line segment
          if (ncst.gt.0) then           ! by segment. Do not bother,
            call gslwsc (thick_line)    ! if no data is available.
            do i=1,nsgcst-1
              call curved (xcst(isgcst(i)+1), ycst(isgcst(i)+1),
     &                                  isgcst(i+1)-isgcst(i)-1)
            enddo
            call gslwsc (medium_line) 
          endif                         ! If no coastline data file
        else                            ! is supplied by the user,
          call gslwsc (thick_line)
          if (earthdat(1:7) .eq. 'Earth..') then
            call mplndr (earthdat, 1)
          else                          ! use NCAR graphics library
            call maplot                 ! EzmapA or EzmapB utility
          endif                         ! and dataset to draw 
          call gslwsc (medium_line)     ! continent outlines. 
        endif
#if VERBOSE > 1
            write(*,'(1x,A)') ' ...done.'
#endif
      endif
!
! Extract coordinates and names of geographic objects (e.g., cities)
! from the array where they were saved, and draw them on the map.
!
      do i=1,ncities
        if (i.eq.1) then
          call gslwsc (thick_line)
#if VERBOSE > 1
          write(*,'(1x,A$)')   'Drawing cities'
#endif
        endif
        if (spherical) then
          call maptrn (xcity(1,i),xcity(2,i), xpt,ypt)
        else
          xpt=xcity(2,i)
          ypt=xcity(1,i)
        endif
        if (ul.lt.xpt .and. xpt.lt.ur .and.
     &      ub.lt.ypt .and. ypt.lt.ut) then
          lstr=int(xcity(6,i))
          call plchhq (xpt,ypt, city(i)(1:lstr), basesize*xcity(3,i),
     &                                        xcity(4,i), xcity(5,i))
#if VERBOSE > 1
          write(*,'(1x,A$)') '.'
#endif
        endif
        if (i.eq.ncities) then
          call gslwsc (medium_line)
#if VERBOSE > 1
          write(*,'(1x,A)') 'done'
#endif
        endif
      enddo 
      return
      end
