      subroutine checkstrm (text, lstr, string)
!
! Because NCAR graphics routine plchhq treats colon as a special
! character which is used to encase font switches, if colon character 
! is met within the string, it needs to be overwritten with the
! correct NCAR syntax for colon, i.e. ':133:' in order for plchhq to
! work properly.
!
! However, if colon is associated with the NCAR graphics font
! switches DO NOT OVERWRITE THEM. These colons occur (1) only pairs;
! and (2) there are no less than one and no more than four symbols
! between these colons; and (3) these symbols may be only letters or
! digits; and (4) if both letters and digits are present, the code
! must start with a letter (e.g., :123: and :F10: are accepted as
! switches, but :1F0: is not).
!
      implicit none
      character*(*) text,string
      integer lstr,  i,j, nx,ix(0:16), digits, letters, lenstr
      logical first_letter

      lstr=lenstr(string)                ! Examine the input string:
      nx=0                               ! find and record positions
      do i=1,lstr                        ! of all colons, if any.
        if (string(i:i).eq.':') then
          nx=nx+1                        ! Then, if more than one
          ix(nx)=i                       ! colon is found, examine
        endif                            ! further to identify
      enddo                              ! NCAR font switches.

      if (nx.gt.1) then
        do j=1,nx-1
          if (ix(j+1)-ix(j).lt.6 .and. ix(j+1)-ix(j).gt.1
     &                      .and. ix(j)*ix(j+1).ne.0) then
            digits=0
            letters=0                    ! Check that no other
            first_letter=.true.          ! symbols, except digits
            do i=ix(j)+1,ix(j+1)-1       ! and letters are present.
              if (string(i:i).ge.'0' .and.
     &             string(i:i).le.'9') then
                digits=digits+1 
                if (i.eq.ix(j)+1) first_letter=.false.
              elseif (string(i:i).ge.'A' .and.
     &                string(i:i).le.'Z') then
                letters=letters+1
c**           elseif (string(i:i).ge.'a'  .and.
c**  &                string(i:i).le.'z') then
c**             letters=letters+1
              endif
              if ((first_letter .or. letters.eq.0) .and.
     &            digits+letters.eq.ix(j+1)-ix(j)-1) then
c**             write(*,'(1x,3A)') 'font switch = ''',
c**  &                     string(ix(j):ix(j+1)), ''''
                ix(j)=0
                ix(j+1)=0                ! Mark colons associated
              endif                      ! with NCAR font switches
            enddo                        ! for the subsequent
          endif                          ! exclusion from the list
        enddo                            ! of colons.
        i=0
        do j=1,nx
          if (ix(j).gt.0) then           ! Exclude the marked
            i=i+1                        ! colons from the list 
            ix(i)=ix(j)                  ! and rearrange indexing
          endif                          ! to shorten the list
        enddo                            ! accordingly.
        nx=i 
      endif
      ix(0)=0
      ix(nx+1)=lstr+1

      lstr=0                             ! Segment-by-segment copy
      do j=0,nx                          ! the input string into the
        if (ix(j).gt.0) then             ! target text and overwrite
          text(lstr+1:lstr+5)=':133:'    ! remaining colons with
          lstr=lstr+5                    ! special code.
        endif
        text(lstr+1:lstr+ix(j+1)-ix(j)-1)=string(ix(j)+1:ix(j+1)-1)
        lstr=lstr+ix(j+1)-ix(j)-1
      enddo
      return 
      end

c--#define TEST_CHECKSTRM
#ifdef TEST_CHECKSTRM
      implicit none
      character*64 text, string 
      integer lstr
  1   write(*,'(A,$)') 'Enter string: '
      read(*,'(A)') string
      call checkstrm (text,lstr,string)
      write(*,'(/1x,3A,I3/)') 'text = ''', text(1:lstr),
     &                               ''' lstr = ', lstr
      goto 1
      end
#endif

