      subroutine cgrid (x,y,im,jm, xg,yg,img,jmg, igrid,derive)
!
! Computes requested horizontal grid from curvilinear metric
! coefficients.
!
! input:  im,jm   dimensions of the desired grid "x,y"
!         xg,yg   either  LON,LAT- or X,Y-coordinates or curvilinear
!                      metric coefficients pm,pn of given "old" grid
!                      assumed to be defined at RHO-points
!         img,jmg
!                    in XI-direction.
!         yg         Curvilinear metric (m) or latitude (degrees)
!                    in the ETA-direction.
!         img         Size of inner dimension for "xg" and "yg".
!         jmg         Size of outer dimension for "xg" and "yg".
!         igrid     desired grid type: 
!                      igrid=0  => None.
!                      igrid=1  => density points.
!                      igrid=2  => streamfunction points.
!                      igrid=3  => u-velocity points.
!                      igrid=4  => v-velocity points.
!                      igrid=5  => w-velocity points.
!                      igrid=6  => w-velocity points, range 0:N.
!                      igrid=7  => interior density points.
!         derive     Switch to derive Cartesian grid (logical).
!
! output:  x,y     X,Y-coordinates of nodes of the desired "new" grid
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
      integer im,jm, img,jmg, i,j, igrid
      real x(im,jm),y(im,jm),  xg(img,jmg),yg(img,jmg)
      logical derive
!
! Compute/Derive requested grid.
!--------------- --------- -----
!
      if (.not.derive) then
        if (igrid.eq.1 .or. igrid.eq.5 .or. igrid.eq.6) then
          do j=1,jm
            do i=1,im                            ! Compute horizontal
              x(i,j)=xg(i,j)                     ! grid positions
              y(i,j)=yg(i,j)                     ! at RHO-points.
            enddo
          enddo
        elseif (igrid.eq.2) then                 ! at streamfunction
          do j=1,jm                              ! points.
            do i=1,im
              x(i,j)=0.25*(xg(i,j)+xg(i+1,j)+xg(i,j+1)+xg(i+1,j+1))
              y(i,j)=0.25*(yg(i,j)+yg(i+1,j)+yg(i,j+1)+yg(i+1,j+1))
            enddo
          enddo
        elseif (igrid.eq.3) then
          do j=1,jm
            do i=1,im
              x(i,j)=0.5*(xg(i,j)+xg(i+1,j))     ! at U-velocity
              y(i,j)=0.5*(yg(i,j)+yg(i+1,j))     ! points.
            enddo
          enddo
        elseif (igrid.eq.4) then
          do j=1,jm
            do i=1,im                          
              x(i,j)=0.5*(xg(i,j)+xg(i,j+1))     ! at V-velocity
              y(i,j)=0.5*(yg(i,j)+yg(i,j+1))     ! points.
            enddo
          enddo
        elseif (igrid.eq.7) then
          do j=1,jm
            do i=1,im                            ! at interior
              x(i,j)=xg(i+1,j+1)                 ! density points.
              y(i,j)=yg(i+1,j+1)
            enddo
          enddo
        endif
      else                                              ! Derive
        do j=1,jm                                       ! Cartesian 
          do i=1,im                                     ! grid from  
            xg(i,j)=1./xg(i,j)                          ! curvilinear 
            yg(i,j)=1./yg(i,j)                          ! metric
          enddo                                         ! terms.
        enddo
        if (igrid.eq.1 .or. igrid.eq.5 .or. igrid.eq.6) then
          do j=1,jm
            x(1,j)=-0.5*xg(1,j)
            do i=2,im                                   ! Compute 
              x(i,j)=x(i-1,j)+0.5*(xg(i-1,j)+xg(i,j))   ! horizontal 
            enddo                                       ! grid 
          enddo                                         ! positions
          do i=1,im                                    ! at
            y(i,1)=-0.5*xg(i,1)                         ! RHO-points.
            do j=2,jm
              y(i,j)=y(i,j-1)+0.5*(yg(i,j-1)+yg(i,j))
            enddo
          enddo
        elseif (igrid.eq.2) then                        ! at PSI-
          do j=1,jm                                    ! points
            x(1,j)=0.
            do i=2,im
              x(i,j)=x(i-1,j)+xg(i,j)
            enddo
          enddo
          do i=1,im
            y(i,1)=0.
            do j=2,jm
              y(i,j)=y(i,j-1)+yg(i,j)
            enddo
          enddo
        elseif (igrid.eq.3) then
          do j=1,jm
            x(1,j)=0.                                   ! at U-points
            do i=2,im
              x(i,j)=x(i-1,j)+xg(i,j)
            enddo
          enddo
          do i=1,im
            y(i,1)=-0.5*xg(i,1)
            do j=2,jm
              y(i,j)=y(i,j-1)+0.5*(yg(i,j-1)+yg(i,j))
            enddo
          enddo
        elseif (igrid.eq.4) then
          do j=1,jm                                    ! at V-points
            x(1,j)=-0.5*xg(1,j)
            do i=2,im
              x(i,j)=x(i-1,j)+0.5*(xg(i-1,j)+xg(i,j))
            enddo
          enddo
          do i=1,im
            y(i,1)=0.
            do j=2,jm
              y(i,j)=y(i,j-1)+yg(i,j)
            enddo
          enddo
        elseif (igrid.eq.7) then
          do j=1,jm
            x(1,j)=0.5*xg(2,j+1)
            do i=2,im                                    ! at 
              x(i,j)=x(i-1,j)+0.5*(xg(i,j+1)+xg(i+1,j+1))! interior
            enddo                                        ! density
          enddo                                          ! points.
          do i=1,im
            y(i,1)=-0.5*xg(i+1,2)
            do j=2,jm
              y(i,j)=y(i,j-1)+0.5*(yg(i+1,j)+yg(i+1,j+1))
            enddo
          enddo
        endif
      endif
      return
      end
