      subroutine cfield (fout,im,jm,km,finp,imr,jmr,kmr,igrid)
!
! This routine computes computes field at requested horizontal
! grid positions from the original field at RHO-points.
!
! input: im,jm,km     sizes of X,Y,Z-dimensions of array "fout".
!        finp         input field at RHO-points.
!        imr,jmr,kmr  X,Y,Z-dimensions of array "finp".
!        igrid        staggered C grid type:
!
!     igrid=1 => density points          5 => w-velocity points
!           2 => streamfunction points   6 => w-velocity points,
!           3 => u-velocity points                       range 0:N
!           4 => v-velocity points       7 => interior density points
!
! output: fout  field at requested grid.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none
#include "pconst.h"

      integer i, igrid, im, imr, j, jm, jmr, k, km, kmr
      real finp(imr,jmr,kmr), fout(im,jm,km)

      if (igrid.eq.1 .or. igrid.eq.5) then   ! Compute field
        do k=1,km                            ! at RHO-points...
          do j=1,jm
            do i=1,im
              fout(i,j,k)=finp(i,j,k)
            enddo
          enddo
        enddo
      elseif (igrid.eq.2) then               ! at PSI-points...
        do k=1,km
          do j=1,jm
            do i=1,im
              if (finp(i  ,j  ,k).eq.spval1 .or.
     &            finp(i+1,j  ,k).eq.spval1  .or.
     &            finp(i  ,j+1,k).eq.spval1  .or.
     &            finp(i+1,j+1,k).eq.spval1) then
                fout(i,j,k)=spval1
              else
                fout(i,j,k)=0.25*(finp(i,j  ,k)+finp(i+1,j  ,k)+
     &                            finp(i,j+1,k)+finp(i+1,j+1,k))
              endif
            enddo
          enddo
        enddo
      elseif (igrid.eq.3) then               ! at U-points...
        do k=1,km
          do j=1,jm
            do i=1,im
              if (finp(i  ,j  ,k).eq.spval1 .or.
     &            finp(i+1,j  ,k).eq.spval1) then
                fout(i,j,k)=spval1
              else
                fout(i,j,k)=0.5*(finp(i,j,k)+finp(i+1,j,k))
              endif
            enddo
          enddo
        enddo
      elseif (igrid.eq.4) then               ! at V-points...
        do k=1,km
          do j=1,jm
            do i=1,im
              if (finp(i  ,j  ,k).eq.spval1 .or.
     &            finp(i  ,j+1,k).eq.spval1) then
                fout(i,j,k)=spval1
              else
                fout(i,j,k)=0.5*(finp(i,j,k)+finp(i,j+1,k))
              endif
            enddo
          enddo
        enddo
      elseif (igrid.eq.7) then               ! at interior
        do k=1,km                            ! RHO-points...
          do j=1,jm
            do i=1,im
              fout(i,j,k)=finp(i+1,j+1,k)
            enddo
          enddo
        enddo
      endif
      return
      end
