!
! Contours the desired field(s) at the given depth level(s) and
! time(s) using NCAR GKS plotting package. Unified code for COLOR
! or MONOCHROME versions.
!
! Copyright (c) 1996 Rutgers University
!
#ifdef MONOCHROME
      program cnt
#else
      program ccnt
#endif
      implicit none
      real*8 day
      real level, lev,  fmin, fmax, favg,  frms, fsdv,
     &                       cmin, cmax,  cint, cntint
      integer imask, icolor,  clr2, clrV, ipos,  ipm,
     &        indx, n, idfd, i,np, ictime, page_number
      parameter (imask=0,
#ifdef MONOCHROME
     &           icolor=0, clr2=0, clrV=0)
#else
     &                   icolor=1, clr2=2)
#endif
#include "ndimen.h"
#include "param.h"
#include "pconst.h"
#include "domdat.h"
#include "fields.h"
#include "fldsid.h"
#include "ncinfo.h"
#include "pltfld.h"
#include "pltio.h"
#include "pltncar.h"
#include "cntwkspa.h"
                                   ! Set switch for plot type.
      plttyp=cntplt                ! Read in plot job parameters,
      call read_inputs(iwrk)       ! default settings, and variable
      page_number=0                ! IDs. Reset page number counter,
      ipltpg=0                     ! counter of plots within the page
      gks_open=.false.             ! and and gks_open flag to signal
      ictime=1                     ! that NCAR GKS is not in active
      day=frstd                    ! state yet.

#ifdef MONOCHROME
      ipos=-1
#else
      ipos=+1                      ! Set default position of color
      if (lvcolor) then            ! bar to vertical. This may later 
        clrV=icolor                ! be overwritten by cnt_set_frame
      else                         ! fields, if it needs to conserve
        clrV=0                     ! physical aspect ratio. Also set
      endif                        ! color for vector overlays.
#endif

      do while (frstd.le.day .and. day.le.lastd)
        call get_pltday (day, ictime)
        do ipm=1,nfields*nlevels        ! If more than one field and
          if (levs_flds) then           ! more than one level need to
            indx=1 + (ipm-1)/nlevels    ! be plotted, set sequence:
            n=ipm - (indx-1)*nlevels    ! either plot all levels for 
          else                          ! the first field, then all
            n=1 + (ipm-1)/nfields       ! levels for the next and so
            indx=ipm - (n-1)*nfields    ! on... or all fields for
          endif                         ! the first level, then all
                                        ! fields for the next one and
          if (.not.gks_open) then       ! so on...
            gks_open=.true.
            call gks_init (postscript, page_number, icolor,ifill)
          endif
          timedepend=.false.
!
! Read primary field(s) at specified time:
!===== ======= ======== == ========= =====
!
          level=fldlev(n)
          call get_2dfld (day, x,y, f1,f2, np,1, fldid(indx),level)
          if (n.gt.1 .and. levless) goto 10
          if (iref.eq.3) then
            call get_2dfld (day,  x,y, f3,f4, np, 2, fldid(indx),
     &                                                       level)
            do i=1,np
              f1(i)=f1(i)-f3(i)
              f2(i)=f2(i)-f4(i)
            enddo
          elseif (iref.eq.4) then
            call get_2dfld (frstd, x,y, f3,f4, np, 1, fldid(indx), 
     &                                                      level)
            do i=1,np
              f1(i)=f3(i)-f1(i)
              f2(i)=f4(i)-f2(i)
            enddo
          endif
!                      First determine whether it is scalar, vector
! Plot primary field:  or streamlines plot, then find its min,max and
!----- ------- ------  other statistics and decide how to set bounds.
!                      Recall that vector magnitude ID is always
!                      fldid(indx)+1). 
!
          if (vtype(fldid(indx)).eq.2 .or.
     &        vtype(fldid(indx)).eq.5) then
            plot1=vect
          elseif (vtype(fldid(indx)).eq.6) then
            plot1=strml
          else
            plot1=scalar
          endif
          levless=is2d(fldid(indx))

          if (plot1.eq.scalar) then
            call fdiag (f1,im,jm, fldid(indx), day,level,
     &                         fmin,fmax, favg, frms,fsdv)
          elseif (plot1.eq.vect .or. plot1.eq.strml) then
            if (plot1 .eq. vect) then
              idfd=fldid(indx)+1
            elseif (plot1 .eq. strml) then
              idfd=fldid(indx)-1
            endif
            call vecmag (f3, f1,f2, im,jm, spval1)
            call  fdiag (f3, im,jm, idfd, day, level,
     &                     fmin,fmax, favg, frms, fsdv)
          endif

          if (pmax(ipm).ne.0. .or. pmin(ipm).ne.0) then
            cmin=pmin(ipm)
            cmax=pmax(ipm)
          elseif (sdv_fac.eq.0.) then
            cmin=fmin
            cmax=fmax
          else
            cmin=max(fmin,favg-sdv_fac*fsdv)
            cmax=min(fmax,favg+sdv_fac*fsdv)
          endif

          call cnt_set_frame (im,jm, icolor, ipos)
          call gsclip (1)
          if (plot1.eq.scalar) then
#ifdef MONOCHROME
            if (cntval(indx).ne.0.) then
              cint=cntval(indx)
            else
              cint=cntint (fldid(indx), lev, cmin,cmax, cont,
     &                                                  cfld, clev)
            endif
            call cntpack (f1,im,im,jm,cmin,cmax,cint,imask,icolor)
#else
            call cntcolor (f1, im,im,jm, cmin,cmax)
#endif
          elseif (plot1.eq.vect) then
            call vecpack (f3, f1,f2, im,im,jm, cmin,cmax, clrV)
          elseif (plot1.eq.strml) then
            call streamlines (f3,f1,f2, im,im,jm, cmin,cmax,clrV)
          endif
#ifndef MONOCHROME
          if (lclrbar .and. (plot1.eq.scalar  .or.
     &        (plot1.eq.vect .and. clrV.gt.0))) then
            call colorbar (cmin,cmax, ipos)
          endif
#endif
!                         Similarly to above: the procedure consists
! Read in overlay field:  of reading/computing the requested field, 
!===== == ======= ======  determine plot type: scalar/vector/stream- 
!                         lines, finding min/max and chosing plotting
!                         bounds and, finally plotting it.

          if ((iref.eq.1 .or. iref.eq.2) .and.idover(indx).ne.0) then
            if (levover(indx).eq.0.) then
              lev=level
            else
              lev=levover(indx)
            endif
            call get_2dfld (day, x,y,f1,f2,np, iref,idover(indx),lev)
          endif 
!                               ! Note that if iref=3 or 4, overlay
! Plot overlay field:           ! field is already computed above as
!----- ------- ------           ! as the difference from reference
!                               ! field.
          if (iref.ne.0) then
            if (idover(indx).eq.0) idover(indx)=fldid(indx)
            if (vtype(idover(indx)).eq.2 .or.
     &          vtype(idover(indx)).eq.5) then
              plot2=vect
            elseif (vtype(idover(indx)).eq.6) then
              plot2=strml
            else
              plot2=scalar
            endif
            levless=is2d(idover(indx))

            if (plot2.eq.scalar) then
              call fdiag (f1, im,jm, idover(indx), day,
     &                      lev, cmin,cmax, favg, frms,fsdv)
            elseif (plot2.eq.vect .or. plot2.eq.strml) then
              if (plot2.eq.vect) then
                idfd=idover(indx)+1
              elseif (plot2.eq.strml) then
                idfd=idover(indx)-1
              endif
              call vecmag (f3, f1,f2, im,jm, spval1)
              call  fdiag (f3, im,jm, idfd,  day, lev,
     &                     cmin,cmax, favg,  frms,fsdv)
            endif

            if (rmin(indx).ne.0. .or. rmax(indx).ne.0.) then
              cmin=rmin(indx)
              cmax=rmax(indx)
            elseif (sdv_fac .ne. 0.) then
              cmin=max(cmin,favg-sdv_fac*fsdv)
              cmax=min(cmax,favg+sdv_fac*fsdv)
            endif

            if (plot2.eq.scalar) then
              cint=cntint(idover(indx),lev, cmin,cmax, cont,
     &                                              cfld,clev)
              call cntpack (f1, im,im,jm, cmin,cmax,cint, imask,
     &                                                     clr2)
            elseif (plot2.eq.vect) then
              call vecpack (f3, f1,f2, im,im,jm, cmin,cmax,clr2)
            elseif (plot2.eq.strml) then
              call streamlines (f3, f1,f2, im,im,jm, cmin,cmax,
     &                                                    clr2)
            endif
          endif
!
! Draw background plot, write map titles, draw any USER application
! and advance frame when appropriate.
!
          if (ldomain) call dombox (im,jm)
          call cnt_end_frame (icolor)
          call maptitles (day, cint, fmin,fmax, frms,
     &               icolor, fldid(indx), level, ipos)
          call draw_user
          if (close_page) then
            call frame
            if (postscript) then   ! PostScript file sequence:
              call gdawk(1)        ! Close NCAR GKS completely,
              call gclwk(1)        ! be reopen and new file     
              call gclks           ! with different name will be
              gks_open=.false.     ! created for the next page.
            endif 
          endif
  10      continue
        enddo
      enddo                        ! Close GKS software
      call crash ('DONE',1)        ! and datasets.
      stop
      end
