       subroutine caldate (julian,month,iday,iyear,yday)
!
! This routine converts  Julian Day  number to calendar date.
! Input:  JULIAN  Julian day number, and
!
! Output: MONTH, IDAY, IYEAR as the month, day, and year.
!
! Copyright (c) 1996 Rutgers University.
!
      implicit none
      integer gregorian, iday, ileap, iyear, ja, jalpha,
     &        jb, jc, jd, je, julian, month, iyd(13), iydl(13)
      real yday
      parameter (gregorian=2299161)
      data iyd  /1,32,60,91,121,152,182,213,244,274,305,335,366/
      data iydl /1,32,61,92,122,153,183,214,245,275,306,336,367/

      if (julian.ge.gregorian) then
        jalpha=int(((julian-1867216)-0.25)/36524.25)
        ja=julian+1+jalpha-int(0.25*float(jalpha))
      else
        ja=julian
      endif
      jb=ja+1524
      jc=int(6680.0+(float(jb-2439870)-122.1)/365.25)
      jd=365*jc+int(0.25*float(jc))
      je=int(float(jb-jd)/30.6001)
      iday=jb-jd-int(30.6001*float(je))
      month=je-1
      if (month.gt.12) month=month-12
      iyear=jc-4715
      if (month.gt.2) iyear=iyear-1
      if (iyear.le.0) iyear=iyear-1
      ileap=mod(iyear,4)
      if (ileap.eq.0) then
        yday=float(iydl(month))+float(iday)-1.
      else
        yday=float(iyd(month))+float(iday)-1.
      endif
      return
      end
