      subroutine bernoulli (B,rho,zeta,z_w,z_r,ziso,L,M,N,level)
!
! Computes the Bernoulli function: To do so integrate density
! anomaly from the bottom or from the depth of isopycnic surface.
!                                                                    ===
! input: rho      Density anomaly
!        zeta     Free-surface (m)
!        z_w      Depths at W-points (m)
!        z_r      Depths at RHO-points (m)
!        ziso     Depths of requested isopycnal (m), if any
!        L        Number of points in the XI-direction
!        M        Number of points in the ETA-direction
!        N        Number of points in the S-direction
!        level    Depth (>0), level (>0), or isopycnal (>1000)
!                           to process (real).                                       ===
!
! output: B        Bernoulli function (Pa).
!
      implicit none
#include "pconst.h"
#include "domdat.h"

      integer L, M, N, i, j, k
      real d1, d2, level, ri, rref, sum
      real B(0:L,0:M), rho(0:L,0:M,N), zeta(0:L,0:M), ziso(0:L,0:M),
     &     z_r(0:L,0:M,N), z_w(0:L,0:M,0:N)
c
c  Compute free-surface contribution.
c
      do j=0,M
        do i=0,L
          B(i,j)=rho0*grav*zeta(i,j)
        enddo
      enddo
c
c  Integerage density from requested isopycnal depths.
c
      if (level.ge.1000.) then
        rref=level-1000.
        do j=0,M
          do i=0,L 
            if (ziso(i,j).lt.z_r(i,j,N)) then
              sum=(z_w(i,j,N)-z_r(i,j,N))*(rho(i,j,N)-rref)
              do k=N-1,1,-1
                if (ziso(i,j).lt.z_r(i,j,k)) then
                  sum=sum+
     &                (z_r(i,j,k+1)-z_w(i,j,k))*(rho(i,j,k+1)-rref)+
     &                (z_w(i,j,k  )-z_r(i,j,k))*(rho(i,j,k  )-rref)
                else
                  d1=z_r(i,j,k+1)-ziso(i,j)
                  d2=ziso(i,j)-z_r(i,j,k)
                  ri=(d1*rho(i,j,k)+d2*rho(i,j,k+1))/(d1+d2)
                  sum=sum+
     &                (z_r(i,j,k)-ziso(i,j))*(ri-rref)
                  goto 10
                endif
              enddo
  10          B(i,j)=B(i,j)+grav*sum
            else
              B(i,j)=spval1
            endif  
          enddo
        enddo            
c
c  Integerage density from requested depth.
c
      elseif (level.lt.0.) then
        rref=0.
        do j=0,M
          do i=0,L 
            if (level.lt.z_r(i,j,N)) then
              sum=(z_w(i,j,N)-z_r(i,j,N))*(rho(i,j,N)-rref)
              do k=N-1,1,-1
                if (level.lt.z_r(i,j,k)) then
                  sum=sum+
     &                (z_r(i,j,k+1)-z_w(i,j,k))*(rho(i,j,k+1)-rref)+
     &                (z_w(i,j,k  )-z_r(i,j,k))*(rho(i,j,k  )-rref)
                else
                  d1=z_r(i,j,k+1)-level
                  d2=level-z_r(i,j,k)
                  ri=(d1*rho(i,j,k)+d2*rho(i,j,k+1))/(d1+d2)
                  sum=sum+
     &                (z_r(i,j,k)-ziso(i,j))*(ri-rref)
                  goto 20
                endif
              enddo
  20          B(i,j)=B(i,j)+grav*sum
            else
              B(i,j)=spval1
            endif  
          enddo
        enddo            
      endif
      return
      end
