      function bcintrp (is,js, xi,eta, fld,im,jm, spval)
!
! Interpolate field "fld" defined at nodes of a regular grid
! to the location specified by indices is,js and local fractional
! coordinates xi,eta.
!
! input: is,js indices of the grid cell containing point to which 
!                               field "fld" needs to be interpolated 
!       xi,eta local fractional coordinates specifying exact location 
!                     of the interpolated point within the cell is,js
!        fld   field data to interpolate from
!        im,jm inner and outer dimensions of arrays "fld,x,y"
!        spval field special value used for land  masking
!
! output: bcintrp  returns interpolated value of "fld"
!
      implicit none
      integer is,js, im,jm
      real xi,eta, fld(im,jm),  spval,  bcintrp
#define CUBIC
c--#define LIMTR 3.
#ifdef CUBIC
# ifdef CUBIC_XX
      integer i,j
      real f(-1:2,-1:2)
# else
      real f(0:1,0:1), dfx(0:1,0:1), dfy(0:1,0:1), dfc
# endif
      real f0,fx,fy,fxx,fxy,fyy, fxxx,fxxy,fxyy,fyyy
      real OneFortyEighth, OneThirtySecond, OneSixteenth,
     &     OneSixth, Quarter, Half, FiveSixteenth, FiveEighth,
     &     ThreeHalf, ThirteenTwentyFourth
      parameter (OneFortyEighth=1./48., OneThirtySecond=1./32.,
     &     OneSixteenth=1./16.,  OneSixth=1./6.,  Quarter=0.25,
     &     Half=0.5,   FiveSixteenth=5./16.,  FiveEighth=5./8.,
     &     ThreeHalf=1.5,   ThirteenTwentyFourth=13./24.)
#endif

      if (fld(is,js).eq.spval .or. fld(is+1,js+1).eq.spval .or.
     &    fld(is+1,js).eq.spval .or. fld(is,js+1).eq.spval) then
        bcintrp=spval
      else
#ifdef CUBIC
# ifdef CUBIC_XX
!
! Genuinely two-dimensional, isotropic cubic interpolation scheme
! using 12-point stencil.  In the code below the interpolated field
! "f" is expanded into two-dimensional Taylor series of local frac-
! tional coordinates "xi" and "eta", retaining all terms of combined
! power up to third order (i.e., xi, eta, xi^2, eta^2, xi*eta, xi^3,
! eta^3, xi^2*eta, and xi*eta^2), with all
! coefficients (i.e., derivatives) computed via          x  x
! two-dimensional finite difference expressions          |  |
! of "natural" order of accuracy: 4th-order for       x--x--x--x
! the field itself and its first derivatives in          |  |
! both directions; and 2nd-order for all higher-      x--x--x--x
! order derivatives. The permissible range of            |  |
! of coordinates is -1/2 < xi,eta < +1/2, which          x--x
! covers the central cell on the stencil, while
! xi=eta=0 corresponds to its center. This interpolation scheme has
! the property that if xi,eta=+/-1/2 (any combination of +/- signs)
! it reproduces exactly value of the function at the corresponding
! corner of the central "working" cell. However, it does not pass
! exactly through the  extreme points of the stencil, where either
! xi=+/-3/2 or eta+/-3/2. And, unlike a split-directional scheme,
! when interpolating along the line eta=+/-1/2 (similarly xi=+/-1/2),
! it has non-zero contribution from points on the side from the line,
! except if xi=-1/2; 0; +1/2 (similarly eta=-1/2; 0; +1/2).
!
! WARNING: Code segment below is a prototype algorithm. For the sake
! of clarity, land masking capability is not implemented in this code
! segment. It is kept here for illustration, reference, and debugging
! purposes only. The complete algorithm is placed below.
!
        do j=-1,2
          do i=-1,2
            f(i,j)=fld(max(1,min(im,is+i)), max(1,min(jm,js+j)))
          enddo
        enddo

        f0=FiveSixteenth*(f(1,1)+f(1,0) +f(0,1)+f(0,0))
     &     -OneThirtySecond*(f(2,0)+f(2,1)+f(1,2)+f(0,2)
     &                 +f(-1,1)+f(-1,0)+f(0,-1)+f(1,-1))

        fx=FiveEighth*(f(1,1)+f(1,0)-f(0,1)-f(0,0))
     &   -OneFortyEighth*(f(2,1)+f(2,0)-f(-1,1)-f(-1,0))
     &     -OneSixteenth*(f(1,2)-f(0,2)+f(1,-1)-f(0,-1))

        fy=FiveEighth*(f(1,1)-f(1,0)+f(0,1)-f(0,0))
     &   -OneFortyEighth*(f(1,2)+f(0,2)-f(1,-1)-f(0,-1))
     &     -OneSixteenth*(f(2,1)-f(2,0)+f(-1,1)-f(-1,0))

        fxy=f(1,1)-f(1,0)-f(0,1)+f(0,0)

        fxx=Quarter*( f(2,1)-f(1,1)-f(0,1)+f(-1,1)
     &               +f(2,0)-f(1,0)-f(0,0)+f(-1,0))

        fyy=Quarter*( f(1,2)-f(1,1)-f(1,0)+f(1,-1)
     &               +f(0,2)-f(0,1)-f(0,0)+f(0,-1))

        fxxx=Half*(f(2,1)+f(2,0)-f(-1,1)-f(-1,0))
     &   -ThreeHalf*(f(1,1)+f(1,0)-f(0,1)-f(0,0))

        fyyy=Half*(f(1,2)+f(0,2)-f(1,-1)-f(0,-1))
     &   -ThreeHalf*(f(1,1)-f(1,0)+f(0,1)-f(0,0))

        fxxy=Half*( f(2,1)-f(1,1)-f(0,1)+f(-1,1)
     &             -f(2,0)+f(1,0)+f(0,0)-f(-1,0))

        fxyy=Half*( f(1,2)-f(1,1)-f(1,0)+f(1,-1)
     &             -f(0,2)+f(0,1)+f(0,0)-f(0,-1))
# else
!
! Algorithm below is equivalent to the one above, except that special
! care is taken to avoid interpolation accross land. This is achieved
! by shortening the stencil and reducing order of polynomial, if
! extreme points of the stencil touch land. This is achieved by
! expressing all f0,fx,fy,...,fxyy in terms of values of interpolated
! field at the four corners of central cell (which already checked to
! stay away from land), and eight one-sided differences dfx,dfy (see
! below) in such a way that field values at the extreme points of the
! 12-point stencil do not participate directly into f0,fx,...,fxyy. 
! Should an extreme point of the stencil touch land, thus making it
! impossible to compute the corresponding one-sided difference, this
! difference is retracted toward the center of the stencil.
!                                    ! Optionally a slope-limiting 
        f(0,0)=fld(is  ,js )         ! algorithm may be employed to
        f(1,0)=fld(is+1,js  )        ! prevent spurious oscillations
        f(0,1)=fld(is  ,js+1)        ! of the interpolant. This is a
        f(1,1)=fld(is+1,js+1)        ! valuable property, if dealing
                                     ! with rough data, however, as
                                     ! a side effect, it turns off
        dfc=f(1,1)-f(0,1)            ! high-order interpolation in
        if (is+2.gt.im) then         ! the vicinity of extrema.
          dfx(1,1)=dfc
        elseif (fld(is+2,js+1).eq.spval) then
          dfx(1,1)=dfc
        else
          dfx(1,1)=fld(is+2,js+1)-f(1,1)
#  ifdef LIMTR
          if (dfx(1,1)*dfc .lt. 0.) then
            dfx(1,1)=0.
          elseif (abs(dfx(1,1)) .gt. LIMTR*abs(dfc)) then
            dfx(1,1)=LIMTR*dfc
          endif
#  endif
        endif                               ! The slope-limiting
                                            ! algorithm employed
        dfc=f(1,0)-f(0,0)                   ! here checks that two
        if (is+2.gt.im) then                ! consecutive elementary
          dfx(1,0)=dfc                      ! differences, "dfx" and
        elseif (fld(is+2,js).eq.spval) then ! "dfc" have the same
          dfx(1,0)=dfc                      ! sign and differ in
        else                                ! magnitude by no more
          dfx(1,0)=fld(is+2,js)-f(1,0)      ! than factor of 3.
#  ifdef LIMTR
          if (dfx(1,0)*dfc .lt. 0.) then
            dfx(1,0)=0.
          elseif (abs(dfx(1,0)) .gt. LIMTR*abs(dfc)) then
            dfx(1,0)=LIMTR*dfc
          endif
#  endif
        endif

        dfc=f(1,1)-f(0,1)
        if (is-1.lt.1) then
          dfx(0,1)=dfc
        elseif (fld(is-1,js+1).eq.spval) then
          dfx(0,1)=dfc
        else
          dfx(0,1)=f(0,1)-fld(is-1,js+1)
#  ifdef LIMTR
          if (dfx(0,1)*dfc .lt. 0.) then
            dfx(0,1)=0. 
          elseif (abs(dfx(0,1)) .gt. LIMTR*abs(dfc)) then
            dfx(0,1)=LIMTR*dfc
          endif
#  endif
        endif

        dfc=f(1,0)-f(0,0)
        if (is-1.lt.1) then
          dfx(0,0)=dfc
        elseif (fld(is-1,js).eq.spval) then
          dfx(0,0)=dfc
        else
          dfx(0,0)=f(0,0)-fld(is-1,js)
#  ifdef LIMTR
          if (dfx(0,0)*dfc .lt. 0.) then
            dfx(0,0)=0.
          elseif (abs(dfx(0,0)) .gt. LIMTR*abs(dfc)) then
            dfx(0,0)=LIMTR*dfc
          endif
#  endif
        endif


        dfc=f(1,1)-f(1,0)
        if (js+2.gt.jm) then
          dfy(1,1)=dfc
        elseif (fld(is+1,js+2).eq.spval) then
          dfy(1,1)=dfc
        else
          dfy(1,1)=fld(is+1,js+2)-f(1,1)
#  ifdef LIMTR
          if (dfy(1,1)*dfc .lt. 0.) then
            dfy(1,1)=0.
          elseif (abs(dfy(1,1)) .gt. LIMTR*abs(dfc)) then
            dfy(1,1)=LIMTR*dfc
          endif
#  endif
        endif

        dfc=f(0,1)-f(0,0)
        if (js+2.gt.jm) then
          dfy(0,1)=dfc
        elseif (fld(is,js+2).eq.spval) then
          dfy(0,1)=dfc
        else
          dfy(0,1)=fld(is,js+2)-f(0,1)
#  ifdef LIMTR
          if (dfy(0,1)*dfc .lt. 0.) then
            dfy(0,1)=0.
          elseif (abs(dfy(0,1)) .gt. LIMTR*abs(dfc)) then
            dfy(0,1)=LIMTR*dfc
         endif
#  endif
        endif

        dfc=f(1,1)-f(1,0)
        if (js-1.lt.1) then
          dfy(1,0)=dfc
        elseif (fld(is+1,js-1).eq.spval) then 
          dfy(1,0)=dfc
        else
          dfy(1,0)=f(1,0)-fld(is+1,js-1)
#  ifdef LIMTR
          if (dfy(1,0)*dfc .lt. 0.) then
            dfy(1,0)=0.
          elseif (abs(dfy(1,0)) .gt. LIMTR*abs(dfc)) then
            dfy(1,0)=LIMTR*dfc
          endif
#  endif
        endif

        dfc=f(0,1)-f(0,0)
        if (js-1.lt.1) then
          dfy(0,0)=dfc
        elseif (fld(is,js-1).eq.spval) then
          dfy(0,0)=dfc
        else
          dfy(0,0)=f(0,0)-fld(is,js-1)
#  ifdef LIMTR
          if (dfy(0,0)*dfc .lt. 0.) then
            dfy(0,0)=0.
          elseif (abs(dfy(0,0)) .gt. LIMTR*abs(dfc)) then
            dfy(0,0)=LIMTR*dfc
          endif
#  endif
        endif


        f0=Quarter*(f(1,1)+f(1,0)+f(0,1)+f(0,0))
     &   -OneThirtySecond*( dfx(1,1)+dfx(1,0)-dfx(0,1)-dfx(0,0)
     &                     +dfy(1,1)-dfy(1,0)+dfy(0,1)-dfy(0,0))

        fx=ThirteenTwentyFourth*(f(1,1)-f(0,1) + f(1,0)-f(0,0))
     &     -OneFortyEighth*(dfx(1,1)+dfx(1,0)+dfx(0,1)+dfx(0,0))
     &       -OneSixteenth*(dfy(1,1)-dfy(0,1)-dfy(1,0)+dfy(0,0))

        fy=ThirteenTwentyFourth*(f(1,1)-f(1,0) + f(0,1)-f(0,0))
     &     -OneFortyEighth*(dfy(1,1)+dfy(0,1)+dfy(1,0)+dfy(0,0))
     &       -OneSixteenth*(dfx(1,1)-dfx(1,0)-dfx(0,1)+dfx(0,0))

        fxy=f(1,1)-f(1,0)-f(0,1)+f(0,0)

        fxx=Quarter*(dfx(1,1)-dfx(0,1) +dfx(1,0)-dfx(0,0))

        fyy=Quarter*(dfy(1,1)-dfy(1,0) +dfy(0,1)-dfy(0,0))

        fxxx=Half*(dfx(1,1)+dfx(1,0)+dfx(0,1)+dfx(0,0))
     &                   -f(1,1)+f(0,1) -f(1,0)+f(0,0)

        fyyy=Half*(dfy(1,1)+dfy(0,1)+dfy(1,0)+dfy(0,0))
     &                   -f(1,1)+f(1,0) -f(0,1)+f(0,0)

        fxxy=Half*(dfx(1,1)-dfx(0,1) -dfx(1,0)+dfx(0,0))

        fxyy=Half*(dfy(1,1)-dfy(1,0) -dfy(0,1)+dfy(0,0))
# endif
        bcintrp=f0 +fx*xi +fy*eta
     &             +Half*fxx*xi*xi +fxy*xi*eta +Half*fyy*eta*eta
     &             +OneSixth*fxxx*xi*xi*xi     +Half*fxxy*xi*xi*eta
     &             +OneSixth*fyyy*eta*eta*eta  +Half*fxyy*xi*eta*eta
#else
        bcintrp=(0.5+eta)*( (0.5-xi)*fld(is  ,js+1)  ! Bi-linear
     &                     +(0.5+xi)*fld(is+1,js+1)) ! interpolation
     &         +(0.5-eta)*( (0.5-xi)*fld(is  ,js  )  !
     &                     +(0.5+xi)*fld(is+1,js  )) !
#endif
      endif
c-      write(*,*) bcintrp
      return
      end
