      subroutine ARPRAM (IAM, IF1,IF2,IF3)

      implicit none
      integer IAM(*), IF1,IF2,IF3
!
! Examine the area map. Find points of intersection, delete redundant
! edge segments, and adjust the area identifiers.
!
! IAM is the array which holds an area map previously initialized by
! a call to ARINAM and augmented by calls to AREDAM.
!
! IF1 specifies what kind of search is made for intersections. If IF1
! is zero, all pairs of edge segments which could possibly intersect
! are examined for actual intersection, a very time-consuming process.
! If IF1 is one, a pair is examined only if one of its members has a
! left or a right identifier less than or equal to zero; this saves a
! lot of time and is intended for use with contour lines.
!
! IF2 specifies what kind of action is taken to remove unclosed edges.
! If IF2 is zero, a search is made for such edges and they are simply
! removed from the area map.  If IF2 is one, no such search is made;
! all edges are assumed closed.
!
! IF3 specifies what kind of search is made for area identifiers to
! be changed. If IF3 is zero, all edges of all subareas are examined
! in complete detail, a very time-consuming process.  If IF3 is one,
! only those edges having a zero or negative area identifier are
! examined (all others being assumed correct) and holes are ignored,
! which saves a lot of time; this is intended for use with contour
! lines.
!
! $Id: arpram.f,v 1.17 2000/08/22 15:01:53 haley Exp $
!
! Declare the AREAS common block:  ARCOMN contains variables which are
! used by all the AREAS routines.
!
      integer IAD,IAU,ILC,ILM,ILP,IBS,IDB,IDC,IDI,IRC
      real    RLC,RLM,RLP,RBS,DBS,RLA,RWA,RDI,RSI
      common /ARCOMN/ IAD,IAU,ILC,RLC,ILM,RLM,ILP,RLP,IBS,RBS,DBS,IDB,
     &                IDC,IDI,IRC(16),RLA,RWA,RDI,RSI
      save   /ARCOMN/
!
! Declare the BLOCK DATA routine external, which should force it to
! load from a binary library.
!
      EXTERNAL ARBLDA
!
! Define some double precision variables.
!
      DOUBLE PRECISION DPT,DP1,DP2
!
! Define the arrays which determine the multiple-precision operations
! to be done by ARMPIA.
!
      integer IO1(4,8),IO2(4,4), IO6(4,8),IO7(4,4)

      data IO1 / 1 ,  1 ,  0 ,  0 ,
     +           1 ,  2 ,  0 ,  0 ,
     +           1 ,  3 ,  0 ,  0 ,
     +           1 ,  4 ,  0 ,  0 ,
     +           4 ,  5 ,  1 ,  3 ,
     +           4 ,  6 ,  2 ,  4 ,
     +           2 ,  7 ,  5 ,  6 ,
     +           5 ,  7 ,  0 ,  0 /
      data IO2 / 4 ,  3 ,  1 ,  1 ,
     +           4 ,  4 ,  2 ,  2 ,
     +           2 ,  5 ,  3 ,  4 ,
     +           5 ,  5 ,  0 ,  0 /
      data IO6 / 1 ,  1 ,  0 ,  0 ,
     +           1 ,  2 ,  0 ,  0 ,
     +           1 ,  3 ,  0 ,  0 ,
     +           1 ,  4 ,  0 ,  0 ,
     +           4 ,  5 ,  1 ,  2 ,
     +           4 ,  6 ,  3 ,  4 ,
     +           3 ,  7 ,  5 ,  6 ,
     +           5 ,  7 ,  0 ,  0 /
      data IO7 / 4 ,  5 ,  1 ,  4 ,
     +           4 ,  6 ,  2 ,  3 ,
     +           2 ,  7 ,  5 ,  6 ,
     +           5 ,  7 ,  0 ,  0 /

      logical lsw129, lsw168, lsw242, lswch 

      integer ICN,ICZ,IOS, LAM,ILW, KF1,KF2,KF3, IPX,IPN, NXL,
     &        IPI,NDO, IX0,IY0, IQE,IQB,IQT,IQL,IQU,
     &        IXL,IYL, IXP,IYP,IXQ,IYQ, IXR,IYR, IX1,IY1,IX2,IY2,
     &        ISX,ISY, ISP,ISU,ISL,ISR,ISD, ISQ,
     &        IP1,IP2,IP3, IPF, IPH,IPM, IPP,IPQ,IPR,IPS,IPT,IPU,IPV,
     &        ITM, JRC,IAI,IAP,IAX,IAQ, IGI, IOF,   i,ierr 
      integer ICFELL
      real FXL, FXD,FYD,  YCI,YCO,YTM, TMP,DSQ, ANG,ANT,ANM
     



c      IAU=3
c      write(*,*) 'IAU =', IAU, IAD

c**
      ICN=0
      ICZ=0
      IOS=0
c**

#define ARRAT2 ATAN2
#define ARDAT2 DATAN2


!
! Check for an uncleared prior error. Also pull out the length of the
! area map and check for initialization
!
      IF (ICFELL('ARPRAM - UNCLEARED PRIOR ERROR',1).NE.0) RETURN
      LAM=IAM(1)
      if (IAU.eq.0 .OR. IAM(LAM).ne.LAM) then
        call SETER ('ARPRAM - INITIALIZATION DONE IMPROPERLY',2,1)
        return 
      endif
!
! Save the pointer to the last word of the last node, so that, in case
! of error, we can remove new nodes added to the area map.  Also, zero
! the variable that saves the upper-end pointer; again, this is done so
! that, when an error occurs, the proper action can be taken to dispose
! of any space temporarily used at the upper end of the area map array.
!
      ILW=IAM(5)
      ISU=0
!
! Copy the fast-path flags to internal variables.
!
      KF1=IF1
      KF2=IF2
      KF3=IF3
!
! Initialize the pointer used in determining the coordinate ordering of
! new nodes.
!
      IPX=8
!
! If debugging is turned on, produce an initial plot.
!
      if (IDB.NE.0) then
        CALL ARDBPA (IAM,IDB,'AT START OF ARPRAM')
        IF (ICFELL('ARPRAM',3).NE.0) RETURN
      endif
!
! First, find the average length of the projection on the X axis of the
! line segments in the area map.
!
      NXL=0
      FXL=0.
      IPT=8
      do while(IAM(IPT+3).ne.18)
        IPT=IAM(IPT+3)
        if (IAM(IPT+7).NE.0) then
          NXL=NXL+1
          FXL=FXL+real(ABS( IAM(IPT+1)-IAM(IAM(IPT+4)+1) ))
        endif
      enddo
      if (NXL.EQ.0) then
        CALL SETER ('ARPRAM - NO EDGES IN AREA MAP',4,1)
        GO TO 10008
      endif
      IXL=INT(FXL/real(NXL))
!
! Decide what the maximum such length should be and save it.  Adjust
! the X and Y coordinates in the dummy nodes at the ends of the list.
!
      IAM(2)=MAX(2,MIN(ILC,2*IXL))
      IAM(9)=-(IAM(2)+1)
      IAM(10)=-(IAM(2)+1)
      IAM(19)=ILC+(IAM(2)+1)
      IAM(20)=ILC+(IAM(2)+1)
!
! Now, break up any edge segments whose projections on the X axis are
! greater than the maximum.
!
      IPI=8
      do while(IAM(IPI+3).ne.18)
        IPI=IAM(IPI+3)
        if (IAM(IPI+7).ne.0) then
          NDO=1+(ABS(IAM(IPI+1)-IAM(IAM(IPI+4)+1))-1)/IAM(2)
          if (NDO.gt.1) then
            IXL=IAM(IAM(IPI+4)+1)
            IYL=IAM(IAM(IPI+4)+2)
            FXD=real(IAM(IPI+1)-IXL)/real(NDO)
            FYD=real(IAM(IPI+2)-IYL)/real(NDO)
            i=1
            do while (i.lt.NDO)
              IX0=IXL+nint(real(i)*FXD)
              IY0=IYL+nint(real(i)*FYD)
              call ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr)
              if (ierr.ne.0) goto 10008
              i=i+1
            enddo
          endif
        endif
      enddo
!
! If debugging is turned on, produce a plot.
!
      if (IDB.NE.0) then
        CALL ARDBPA (IAM,IDB,'AFTER BREAKING UP LONG EDGE SEGMENTS')
        IF (ICFELL('ARPRAM',5).NE.0) RETURN
      endif
!
! Now, look for points of intersection between edges.  The algorithm
! used should run in O(nlogn) time, rather than O(n**2) time.  A
! vertical sweep line is passed over the plane from left to right.
! A list is kept of all the edge segments intersected by the sweep
! line, sorted in order of increasing Y coordinate.  Whenever a new
! edge segment is added to the list, a check is made for intersection
! of it with the edge segments on either side of it.  Whenever an edge
! segment is removed from the list, a check is made for intersection
! of the edge segments which were on either side of it.  There are
! various complications, mostly having to do with the fact that points
! of intersection are incorporated in the area map as they are found
! and that we are working with a discrete grid, rather than with the
! classic Euclidean plane.
!
! The list is kept at the upper end of the area map.  Each five-word
! node in it represents one edge segment intersecting the sweep line
! and has the following format:
!
!   Word 0:  A pointer to the next node in the list (0 if no more).
!   Word 1:  A pointer to the last node in the list (0 if no more).
!   Word 2:  A pointer to the left end of the edge segment.
!   Word 3:  A pointer to the right end of the edge segment.
!   Word 4:  A pointer to the drawing end of the edge segment.
!
  101 CONTINUE
!
! Save the index of the last element used at the upper end of the area
! map.
!
      ISU=IAM(6)
!
! IQB points to the beginning of the edge-segment list and IQE to a
! linked list of nodes removed from the edge-segment list and available
! for re-use.  Both start out empty.
!
      IQB=0
      IQE=0
!
! ISP points to the node in the area map defining the current position
! of the sweep line.
!
      ISP=8
!
! A WHILE loop moves the sweep line, one point position at a time,
! across the area map.
!
      do while (IAM(ISP+5).NE.18)
        ISP=IAM(ISP+5)
!
! Pull out the X and Y coordinates of the point defining the current
! position of the sweep line.
!
        ISX=IAM(ISP+1)
        ISY=IAM(ISP+2)
!
! Interpolate the new point along any line segment which passes within
! one unit of it and, at the same time, remove any line segment having
! the current point, or any with the same coordinates, as a right
! end point.
!
        IQT=IQB
        do while (IQT.ne.0)
          IX1=IAM(IAM(IQT+2)+1)
          IY1=IAM(IAM(IQT+2)+2)
          IX2=IAM(IAM(IQT+3)+1)
          IY2=IAM(IAM(IQT+3)+2)

          if (IAU.EQ.1) then
            TMP=max(0., min(1., ( real(ISX-IX1)*real(IX2-IX1)
     &                           +real(ISY-IY1)*real(IY2-IY1))
     &                         /( real(IX2-IX1)*real(IX2-IX1)
     &                           +real(IY2-IY1)*real(IY2-IY1))
     &                                                      ))
            DSQ=(real(IX1-ISX)+real(IX2-IX1)*TMP)**2
     &         +(real(IY1-ISY)+real(IY2-IY1)*TMP)**2
          elseif (IAU.EQ.2) then

            DPT=max(0.D0, min(1.D0, ( dble(ISX-IX1)*dble(IX2-IX1)
     &                               +dble(ISY-IY1)*dble(IY2-IY1))
     &                             /( dble(IX2-IX1)*dble(IX2-IX1)
     &                               +dble(IY2-IY1)*dble(IY2-IY1))
     &                                                          ))
            DSQ=real( (dble(IX1-ISX)+dble(IX2-IX1)*DPT)**2
     &               +(dble(IY1-ISY)+dble(IY2-IY1)*DPT)**2)
          else
            IO1(3,1)=IX2-IX1
            IO1(3,2)=IY2-IY1
            IO1(3,3)=ISX-IX1
            IO1(3,4)=ISY-IY1
            CALL ARMPIA (IO1,DP1,ierr)
            IF (ierr.NE.0) GO TO 10028
            CALL ARMPIA (IO2,DP2,ierr)
            IF (ierr.NE.0) GO TO 10028
            DPT=MAX(0.D0,MIN(1.D0,DP1/DP2))
            DSQ=real((dble(IX1-ISX)+dble(IX2-IX1)*DPT)**2
     &              +(dble(IY1-ISY)+dble(IY2-IY1)*DPT)**2)
          endif

          if (DSQ.LT.1. .and. (IX1.NE.ISX .or. IY1.NE.ISY)
     &                  .and. (IX2.NE.ISX .or. IY2.NE.ISY)) then
            IPI=IAM(IQT+4)
            IX0=ISX
            IY0=ISY
            call ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr)
            if (ierr.ne.0) goto 10008
            IAM(IQT+3)=IPN
            IF (IAM(IQT+4).NE.IAM(IQT+2)) IAM(IQT+4)=IPN
          endif

          if (IAM(IAM(IQT+3)+1).EQ.ISX .and.
     &        IAM(IAM(IQT+3)+2).EQ.ISY) then
            if (IAM(IQT+1).eq.0) then
              IQB=IAM(IQT)
              IF (IQB.NE.0) IAM(IQB+1)=0
              IAM(IQT)=IQE
              IQE=IQT
              IQT=IQB
            elseif (IAM(IQT).eq.0) then
              IAM(IAM(IQT+1))=0
              IAM(IQT)=IQE
              IQE=IQT
              IQT=0
            else
              IQL=IAM(IQT+1)
              IQU=IAM(IQT)
              IAM(IQL)=IQU
              IAM(IQU+1)=IQL
              IAM(IQT)=IQE
              IQE=IQT
              if (IAM(IAM(IQU+3)+1).ne.ISX .or.
     &            IAM(IAM(IQU+3)+2).ne.ISY) then
                call INTERSECT (IAM, KF1,IAU, ILP, IQL,IQU,IQB,IQT,
     &                          ISX,ISY, IPN,IPI,IPX, IO1,IO2, ierr)
                if (ierr.eq.10008) goto 10008
                if (ierr.eq.10028) goto 10028
              endif
              IQT=IQU
            endif
          else
            IQT=IAM(IQT)
          endif
        enddo
!
! Add line segments having the current point as a left endpoint.
!
        if (IAM(ISP+7).ne.0 .AND. ( IAM(ISP+1).lt.IAM(IAM(ISP+4)+1)
     &               .OR. ( IAM(ISP+1).eq.IAM(IAM(ISP+4)+1) .and.
     &                      IAM(ISP+2).lt.IAM(IAM(ISP+4)+2) ))) then
          ISL=ISP
          ISR=IAM(ISP+4)
          ISD=ISP
          call ADDSEGM (IAM, KF1,IAU, ILP,IQL,IQU,IQB,IQT, ISX,ISY,
     &                  IPN,IPI,IPX, ISL,ISR,ISD,IQE, IO1,IO2,ierr)
          if (ierr.eq.10008) goto 10008
          if (ierr.eq.10028) goto 10028
        endif
        if (IAM(IAM(ISP+3)+7).ne.0 .AND.
     &      (  IAM(ISP+1).lt.IAM(IAM(ISP+3)+1) .or.
     &       ( IAM(ISP+1).eq.IAM(IAM(ISP+3)+1)  .and.
     &       IAM(ISP+2).lt.IAM(IAM(ISP+3)+2) ))) then
          ISL=ISP
          ISR=IAM(ISP+3)
          ISD=ISR
          call ADDSEGM (IAM, KF1,IAU, ILP,IQL,IQU,IQB,IQT, ISX,ISY,
     &                  IPN,IPI,IPX, ISL,ISR,ISD,IQE, IO1,IO2,ierr)
          if (ierr.eq.10008) goto 10008
          if (ierr.eq.10028) goto 10028
        endif
      enddo
!
! Restore the index of the last element used at the upper end of the
! area map.
!
      IAM(6)=ISU
      ISU=0
!
! If debugging is turned on, produce a plot.
!
      if (IDB.NE.0) then
        CALL ARDBPA (IAM,IDB,'AFTER FINDING POINTS OF INTERSECTION')
        IF (ICFELL('ARPRAM',7).NE.0) RETURN
      endif
!
! Now look for coincident line segments in the list and remove them.
!
      ISP=8
      do while (IAM(ISP+5).ne.18)
        ISP=IAM(ISP+5)
        if (IAM(ISP+7).NE.0) then
          if (IAM(IAM(ISP+3)+7).ne.0 .and.
     &        IAM(IAM(ISP+3)+1).eq.IAM(IAM(ISP+4)+1) .and.
     &        IAM(IAM(ISP+3)+2).eq.IAM(IAM(ISP+4)+2)) then
            IP1=ISP
            IP2=IAM(ISP+3)
            call RMCOINS (IAM, IP1,IP2)
          endif
          ISQ=IAM(ISP+5)
          do while (IAM(ISQ+1).EQ.IAM(ISP+1)
     &        .and. IAM(ISQ+2).EQ.IAM(ISP+2))
            if (IAM(ISQ+7).ne.0  .and.
     &          IAM(IAM(ISQ+4)+1).eq.IAM(IAM(ISP+4)+1) .and.
     &          IAM(IAM(ISQ+4)+2).eq.IAM(IAM(ISP+4)+2)) then
              IP1=ISP
              IP2=ISQ
              call RMCOINS (IAM, IP1,IP2)
            endif
            if (IAM(IAM(ISQ+3)+7).ne.0 .and.
     &          IAM(IAM(ISQ+3)+1).EQ.IAM(IAM(ISP+4)+1) .and.
     &          IAM(IAM(ISQ+3)+2).EQ.IAM(IAM(ISP+4)+2)) then
              IP1=ISP
              IP2=IAM(ISQ+3)
              call RMCOINS (IAM, IP1,IP2)
            endif
            ISQ=IAM(ISQ+5)
          enddo
        endif
        if (IAM(IAM(ISP+3)+7).NE.0) then
          ISQ=IAM(ISP+5)
          do while (IAM(ISQ+1).eq.IAM(ISP+1)
     &        .and. IAM(ISQ+2).eq.IAM(ISP+2))
            if (IAM(ISQ+7).ne.0 .and.
     &          IAM(IAM(ISQ+4)+1).eq.IAM(IAM(ISP+3)+1) .and.
     &          IAM(IAM(ISQ+4)+2).eq.IAM(IAM(ISP+3)+2)) then
              IP1=IAM(ISP+3)
              IP2=ISQ
              call RMCOINS (IAM, IP1,IP2)
            endif
            if (IAM(IAM(ISQ+3)+7).ne.0 .AND.
     &          IAM(IAM(ISQ+3)+1).eq.IAM(IAM(ISP+3)+1) .and.
     &          IAM(IAM(ISQ+3)+2).eq.IAM(IAM(ISP+3)+2)) then
              IP1=IAM(ISP+3)
              IP2=IAM(ISQ+3)
              call RMCOINS (IAM, IP1,IP2)
            endif
            ISQ=IAM(ISQ+5)
          enddo
        endif
      enddo
!
! If debugging is turned on, produce a plot.
!
      if (IDB.NE.0) then
        CALL ARDBPA (IAM,IDB,'AFTER REMOVING COINCIDENT SEGMENTS')
        if (ICFELL('ARPRAM',8).NE.0) return
      endif
!
! Look for unclosed edges, if that is to be done.
!
      if (KF2.eq.0) then
        lsw129=.true.
        do while (lsw129)
          lsw129=.false.
          IPT=8
          do while (IAM(IPT+3).NE.18)
            IPT=IAM(IPT+3)
            if (IAM(IPT+7).ne.0 .and. IAM(IAM(IPT+4)+7).eq.0) then
              IGI=ABS(IAM(IPT+7))
              IP1=IAM(IPT+4)
              IP2=IP1
              do while (IAM(IAM(IP2+6)+1).eq.IAM(IP1+1)
     &            .and. IAM(IAM(IP2+6)+2).eq.IAM(IP1+2))
                IP2=IAM(IP2+6)
              enddo 
              IP3=IP2
              IPF=0
              lswch=.true.
              do while (lswch)
                if (IP2.NE.IP1 .and. ( ABS(IAM(IP2+7)).EQ.IGI
     &                     .or. ABS(IAM(IAM(IP2+3)+7)).EQ.IGI)) then
                  IPF=1
                  lswch=.false.
                else
                  IP2=IAM(IP2+5)
                  IF (IAM(IP2+1).ne.IAM(IP1+1) .or.
     &                IAM(IP2+2).ne.IAM(IP1+2)) lswch=.false.
                endif
              enddo                        !--> discard lswch 
              if (IPF.EQ.0) then
                if (IAM(IPT+7).GT.0) then
                  IP2=IP3
                  lswch=.true.
                  do while (lswch)
                    if (IP2.NE.IP1) then
                      if (IAM(IP2+7).LT.0 .AND. ABS(IAM(IP2+7)).NE.IGI
     &                       .AND. IAM(IAM(IP2+4)+1).EQ.IAM(IPT+1)
     &                       .AND. IAM(IAM(IP2+4)+2).EQ.IAM(IPT+2)) then
                        IAM(IP2+7)=ABS(IAM(IP2+7))
                        lswch=.false.
                      elseif (IAM(IAM(IP2+3)+7).LT.0 .AND.
     &                    ABS(IAM(IAM(IP2+3)+7)).NE.IGI .AND.
     &                    IAM(IAM(IP2+3)+1).EQ.IAM(IPT+1) .AND.
     &                    IAM(IAM(IP2+3)+2).EQ.IAM(IPT+2)) then
                        IAM(IAM(IP2+3)+7)=ABS(IAM(IAM(IP2+3)+7))
                        lswch=.false.
                      endif 
                    endif
                    if (lswch) then
                      IP2=IAM(IP2+5)
                      if (IAM(IP2+1).NE.IAM(IP1+1) .or.
     &                    IAM(IP2+2).NE.IAM(IP1+2)) lswch=.false.
                    endif
                  enddo                    !--> discard lswch 
                endif
                IAM(IPT+7)=0
                lsw129=.true. 
              endif
            endif
          enddo

          IPT=18
          do while (IAM(IPT+4).NE.8)
            IPT=IAM(IPT+4)
            if (IAM(IPT+7).NE.0 .and. IAM(IAM(IPT+3)+7).EQ.0) then
              IGI=ABS(IAM(IPT+7))
              IP1=IPT
              IP2=IP1
              do while (IAM(IAM(IP2+6)+1).EQ.IAM(IP1+1)
     &            .and. IAM(IAM(IP2+6)+2).EQ.IAM(IP1+2))
                IP2=IAM(IP2+6)
              enddo 
              IP3=IP2
              IPF=0
              lswch=.true.
              do while (lswch)
                if (IP2.NE.IP1 .and. (ABS(IAM(IP2+7)).EQ.IGI
     &              .or. ABS(IAM(IAM(IP2+3)+7)).EQ.IGI)) then
                  IPF=1
                  lswch=.false. 
                else 
                  IP2=IAM(IP2+5)
                  if (IAM(IP2+1).NE.IAM(IP1+1) .or.
     &                IAM(IP2+2).NE.IAM(IP1+2)) lswch=.false. 
                endif
              enddo                        !--> discard lswch
              if (IPF.EQ.0) then
                if (IAM(IPT+7).GT.0) then
                  IP2=IP3
                  lswch=.true. 
                  do while (lswch)
                    if (IP2.NE.IP1) then
                      if (IAM(IP2+7).LT.0 .AND.
     &                    ABS(IAM(IP2+7)).NE.IGI .AND.
     &                    IAM(IAM(IP2+4)+1).EQ.IAM(IAM(IPT+4)+1) .AND.
     &                    IAM(IAM(IP2+4)+2).EQ.IAM(IAM(IPT+4)+2)) then
                        IAM(IP2+7)=ABS(IAM(IP2+7))
                        lswch=.false. 
                      elseif (IAM(IAM(IP2+3)+7).LT.0 .AND.
     &                    ABS(IAM(IAM(IP2+3)+7)).NE.IGI .AND.
     &                    IAM(IAM(IP2+3)+1).EQ.IAM(IAM(IPT+4)+1) .AND.
     &                    IAM(IAM(IP2+3)+2).EQ.IAM(IAM(IPT+4)+2)) then
                        IAM(IAM(IP2+3)+7)=ABS(IAM(IAM(IP2+3)+7))
                        lswch=.false. 
                      endif
                    endif
                    if (lswch) then 
                      IP2=IAM(IP2+5)
                      if (IAM(IP2+1).NE.IAM(IP1+1) .or.
     &                    IAM(IP2+2).NE.IAM(IP1+2))  lswch=.false.
                    endif
                  enddo                    !--> discard lswch 
                endif
                IAM(IPT+7)=0
                lsw129=.true.
              endif 
            endif           
          enddo
        enddo
!
! If debugging is turned on, produce a plot.
!
        if (IDB.NE.0) then
          CALL ARDBPA (IAM,IDB,'AFTER REMOVING UNCLOSED EDGES')
          IF (ICFELL('ARPRAM',9).NE.0) RETURN
        endif
      endif   !<-- KF.eq.0

C
C Adjust the area identifiers for all edge segments in the map.  We
C first make a pass over the entire area map, looking for holes and
C eliminating them by the insertion of some temporary connecting lines.
C
C Save the pointer to the last word of the last node, so that we can
C remove the nodes implementing the temporary connecting lines before
C returning to the caller.
C
      ILW=IAM(5)
C
C Each pass through the following loop traces the boundary of one
C connected loop.  In some cases (for contour maps, for example),
C this step can be omitted; in those cases, there is a small chance
C of failure, in which case we have to come back and force the step
C to occur.
C
  104 CONTINUE
      if (KF3.eq.0) then
        IPT=8

10162   CONTINUE

! Move to the right across the area map, looking for an edge segment
! that has not yet been completely processed.  If no such segment can
! be found, all subareas have been done.

          do while (MOD(IAM(IPT),4).EQ.3.OR.ABS(IAM(IPT+7)).LT.IAM(6))
            IPT=IAM(IPT+5)
            IF (IPT.EQ.18) GO TO 10165
          enddo
!
! Pull out the group identifier for the segment.
!
          IGI=ABS(IAM(IPT+7))
!
! Decide whether to scan the subarea to the left of the edge being
! traced (IPU=1) or the one to the right (IPU=2).
!
          if (mod(IAM(IPT),2).eq.0) then
            IPU=1
          else
            IPU=2
          endif
!
! IPQ points to the node defining the beginning of the edge segment,
! IPR to the node defining the end of the edge segment, and IPS to
! the node defining the beginning of the edge, so that we can tell
! when we've gone all the way around it.
!
          IPQ=IAM(IPT+4)
          IPR=IPT
          IPS=IPQ
          IPM=IPR
          IPV=IPU
!
! We need to keep track of the highest point found along the loop and
! the total change in direction.  Initialize the variables involved.
!
          IPH=IPQ
          ANT=0.
!
! Each pass through the following loop moves one step along the edge of
! the subarea.
!
          lsw168=.true.
          do while (lsw168)
!
! Update the pointer to the highest point found along the loop.
!
            IF (IAM(IPR+2).GT.IAM(IPH+2)) IPH=IPR
!
! Move IPQ to IPP and IPR to IPQ.  They point to the nodes defining the
! ends of the current edge segment.
!
            IPP=IPQ
            IPQ=IPR
!
! Get the coordinates of the ends of the edge segment for use in
! computing change in direction to a possible next point.
!
            IXP=IAM(IPP+1)
            IYP=IAM(IPP+2)
            IXQ=IAM(IPQ+1)
            IYQ=IAM(IPQ+2)
!
! Back up IPR to the beginning of the group of nodes which have the
! same X and Y coordinates as it does.
!
            do while (IAM(IPR+1).eq.IAM(IAM(IPR+6)+1)
     &          .and. IAM(IPR+2).eq.IAM(IAM(IPR+6)+2))
              IPR=IAM(IPR+6)
            enddo
!
! Go through the group of nodes, examining all the possible ways to
! move from the current position to a new one.  Pick the direction
! which is leftmost (if IPU=1) or rightmost (if IPU=2).
!
c**       write(*,*)
            IP1=IPR
            IP2=IPR
            IPR=0
            if (IPU.eq.1) then
              ANM=-3.14159265358979
            else
              ANM=+3.14159265358979
            endif

            do while (IAM(IP2+1).eq.IAM(IP1+1)
     &          .and. IAM(IP2+2).eq.IAM(IP1+2))

c**            write(*,*) 'ANM=', ANM

              if (ABS(IAM(IAM(IP2+3)+7)).eq.IGI  .and.
     &            (IAM(IAM(IP2+3)+1).ne.IAM(IPP+1)  .or.
     &             IAM(IAM(IP2+3)+2).ne.IAM(IPP+2))) then
                IXR=IAM(IAM(IP2+3)+1)
                IYR=IAM(IAM(IP2+3)+2)
                if (IAU.EQ.1) then
                  ANG=ARRAT2(real(IXQ-IXP)*real(IYR-IYQ)
     &                      -real(IYQ-IYP)*real(IXR-IXQ),
     &                       real(IXQ-IXP)*real(IXR-IXQ)
     &                      +real(IYQ-IYP)*real(IYR-IYQ))
                elseif (IAU.EQ.2) then
                  ANG=ARDAT2(dble(IXQ-IXP)*dble(IYR-IYQ)
     &                      -dble(IYQ-IYP)*dble(IXR-IXQ),
     &                       dble(IXQ-IXP)*dble(IXR-IXQ)
     &                      +dble(IYQ-IYP)*dble(IYR-IYQ))
                else
                  IO6(3,1)=IXQ-IXP
                  IO6(3,2)=IYR-IYQ
                  IO6(3,3)=IYQ-IYP
                  IO6(3,4)=IXR-IXQ
                  CALL ARMPIA (IO6, DP1, ierr)
                  if (ierr.ne.0) goto 10028
                  CALL ARMPIA (IO7, DP2, ierr)
                  if (ierr.ne.0) goto 10028
                  ANG=ARDAT2(DP1,DP2)
                endif

                if (IPU.eq.1) then
                  if (ANG.GT.ANM) then
                    IPR=IAM(IP2+3)
                    ANM=ANG
                    IPM=IPR
                    IPV=1
                  endif
                elseif (ANG.LT.ANM) then
                  IPR=IAM(IP2+3)
                  ANM=ANG
                  IPM=IPR
                  IPV=2
                endif
              endif

              if (ABS(IAM(IP2+7)).eq.IGI .and.
     &            (IAM(IAM(IP2+4)+1).ne.IAM(IPP+1) .or.
     &             IAM(IAM(IP2+4)+2).ne.IAM(IPP+2))) then
                IXR=IAM(IAM(IP2+4)+1)
                IYR=IAM(IAM(IP2+4)+2)
                if (IAU.EQ.1) then
                  ANG=ARRAT2(real(IXQ-IXP)*real(IYR-IYQ)
     &                      -real(IYQ-IYP)*real(IXR-IXQ),
     &                       real(IXQ-IXP)*real(IXR-IXQ)
     &                      +real(IYQ-IYP)*real(IYR-IYQ))
                elseif (IAU.EQ.2) then
                  ANG=ARDAT2(dble(IXQ-IXP)*dble(IYR-IYQ)
     &                      -dble(IYQ-IYP)*dble(IXR-IXQ),
     &                       dble(IXQ-IXP)*dble(IXR-IXQ)
     &                      +dble(IYQ-IYP)*dble(IYR-IYQ))
                else
                  IO6(3,1)=IXQ-IXP
                  IO6(3,2)=IYR-IYQ
                  IO6(3,3)=IYQ-IYP
                  IO6(3,4)=IXR-IXQ
                  call ARMPIA (IO6, DP1, ierr)
                  if (ierr.ne.0) goto 10028
                  call ARMPIA (IO7, DP2, ierr)
                  if (ierr.ne.0) goto 10028
                  ANG=ARDAT2(DP1,DP2)
                endif

                if (IPU.EQ.1) then
                  if (ANG.GT.ANM) then
                    IPR=IAM(IP2+4)
                    ANM=ANG
                    IPM=IP2
                    IPV=2
                  endif
                elseif (ANG.LT.ANM) then
                  IPR=IAM(IP2+4)
                  ANM=ANG
                  IPM=IP2
                  IPV=1
                endif
              endif
              IP2=IAM(IP2+5)
            enddo
!
! If no possible exit was found, reverse direction.
!
            if (IPR.EQ.0) then
              IPR=IPP
              IPV=3-IPV
              if (IPU.EQ.1) then
                ANM=+3.14159265358979
              else
                ANM=-3.14159265358979
              endif
            endif
!
! Update the total angular change.
!
            ANT=ANT+ANM
!
! Set the marker for the edge segment picked.  If the marker is set
! already, either go back and do a slow-path intersection search or
! log an error.
!
            if (IPV.eq.1 .and. mod(IAM(IPM),2).eq.0) then
              IAM(IPM)=IAM(IPM)+1
            elseif (IPV.EQ.2 .and. mod(IAM(IPM)/2,2).EQ.0) then
              IAM(IPM)=IAM(IPM)+2
            else
              IPT=IAM(5)-9
              do while (IPT.gt.ILW)
                IAM(IAM(IPT+4)+3)=IAM(IPT+3)
                IAM(IAM(IPT+3)+4)=IAM(IPT+4)
                IAM(IAM(IPT+6)+5)=IAM(IPT+5)
                IAM(IAM(IPT+5)+6)=IAM(IPT+6)
                IPT=IPT-10
              enddo
              IAM(5)=ILW
              do IPT=8,IAM(5)-9,10
                IAM(IPT)=4*(IAM(IPT)/4)
              enddo
              if (KF1.ne.0) then
                KF1=0
                GO TO 101
              else 
                CALL SETER ('ARPRAM - ALGORITHM FAILURE',10,1)
                GO TO 10008
              endif
            endif
!
! Exit if we're passing the start of the subarea.
!
            if (IAM(IPQ+1).eq.IAM(IPS+1).and.IAM(IPQ+2).eq.IAM(IPS+2)
     &     .and.IAM(IPR+1).eq.IAM(IPT+1).and.IAM(IPR+2).eq.IAM(IPT+2)
     &                                               ) lsw168=.false.
          enddo



!
! If the closed loop just traced was a hole, insert a temporary
! connecting line to get rid of the hole.
!
          if ((IPU.EQ.1 .and. ANT.lt.0.)  .or.
     &        (IPU.EQ.2 .and. ANT.gt.0.)) then
            IOF=0
            IX0=IAM(IPH+1)
            IY0=IAM(IPH+2)
            YCI=real(IY0)
            YCO=RLP
            IP1=IPH
            do while (IAM(IAM(IP1+5)+1) .eq.IX0)
              IP1=IAM(IP1+5)
            enddo

            do while (IAM(IP1+1).ge.IX0-IAM(2))
              if (ABS(IAM(IP1+7)).eq.IGI .and.
     &            IAM(IAM(IP1+4)+1).gt.IAM(IP1+1) .and.
     &            IAM(IAM(IP1+4)+1).ge.IX0) then
                if (IAU.EQ.1) then
                  YTM=real(IAM(IP1+2)) + real(IX0-IAM(IP1+1))
     &                     *( real(IAM(IAM(IP1+4)+2)-IAM(IP1+2))
     &                       /real(IAM(IAM(IP1+4)+1)-IAM(IP1+1)))
                else
                  YTM=real( dble(IAM(IP1+2)) + dble(IX0-IAM(IP1+1))
     &                        *( dble(IAM(IAM(IP1+4)+2)-IAM(IP1+2))
     &                          /dble(IAM(IAM(IP1+4)+1)-IAM(IP1+1))
     &                                                           ))
                endif
                if (YTM.GT.YCI .and. YTM.LT.YCO) then
                  IOF=IP1
                  YCO=YTM
                endif
              endif
              if (ABS(IAM(IAM(IP1+3)+7)).eq.IGI .and.
     &            IAM(IAM(IP1+3)+1).gt.IAM(IP1+1) .and.
     &            IAM(IAM(IP1+3)+1).ge.IX0) then
                if (IAU.EQ.1) then
                  YTM=real(IAM(IP1+2)) + real(IX0-IAM(IP1+1))
     &                     *( real(IAM(IAM(IP1+3)+2)-IAM(IP1+2))
     &                       /real(IAM(IAM(IP1+3)+1)-IAM(IP1+1)))
                else
                  YTM=real( dble(IAM(IP1+2)) + dble(IX0-IAM(IP1+1))
     &                        *( dble(IAM(IAM(IP1+3)+2)-IAM(IP1+2))
     &                          /dble(IAM(IAM(IP1+3)+1)-IAM(IP1+1))
     &                                                           ))
                endif
                if (YTM.GT.YCI .and. YTM.LT.YCO) then
                  IOF=IAM(IP1+3)
                  YCO=YTM
                endif
              endif
              IP1=IAM(IP1+6)
            enddo

            if (IOF.NE.0) then
              IX0=IAM(IPH+1)
              IY0=IAM(IPH+2)
              if (INT(YCO+0.5).NE.IY0) then
                IPI=18
                call ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr)
                if (ierr.ne.0) goto 10008
                IAM(IPN+7)=0
                IAM(IPN+8)=0
                IAM(IPN+9)=0
                IY0=INT(YCO+.5)
                call ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr)
                if (ierr.ne.0) goto 10008
                IAM(IPN+7)=LAM-IGI
                IAM(IPN+8)=0
                IAM(IPN+9)=0
              endif

              if ((IX0.ne.IAM(IOF+1) .or. IY0.NE.IAM(IOF+2)) .and.
     &            (IX0.ne.IAM(IAM(IOF+4)+1) .or.
     &                             IY0.ne.IAM(IAM(IOF+4)+2))) then
                IPI=IOF
                call ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr)
                if (ierr.ne.0) goto 10008
              endif
            endif
          endif

        GO TO 10162
10165   CONTINUE
!
! Zero the lower bits in the markers in all the nodes.
!
        do IPT=8,IAM(5)-9,10
          IAM(IPT)=4*(IAM(IPT)/4)
        enddo
!
! If debugging is turned on, produce a plot.
!
        if (IDB.NE.0) then
          CALL ARDBPA (IAM,IDB,'AFTER LOOKING FOR HOLES')
          IF (ICFELL('ARPRAM',11).NE.0) RETURN
        endif
      endif      !<-- KF3.eq.0

!
! Now, make another pass through the area map, tracing one subarea at
! a time and setting the area identifiers in each. Each pass through
! the following loop traces the boundary of one subarea.
!
      IPT=8

10232 CONTINUE

! Move to the right across the area map, looking for an edge segment
! that has not yet been completely processed.  If no such segment can
! be found, all subareas have been done.
!
        do while (MOD(IAM(IPT),4).EQ.3 .OR. ABS(IAM(IPT+7)).LT.IAM(6)
     &           .OR. (KF3.NE.0 .AND.
     &            ((MOD(IAM(IPT),2).NE.0   .OR. IAM(IPT+8).GT.0) .AND.
     &             (MOD(IAM(IPT)/2,2).NE.0 .OR. IAM(IPT+9).GT.0) )))
          IPT=IAM(IPT+5)
          IF (IPT.EQ.18) GO TO 10235
        enddo
!
! Pull out the group identifier for the segment.
!
        IGI=ABS(IAM(IPT+7))
!
! Decide how contradictory area identifiers are to be reconciled.
!
        JRC=IRC(MAX(1,MIN(16,IAM(IGI)/2)))
!
! Decide whether to scan the subarea to the left of the edge being
! traced (IPU=1) or the one to the right (IPU=2) and initialize the
! area identifier.
!
        if (MOD(IAM(IPT),2).EQ.0 .and.
     &     (KF3.EQ.0 .or. IAM(IPT+8).LE.0)) then
          IPU=1
        else
          IPU=2
        endif

        IAI=0
        IAP=0
        IAX=0

        if (JRC.NE.0) then
          ICN=0
          ICZ=0
          IOS=LAM-IAM(6)
          if (IOS.GT.IAM(6)-1-IAM(5)) then
            CALL SETER ('ARPRAM - AREA-MAP ARRAY OVERFLOW',12,1)
            GO TO 10008
          endif
          do ITM=IAM(6),LAM-1
            IAM(ITM-IOS)=0
          enddo
        write(*,*) JRC,ICN,ICZ,IOS
        endif
 
!
! IPQ points to the node defining the beginning of the edge segment,
! IPR to the node defining the end of the edge segment, and IPS to
! the node defining the beginning of the edge, so that we can tell
! when we've gone all the way around it.
!
        IPQ=IAM(IPT+4)
        IPR=IPT
        IPS=IPQ
        IPM=IPR
        IPV=IPU
!
! Each pass through the following loop moves one step along the edge of
! the subarea.
!
        lsw242=.true.
        do while (lsw242)
!
! Move IPQ to IPP and IPR to IPQ.
!
          IPP=IPQ
          IPQ=IPR
!
! Get the coordinates of the ends of the edge segment for use in
! computing change in direction to a possible next point.
!
          IXP=IAM(IPP+1)
          IYP=IAM(IPP+2)
          IXQ=IAM(IPQ+1)
          IYQ=IAM(IPQ+2)
!
! Back up IPR to the beginning of the group of nodes which have the
! same X and Y coordinates as it does.
!
          do while (IAM(IPR+1).EQ.IAM(IAM(IPR+6)+1)
     &        .and .IAM(IPR+2).EQ.IAM(IAM(IPR+6)+2))
            IPR=IAM(IPR+6)
          enddo
!
! If there is only one node in the group, the exit path is obvious.
!
          if (IAM(IPR+1).NE.IAM(IAM(IPR+5)+1) .or.
     &        IAM(IPR+2).NE.IAM(IAM(IPR+5)+2)) then
            if (IAM(IAM(IPR+3)+1).NE.IAM(IPP+1) .or.
     &          IAM(IAM(IPR+3)+2).NE.IAM(IPP+2)) then
              if (IAM(IAM(IPR+3)+7).EQ.LAM-IGI .or.
     &            ABS(IAM(IAM(IPR+3)+7)).EQ.IGI) then
                IPM=IAM(IPR+3)
                IPR=IPM
                IPV=IPU
              else
                IPR=0
              endif
            else
              if (IAM(IPR+7).EQ.LAM-IGI .or.
     &            ABS(IAM(IPR+7)).EQ.IGI) then
                IPM=IPR
                IPR=IAM(IPR+4)
                IPV=3-IPU
              else
                IPR=0
              endif
            endif
          else
!
! Otherwise, go through the group of nodes, examining all the possible
! ways to move from the current position to a new one.  Pick the
! direction which is leftmost (if IPU=1) or rightmost (if IPU=2).
!
            IP1=IPR
            IP2=IPR
            IPR=0

            if (IPU.EQ.1) then
              ANM=-3.14159265358979
            else
              ANM=+3.14159265358979
            endif

            do while (IAM(IP2+1).EQ.IAM(IP1+1)
     &          .and. IAM(IP2+2).EQ.IAM(IP1+2))
              if ((IAM(IAM(IP2+3)+7).EQ.LAM-IGI .or.
     &             ABS(IAM(IAM(IP2+3)+7)).EQ.IGI) .and.
     &            (IAM(IAM(IP2+3)+1).NE.IAM(IPP+1) .or.
     &             IAM(IAM(IP2+3)+2).NE.IAM(IPP+2))) then
                IXR=IAM(IAM(IP2+3)+1)
                IYR=IAM(IAM(IP2+3)+2)

                if (IAU.EQ.1) then
                  ANG=ARRAT2(real(IXQ-IXP)*real(IYR-IYQ)
     &                      -real(IYQ-IYP)*real(IXR-IXQ),
     &                       real(IXQ-IXP)*real(IXR-IXQ)
     &                      +real(IYQ-IYP)*real(IYR-IYQ))
                elseif (IAU.EQ.2) then
                  ANG=ARDAT2(dble(IXQ-IXP)*dble(IYR-IYQ)
     &                      -dble(IYQ-IYP)*dble(IXR-IXQ),
     &                       dble(IXQ-IXP)*dble(IXR-IXQ)
     &                      +dble(IYQ-IYP)*dble(IYR-IYQ))
                else
                  IO6(3,1)=IXQ-IXP
                  IO6(3,2)=IYR-IYQ
                  IO6(3,3)=IYQ-IYP
                  IO6(3,4)=IXR-IXQ
                  call ARMPIA (IO6, DP1, ierr)
                  if (ierr.NE.0) goto 10028
                  call ARMPIA (IO7, DP2, ierr)
                  if (ierr.ne.0) goto 10028
                  ANG=ARDAT2(DP1,DP2)
                endif

                if (IPU.eq.1 .and. ANG.gt.ANM) then
                  IPR=IAM(IP2+3)
                  ANM=ANG
                  IPM=IPR
                  IPV=1
                elseif (IPU.eq.2 .and. ANG.lt.ANM) then
                  IPR=IAM(IP2+3)
                  ANM=ANG
                  IPM=IPR
                  IPV=2
                endif
              endif

              if ((IAM(IP2+7).eq.LAM-IGI .or. ABS(IAM(IP2+7)).eq.IGI)
     &                 .and. (IAM(IAM(IP2+4)+1).ne.IAM(IPP+1) .or.
     &                        IAM(IAM(IP2+4)+2).ne.IAM(IPP+2)) ) then
                IXR=IAM(IAM(IP2+4)+1)
                IYR=IAM(IAM(IP2+4)+2)
                if (IAU.EQ.1) then
                  ANG=ARRAT2(real(IXQ-IXP)*real(IYR-IYQ)
     &                      -real(IYQ-IYP)*real(IXR-IXQ),
     &                       real(IXQ-IXP)*real(IXR-IXQ)
     &                      +real(IYQ-IYP)*real(IYR-IYQ))
                elseif (IAU.EQ.2) then
                  ANG=ARDAT2(dble(IXQ-IXP)*dble(IYR-IYQ)
     &                      -dble(IYQ-IYP)*dble(IXR-IXQ),
     &                       dble(IXQ-IXP)*dble(IXR-IXQ)
     &                      +dble(IYQ-IYP)*dble(IYR-IYQ))
                else
                  IO6(3,1)=IXQ-IXP
                  IO6(3,2)=IYR-IYQ
                  IO6(3,3)=IYQ-IYP
                  IO6(3,4)=IXR-IXQ
                  CALL ARMPIA (IO6, DP1, ierr)
                  IF (ierr.ne.0) GO TO 10028
                  CALL ARMPIA (IO7, DP2, ierr)
                  IF (ierr.ne.0) GO TO 10028
                  ANG=ARDAT2(DP1,DP2)
                endif

                if (IPU.eq.1 .and. ANG.gt.ANM) then
                  IPR=IAM(IP2+4)
                  ANM=ANG
                  IPM=IP2
                  IPV=2
                elseif (IPU.eq.2 .and. ANG.lt.ANM) then
                  IPR=IAM(IP2+4)
                  ANM=ANG
                  IPM=IP2
                  IPV=1
                endif
              endif
              IP2=IAM(IP2+5)
            enddo
          endif
!
! If no possible exit was found, reverse direction.
!
          if (IPR.eq.0) then
            IPR=IPP
            IPV=3-IPV
          endif
!
! Update the markers for the edge segment picked.
!
          if (IPV.eq.1 .and. mod(IAM(IPM),2).eq.0) then
            IAM(IPM)=IAM(IPM)+1
            IAQ=IPM+8
          elseif (IPV.eq.2 .and. mod(IAM(IPM)/2,2).eq.0) then
            IAM(IPM)=IAM(IPM)+2
            IAQ=IPM+9
          else
            write(*,*) 'IPV,IPM,IAM(IPM) =', IPV,IPM,IAM(IPM) 
            CALL SETER ('ARPRAM - ALGORITHM FAILURE',13,1)
            write(*,*) 'after'
            GO TO 10008
          endif
          if (IAM(IAQ).le.0 .or. IAM(IAQ).ge.IAM(6)) then
            if (JRC.EQ.0) then
              if (IAM(IAQ).LT.0) then
                IAI=-1
                IAX=LAM*4
              elseif (IAM(IAQ).GE.IAM(6).AND.IAM(IPM).GT.IAX) then
                IAI=IAM(IAQ)
                IAX=IAM(IPM)
              endif
            else
              if (IAM(IAQ).LT.0) then
                ICN=ICN+1
              elseif (IAM(IAQ).EQ.0) then
                ICZ=ICZ+1
              elseif (IAM(IAQ).GE.IAM(6)) then
                IAM(IAM(IAQ)-IOS)=IAM(IAM(IAQ)-IOS)+1
              endif
            endif
            IAM(IAQ)=IAP
            IAP=IAQ
          endif
!
! Exit if we are passing the start of the subarea.
!
          if (IAM(IPQ+1).eq.IAM(IPS+1) .and. IAM(IPQ+2).eq.IAM(IPS+2)
     &  .and. IAM(IPR+1).eq.IAM(IPT+1) .and. IAM(IPR+2).eq.IAM(IPT+2)
     &                                               ) lsw242=.false.
        enddo


!
! If the new way of reconciling contradictory area-identifier info was
! requested, set IAI accordingly, using the counts that were generated
! while tracing the boundary of the area.
!
        if (JRC.LT.0 .and. ICN.GT.0) then
          IAI=-1
        elseif (JRC.NE.0) then
          if (ICN.GT.0) then
            IAI=-1
            IAX=ICN
          endif
          if (ICZ.GT.IAX .and. ABS(JRC).EQ.2) then
            IAI=0
            IAX=ICZ
          endif
          do ITM=IAM(6),LAM-1
            if (IAM(ITM-IOS).GT.IAX) then
              IAI=ITM
              IAX=IAM(ITM-IOS)
            endif
          enddo
        endif
!
! Go through the chain of area identifiers, updating them.
!
        do while (IAP.NE.0)
          IAQ=IAM(IAP)
          IAM(IAP)=IAI
          IAP=IAQ
        enddo
!
! If a zero identifier was selected for the area, see if the search for
! holes was suppressed and, if so, re-do it.
!
        if (IAI.EQ.0 .and. KF3.NE.0) then
          do IPT=8,IAM(5)-9,10
            IAM(IPT)=4*(IAM(IPT)/4)
          enddo
          KF3=0
          GO TO 104
        endif

      GO TO 10232
10235 CONTINUE
!
! Delete the nodes used to put in the temporary connecting lines.
!
      IPT=IAM(5)-9
      do while (IPT.GT.ILW)
        IAM(IAM(IPT+4)+3)=IAM(IPT+3)
        IAM(IAM(IPT+3)+4)=IAM(IPT+4)
        IAM(IAM(IPT+6)+5)=IAM(IPT+5)
        IAM(IAM(IPT+5)+6)=IAM(IPT+6)
        IPT=IPT-10
      enddo
      IAM(5)=ILW
!
! Zero the markers in all the remaining nodes.
!
      do IPT=8,IAM(5)-9,10
        IAM(IPT)=0
      enddo
!
! Update the map state.
!
      IAM(4)=1
!
! If debugging is turned on, produce a plot.
!
      if (IDB.ne.0) then
        CALL ARDBPA (IAM,IDB,'AFTER UPDATING AREA IDENTIFIERS')
        IF (ICFELL('ARPRAM',14).NE.0) RETURN
      endif
!
! Done.
!
      RETURN
!
! This internal procedure is called when an error occurs in ARMPIA.
!
10028 CONTINUE
        CALL SETER
     +  ('ARPRAM/ARMPIA - MULTIPLE-PRECISION QUANTITY IS TOO BIG',
     +                                                       16,1)
!
! This internal procedure cleans up after an error condition occurs.
! It removes nodes used to put in temporary connecting lines, if any,
! and returns markers in the remaining nodes to zero.
!
10008 CONTINUE
!
! Delete new nodes from the area map.
!
        IPT=IAM(5)-9
        do while (IPT.gt.ILW)
          IAM(IAM(IPT+4)+3)=IAM(IPT+3)
          IAM(IAM(IPT+3)+4)=IAM(IPT+4)
          IAM(IAM(IPT+6)+5)=IAM(IPT+5)
          IAM(IAM(IPT+5)+6)=IAM(IPT+6)
          IPT=IPT-10
        enddo
        IAM(5)=ILW
!
! Zero the low-order bits of the markers in all the remaining nodes.
!
        do IPT=8,IAM(5)-9,10
          IAM(IPT)=4*(IAM(IPT)/4)
        enddo
!
! If appropriate, delete space temporarily used at the upper end of
! the area map array.
!
        IF (ISU.NE.0) IAM(6)=ISU
!
! Return to the calling routine.
!
      return
      end


      subroutine ADDPOINT (IAM, IX0,IY0, IPN,IPI,IPX, ierr) 
!
! This internal procedure adds a new point in the existing part of the
! area map. Note that ADD-A-POINT puts a new point which has the same
! coordinates as an old point after the old point in the area map (in
! coordinate order); this is important.
!
      implicit none
      integer IAM(*), IX0,IY0, IPN,IPI,IPX, ierr
      logical lswch 

      IPN=IAM(5)+1
      if (IAM(5)+10 .lt. IAM(6)) then
        IAM(5)=IAM(5)+10
        IAM(IPN)=IAM(IPI)
        IAM(IPN+1)=IX0
        IAM(IPN+2)=IY0
        IAM(IPN+3)=IPI
        IAM(IPN+4)=IAM(IPI+4)
        IAM(IAM(IPI+4)+3)=IPN
        IAM(IPI+4)=IPN

        lswch=.true.
        do while (lswch)
          if (IAM(IPN+1).LT.IAM(IPX+1)) then
            IPX=IAM(IPX+6)
          elseif (IAM(IPN+1).GT.IAM(IAM(IPX+5)+1)) then
            IPX=IAM(IPX+5)
          else
            do while (lswch)
              if (IAM(IPN+1).EQ.IAM(IPX+1) .and.
     &            IAM(IPN+2).LT.IAM(IPX+2)) then
                IPX=IAM(IPX+6)
              elseif (IAM(IPN+1).EQ.IAM(IAM(IPX+5)+1) .and.
     &                IAM(IPN+2).GT.IAM(IAM(IPX+5)+2)) then
                IPX=IAM(IPX+5)
              else
                do while (IAM(IAM(IPX+5)+1).EQ.IAM(IPN+1)
     &              .and. IAM(IAM(IPX+5)+2).EQ.IAM(IPN+2))
                  IPX=IAM(IPX+5)
                enddo
                lswch=.false.
              endif
            enddo
          endif
        enddo

        IAM(IPN+5)=IAM(IPX+5)
        IAM(IPN+6)=IAM(IAM(IPX+5)+6)
        IAM(IAM(IPX+5)+6)=IPN
        IAM(IPX+5)=IPN
        IAM(IPN+7)=IAM(IPI+7)
        IAM(IPN+8)=IAM(IPI+8)
        IAM(IPN+9)=IAM(IPI+9)
        ierr=0
      else
        call SETER ('ARPRAM/ADDPOINT - AREA-MAP ARRAY OVERFLOW',15,1)
        ierr=1  
      endif
      return
      end



      subroutine RMCOINS (IAM, IP1,IP2)
      implicit none
      integer IAM(*), IP1,IP2,    IL1,IL2, IR1,IR2, IMN,IMX
!
! This internal procedure processes coincident pairs of segments found.
! If both members of the pair belong to the same group, area identifier
! information from both members is reconciled and one of the pair is
! deleted.  If they belong to different groups, the group id in one of
! them is negated, so that it is present when we are looking at edges
! belonging to a single group, but absent when we are looking at all
! the edges together.
!
      if (abs(IAM(IP1+7)) .eq. ABS(IAM(IP2+7))) then
        IL1=IAM(IP1+8)
        IR1=IAM(IP1+9)
        if (IAM(IP1+1).eq.IAM(IP2+1) .and.
     &      IAM(IP1+2).eq.IAM(IP2+2)) then
          IL2=IAM(IP2+8)
          IR2=IAM(IP2+9)
        else
          IL2=IAM(IP2+9)
          IR2=IAM(IP2+8)
        endif
        IMN=MAX(-1,MIN(IL1,IL2))
        IMX=MAX(-1,MAX(IL1,IL2))
        if (IMN.EQ.IMX) then
          IAM(IP1+8)=IMN
        else
          IAM(IP1+8)=0
        endif
        IMN=MAX(-1,MIN(IR1,IR2))
        IMX=MAX(-1,MAX(IR1,IR2))
        if (IMN.EQ.IMX) then
          IAM(IP1+9)=IMN
        else
          IAM(IP1+9)=0
        endif
        IAM(IP2+8)=0
        IAM(IP2+9)=0
        IAM(IP2+7)=0
      elseif (IAM(IP1+7).GT.0) then
        IAM(IP2+7)=-abs(IAM(IP2+7))
      endif
      return
      end

#include "addsegm.F"
#include "intersect.F"
