      subroutine areafill (fill)
!
! Draw bottom line and fill area below the bottomline with an
! appropriate filling pattern, depending on input parameter fill.
! This routine is ised only for black and white crossection plot.
!
! fill = 1  default dot pattern.
!        2  dots, square and cross patterns.
!        3  dots, slanted square pattern.
!        4  vertical lines and dots.
!        5  vertical lines.
!        6  tree pattern.
!
! Copyright (c) 1996 Rutgers University
!
      implicit none

#include "param.h"
#include "pltio.h"
#include "pltncar.h"
#include "cntwkspa.h"


      integer fill, id1(8,8), id2(8,8), id3(8,8), ind(mcs)
      real dst(mcs)
      data id1 /1,1,0,0,0,0,1,1,
     &          1,1,0,1,1,0,1,1,
     &          0,0,0,1,1,0,0,0,
     &          0,1,1,1,1,1,1,0,
     &          0,1,1,1,1,1,1,0,
     &          0,0,0,1,1,0,0,0,
     &          1,1,0,1,1,0,1,1,
     &          1,1,0,0,0,0,1,1/

      data id2 /0,0,0,0,0,0,0,0,
     &          0,1,1,1,1,1,1,0,
     &          0,1,1,1,1,1,1,0,
     &          0,1,1,0,0,1,1,0,
     &          0,1,1,0,0,1,1,0,
     &          0,1,1,1,1,1,1,0,
     &          0,1,1,1,1,1,1,0,
     &          0,0,0,0,0,0,0,0/

      data id3 /0,0,0,0,0,0,0,0,
     &          0,0,0,0,1,0,0,0,
     &          0,0,0,1,1,1,0,0,
     &          0,1,0,0,1,0,0,1,
     &          0,0,1,1,1,1,1,0,
     &          0,0,0,0,1,0,0,0,
     &          0,0,0,1,0,1,0,0,
     &          0,1,1,0,0,0,1,1/
      save id1,id2,id3
!
! Check size of work space arrays.
!
      if (mcs.lt.3*nra) then
        write(stdout,'(/1x,3A,I8,1x,A/18x,A,I8,A/18x,A/)') 'ERROR: ',
     &       'AREAFILL: Array sise parameter mcs =', mcs, 'in file ',
     &       '''cntwkspa.h''',  'is too small. It must be at least ',
     &        3*nra,   '.',     'To Fix: Increase it and recompile.'
        stop
      elseif (fill.eq.1) then
        call sfsetr ('SP - spacing of fill lines', 0.005)
        call sfseti ('AN - angle of fill lines', 0)
        call sfseti ('DO - dot-fill flag',1)
        call sfwrld (xra,yra,nra, dst,mcs, ind,mcs)
      elseif (fill.eq.2) then
        call sfsetr ('SP - spacing of fill lines', 0.004)
        call sfseti ('DO - dot-fill flag',1)
        call sfsetp (id1)
        call sfwrld (xra,yra,nra, dst,mcs, ind,mcs)
      elseif (fill.eq.3) then
        call sfseti ('AN - angle of fill lines', 45)
        call sfseti ('DO - dot-fill flag',1)
        call sfsetp (id2)
        call sfwrld (xra,yra,nra, dst,mcs, ind,mcs)
      elseif (fill.eq.4) then
        call sfsetr ('SP - spacing of fill lines', 0.012)
        call sfseti ('AN - angle of fill lines', 90)
        call sfseti ('DO - dot-fill flag',0)
        call sfwrld (xra,yra,nra, dst,mcs, ind,mcs)
        call sfsetr ('SP - spacing of fill lines', 0.006)
        call sfseti ('AN - angle of fill lines', 90)
        call sfseti ('DO - dot-fill flag',1)
        call sfnorm (xra,yra,nra, dst,mcs, ind,mcs)
      elseif (fill.eq.5) then
        call sfsetr ('SP - spacing of fill lines', 0.005)
        call sfseti ('AN - angle of fill lines', 90)
        call sfwrld (xra,yra,nra, dst,mcs, ind,mcs)
      elseif (fill.eq.6) then
        call gschh (0.004)
        call sfsetr ('SP - spacing of fill lines', 0.004)
        call sfseti ('AN - angle of fill lines',0)
        call sfseti ('DO - dot-fill flag',1)
        call sfsetc ('CH - character specifier', 'o')
        call sfsetp (id3)
        call sfwrld (xra,yra,nra, dst,mcs, ind,mcs)
      endif
      return
      end
