      subroutine ADDSEGM (IAM, KF1,IAU, ILP,IQL,IQU,IQB,IQT, ISX,ISY,
     &                    IPN,IPI,IPX, ISL,ISR,ISD,IQE, IO1,IO2,ierr)
!
! The following internal procedure adds a segment to the list.
! It also checks for intersection of that segment with the
! segments on either side of it in the list.
!
      implicit none
      integer IAM(*),KF1,IAU, ILP, IQL,IQU,IQB,IQT, ISX,ISY,
     &  IPN,IPI,IPX,  ISL,ISR,ISD,  IQE, IO1(4,8),IO2(4,4), ierr

      logical search        ! These are internal variables:
      integer ILX,IQS,IQI   ! they are not present in the 
      real RLY,RTY,SLL,SLP  ! calling routine, except DPT,
      double precision DPT  ! which is used as short-life
                            ! scratch.
      IQS=0
      IQT=IQB
      ILX=IAM(ISL+1)
      RLY=real(IAM(ISL+2))
      if (IAM(ISL+1) .ne. IAM(ISR+1)) then
        SLL=real(IAM(ISR+2)-IAM(ISL+2))
     &     /real(IAM(ISR+1)-IAM(ISL+1))
      else
        SLL=real(ILP)
      endif

      search=.true.
      do while (search .and. IQT.ne.0)
        if (IAM(IAM(IQT+2)+1) .ne. IAM(IAM(IQT+3)+1)) then
          if (IAU.EQ.1) then
            SLP=real(IAM(IAM(IQT+3)+2)-IAM(IAM(IQT+2)+2))
     &         /real(IAM(IAM(IQT+3)+1)-IAM(IAM(IQT+2)+1))
            RTY=real(IAM(IAM(IQT+2)+2))
     &                   +real(ILX-IAM(IAM(IQT+2)+1))*SLP
          else
            DPT=dble(IAM(IAM(IQT+3)+2)-IAM(IAM(IQT+2)+2))
     &         /dble(IAM(IAM(IQT+3)+1)-IAM(IAM(IQT+2)+1))
            SLP=real(DPT)
            RTY=dble(IAM(IAM(IQT+2)+2))
     &                  +dble(ILX-IAM(IAM(IQT+2)+1))*DPT
          endif
        else
          SLP=real(ILP)
          RTY=real(IAM(IAM(IQT+2)+2))
        endif
        if (RLY.lt.RTY .or. (RLY.EQ.RTY .and. SLL.LT.SLP)) then
          search=.false.
        else
          IQS=IQT
          IQT=IAM(IQT)
        endif
      enddo

      if (IQE.ne.0) then
        IQI=IQE
        IQE=IAM(IQE)
      elseif (IAM(5).lt.IAM(6)-5) then
        IQI=IAM(6)-5
        IAM(6)=IQI
      else
        call SETER ('ARPRAM - AREA-MAP ARRAY OVERFLOW',6,1)
        ierr=10008
        return
      endif

      IAM(IQI)=IQT
      IAM(IQI+1)=IQS
      IAM(IQI+2)=ISL
      IAM(IQI+3)=ISR
      IAM(IQI+4)=ISD
      if (IQS.ne.0) IAM(IQS)=IQI
      if (IQT.ne.0) IAM(IQT+1)=IQI
      if (IQB.eq.IQT) IQB=IQI
      if (IQS.NE.0) then
        IQL=IQS
        IQU=IQI
        call INTERSECT (IAM, KF1,IAU, ILP, IQL,IQU,IQB,IQT,
     &                  ISX,ISY, IPN,IPI,IPX, IO1,IO2, ierr)
        if (ierr.ne.0) return
      endif
      if (IQT.NE.0) then
        IQL=IQI
        IQU=IQT
        call INTERSECT (IAM, KF1,IAU, ILP, IQL,IQU,IQB,IQT,
     &                  ISX,ISY, IPN,IPI,IPX, IO1,IO2, ierr)
      endif
      return
      end

