# Platform-specific definitions: Version for ORIGIN 2000 in NCSA.
#

.SUFFIXES: .o .f .F

.F.o:
	$(CPP) -P $(CPPFLAGS) $*.F | $(HOME)/bin/mpc_clean > $*.f
	$(CFT) -c $(FFLAGS) $*.f
#rm $*.f

.F.f:
	$(CPP) -P $(CPPFLAGS) $*.F | $(HOME)/bin/mpc_clean > $*.f
.f.o:
	$(CFT) -c $(FFLAGS) $*.f
.F:
	$(CFT) -o $@ $(FFLAGS) $(LDFLAGS) $<
.f:
	$(CFT) -o $@ $(FFLAGS) $(LDFLAGS) $<

# CFT           Name of the fortran compiler to use
# CPPFLAGS      Flags to the C preprocessor
# CPP           Name of the C preprocessor
# FFLAGS        Flags to the fortran compiler
# LDR           Program to load the objects into an executable
# LDFLAGS       Flags to the loader
# RANLIB        Name of ranlib command
# CDFLIB        Name of netCDF library, either -lnetcdf or null

 BINARY_TYPE = n32
         CPP = /usr/lib32/cmplrs/cpp
    CPPFLAGS = -DSGI -I../lib$(BINARY_TYPE)
  CPPFLAGS = -DSGI -D"set=???" -I../lib$(BINARY_TYPE)
         CFT = f77  -$(BINARY_TYPE) -mips4
         LDR = $(CFT) $(LDFLAGS)

      FFLAGS = $(CPPFLAGS) -O3
#     FFLAGS = -g -DEBUG:div_check=3:subscript_check=ON:trap_uninitialized=ON:verbose_runtime=ON

#     LDFLAGS = -v

      RANLIB = touch
#
# NCARG_ROOT must be set in .cshrc file.
# NCARG version 3.2.1 requires -lncarg_loc before -lX11,
#         while v. 4.x.x do not.
#
     LIBNCAR = -L$(NCARG_ROOT)/lib -L/usr/local/lib -lncarg -lncarg_gks -lncarg_c -lX11


      CDFLIB = ../lib$(BINARY_TYPE)/libnetcdf.a

        LIBS = $(CDFLIB) $(LIBNCAR)

