#include "cppdefs.h"
 
      subroutine v2dbc (tile)
      implicit none
      integer tile
#include "param.h"
#include "private_scratch.h"
#include "compute_tile_bounds.h"
      call v2dbc_tile (istr,iend,jstr,jend, A2d(1,1))
      return
      end
 
      subroutine v2dbc_tile (istr,iend,jstr,jend, grad)
!
! Set lateral boundary conditions for the barotropic (i.e.
! vertically integrated) ETA-component velocity vbar(:,:,knew).
!
      implicit none
      integer istr,iend,jstr,jend, i,j
      real grad(PRIVATE_2D_SCRATCH_ARRAY), eps,cff,
     &                           cx,cy, dft,dfx,dfy
      parameter (eps=1.D-20)
#include "param.h"
#include "grid.h"
#include "ocean2d.h"
#include "scalars.h"
#include "climat.h"
!
#include "compute_auxiliary_bounds.h"
!
#ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then            ! Southern edge radiation BC
# ifdef OBC_SOUTH
#  ifdef OBC_M2ORLANSKI
        do i=istr,iend+1
          grad(i,1)=(vbar(i,1,kstp)-vbar(i-1,1,kstp))
          grad(i,2)=(vbar(i,2,kstp)-vbar(i-1,2,kstp))
        enddo
        do i=istr,iend
          dft=vbar(i,2,kstp)-vbar(i,2,knew)
          dfx=vbar(i,2,kstp)-vbar(i,3,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(i,2)+grad(i+1,2)) .gt. 0.) then
            dfy=grad(i  ,2)
          else
            dfy=grad(i+1,2)
          endif
 
 
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          vbar(i,1,knew)=( (1.-cx)*vbar(i,1,kstp)+cx*vbar(i,2,kstp)
     &                                       -max(cy,0.)*grad(i  ,1)
     &                                       -min(cy,0.)*grad(i+1,1)
     &                                                             )
#   ifdef MASKING
     &                                              *vmask(i,1)
#   endif
        enddo
#  else
        do i=istr,iend                    ! Northern edge gradient BC
          vbar(i,1,knew)=vbar(i,2,knew)   ! ======== ==== ======== ==
#   ifdef MASKING
     &                       *vmask(i,1)
#   endif
        enddo
#  endif
# else
        do i=istrR,iendR
          vbar(i,jstrV-1,knew)=0.   ! Southern edge normal no-flux BC
        enddo                       ! ======== ==== ====== ======= ==
# endif          /* OBC_SOUTH */
      endif      !<-- SOUTHERN_EDGE
 
 
      if (NORTHERN_EDGE) then            ! Northern edge radiation BC
# ifdef OBC_NORTH
#  ifdef OBC_M2ORLANSKI
        do i=istr,iend+1
          grad(i,Mm  )=(vbar(i,Mm  ,kstp)-vbar(i-1,Mm  ,kstp))
          grad(i,Mm+1)=(vbar(i,Mm+1,kstp)-vbar(i-1,Mm+1,kstp))
        enddo
        do i=istr,iend
          dft=vbar(i,Mm,kstp)-vbar(i,Mm,knew)
          dfx=vbar(i,Mm,kstp)-vbar(i,Mm-1,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(i,Mm)+grad(i,Mm+1)) .gt. 0.) then
            dfy=grad(i  ,Mm)
          else
            dfy=grad(i+1,Mm)
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          vbar(i,Mm+1,knew)=( (1.-cx)*vbar(i,Mm+1,kstp)
     &                                       +cx*vbar(i,Mm,kstp)
     &                                  -max(cy,0.)*grad(i  ,Mm+1)
     &                                  -min(cy,0.)*grad(i+1,Mm+1)
     &                                                           )
#   ifdef MASKING
     &                                 *vmask(i,Mm+1)
#   endif
        enddo
#  else                                   ! Northern edge gradient BC
        do i=istr,iend                    ! ======== ==== ======== ==
          vbar(i,Mm+1,knew)=vbar(i,Mm,knew)
#   ifdef MASKING
     &                       *vmask(i,Mm+1)
#   endif
        enddo
#  endif
# else
        do i=istrR,iendR
          vbar(i,jend+1,knew)=0.    ! Northern edge normal no-flux BC
        enddo                       ! ======== ==== ====== ======= ==
# endif                  /* OBC_NORTH */
      endif         !<--  NORTHERN_EDGE
#endif               /* !NS_PERIODIC */
 
 
 
#ifndef EW_PERIODIC
      if (WESTERN_EDGE) then              ! Western edge radiation BC
# ifdef OBC_WEST
#  ifdef OBC_M2ORLANSKI
        do j=jstrV-1,jend
          grad(0,j)=(vbar(0,j+1,kstp)-vbar(0,j,kstp))
          grad(1,j)=(vbar(1,j+1,kstp)-vbar(1,j,kstp))
        enddo
        do j=jstrV,jend
          dft=vbar(1,j,kstp)-vbar(1,j,knew)
          dfx=vbar(1,j,kstp)-vbar(2,j,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(1,j-1)+grad(1,j)) .gt. 0.) then
            dfy=grad(1,j-1)
          else
            dfy=grad(1,j  )
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          vbar(0,j,knew)=( (1.-cx)*vbar(0,j,kstp)+cx*vbar(1,j,kstp)
     &                                        -max(cy,0.)*grad(0,j-1)
     &                                        -min(cy,0.)*grad(0,j  )
     &                                                              )
#   ifdef MASKING
     &                                            *vmask(0,j)
#   endif
        enddo
#  else
        do j=jstrV,jend                    ! Western edge gradient BC
          vbar(0,j,knew)=vbar(1,j,knew)    ! ======= ==== ======== ==
#   ifdef MASKING
     &                      *vmask(0,j)
#   endif
        enddo
#  endif
# else
#  ifdef NS_PERIODIC
#   define J_TANG_RANGE jstrV,jend
#  else
#   define J_TANG_RANGE jstr,jendR
#  endif                           ! Closed BC: free-slip (gamma2=+1)
        do j=J_TANG_RANGE          ! ====== ===   no-slip (gamma2=-1)
          vbar(0,j,knew)=gamma2*vbar(1,j,knew)
#  ifdef MASKING
     &                             *vmask(0,j)
#  endif
        enddo
#  undef J_TANG_RANGE
# endif              /* OBC_WEST */
      endif        !<-- WESTERN_EDGE
 
 
      if (EASTERN_EDGE) then              ! Eastern edge radiation BC
# ifdef OBC_EAST
#  ifdef OBC_M2ORLANSKI
        do j=jstrV-1,jend
          grad(Lm  ,j)=(vbar(Lm  ,j+1,kstp)-vbar(Lm  ,j,kstp))
          grad(Lm+1,j)=(vbar(Lm+1,j+1,kstp)-vbar(Lm+1,j,kstp))
        enddo
        do j=jstrV,jend
          dft=vbar(Lm,j,kstp)-vbar(Lm,j,knew)
          dfx=vbar(Lm,j,kstp)-vbar(Lm-1,j,kstp)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          if (dft*(grad(Lm,j-1)+grad(Lm,j)) .gt. 0.) then
            dfy=grad(Lm,j-1)
          else
            dfy=grad(Lm,j  )
          endif
 
          cff=dft/max(dfx*dfx+dfy*dfy, eps)
          cx=min(1., cff*dfx)
          cy=min(1., max(-1.,cff*dfy))
 
          vbar(Lm+1,j,knew)=( (1.-cx)*vbar(Lm+1,j,kstp)
     &                                       +cx*vbar(Lm,j,kstp)
     &                                  -max(cy,0.)*grad(Lm+1,j-1)
     &                                  -min(cy,0.)*grad(Lm+1,j  )
     &                                                           )
#   ifdef MASKING
     &                                 *vmask(Lm+1,j)
#   endif
        enddo
#  else                                    ! Eastern edge gradient BC
        do j=jstrV,jend                    ! ======= ==== ======== ==
          vbar(Lm+1,j,knew)=vbar(Lm,j,knew)
#   ifdef MASKING
     &                        *vmask(Lm+1,j)
#   endif
        enddo
#  endif
# else
#  ifdef NS_PERIODIC
#   define J_TANG_RANGE jstrV,jend
#  else
#   define J_TANG_RANGE jstr,jendR
#  endif                           ! Closed BC: free-slip (gamma2=+1)
        do j=J_TANG_RANGE          ! ====== ===   no-slip (gamma2=-1)
          vbar(Lm+1,j,knew)=gamma2*vbar(Lm,j,knew)
#  ifdef MASKING
     &                       *vmask(Lm+1,j)
#  endif
        enddo
#  undef J_TANG_RANGE
# endif                  /* OBC_EAST */
      endif            !<-- EASTERN_EDGE
#endif               /* !EW_PERIODIC */
 
                                    ! Open corners (if any)
                                    ! ==== ======= === ====
 
#if defined OBC_SOUTH && defined OBC_WEST
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        vbar(0,1,knew)=0.5*(vbar(0,2,knew)+vbar(1,1,knew))
      endif
#endif
#if defined OBC_SOUTH && defined OBC_EAST
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        vbar(Lm+1,1,knew)=0.5*(vbar(Lm+1,2,knew)+vbar(Lm,1,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_WEST
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        vbar(0,Mm+1,knew)=0.5*(vbar(0,Mm,knew)+vbar(1,Mm+1,knew))
      endif
#endif
#if defined OBC_NORTH && defined OBC_EAST
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        vbar(Lm+1,Mm+1,knew)=0.5*(vbar(Lm+1,Mm  ,knew)
     &                           +vbar(Lm  ,Mm+1,knew))
      endif
#endif
      return
      end
 
