#include "cppdefs.h"
 
      subroutine put_global_atts (ncid, ierr)
      implicit none
      integer ncid, ierr, nf_ftype, lvar,lenstr
#include "param.h"
#include "scalars.h"
#include "ncscrum.h"
#include "netcdf.inc"
#include "strings.h"
 
#if defined MPI && defined PARALLEL_FILES
      integer*4 ibuff(4)
!
! Put global attribute 'partition' which identifies subdomain
! within the processor grid individually for each file.
!
      ibuff(1)=ii
      ibuff(2)=jj
      ibuff(3)=NP_XI
      ibuff(4)=NP_ETA
      ierr=nf_put_att_int (ncid, nf_global, 'partition',
     &                                  nf_int, 4, ibuff)
#endif
!
! Decide about output file type and precision for floating point
! variables (restart file always has the same precision as in the
! code, typically double precision, while all others can be made
! single precision.
!
      if (ncid.eq.ncidrst) then
        nf_ftype=NF_FTYPE
      else
        nf_ftype=NF_FOUT
      endif
 
      if (ncid.eq.ncidrst) then
        ierr=nf_put_att_text (ncid, nf_global, 'type',  17,
     &                                 'ROMS restart file')
      elseif (ncid.eq.ncidhis) then
        ierr=nf_put_att_text (ncid, nf_global, 'type',  17,
     &                                 'ROMS history file')
#ifdef AVERAGES
      elseif (ncid.eq.ncidavg) then
        ierr=nf_put_att_text (ncid, nf_global, 'type',  18,
     &                                'ROMS averages file')
#endif
#ifdef STATIONS
      elseif (ncid.eq.ncidsta) then
        ierr=nf_put_att_text(ncid,  nf_global, 'type', 18,
     &                                'ROMS stations file')
#endif
      endif
 
 
      lvar=lenstr(title)
      ierr=nf_put_att_text(ncid, nf_global, 'title',   lvar,
     &                                         title(1:lvar))
      lvar=lenstr(date_str)
      ierr=nf_put_att_text(ncid, nf_global, 'date',    lvar,
     &                                      date_str(1:lvar))
      lvar=lenstr(rstname)
      ierr=nf_put_att_text(ncid, nf_global, 'rst_file',lvar,
     &                                       rstname(1:lvar))
      lvar=lenstr(hisname)
      ierr=nf_put_att_text(ncid, nf_global, 'his_file',lvar,
     &                                       hisname(1:lvar))
#ifdef AVERAGES
      lvar=lenstr(avgname)
      ierr=nf_put_att_text(ncid, nf_global, 'avg_file',lvar,
     &                                       avgname(1:lvar))
#endif
#ifdef STATIONS
      lvar=lenstr(staname)
      ierr=nf_put_att_text(ncid, nf_global, 'sta_file',lvar,
     &                                       staname(1:lvar))
      lvar=lenstr(sposnam)
      ierr=nf_put_att_text(ncid, nf_global, 'spos_file',lvar,
     &                                       sposnam(1:lvar))
#endif
#ifdef FLOATS
      lvar=lenstr(fltname)
      ierr=nf_put_att_text(ncid, nf_global, 'flt_file',lvar,
     &                                       fltname(1:lvar))
#endif
#ifndef ANA_GRID
      lvar=lenstr(grdname)
      ierr=nf_put_att_text(ncid, nf_global, 'grd_file',lvar,
     &                                       grdname(1:lvar))
#endif
#ifndef ANA_INITIAL
      lvar=lenstr(ininame)
      ierr=nf_put_att_text(ncid, nf_global, 'ini_file',lvar,
     &                                       ininame(1:lvar))
#endif
#if !defined ANA_SMFLUX || !defined ANA_STFLUX \
 || (defined SG_BBL96 && !defined ANA_BSEDIM)  \
 || (defined SG_BBL96 && !defined ANA_WWAVE)   \
 || (defined SALINITY && !defined ANA_SSFLUX)  \
 || (defined LMD_KPP  && !defined ANA_SRFLUX)
      lvar=lenstr(frcname)
      ierr=nf_put_att_text(ncid, nf_global,'frc_file', lvar,
     &                                       frcname(1:lvar))
#endif
#ifdef ASSIMILATION
      lvar=lenstr(assname)
      ierr=nf_put_att_text(ncid, nf_global,'ass_file', lvar,
     &                                       assname(1:lvar))
      lvar=lenstr(aparnam)
      ierr=nf_put_att_text(ncid, nf_global,'apar_file',lvar,
     &                                       aparnam(1:lvar))
#endif
#ifdef FLOATS
      lvar=lenstr(fparnam)
      ierr=nf_put_att_text(ncid, nf_global,'fpar_file',lvar,
     &                                       fparnam(1:lvar))
#endif
#ifdef SOLVE3D
!
! S-coordinate control parameters "theta_s", "theta_b", and "hc"
!
      ierr=nf_put_att_FTYPE(ncid, nf_global,'theta_s',nf_ftype,
     &                                            1,  theta_s)
      ierr=nf_put_att_text (ncid, nf_global,'theta_s_expl',38,
     &                   'S-coordinate surface control parameter')
 
      ierr=nf_put_att_FTYPE(ncid,nf_global,'theta_b',nf_ftype, 1,
     &                                                       theta_b)
      ierr=nf_put_att_text (ncid,nf_global,'theta_b_expl',37,
     &                       'S-coordinate bottom control parameter')
 
      ierr=nf_put_att_FTYPE(ncid, nf_global, 'hc',nf_ftype, 1, hc)
      ierr=nf_put_att_text (ncid, nf_global, 'hc_expl',38,
     &                      'S-coordinate parameter, critical depth')
      ierr=nf_put_att_text (ncid, nf_global, 'hc_units', 5, 'meter')
!
! S-coordinate independent variables "sc_w", "sc_r" and stretching
! curves "Cs_w", "Cs_r" at W- and RHO-points.
!
      ierr=nf_put_att_FTYPE(ncid, nf_global,'sc_w',nf_ftype, N+1,
     &                                                          sc_w)
      ierr=nf_put_att_text (ncid, nf_global,'sc_w_expl', 24,
     &                                    'S-coordinate at W-points')
      ierr=nf_put_att_FTYPE(ncid, nf_global,'Cs_w',nf_ftype, N+1,
     &                                                          Cs_w)
      ierr=nf_put_att_text (ncid, nf_global,'Cs_w_expl',42,
     &                  'S-coordinate stretching curves at W-points')
      ierr=nf_put_att_FTYPE(ncid,nf_global,'sc_r',nf_ftype,N,sc_r)
      ierr=nf_put_att_text (ncid, nf_global,'sc_r_expl', 24,
     &                                    'S-coordinate at W-points')
      ierr=nf_put_att_FTYPE(ncid,nf_global,'Cs_r',nf_ftype,N,Cs_r)
      ierr=nf_put_att_text (ncid, nf_global,'Cs_r_expl',44,
     &                'S-coordinate stretching curves at RHO-points')
#endif
!
! Time stepping parameters.
!
      ierr=nf_put_att_int(ncid,nf_global,'ntimes',  nf_int,1,ntimes)
      ierr=nf_put_att_int(ncid,nf_global,'ndtfast', nf_int,1,ndtfast)
      ierr=nf_put_att_FTYPE(ncid,nf_global,'dt',    nf_ftype, 1,  dt)
      ierr=nf_put_att_FTYPE(ncid,nf_global,'dtfast',nf_ftype, 1,
     &                                                        dtfast)
      ierr=nf_put_att_int  (ncid,nf_global,'nwrt',  nf_int,  1, nwrt)
#ifdef AVERAGES
      ierr=nf_put_att_int  (ncid,nf_global,'ntsavg',nf_int, 1,ntsavg)
      ierr=nf_put_att_text (ncid,nf_global,'ntsavg_expl',59,
     & 'starting time-step for accumulation of time-averaged fields')
 
      ierr=nf_put_att_int  (ncid,nf_global,'navg',  nf_int, 1,  navg)
      ierr=nf_put_att_text (ncid,nf_global,'navg_expl',50,
     &          'number of time-steps between time-averaged records')
#endif
#ifdef STATIONS
      ierr=nf_put_att_int  (ncid,nf_global,'nsta',  nf_int, 1,  nsta)
      ierr=nf_put_att_text (ncid,nf_global,'nsta_expl', 45,
     &               'number of time-steps between stations records')
#endif
!
! Horizontal viscosity and mixing coefficients.
!
#ifdef UV_VIS2
      ierr=nf_put_att_FTYPE(ncid,nf_global,'visc2',nf_ftype,1,visc2)
      ierr=nf_put_att_text (ncid,nf_global,'visc2_expl',41,
     &                   'Laplacian mixing coefficient for momentum')
      ierr=nf_put_att_text (ncid,nf_global,'visc2_units',15,
     &                                             'meter2 second-1')
#endif
#ifdef UV_VIS4
      ierr=nf_put_att_FTYPE(ncid,nf_global,'visc4',nf_ftype, 1,visc4)
      ierr=nf_put_att_text (ncid,nf_global,'visc4_expl', 42,
     &                  'biharmonic mixing coefficient for momentum')
      ierr=nf_put_att_text (ncid,nf_global,'visc4_units', 15,
     &                                             'meter4 second-1')
#endif
#ifdef SOLVE3D
# ifdef TS_DIF2
      ierr=nf_put_att_FTYPE(ncid,nf_global,'tnu2',nf_ftype, 1,tnu2)
      ierr=nf_put_att_text (ncid,nf_global,'tnu2_expl',40,
     &                    'Laplacian mixing coefficient for tracers')
      ierr=nf_put_att_text (ncid,nf_global,'tnu2_units',15,
     &                                             'meter2 second-1')
# endif
# ifdef TS_DIF4
      ierr=nf_put_att_FTYPE(ncid,nf_global,'tnu4', nf_ftype, 1,tnu4)
      ierr=nf_put_att_text (ncid,nf_global,'tnu4_expl',41,
     &                   'biharmonic mixing coefficient for tracers')
      ierr=nf_put_att_text (ncid,nf_global,'units',15,
     &                                             'meter4 second-1')
# endif
# ifdef MY25_MIXING
#  ifdef Q2_DIF2
      ierr=nf_put_att_FTYPE(ncid,nf_global,'q2nu2',nf_ftype, 1,q2nu2)
      ierr=nf_put_att_text (ncid,nf_global,'q2nu2_expl',49,
     &           'Laplacian mixing coefficient for turbulent energy')
      ierr=nf_put_att_text (ncid,nf_global,'q2nu2_units',15,
     &                                             'meter2 second-1')
#  endif
#  ifdef Q2_DIF4
      ierr=nf_put_att_FTYPE(ncid,nf_global,'q2nu4',nf_ftype, 1,q2nu4)
      ierr=nf_put_att_text (ncid,nf_global,'q2nu4_expl',50,
     &          'Biharmonic mixing coefficient for turbulent energy')
      ierr=nf_put_att_text (ncid,nf_global,'q2nu4_units',15,
     &                                             'meter4 second-1')
#  endif
# endif
# if !defined LMD_MIXING && !defined BVF_MIXING\
  && !defined MY2_MIXING && !defined MY25_MIXING\
                         && !defined PP_MIXING
!
! Background vertical viscosity and tracer mixing coefficients.
!
      ierr=nf_put_att_FTYPE(ncid,nf_global,'Akv_bak',nf_ftype, 1,
     &                                                      Akv_bak)
      ierr=nf_put_att_text (ncid,nf_global,'Akv_bak',51,
     &         'background vertical mixing coefficient for momentum')
      ierr=nf_put_att_text (ncid,nf_global,'Akv_bak_units',15,
     &                                             'meter2 second-1')
 
      ierr=nf_put_att_FTYPE(ncid,nf_global,'Akt_bak',nf_ftype, NT,
     &                                                       Akt_bak)
      ierr=nf_put_att_text (ncid,nf_global,'Akt_bak_expl', 50,
     &          'background vertical mixing coefficient for tracers')
      ierr=nf_put_att_text (ncid,nf_global,'Akt_bak_units', 15,
     &                                             'meter2 second-1')
# endif
# ifdef MY25_MIXING
      ierr=nf_put_att_FTYPE(ncid,nf_global,'Akq_bak',nf_ftype,
     &                    1,Akq_bak)
      ierr=nf_put_att_text (ncid,nf_global,'Akq_bak_expl',59,
     & 'background vertical mixing coefficient for turbulent energy')
      ierr=nf_put_att_text (ncid,nf_global,'Akq_bak_units',15,
     &                                             'meter2 second-1')
# endif
#endif
!
! Bottom drag coefficients.
!
      ierr=nf_put_att_FTYPE(ncid,nf_global,'rdrg',nf_ftype,1,rdrg)
      ierr=nf_put_att_text (ncid,nf_global,'rdrg_expl',23,
     &                                     'linear drag coefficient')
      ierr=nf_put_att_text (ncid,nf_global,'rdrg_units',14,
     &                                              'meter second-1')
      ierr=nf_put_att_FTYPE(ncid,nf_global,'rdrg2',nf_ftype,1,rdrg2)
      ierr=nf_put_att_text (ncid,nf_global,'rdrg2_expl',26,
     &                                  'quadratic drag coefficient')
      ierr=nf_put_att_text (ncid,nf_global,'rdrg2_units',14,
     &                                              'nondimensional')
#ifdef SOLVE3D
!
! Equation of State parameters.
!
      ierr=nf_put_att_FTYPE(ncid,nf_global,'rho0',nf_ftype, 1,rho0)
      ierr=nf_put_att_text (ncid,nf_global,'rho0_expl', 45,
     &               'Mean density used in Boussinesq approximation')
      ierr=nf_put_att_text (ncid,nf_global,'rho0_units', 16,
     &                                            'kilogram meter-3')
# ifndef NONLIN_EOS
      ierr=nf_put_att_FTYPE(ncid,nf_global,'R0',  nf_ftype, 1, R0)
      ierr=nf_put_att_text (ncid,nf_global,'R0_expl', 51,
     &         'Background density used in linear equation of state')
      ierr=nf_put_att_text (ncid,nf_global,'R0_units', 16,
     &                                            'kilogram meter-3')
 
      ierr=nf_put_att_FTYPE(ncid,nf_global,'Tcoef',nf_ftype, 1,Tcoef)
      ierr=nf_put_att_text (ncid,nf_global,'Tcoef_expl',29,
     &                               'thermal expansion coefficient')
      ierr=nf_put_att_text (ncid,nf_global,'Tcoef_units',9,
     &                                                   'Celsius-1')
 
      ierr=nf_put_att_FTYPE(ncid,nf_global,'Scoef',nf_ftype, 1,Scoef)
      ierr=nf_put_att_text (ncid,nf_global,'Scoef_expl', 30,
     &                              'Saline contraction coefficient')
      ierr=nf_put_att_text (ncid,nf_global,'Scoef_units', 5, 'PSU-1')
# endif
!
! Various parameters.
!
# ifdef BODYFORCE
      ierr=nf_put_att_int (ncid,nf_global,'levsfrc',nf_int,1,levsfrc)
      ierr=nf_put_att_text(ncid,nf_global, 'levsfrc_expl', 38,
     &                      'Shallowest level for body-force stress')
      ierr=nf_put_att_int (ncid,nf_global,'levbfrc',nf_int,1,levbfrc)
      ierr=nf_put_att_text(ncid,nf_global,'levbfrc_expl', 35,
     &                         'Deepest level for body-force stress')
# endif
#endif /* SOLVE3D */
!
! Slipperiness parameters.
!
      ierr=nf_put_att_FTYPE(ncid,nf_global,'gamma2',nf_ftype, 1,
     &                                                      gamma2)
      ierr=nf_put_att_text (ncid,nf_global,'gamma2_expl', 22,
     &                                    'Slipperiness parameter')
!
! List of Source Codes and Activated CPP-switches
!
      lvar=lenstr(srcs)
      ierr=nf_put_att_text (ncid,nf_global, 'SRCS', lvar,
     &                                       srcs(1:lvar))
      lvar=lenstr(cpps)
      ierr=nf_put_att_text (ncid,nf_global, 'CPPS', lvar,
     &                                       cpps(1:lvar))
      return
      end
 
