#include "cppdefs.h"
#ifdef LMD_KPP
 
      subroutine lmd_kpp_tile (istr,iend,jstr,jend, Kv,Kt,Ks,
     &                         sl_dpth, Bo,Bosol, Bfsfc,stable, f1,
     &                          Gm1,dGm1dS, Gt1,dGt1dS, Gs1,dGs1dS,
     &                                         wrk1,wrk2,wrk3, Rib)
      implicit none
# include "param.h"
      integer istr,iend,jstr,jend, i,j,k, ka,ku,ksave, itrc
      real Kv(PRIVATE_2D_SCRATCH_ARRAY,0:N),
     &     Kt(PRIVATE_2D_SCRATCH_ARRAY,0:N),
     &     Ks(PRIVATE_2D_SCRATCH_ARRAY,0:N),
 
     &    sl_dpth(PRIVATE_2D_SCRATCH_ARRAY),
     &         Bo(PRIVATE_2D_SCRATCH_ARRAY),
     &      Bosol(PRIVATE_2D_SCRATCH_ARRAY),
     &      Bfsfc(PRIVATE_2D_SCRATCH_ARRAY),
     &     stable(PRIVATE_2D_SCRATCH_ARRAY),
 
     &         f1(PRIVATE_2D_SCRATCH_ARRAY),
     &        Gm1(PRIVATE_2D_SCRATCH_ARRAY),
     &     dGm1dS(PRIVATE_2D_SCRATCH_ARRAY),
     &        Gt1(PRIVATE_2D_SCRATCH_ARRAY),
     &     dGt1dS(PRIVATE_2D_SCRATCH_ARRAY),
     &        Gs1(PRIVATE_2D_SCRATCH_ARRAY),
     &     dGs1dS(PRIVATE_2D_SCRATCH_ARRAY),
 
     &       wrk1(PRIVATE_2D_SCRATCH_ARRAY),
     &       wrk2(PRIVATE_2D_SCRATCH_ARRAY),
     &       wrk3(PRIVATE_2D_SCRATCH_ARRAY),
     &      Rib(PRIVATE_2D_SCRATCH_ARRAY,2)
 
      real Vtc,    hekman,  hmonob, hlimit, dVsq,  Vtsq,
     &             sl_dnew, sig,    Kv_p,   Kt_p,  Ks_p,
     &     cff,    z_sldf,  lmd_a1, Kv_h,   Kt_h,  Ks_h,
     &     cff_up, in_sl,   lmd_a2, Gm,     Gt,    Gs,
     &     cff_dn, Ritop,   lmd_a3, Kv_bl,  Kt_bl, Ks_bl
 
# include "grid.h"
# include "ocean3d.h"
# include "forces.h"
# include "mixing.h"
# include "scalars.h"
# define tind nstp
 
      real lmd_nubl, lmd_cs, lmd_Cv, Ric, lmd_betaT, lmd_epsilon,
     &             lmd_cekman, lmd_cmonob, lmd_Cstar, lmd_Cg, eps
      parameter (
     &   lmd_nubl=0.01,    ! Maximum allowed boundary layer
                           ! viscosity and diffusivity [m^2/s].
 
     &   lmd_cs=98.96,     ! see parameter associated with turbulent
                           !     velocity scales in lmd_wscale.F
 
     &   lmd_Cv=1.8,       ! Ratio of interior Brunt-Vaisala
                           !     frequency "N" to that at the
                           !           entrainment depth "he".
 
     &   Ric=0.3,          ! Critical bulk Richardson number.
 
     &   lmd_betaT=-0.2,   ! Ratio of entrainment flux to
                           !       to surface buoyancy flux.
 
     &   lmd_epsilon=0.1,  ! Nondimensional extent of the
                           !                surface layer.
 
     &   lmd_cekman=0.7,   ! Constant used in the computation
                           !           of Ekman depth.
 
     &   lmd_cmonob=1.,    ! Constant used in the computaion
                           ! Monin-Obukhov depth.
 
     &   lmd_Cstar=10.,    ! Proportionality coefficient
                           ! parameterizing nonlocal transport.
     &   eps=1.E-20)
 
      lmd_Cg=lmd_Cstar*vonKar*(lmd_cs*vonKar*lmd_epsilon)**(1./3.)
!
!  The first call: compute constant part of the velocity scale of
!  turbulent velocty shear "Vt". This one is to be reatained for
!  the further use. Also initialize relevant arrays.
!
      if (iic.eq.ntstart) then
        do j=jstr,jend
          do i=istr,iend
            Bfsfc(i,j)=0.
            stable(i,j)=1.
            ustar(i,j)=0.
          enddo
        enddo
      endif
!-
      Vtc=lmd_Cv*sqrt(-lmd_betaT)/( sqrt(lmd_cs*lmd_epsilon)
     &                               *Ric*vonKar*vonKar )
!
!  Get approximation of surface layer depth using "lmd_eps" and
!  boundary layer depth from previous time step sl_dpth=lmd_eps*hbl.
!  This will be used when averaging over the surface layer depth in
!  the bulk Richardson number calculations and in the determination
!  of the turbulent velocity scale.
!
       do j=jstr,jend
          do i=istr,iend
            sl_dpth(i,j)=lmd_epsilon*hbl(i,j)
          enddo
        enddo
 
!
!  Compute turbulent friction velocity [m/s] "ustar" from wind stress
!  at RHO-points.
!
      do j=jstr,jend
        do i=istr,iend
          ustar(i,j)=sqrt(sqrt( (0.5*(sustr(i,j)+sustr(i+1,j)))**2
     &                         +(0.5*(svstr(i,j)+svstr(i,j+1)))**2))
        enddo
      enddo
!
!  Compute thermal expansion coefficient "alpha" [kg/m^3/decC] and
!  saline contraction coefficient "beta" [kg/m^3/PSU] at the surface.
!
#define alpha wrk1
#define  beta wrk2
      call alfabeta_tile (istr,iend,jstr,jend, alpha,beta)
!
!  Compute surface turbulent buoyancy forcing "Bo" [m^2/s^3].
!  Remove incoming solar shortwave radiation because this
!  contribution is included in "Bosol".
!
!  Also compute surface radiative buoyancy forcing "Bosol" [m^2/s^3].
!
      do j=jstr,jend
        do i=istr,iend
          Bo(i,j)=g*( alpha(i,j)*(stflx(i,j,itemp)-srflx(i,j))
# ifdef SALINITY
     &                              -beta(i,j)*stflx(i,j,isalt)
# endif
     &                                                        )
          Bosol(i,j)=g*alpha(i,j)*srflx(i,j)
        enddo
      enddo  !--> discard alpha,beta; keep Bo,Bosol to the very end.
#undef beta
#undef alpha
!
!  Compute bulk Richardson number "Rib" and then find depth of the
!  oceanic planetary boundary layer "hbl", such that Rib(hbl)=Ric.
!--------------------------------------------------------------
!
!  Set indices for array "Rib", the bulk Richardson number.
!
      ka=1
      ku=2
!
!  Intialize boundary layer depth "hbl" and index "kbl" of first grid
!  level below "hbl" to maximum (bottomed out) values.
!
      do j=jstr,jend
        do i=istr,iend
          hbl(i,j)=-z_r(i,j,1)
          kbl(i,j)=1
          Rib(i,j,ka)=0.
        enddo
      enddo
!
!  Find bulk Richardson number at every grid level until > Ric.
!
      do k=N-1,2,-1
!
!  Compute fraction of the solar shortwave flux "swdk" penetrating
!  to grid level depth (at vertical RHO-points).
!
!  Then compute total surface buoyancy flux "Bfsfc" as the sum of
!  contributions from surface turbulent buoyancy forcing "Bo"
!  and radiative flux down to boundary layer depth [Bosol*(1-swdk)].
!
#define zgrid wrk1
#define swdk wrk2
        do j=jstr,jend
          do i=istr,iend
            zgrid(i,j)=z_r(i,j,k)
          enddo
        enddo
        call lmd_swfrac_tile (istr,iend,jstr,jend, 1.,zgrid,swdk)
        do j=jstr,jend
          do i=istr,iend
            Bfsfc(i,j)=Bo(i,j)+Bosol(i,j)*(1.-swdk(i,j))
            stable(i,j)=0.5+sign(0.5,Bfsfc(i,j))
          enddo
        enddo       !--> discard zgrid,swdk
#undef swdk
#undef zgrid
!
!  Get approximation of surface layer depth using "lmd_eps" and
!  boundary layer depth from previous time step sl_dpth=lmd_eps*hbl.
!  This will be used when averaging over the surface layer depth in
!  the bulk Richardson number calculations and in the determination
!  of the turbulent velocity scale.
!
!  Set stability switch "stable" to one in stable forcing and to zero
!  in unstable forcing. Compute nondimensional vertical coordinate
!  "sigma". Compute turbulent velocity scales (wm,ws) at "sigma".
!
#define sigma wrk1
#define wm wrk3
#define ws wrk2
        do j=jstr,jend
          do i=istr,iend
            z_sldf=z_r(i,j,k)+sl_dpth(i,j)
            in_sl=0.5+sign(0.5,z_sldf)
            sigma(i,j)=(-z_r(i,j,k))*stable(i,j)+
     &                 (-z_r(i,j,k))*(1.-stable(i,j))*in_sl+
     &                   sl_dpth(i,j)*(1.-stable(i,j))*(1.-in_sl)
          enddo
        enddo       !--> discard Bfsfc (will be recomputed later)
 
        call lmd_wscale_tile (istr,iend,jstr,jend, Bfsfc,
     &                                     sigma, wm, ws)
#undef sigma
#undef wm
!                                             !--> discard sigma
!  Compute bulk Richardson number "Rib"
!---------------------------------------
!
!                  [Br - B(d)] * d
!     Rib(d) = ----------------------- ;       Rib(hbl)=Ric
!              |Vr - V(d)|^2 + Vt(d)^2
!
!  To do so, first compute numerator of bluk Richardson number,
!  Ritop=(Br-B)*d, where Br is the near-surface reference buoyancy,
!  B is the mean buoyancy as function of d, and d is the distance
!  coordinate from the boundary.
!
!  Then compute the square of velocity shear relative to reference
!  velocities, dVsq=|Vr-V|^2, at horizontal and vertical RHO-points.
!
!  Then compute Vtsq= ????
!
        cff=g/rho0
        do j=jstr,jend
          do i=istr,iend
            Ritop=-cff*(rho1(i,j,N)-rho1(i,j,k))
     &                   *(z_r(i,j,N)-z_r(i,j,k))
 
            dVsq=0.25*( (u(i  ,j,N,tind)-u(i  ,j,k,tind)+
     &                   u(i+1,j,N,tind)-u(i+1,j,k,tind))**2
     &                 +(v(i,j  ,N,tind)-v(i,j  ,k,tind)+
     &                   v(i,j+1,N,tind)-v(i,j+1,k,tind))**2)
 
            Vtsq=Vtc*(-z_r(i,j,k))*ws(i,j)
     &              *sqrt(abs(0.5*(bvf(i,j,k)+bvf(i,j,k-1))))
 
            Rib(i,j,ku)=Ritop/(dVsq+Vtsq+eps)
          enddo
        enddo   !--> discard ws; wm was not used and will not be (?)
#undef ws
!
!  Linearly interpolate to find "hbl" where Rib=Ric.
!
        do j=jstr,jend
          do i=istr,iend
            if (kbl(i,j).eq.1 .and. Rib(i,j,ku).gt.Ric) then
              hbl(i,j)=-z_r(i,j,k+1)+(z_r(i,j,k+1)-z_r(i,j,k))*
     &               (Ric-Rib(i,j,ka))/(Rib(i,j,ku)-Rib(i,j,ka))
 
c              hbl(i,j)=-( z_r(i,j,k+1)*(Rib(i,j,ku)-Ric)
c                           +z_r(i,j,k)*(Ric-Rib(i,j,ka))
c                             )/(Rib(i,j,ku)-Rib(i,j,ka))
 
              kbl(i,j)=k
            endif
          enddo
        enddo
        ksave=ka
        ka=ku
        ku=ksave
      enddo    !<-- k    !--> discard Rr,Zr,Ur,Vr,Rib
!
!  Find stability and buoyancy forcing "Bfsfc" for boundary layer.
!  Insure that Bfsfc is never equal to zero
!
# define swdk_hbl wrk2
      do j=jstr,jend
        do i=istr,iend
          wrk1(i,j)=hbl(i,j)
        enddo
      enddo
      call lmd_swfrac_tile (istr,iend,jstr,jend, -1.,wrk1,swdk_hbl)
c      do i=istr,iend
c        print *,' at hbl swdk=',swdk_hbl(i,10)
c      enddo
      do j=jstr,jend
        do i=istr,iend
          Bfsfc(i,j)=Bo(i,j)+Bosol(i,j)*(1.-swdk_hbl(i,j))
          stable(i,j)=0.5+sign(0.5,Bfsfc(i,j))
        enddo
      enddo      !--> discard wrk1,swdk_hbl
# undef swdk_hbl
!
!  Compare "hbl" with physically limiting cases (Ekman depth
!  and Monin-Obukhov depth) and correct.
!
      do j=jstr,jend
        do i=istr,iend
          if (Bfsfc(i,j).gt.0.) then
            hekman=lmd_cekman*ustar(i,j)/max(abs(f(i,j)),eps)
            hmonob=lmd_cmonob*ustar(i,j)*ustar(i,j)*ustar(i,j)
     &                                    /(vonKar*Bfsfc(i,j))
 
            hlimit=stable(i,j)*min(hekman,hmonob)+
     &                             (stable(i,j)-1.)*z_r(i,j,1)
 
c**         hlimit=stable(i,j)*hekman+(stable(i,j)-1.)*z_r(i,j,1)
 
            hbl(i,j)=min(hbl(i,j),hlimit)
            hbl(i,j)=max(hbl(i,j),-z_w(i,j,N))
            hbl(i,j)=min(hbl(i,j),-z_w(i,j,1))
          endif
# ifdef MASKING
c          hbl(i,j)=max(10.,hbl(i,j))
          hbl(i,j)=hbl(i,j)*rmask(i,j)
# endif
          kbl(i,j)=1
        enddo
      enddo
!
!  Pad out values at the boundaries (NON-PERIODIC VERSIONS ONLY).
!
      if (WESTERN_EDGE) then
        do j=jstr,jend
          hbl(istr-1,j)=hbl(istr,j)
        enddo
      endif
      if (EASTERN_EDGE) then
        do j=jstr,jend
          hbl(iend+1,j)=hbl(iend,j)
        enddo
      endif
      if (SOUTHERN_EDGE) then
        do i=istr,iend
          hbl(i,jstr-1)=hbl(i,jstr)
        enddo
      endif
      if (NORTHERN_EDGE) then
        do i=istr,iend
          hbl(i,jend+1)=hbl(i,jend)
        enddo
      endif
      if (WESTERN_EDGE .and. SOUTHERN_EDGE) then
        hbl(istr-1,jstr-1)=hbl(istr,jstr)
      endif
      if (WESTERN_EDGE .and. NORTHERN_EDGE) then
        hbl(istr-1,jend+1)=hbl(istr,jend)
      endif
      if (EASTERN_EDGE .and. SOUTHERN_EDGE) then
        hbl(iend+1,jstr-1)=hbl(iend,jstr)
      endif
      if (EASTERN_EDGE .and. NORTHERN_EDGE) then
        hbl(iend+1,jend+1)=hbl(iend,jend)
      endif
!
!  Find new boundary layer index "kbl".
!
      do k=1,N-1
        do j=jstr,jend
          do i=istr,iend
            if (-z_r(i,j,k).gt.hbl(i,j)) then
              kbl(i,j)=k
            endif
          enddo
        enddo
      enddo
!
!  Find stability and buoyancy forcing for final "hbl" values.
!
# define swdk_hbl wrk2
      do j=jstr,jend
        do i=istr,iend
          wrk1(i,j)=hbl(i,j)
        enddo
      enddo
 
      call lmd_swfrac_tile (istr,iend,jstr,jend, -1.,wrk1,swdk_hbl)
 
      do j=jstr,jend
        do i=istr,iend
          Bfsfc(i,j)=Bo(i,j)+Bosol(i,j)*(1.-swdk_hbl(i,j))
# ifdef MASKING
          Bfsfc(i,j)=Bfsfc(i,j)*rmask(i,j)
# endif
          stable(i,j)=0.5+sign(0.5,Bfsfc(i,j))
        enddo
      enddo    !--> discard wrk1,swdk_hbl
# undef swdk_hbl
# ifdef LMD_NONLOCAL
!
!  Begin computing nonlocal transport function.
!
#  define zgrid wrk1
#  define swdk wrk2
      do k=1,N-1
        do j=jstr,jend
          do i=istr,iend
            zgrid(i,j)=z_w(i,j,k)
          enddo
        enddo
        call lmd_swfrac_tile (istr,iend,jstr,jend, 1.,zgrid,swdk)
        do j=jstr,jend
          do i=istr,iend
            ghats(i,j,k)=Bo(i,j)+Bosol(i,j)*(1.-swdk(i,j))
          enddo
        enddo
      enddo       !--> discard zgrid,swdk
#  undef swdk
#  undef zgrid
# endif /* LMD_NONLOCAL */
 
 
 
 
 
#define sigma wrk1
#define wm wrk3
#define ws wrk2
!
!  Compute tubulent velocity scales (wm,ws) at "hbl".
!
      do j=jstr,jend
        do i=istr,iend
          sigma(i,j)=hbl(i,j)*(stable(i,j)+lmd_epsilon*(1.-
     &                                         stable(i,j)))
        enddo  /* R8000: 2 clock cycles/iteration */
      enddo
      call lmd_wscale_tile (istr,iend,jstr,jend, Bfsfc,
     &                                   sigma, wm, ws)
      do j=jstr,jend
        do i=istr,iend
          f1(i,j)=stable(i,j)*5.*Bfsfc(i,j)*vonKar/( ustar(i,j)*
     &                     ustar(i,j)*ustar(i,j)*ustar(i,j)+eps)
        enddo
      enddo     /* R8000: 12 clock cycles/iteration */
#undef sigma
!
!  Compute nondimensional shape function Gx(sigma) in terms
!  of interior diffusivities at sigma=1 (Gm1, Gs1, Gt1) and
!  its vertical derivative at hbl.
!
      do j=jstr,jend
        do i=istr,iend
          if (kbl(i,j).lt.1 .or. kbl(i,j).gt.N-1) then
            write(*,*) 'KBL-?: i,j,k=',i,j,k
            may_day_flag=7
            return
          endif
        enddo
      enddo
 
      do j=jstr,jend
        do i=istr,iend
          k=kbl(i,j)
          cff=z_r(i,j,k+1)-z_r(i,j,k)
          cff_up=(-hbl(i,j)-z_r(i,j,k))
     &                      /(cff*(z_w(i,j,k+1)-z_w(i,j,k)))
          cff_dn=(z_r(i,j,k+1)+hbl(i,j))
     &                      /(cff*(z_w(i,j,k)-z_w(i,j,k-1)))
!
!      Compute nondimensional shape function for viscosity
!      "Gm1" and its vertical derivative "dGm1dS" evaluated
!      at "hbl" via interpolation.
!
          Kv_p=cff_up*max(0.,Kv(i,j,k+1)-Kv(i,j,k  ))
     &        +cff_dn*max(0.,Kv(i,j,k  )-Kv(i,j,k-1))
          Kv_h=Kv(i,j,k)+Kv_p*(-z_r(i,j,k)-hbl(i,j))
          Gm1(i,j)=Kv_h/(hbl(i,j)*wm(i,j)+eps)
# ifdef MASKING
     &                                       *rmask(i,j)
# endif
          dGm1dS(i,j)=min(0., Kv_h*f1(i,j)-Kv_p/(wm(i,j)+eps))
!
!      Compute nondimensional shape function for diffusion of
!      temperature "Gt1" and its vertical derivative "dGt1dS"
!      evaluated at "hbl" via interpolation.
!
          Kt_p=cff_up*max(0.,Kt(i,j,k+1)-Kt(i,j,k  ))
     &        +cff_dn*max(0.,Kt(i,j,k  )-Kt(i,j,k-1))
          Kt_h=Kt(i,j,k)+Kt_p*(-z_r(i,j,k)-hbl(i,j))
          Gt1(i,j)=Kt_h/(hbl(i,j)*ws(i,j)+eps)
# ifdef MASKING
     &                                       *rmask(i,j)
# endif
          dGt1dS(i,j)=min(0., Kt_h*f1(i,j)-Kt_p/(ws(i,j)+eps))
# ifdef SALINITY
!
!       Compute nondimensional shape function for diffusion of
!       salinity (Gs1) and its vertical derivative (dGs1dS)
!       evaluated at "hbl" via interpolation.
!
          Ks_p=cff_up*max(0.,Ks(i,j,k+1)-Ks(i,j,k  ))
     &        +cff_dn*max(0.,Ks(i,j,k  )-Ks(i,j,k-1))
          Ks_h=Ks(i,j,k)+Ks_p*(-z_r(i,j,k)-hbl(i,j))
          Gs1(i,j)=Ks_h/(hbl(i,j)*ws(i,j)+eps)
#  ifdef MASKING
     &                                        *rmask(i,j)
#  endif
          dGs1dS(i,j)=min(0., Ks_h*f1(i,j)-Ks_p/(ws(i,j)+eps))
# endif /* SALINITY */
        enddo
      enddo
#undef wm
#undef ws
!
!  Compute boundary layer mixing coefficients.
!----------------------------------------------------------
!  Compute turbulent velocity scales at vertical W-points.
!
#define sigma wrk1
#define wm wrk3
#define ws wrk2
 
      do k=1,N-1
       do j=jstr,jend
         do i=istr,iend
            sl_dnew=hbl(i,j)*lmd_epsilon
            z_sldf=z_w(i,j,k)+sl_dnew
            in_sl=0.5+sign(0.5,z_sldf)
            sigma(i,j)=(-z_w(i,j,k))*stable(i,j)
     &                +(-z_w(i,j,k))*(1.-stable(i,j))*in_sl
     &                +sl_dnew*(1.-stable(i,j))*(1.-in_sl)
          enddo   /* R8000: 7 cycles/iter, 57%(92%) of peak */
        enddo
        call lmd_wscale_tile (istr,iend,jstr,jend, Bfsfc,
     &                                     sigma, wm, ws)
!
!  Compute verical mixing coefficients
!
        do j=jstr,jend
          do i=istr,iend
            if (k.gt.kbl(i,j)) then
!
!  Set polynomial coefficients for shape function.
!
              sig=-z_w(i,j,k)/(hbl(i,j)+eps)
# ifdef MASKING
              sig=sig*rmask(i,j)
# endif
              lmd_a1=sig-2.
              lmd_a2=3.-2.*sig
              lmd_a3=sig-1.
!
!  Compute nondimesional shape functions.
!
              Gm=lmd_a1+lmd_a2*Gm1(i,j)+lmd_a3*dGm1dS(i,j)
              Gt=lmd_a1+lmd_a2*Gt1(i,j)+lmd_a3*dGt1dS(i,j)
# ifdef SALINITY
              Gs=lmd_a1+lmd_a2*Gs1(i,j)+lmd_a3*dGs1dS(i,j)
# endif
!
!  Compute boundary layer mixing coefficients, combine them
!  with interior mixing coefficients.
!
              Kv_bl=hbl(i,j)*wm(i,j)*sig*(1.+sig*Gm)
              Kt_bl=hbl(i,j)*ws(i,j)*sig*(1.+sig*Gt)
# ifdef SALINITY
              Ks_bl=hbl(i,j)*ws(i,j)*sig*(1.+sig*Gs)
# endif
              Kv(i,j,k)=min(lmd_nubl,Kv_bl)
              Kt(i,j,k)=min(lmd_nubl,Kt_bl)
# ifdef SALINITY
              Ks(i,j,k)=min(lmd_nubl,Ks_bl)
# endif
# ifdef LMD_NONLOCAL
!
!  Compute boundary layer nonlocal transport [m/s^2]
!
              ghats(i,j,k)=ghats(i,j,k)*lmd_Cg*(1.-stable(i,j))
     &                                  /(ws(i,j)*hbl(i,j)+eps)
            else
              ghats(i,j,k)=0.
# endif
            endif
          enddo    /* !!!! This loop was not pipelined */
        enddo
#undef ws
#undef wm
#undef sigma
!
!  Finalize: Set vertical mixing coefficients "Akv" and "Akt" using a
!  time  filter to avoid temporal instability of the implicit scheme.
!
        do j=jstr,jend
          do i=istr,iend
c           Akv(i,j,k)=at1*Kv(i,j,k)+at2*Akv(i,j,k)
            Akv(i,j,k)=Kv(i,j,k)
 
c           Akt(i,j,k,itemp)=at1*Kt(i,j,k)+at2*Akt(i,j,k,itemp)
            Akt(i,j,k,itemp)=Kt(i,j,k)
 
# ifdef SALINITY
c           Akt(i,j,k,isalt)=at1*Ks(i,j,k)+at2*Akt(i,j,k,isalt)
            Akt(i,j,k,isalt)=Ks(i,j,k)
# endif
 
# ifdef BIOLOGY
            do itrc=3,NT
              Akt(i,j,k,itrc)=Ks(i,j,k)
            enddo
# endif
          enddo
        enddo
      enddo
# if defined EW_PERIODIC || defined NS_PERIODIC || defined MPI
      call exchange_w3d_tile (istr,iend,jstr,jend, Akv)
      call exchange_w3d_tile (istr,iend,jstr,jend,
     &                     Akt(START_2D_ARRAY,0,itemp))
      call exchange_w3d_tile (istr,iend,jstr,jend,
     &                     Akt(START_2D_ARRAY,0,isalt))
# endif
#else
      subroutine lmd_kpp_empty
#endif /* LMD_KPP */
      return
      end
 
