! Auxiliary module "compute_tile_bounds.h":
!---------- ------ ------------------------
! Compute bounds designed to cover interior points of an array
! for shared memory subdomain partitioning (tiling.)
!
! input: tile -- usually from 0 to NSUB_X*NSUB_E-1 -- indicates
!                the specified subdomain;  tile=NSUB_X*NSUB_E
!                corresponds to the whole domain of RHO points
!                treated as a single block.
! outputs: istr,iend -- starting and ending indices of subdomain
!          jstr,jend    tile in XI- and ETA-directions.
!
      integer chunk_size_X,margin_X,chunk_size_E,margin_E
 
      parameter (chunk_size_X=(Lm+NSUB_X-1)/NSUB_X,
     &                     margin_X=(NSUB_X*chunk_size_X-Lm)/2,
     &           chunk_size_E=(Mm+NSUB_E-1)/NSUB_E,
     &                     margin_E=(NSUB_E*chunk_size_E-Mm)/2)
      integer istr,iend,jstr,jend, i_X,j_E
 
#ifdef ALLOW_SINGLE_BLOCK_MODE
C$    integer trd, omp_get_thread_num
      if (tile.eq.NSUB_X*NSUB_E) then
C$      trd=omp_get_thread_num()
C$      if (trd.gt.0) return  !--> return, if not master thread
        istr=1
        iend=Lm       ! MONOBLOCK VERSION:
        jstr=1        ! DO NOT DO THE PARTITION
        jend=Mm
      else
#endif
 
        j_E=tile/NSUB_X
        i_X=tile-j_E*NSUB_X
 
        istr=1+i_X*chunk_size_X-margin_X
        iend=istr+chunk_size_X-1
        istr=max(istr,1)
        iend=min(iend,Lm)
 
        jstr=1+j_E*chunk_size_E-margin_E
        jend=jstr+chunk_size_E-1
        jstr=max(jstr,1)
        jend=min(jend,Mm)
 
#ifdef ALLOW_SINGLE_BLOCK_MODE
      endif
#endif
 
