#include "cppdefs.h"
#ifdef ANA_INITIAL
 
      subroutine ana_initial (tile)
      implicit none
      integer tile
# include "param.h"
# include "compute_tile_bounds.h"
      call ana_initial_tile (istr,iend,jstr,jend)
      return
      end
 
      subroutine ana_initial_tile (istr,iend,jstr,jend)
!
! Set initial conditions for momentum and tracer variables using
!  analytical expressions.
!
      implicit none
      integer istr,iend,jstr,jend, i,j,k, itrc
      real fac, x,y, x0,y0, cff1,cff2,cff3
# include "param.h"
# include "grid.h"
# include "ocean2d.h"
# include "ocean3d.h"
# include "scalars.h"
!
# include "compute_auxiliary_bounds.h"
!
# ifdef EW_PERIODIC
#  define IR_RANGE istr,iend
#  define IU_RANGE istr,iend
# else
#  define IR_RANGE istrR,iendR
#  define IU_RANGE  istr,iendR
# endif
 
# ifdef NS_PERIODIC
#  define JR_RANGE jstr,jend
#  define JV_RANGE jstr,jend
# else
#  define JR_RANGE jstrR,jendR
#  define JV_RANGE  jstr,jendR
# endif
!
! Initial conditions for free surface and 2D momentum components.
!======== ========== === ==== ======= === == ======== ===========
!
# if defined SOLITON
      x0= 2.*xl/3.
      y0=el/2.
      cff1=0.395
      cff2=0.771*(cff1*cff1)
      do j=JR_RANGE
        do i=IR_RANGE
          x=xr(i,j)-x0
          y=yr(i,j)-y0
          cff3=exp(-cff1*x)
          fac=cff2*(2.*cff3/(1.+cff3*cff3))**2
          zeta(i,j,1)=0.25*fac*(6.*y*y+3.)*exp(-0.5*y*y)
        enddo
      enddo
      do j=JR_RANGE
        do i=IU_RANGE
          x=0.5*(xr(i-1,j)+xr(i,j))-x0
          y=0.5*(yr(i-1,j)+yr(i,j))-y0
          cff3=exp(-cff1*x)
          fac=cff2 * (2.*cff3/(1.+cff3*cff3))**2
          ubar(i,j,1)=0.25*fac*(6.*y*y-9.)*exp(-0.5*y*y)
        enddo
      enddo
      do j=JV_RANGE
        do i=IR_RANGE
          x=0.5*(xr(i,j-1)+xr(i,j))-x0
          y=0.5*(yr(i,j-1)+yr(i,j))-y0
          cff3=exp(-cff1*x)
          fac=cff2 * (2.*cff3/(1.+cff3*cff3))**2
          vbar(i,j,1)=2.*fac*y*(-2.*cff1*tanh(cff1*x))
     &                                  *exp(-0.5*y*y)
        enddo
      enddo
# else
      do j=JR_RANGE
        do i=IR_RANGE
          zeta(i,j,1)=0.
          ubar(i,j,1)=0.
          vbar(i,j,1)=0.
        enddo
      enddo
# endif
 
# if defined EW_PERIODIC || defined NS_PERIODIC || defined  MPI
      call exchange_r2d_tile (istr,iend,jstr,jend,
     &                        zeta(START_2D_ARRAY,1))
      call exchange_u2d_tile (istr,iend,jstr,jend,
     &                        ubar(START_2D_ARRAY,1))
      call exchange_v2d_tile (istr,iend,jstr,jend,
     &                        vbar(START_2D_ARRAY,1))
# endif
 
# ifdef SOLVE3D
!
! Initial conditions for momentum components [m/s].
!======== ========== === ======== ========== ======
!
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
            u(i,j,k,1)=0.
            u(i,j,k,2)=0.
            v(i,j,k,1)=0.
            v(i,j,k,2)=0.
          enddo
        enddo
      enddo
!
! Initial conditions for tracer type variables.
!======== ========== === ====== ==== ==========
!  Set initial conditions for potential temperature [degC] and
!  salinity [PSU].
!
#  ifdef BASIN
      cff1=(44.690/39.382)**2
      cff2=cff1*(rho0*800./g)*(5.0e-5/((42.689/44.690)**2))
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
            t(i,j,k,1,itemp)=cff2*exp(z_r(i,j,k)/800.)
     &                 *(0.6-0.4*tanh(z_r(i,j,k)/800.))
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
          enddo
        enddo
      enddo
#  elif defined CANYON_A
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
            t(i,j,k,1,itemp)=T0
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
          enddo
        enddo
      enddo
#  elif defined CANYON_B
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
            t(i,j,k,1,itemp)=3.488*exp(z_r(i,j,k)/800.)
     &        *(1.-0.666666666666*tanh(z_r(i,j,k)/800.))
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
          enddo
        enddo
      enddo
#  elif defined DAMEE_B
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
c            t(i,j,k,1,itemp)=0.2+6.*exp(z_r(i,j,k)/2500.)
c     &              +30./(1.+exp((-200.-z_r(i,j,k))/200.))
 
            t(i,j,k,1,itemp)=0.2+6.*exp(z_r(i,j,k)/2500.)
     &                    +20.*exp(z_r(i,j,k)/250.)
 
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
#   ifdef SALINITY
            t(i,j,k,1,isalt)=35.
            t(i,j,k,2,isalt)=35.
#   endif
          enddo
        enddo
      enddo
#  elif defined GRAV_ADJ
      do k=1,N
        do j=jstrR,jendR
          do i=istrR,min(L/2,iendR)  <-- incompatible with MPI
            t(i,j,k,1,itemp)=T0+5.
            t(i,j,k,2,itemp)=T0+5.
          enddo
          do i=max(L/2+1,istrR),iendR
            t(i,j,k,1,itemp)=T0
            t(i,j,k,2,itemp)=T0
          enddo
        enddo
      enddo
#  elif defined OVERFLOW
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
c           t(i,j,k,1,itemp)=T0-0.5*T0*(1.+tanh((yr(i,j)-25000.)
c     &                                                   /1000.))
 
            t(i,j,k,1,itemp)=T0*(0.5-0.5*tanh( yr(i,j)/1000.-25.))
 
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
          enddo
        enddo
      enddo
#  elif defined NJ_BIGHT
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
            if (z_r(i,j,k).ge.-15.0) then
              t(i,j,k,1,itemp)=2.049264257728403e+01-z_r(i,j,k)*(
     &                         2.640850848793918e-01+z_r(i,j,k)*(
     &                         2.751125328535212e-01+z_r(i,j,k)*(
     &                         9.207489761648872e-02+z_r(i,j,k)*(
     &                         1.449075725742839e-02+z_r(i,j,k)*(
     &                         1.078215685912076e-03+z_r(i,j,k)*(
     &                         3.240318053903974e-05+
     &                         1.262826857690271e-07*z_r(i,j,k)
     &                                                     ))))))
              t(i,j,k,1,isalt)=3.066489149193135e+01-z_r(i,j,k)*(
     &                         1.476725262946735e-01+z_r(i,j,k)*(
     &                         1.126455760313399e-01+z_r(i,j,k)*(
     &                         3.900923281871022e-02+z_r(i,j,k)*(
     &                         6.939014937447098e-03+z_r(i,j,k)*(
     &                         6.604436696792939e-04+z_r(i,j,k)*(
     &                         3.191792361954220e-05+
     &                         6.177352634409320e-07*z_r(i,j,k)
     &                                                     ))))))
            else
               t(i,j,k,1,itemp)=14.6+6.7 *tanh(1.1*z_r(i,j,k)+15.9)
               t(i,j,k,1,isalt)=31.3-0.55*tanh(1.1*z_r(i,j,k)+15.9)
            endif
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
            t(i,j,k,2,isalt)=t(i,j,k,1,isalt)
          enddo
        enddo
      enddo
#  elif defined SEAMOUNT
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
#   ifdef NONLIN_EOS
            t(i,j,k,1,itemp)=4.0  ! Just spatially uniform T,S to
            t(i,j,k,2,isalt)=33.0 ! illustrate compressibility effect.
#   else
!
! There are four possible choices here: exponential profile
! which can be initialized as either a set of values at locations
! z_r (to test prsgrd31,32,32A); or in finite volume sense (to test
! prsgrd40,41,42,44). Also there are two similar versions of linear
! profiles.
!
#define AMPL 3.
#define STRAT 500.
 
           t(i,j,k,1,itemp)=AMPL*exp(z_r(i,j,k)/STRAT)

        t(i,j,k,1,itemp)=AMPL*exp((z_r(i,j,k)-0.0003*yr(i,j))/STRAT)
 
c            t(i,j,k,1,itemp)=AMPL*STRAT*( exp(z_w(i,j,k)/STRAT)
c     &                                   -exp(z_w(i,j,k-1)/STRAT)
c     &                                )/(z_w(i,j,k)-z_w(i,j,k-1))
!
! Linear profile to check exact error cancellation.
!
 
c            t(i,j,k,1,itemp)=AMPL*(1.+z_r(i,j,k)/5000.)
 
c           t(i,j,k,1,itemp)=0.5*(z_w(i,j,k)+z_w(i,j,k-1))
 
c            t(i,j,k,1,itemp)=AMPL*(1.+0.5*(z_w(i,j,k)
c     &                            +z_w(i,j,k-1))/5000.)
 
#undef STRAT
#undef AMPL
 
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
#   endif
          enddo
        enddo
      enddo
#  elif defined SHELFRONT
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
            t(i,j,k,1,itemp)=T0+2.5*tanh((yr(i,j)-50000.0)/20000.0)
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
            t(i,j,k,1,isalt)=S0  +  tanh((yr(i,j)-50000.0)/20000.0)
            t(i,j,k,2,isalt)=t(i,j,k,1,isalt)
          enddo
        enddo
      enddo
#  elif defined TASMAN_SEA
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
            t(i,j,k,1,itemp)=17.4+z_r(i,j,k)*(1.727e-2+z_r(i,j,k)*
     &                           (5.707e-06+z_r(i,j,k)*(5.921e-10)))
            t(i,j,k,1,isalt)=35.08+z_r(i,j,k)*(7.56e-4+z_r(i,j,k)*
     &                           (3.185e-07+z_r(i,j,k)*(3.702e-11)))
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
            t(i,j,k,2,isalt)=t(i,j,k,1,isalt)
          enddo
        enddo
      enddo
#  elif defined UPWELLING
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
c            t(i,j,k,1,itemp)=14.+8.*exp(z_r(i,j,k)/50.)
 
#define Z0 (-35.)
#define THKNSS 6.5
#define Z1 (-75.)
#define STRAT 150.
 
c           t(i,j,k,1,itemp)=18.+4.*tanh((z_r(i,j,k)-Z0)/THKNSS)
c     &                                  +(z_r(i,j,k)-Z1)/STRAT
 
           t(i,j,k,1,itemp)=14.+4.*THKNSS*log(
     &                          cosh((z_w(i,j,k )-Z0)/THKNSS)
     &                         /cosh((z_w(i,j,k-1)-Z0)/THKNSS)
     &                             )/(z_w(i,j,k)-z_w(i,j,k-1))
     &               +((z_w(i,j,k)+z_w(i,j,k-1))/2.-Z1)/STRAT
 
#undef Z0
#undef THKNSS
#undef Z1
#undef STRAT
 
 
 
 
 
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
 
#   ifdef SALINITY
c*            t(i,j,k,1,isalt)=1.E-4*yr(i,j)-S0 +0.1
            t(i,j,k,1,isalt)=1.
 
            if (j.lt.Mm/2) then
              t(i,j,k,1,isalt)=0.
            elseif (j.eq.Mm/2) then
              t(i,j,k,1,isalt)=0.5
            elseif (j.gt.Mm/2) then
              t(i,j,k,1,isalt)=1.
            endif
 
            t(i,j,k,2,isalt)=t(i,j,k,1,isalt)
#   endif
          enddo
        enddo
      enddo
#  elif defined USWEST
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
c**         t(i,j,k,1,itemp)=10.+10.*exp(z_r(i,j,k)/200.)
c**         t(i,j,k,1,itemp)=20. + z_r(i,j,k)/4500.
c*          t(i,j,k,1,itemp)=4.+13.*exp(z_r(i,j,k)/450.)
 
 
c           t(i,j,k,1,itemp)=4.+13.*450.*( exp(z_w(i,j,k)/450.)
c     &                                   -exp(z_w(i,j,k-1)/450.))
c     &                                 /(z_w(i,j,k)-z_w(i,j,k-1))
 
 
#define Z0 (-80.)
#define THKNSS 50.
#define Z1 0.
#define STRAT 1000.
 
c*         t(i,j,k,1,itemp)=4.+4.*tanh((z_r(i,j,k)-Z0)/THKNSS)
c*     &                                  +(z_r(i,j,k)-Z1)/STRAT
 
           t(i,j,k,1,itemp)=14.+5.*THKNSS*log(
     &                            cosh((z_w(i,j,k )-Z0)/THKNSS)
     &                           /cosh((z_w(i,j,k-1)-Z0)/THKNSS)
     &                               )/(z_w(i,j,k)-z_w(i,j,k-1))
 
     &               +((z_w(i,j,k)+z_w(i,j,k-1))/2.-Z1)/STRAT
#undef Z0
#undef THKNSS
#undef Z1
#undef STRAT
 
            t(i,j,k,2,itemp)=t(i,j,k,1,itemp)
 
# ifdef SALINITY
            t(i,j,k,1,isalt)=35.
            t(i,j,k,2,isalt)=t(i,j,k,1,isalt)
# endif
# ifdef BIOLOGY
            t(i,j,k,1,ino3_)=0.
            t(i,j,k,2,ino3_)=t(i,j,k,1,ino3_)
            t(i,j,k,1,inh4_)=0.
            t(i,j,k,2,inh4_)=t(i,j,k,1,inh4_)
            t(i,j,k,1,idet_)=0.
            t(i,j,k,2,idet_)=t(i,j,k,1,idet_)
            t(i,j,k,1,iphyt)=0.
            t(i,j,k,2,iphyt)=t(i,j,k,1,iphyt)
            t(i,j,k,1,izoo_)=0.
            t(i,j,k,2,izoo_)=t(i,j,k,1,izoo_)
# endif
          enddo
        enddo
      enddo
#  else
      do k=1,N
        do j=JR_RANGE
          do i=IR_RANGE
            t(i,j,k,1,itemp)=???
            t(i,j,k,2,itemp)=???
            t(i,j,k,1,isalt)=???
            t(i,j,k,2,isalt)=???
          enddo
        enddo
      enddo
#  endif
 
#  if defined EW_PERIODIC || defined NS_PERIODIC || defined  MPI
      call exchange_u3d_tile (istr,iend,jstr,jend,
     &                         u(START_2D_ARRAY,1,1))
      call exchange_v3d_tile (istr,iend,jstr,jend,
     &                         v(START_2D_ARRAY,1,1))
      do itrc=1,NT
        call exchange_r3d_tile (istr,iend,jstr,jend,
     &                   t(START_2D_ARRAY,1,1,itrc))
      enddo
#  endif
# endif /* SOLVE3D */
# undef IR_RANGE
# undef IU_RANGE
# undef JR_RANGE
# undef JV_RANGE
      return
      end
 
#else
      subroutine ana_initial_empty
      return
      end
#endif /* ANA_INITIAL */
 
