#include "cppdefs.h"
 
      subroutine zetabc_tile (istr,iend,jstr,jend, zeta_new)
!
! Set boundary conditions for free surface zeta_new
!
      implicit none
      integer istr,iend,jstr,jend, i,j
      real zeta_new(PRIVATE_2D_SCRATCH_ARRAY),
     &                     cff,cx,dft,dfx, eps
      parameter (eps=1.D-20)
#include "param.h"
#include "grid.h"
#include "ocean2d.h"
#include "scalars.h"
#include "climat.h"
!
#include "compute_auxiliary_bounds.h"
 
#ifndef EW_PERIODIC
!
!====================================================================
!                            WESTERN BC
!====================================================================
      if (WESTERN_EDGE) then
# if defined OBC_WEST && defined OBC_Z2ORLANSKI
        do j=jstrV-1,jend                             ! Western edge
          dft=zeta(istr,j,kstp)-zeta_new(istr,j)      ! Radiation BC
          dfx=zeta_new(istr,j)-zeta_new(istr+1,j)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          cx=dft*dfx
          cff=max(dfx*dfx, eps)
 
          zeta_new(istr-1,j)=( cff*zeta(istr-1,j,kstp)
     &                  +cx*zeta_new(istr,j) )/(cff+cx)
#  ifdef MASKING
     &                                 *rmask(istr-1,j)
#  endif
        enddo
# elif defined OBC_WEST && defined OBC_M2FLATHER
        do j=jstrV-1,jend                              ! Chapman BC
          cx=dtfast*pm(1,j)*sqrt(g*h(1,j))             ! ======= ==
          zeta_new(istr-1,j) =( zeta(istr-1,j,kstp)
     &                    +cx*zeta_new(istr,j))/(1.+cx)
#  ifdef MASKING
     &                                 *rmask(istr-1,j)
#  endif
        enddo
# else
        do j=jstrV-1,jend                              ! Western edge
          zeta_new(istr-1,j)=zeta_new(istr,j)          ! gradient BC
#  ifdef MASKING
     &                        *rmask(istr-1,j)
#  endif
        enddo
# endif
      endif
!
!====================================================================
!                            EASTERN BC
!====================================================================
      if (EASTERN_EDGE) then
#  if defined OBC_EAST && defined OBC_Z2ORLANSKI
        do j=jstrV-1,jend                             ! Eastern edge
          dft=zeta(iend,j,kstp)-zeta_new(iend,j)      ! Radiation BC
          dfx=zeta_new(iend,j)-zeta_new(iend-1,j)
 
          if (dfx*dft .lt. 0.) dft=0.     ! <--  SUPPRESS INFLOW
 
          cx=dft*dfx
          cff=max(dfx*dfx, eps)
 
          zeta_new(iend+1,j)=( cff*zeta(iend+1,j,kstp)
     &                  +cx*zeta_new(iend,j) )/(cff+cx)
#  ifdef MASKING
     &                                 *rmask(iend+1,j)
#  endif
        enddo
# elif defined OBC_EAST && defined OBC_M2FLATHER
        do j=jstrV-1,jend
          cx=dtfast*pm(iend,j)*sqrt(g*h(iend,j))      ! Eastern edge
          zeta_new(iend+1,j)=( zeta(iend+1,j,kstp)    ! Chapman BC
     &               +cx*zeta_new(iend,j))/(1.+cx)
#  ifdef MASKING
     &                            *rmask(iend+1,j)
#  endif
        enddo
#  else
        do j=jstrV-1,jend                             ! Eastern edge
          zeta_new(iend+1,j)=zeta_new(iend,j)         ! gradient BC
#  ifdef MASKING
     &                        *rmask(iend+1,j)
#  endif
        enddo
# endif
      endif
#endif        /* !EW_PERIODIC */
 
#ifndef NS_PERIODIC
!
!====================================================================
!                            SOUTHERN BC
!====================================================================
      if (SOUTHERN_EDGE) then
# if defined OBC_SOUTH && defined OBC_M2FLATHER
        do i=istrU-1,iend
          cx=dtfast*pn(i,jstr)*sqrt(g*h(i,jstr))     ! Southern edge
          zeta_new(i,jstr-1)=( zeta(i,jstr-1,kstp)   ! Chapman BC
     &              +cx*zeta_new(i,jstr) )/(1.+cx)
#  ifdef MASKING
     &                            *rmask(i,jstr-1)
#  endif
        enddo
#  else
        do i=istrU-1,iend                            ! Southern edge
          zeta_new(i,jstr-1)=zeta_new(i,jstr)        ! gradient BC
#  ifdef MASKING
     &                       *rmask(i,jstr-1)
#  endif
        enddo
# endif  /* OBC_SOUTH */
      endif
!
!====================================================================
!                            NORTHERN BC
!====================================================================
!
      if (NORTHERN_EDGE) then
# if defined OBC_NORTH && defined OBC_M2FLATHER
        do i=istrU-1,iend
          cx=dtfast*pn(i,jend)*sqrt(g*h(i,jend))    ! Northern edge
          zeta_new(i,jend+1)=( zeta(i,jend+1,kstp)  ! Chapman BC
     &              +cx*zeta_new(i,jend) )/(1.+cx)
#  ifdef MASKING
     &                            *rmask(i,jend+1)
#  endif
        enddo
# else
        do i=istrU-1,iend                           ! Northern edge
          zeta_new(i,jend+1)=zeta_new(i,jend)       ! gradient BC
#  ifdef MASKING
     &                       *rmask(i,jend+1)
#  endif
        enddo
# endif   /* OBC_NORTH */
      endif
#endif       /* !NS_PERIODIC */
!
!====================================================================
!                   CORNERS (between open boundaries)
!====================================================================
!
#ifndef EW_PERIODIC
# ifndef NS_PERIODIC
      if (SOUTHERN_EDGE .and.
     &    WESTERN_EDGE) then
        zeta_new(istr-1,jstr-1)=0.5*( zeta_new(istr  ,jstr-1)
     &                               +zeta_new(istr-1,jstr  ))
      endif
      if (SOUTHERN_EDGE .and.
     &    EASTERN_EDGE) then
        zeta_new(iend+1,jstr-1)=0.5*( zeta_new(iend  ,jstr-1)
     &                               +zeta_new(iend+1,jstr  ))
      endif
      if (NORTHERN_EDGE .and.
     &    WESTERN_EDGE) then
        zeta_new(istr-1,jend+1)=0.5*( zeta_new(istr  ,jend+1)
     &                               +zeta_new(istr-1,jend  ))
      endif
      if (NORTHERN_EDGE .and.
     &    EASTERN_EDGE) then
        zeta_new(iend+1,jend+1)=0.5*( zeta_new(iend  ,jend+1)
     &                               +zeta_new(iend+1,jend  ))
      endif
# endif
#endif
      return
      end
 
