#include "cppdefs.h"
#ifdef SOLVE3D
 
#undef MIX_GP_UV
#define MIX_S_UV
 
      subroutine visc3d (tile)
      implicit none
      integer tile
# include "param.h"
# include "private_scratch.h"
# include "compute_tile_bounds.h"
      call visc3d_tile (istr,iend,jstr,jend,  A2d(1,1), A2d(1,2),
     &                                        A2d(1,3), A2d(1,4))
      return
      end
 
      subroutine visc3d_tile (istr,iend,jstr,jend, UFx,VFe, UFe,VFx)
!
! Compute lateral mixing terms for XI-component momentum equation.
!
      implicit none
# include "param.h"
      integer istr,iend,jstr,jend, i,j,k,indx
      real UFx(PRIVATE_2D_SCRATCH_ARRAY),
     &     UFe(PRIVATE_2D_SCRATCH_ARRAY), cff,
     &     VFx(PRIVATE_2D_SCRATCH_ARRAY),
     &     VFe(PRIVATE_2D_SCRATCH_ARRAY)
 
# include "grid.h"
# include "ocean3d.h"
# include "coupling.h"
# include "mixing.h"
# include "scalars.h"
!
# include "compute_auxiliary_bounds.h"
!
      indx=3-nstp    !--> time index for target arrays;
#define nnew illegal
 
# ifdef MIX_S_UV
#  ifdef UV_VIS2
!
! Compute horizontal Laplacian viscosity along constant S-surfaces.
!------------------------------------------------------------------
! Compute horizontal viscous U-component momentum fluxes in XI- and
! ETA-directions, then apply them to compute harmonic viscous term.
!
      do k=1,N
        do j=jstrV-1,jend
          do i=istrU-1,iend
            cff=2.*Hz(i,j,k)*visc2_r(i,j)
            UFx(i,j)=cff*(u(i+1,j,k,nstp)-u(i,j,k,nstp))
     &                                 *pm(i,j)*dn_r(i,j)
            VFe(i,j)=cff*(v(i,j+1,k,nstp)-v(i,j,k,nstp))
     &                                 *pn(i,j)*dm_r(i,j)
          enddo
        enddo
        do j=jstr,jend+1
          do i=istr,iend+1
            cff=0.0625*visc2_p(i,j)*( Hz(i,j,k)+Hz(i-1,j,k)
     &                               +Hz(i,j-1,k)+Hz(i-1,j-1,k))
     &              *( (pn(i,j)+pn(i-1,j)+pn(i,j-1)+pn(i-1,j-1))
     &                          *(u(i,j,k,nstp)-u(i,j-1,k,nstp))
     &                +(pm(i,j)+pm(i-1,j)+pm(i,j-1)+pm(i-1,j-1))
     &                          *(v(i,j,k,nstp)-v(i-1,j,k,nstp))
     &                                                         )
#   ifdef MASKING
     &                                         *pmask(i,j)
#   endif
            UFe(i,j)=cff*dm_p(i,j)
            VFx(i,j)=cff*dn_p(i,j)
          enddo
        enddo
 
        do j=jstr,jend
          do i=istrU,iend
            cff=0.25*(pm(i,j)+pm(i-1,j))*(pn(i,j)+pn(i-1,j))
     &             *(UFx(i,j)-UFx(i-1,j)+UFe(i,j+1)-UFe(i,j))
            rufrc(i,j)=rufrc(i,j)+cff
            u(i,j,k,indx)=u(i,j,k,indx)+cff*dt
          enddo
        enddo
 
        do j=jstrV,jend
          do i=istr,iend
            cff=0.25*(pm(i,j)+pm(i,j-1))*(pn(i,j)+pn(i,j-1))
     &             *(VFx(i+1,j)-VFx(i,j)+VFe(i,j)-VFe(i,j-1))
            rvfrc(i,j)=rvfrc(i,j)+cff
            v(i,j,k,indx)=v(i,j,k,indx)+cff*dt
          enddo
        enddo
      enddo
#  endif /* UV_VIS2 */
# endif /* MIX_S_UV */
 
# ifdef MIX_GP_UV
#  ifdef UV_VIS2
!
!  Compute/add_in horizontal Laplacian viscosity along rotated
!  surfaces.
!-------------------------------------------------------------------
!  Compute d(u)/d(z) at horizontal U-points and vertical W-points.
!
      do j=jstr-1,jend+1
        do k=1,N-1
          do i=istrU-1,iend+1
            UFs(i,j,k)=(u(i,j,k+1,nstp)-u(i,j,k,nstp))/
     &                       (0.5*(z_r(i-1,j,k+1)-z_r(i-1,j,k)+
     &                            z_r(i  ,j,k+1)-z_r(i  ,j,k)))
          enddo
        enddo
        do i=istrU-1,iend+1
          UFs(i,j,0)=0.
          UFs(i,j,N)=0.
        enddo
      enddo

      do k=N,1,-1
!
! Compute contribution of the to ETA-component viscous U-fluxes.
!-------------------------------------------------------------------
! Average d(u)/d(z) to vertical RHO-points [1/s]. Notice that
! vertical K-loop is reversed to allow recursive use of 3D work
! array "UFs".
!
        do j=jstr-1,jend+1
          do i=istrU-1,iend+1
            dUdz(i,j)=0.5*(UFs(i,j,k)+UFs(i,j,k-1))
          enddo
        enddo
!
! Compute slope (nondimensional) due mixing along geopotential
! surfaces; if applicable, add in slope due to mixing along
! isopycnal surfaces and apply land/sea mask.
!
        do j=jstr,jend
          do i=istrU-1,iend+1
            Slope(i,j)=0.5*(pm(i,j)+pm(i-1,j))*
     &                    (z_r(i,j,k)-z_r(i-1,j,k))
#   ifdef MIX_EN_UV
            Slope(i,j)=Slope(i,j)+rhosx(i,j,k)
#   endif
#   ifdef MASKING
            Slope(i,j)=Slope(i,j)*umask(i,j)
#   endif
          enddo
!
! Compute flux along along S-surfaces and subtract slope due to
! rotated surfaces, [m^2/s^2]. Save XI-component of the vertical
! flux into work array "wrk".
!
          do i=istrU-1,iend
            cff=pm(i,j)*(u(i+1,j,k,nstp)-u(i,j,k,nstp))
            cff=visc2_r(i,j)*( cff-0.25*(Slope(i,j)+Slope(i+1,j))
     &                                  *(dUdz(i,j)+dUdz(i+1,j)) )
            wrk(i,j)=cff*0.5*(Slope(i,j)+Slope(i+1,j))
            UFx(i,j)=cff*Hz(i,j,k)/pn(i,j)
          enddo
!
! Add in divergence contribution of the XI-component LapU-fluxes.
! Also average XI-component of the vertical flux to horizontal
! U-points and load it back into work array "UFs".
!
          cff=0.25*dt
          do i=istrU,iend
            u(i,j,k,indx)=u(i,j,k,indx)+cff*(pm(i,j)+pm(i-1,j))
     &                                     *(pn(i,j)+pn(i-1,j))
     &                                   *(UFx(i,j)-UFx(i-1,j))
 
            UFs(i,j,k)=0.5*(wrk(i,j)+wrk(i-1,j))
          enddo
        enddo
!
! Compute contribution of the to ETA-component viscous U-fluxes.
!--------------------------------------------------------------------
! Compute slope (nondimensional) due mixing along geopotential
! surfaces; if applicable, add in slope due to mixing along
! isopycnal surfaces and apply land/sea mask.
!
        do j=jstr,jend+1
          do i=istrU-1,iend
            Slope(i,j)=0.5*(pn(i,j)+pn(i,j-1))*
     &                    (z_r(i,j,k)-z_r(i,j-1,k))
#   ifdef MIX_EN_UV
            Slope(i,j)=Slope(i,j)+rhose(i,j,k)
#   endif
#   ifdef MASKING
            Slope(i,j)=Slope(i,j)*vmask(i,j)
#   endif
          enddo
!
! Compute flux along along S-surfaces and subtract slope due
! to rotated surfaces, [m^2/s^2]. Add in ETA-component of the
! vertical flux into work array "wrk".
!
          do i=istrU,iend
            cff=0.25*(pn(i,j)+pn(i,j-1)+pn(i-1,j)+pn(i-1,j-1))
     &                           *(u(i,j,k,nstp)-u(i,j-1,k,nstp))
#   ifdef MASKING
     &                                                 *pmask(i,j)
#   endif
            cff=visc2_p(i,j)*( cff-0.25*(Slope(i-1,j)+Slope(i,j))
     &                                   *(dUdz(i,j)+dUdz(i,j-1)))
            wrk(i,j)=cff*0.5*(Slope(i-1,j)+Slope(i,j))
            UFe(i,j)=cff*(Hz(i,j  ,k)+Hz(i-1,j  ,k)+
     &                    Hz(i,j-1,k)+Hz(i-1,j-1,k))/
     &                   (pm(i,j)+pm(i,j-1)+pm(i-1,j)+pm(i-1,j-1))
          enddo
        enddo
!
! Compute and add in horizontal divergence (along S-surfaces) of the
! flux [m^4/s^2] in the ETA-direction. Average ETA-component of the
! vertical flux to horizontal U-points and add it to array "UFs".
!
        cff=dt*0.25
        do j=jstr,jend
          do i=istrU,iend
            u(i,j,k,indx)=u(i,j,k,indx)+cff*(pm(i,j)+pm(i-1,j))
     &                                     *(pn(i,j)+pn(i-1,j))
     &                                   *(UFe(i,j+1)-UFe(i,j))
 
            UFs(i,j,k)=UFs(i,j,k)+0.5*(wrk(i,j)+wrk(i,j+1))
          enddo
        enddo
      enddo
!
!  Average vertical flux to vertical W-points. Apply no flux boundary
!  conditions. After that apply the vertical divergence of the flux
!  [m^4/s^2] due to sloping S-surfaces.
 
!
      do j=jstr,jend
        do k=1,N-1
          do i=istrU,iend
            UFz(i,k)=0.5*(UFs(i,j,k)+UFs(i,j,k+1))
          enddo
        enddo
        do i=istrU,iend
          UFz(i,0)=0.
          UFz(i,N)=0.
        enddo
        do k=1,N
          do i=istrU,iend
            u(i,j,k,indx)=u(i,j,k,indx)-dt*(UFz(i,k)-UFz(i,k-1))
          enddo
        enddo
      enddo
#  endif /* UV_VIS2 */
# endif
      return
      end
#else
      subroutine u3dmix_empty
      end
#endif /* SOLVE3D */
 
