#include "cppdefs.h"
#ifdef SOLVE3D
 
      subroutine v3dbc_tile (istr,iend,jstr,jend, grad)
!
! Set lateral boundary conditions for ETA-component velocity
! v(:,:,:,nnew)
!
      implicit none
      integer istr,iend,jstr,jend, i,j,k
      real grad(PRIVATE_2D_SCRATCH_ARRAY), cff,eps,
     &                          cx,cy, dft,dfx,dfy
      parameter (eps=1.E-20)
# include "param.h"
# include "grid.h"
# include "ocean3d.h"
# include "scalars.h"
!
#include "compute_auxiliary_bounds.h"
!
# ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
#  ifdef OBC_SOUTH
#   ifdef OBC_M3ORLANSKI
!                                         Southern edge radiation BC
        do k=1,N                      !   ======== ==== ========= ==
          do i=istr,iend+1
            grad(i,1)=(v(i,1,k,nstp)-v(i-1,1,k,nstp))
            grad(i,2)=(v(i,2,k,nstp)-v(i-1,2,k,nstp))
          enddo
          do i=istr,iend
            dft=v(i,2,k,nstp)-v(i,2,k,nnew)
            dfx=v(i,2,k,nstp)-v(i,3,k,nstp)
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(i,2)+grad(i+1,2) .gt. 0.) then
              dfy=grad(i,2)
            else
              dfy=grad(i+1,2)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            v(i,1,k,nnew)=( (1.-cx)*v(i,1,k,nstp)+cx*v(i,2,k,nstp)
     &                                      -max(cy,0.)*grad(i  ,1)
     &                                      -min(cy,0.)*grad(i+1,1)
     &                                                            )
#    ifdef MASKING
            v(i,1,k,nnew)=v(i,1,k,nnew)*vmask(i,1)
#    endif
          enddo
        enddo
#   else
        do k=1,N                         !  Southern edge gradient BC
          do i=istr,iend                 !  ======== ==== ======== ==
            v(i,1,k,nnew)=v(i,2,k,nnew)
#    ifdef MASKING
     &                      *vmask(i,1)
#    endif
          enddo
        enddo
#   endif
#  else
        do k=1,N                           !  Southern edge closed BC
          do i=istr,iend                   !  ======== ==== ====== ==
            v(i,1,k,nnew)=0.
          enddo
        enddo
#  endif              /* OBC_SOUTH */
      endif         !<-- SOUTHERN_EDGE
 
      if (NORTHERN_EDGE) then
#  ifdef OBC_NORTH
#   ifdef OBC_M3ORLANSKI
!                                          Northern edge radiation BC
        do k=1,N                        !  ======== ==== ========= ==
          do i=istr,iend+1
            grad(i,Mm)=(v(i,Mm,k,nstp)-v(i-1,Mm,k,nstp))
            grad(i,Mm+1)=(v(i,Mm+1,k,nstp)-v(i-1,Mm+1,k,nstp))
          enddo
          do i=istr,iend
            dft=v(i,Mm,k,nstp)-v(i,Mm,k,nnew)
            dfx=v(i,Mm,k,nstp)-v(i,Mm-1,k,nstp)
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(i,Mm)+grad(i+1,Mm)) .gt. 0.) then
              dfy=grad(i,Mm)
            else
              dfy=grad(i+1,Mm)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            v(i,Mm+1,k,nnew)=( (1.-cx)*v(i,Mm+1,k,nstp)
     &                                         +cx*v(i,Mm,k,nstp)
     &                                    -max(cy,0.)*grad(i  ,Mm+1)
     &                                    -min(cy,0.)*grad(i+1,Mm+1)
     &                                                             )
#    ifdef MASKING
            v(i,Mm+1,k,nnew)=v(i,Mm+1,k,nnew)*vmask(i,Mm+1)
#    endif
          enddo
        enddo
#   else
        do k=1,N                          ! Northern edge gradient BC
          do i=istr,iend                  ! ======== ==== ======== ==
            v(i,Mm+1,k,nnew)=v(i,Mm,k,nnew)
#    ifdef MASKING
     &                       *vmask(i,Mm+1)
#    endif
          enddo
        enddo
#   endif
#  else
        do k=1,N                           !  Northern edge closed BC
          do i=istr,iend                   !  ======== ==== ====== ==
            v(i,Mm+1,k,nnew)=0.
          enddo
        enddo
#  endif
      endif     !<--  NORTHERN_EDGE
# endif          /* !NS_PERIODIC */
 
# ifndef EW_PERIODIC
      if (WESTERN_EDGE) then
#  ifdef OBC_WEST
#   ifdef OBC_M3ORLANSKI
!                                           Western edge radiation BC
        do k=1,N                          ! ======= ==== ========= ==
          do j=jstrV-1,jend
            grad(0,j)=(v(0,j+1,k,nstp)-v(0,j,k,nstp))
            grad(1,j)=(v(1,j+1,k,nstp)-v(1,j,k,nstp))
          enddo
          do j=jstrV,jend
            dft=v(1,j,k,nstp)-v(1,j,k,nnew)
            dfx=v(1,j,k,nstp)-v(2,j,k,nstp)
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(1,j-1)+grad(1,j)) .gt. 0.) then
              dfy=grad(1,j-1)
            else
              dfy=grad(1,j  )
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            v(0,j,k,nnew)=( (1.-cx)*v(0,j,k,nstp)+cx*v(1,j,k,nstp)
     &                                      -max(cy,0.)*grad(0,j-1)
     &                                      -min(cy,0.)*grad(0,j  )
     &                                                            )
#    ifdef MASKING
            v(0,j,k,nnew)=v(0,j,k,nnew)*vmask(0,j)
#    endif
          enddo
        enddo
#   else
        do k=1,N                           ! Western edge gradient BC
          do j=jstrV,jend                  ! ======= ==== ======== ==
            v(0,j,k,nnew)=v(1,j,k,nnew)
#    ifdef MASKING
     &                      *vmask(0,j)
#    endif
          enddo
        enddo
#   endif
#  else
#   ifdef NS_PERIODIC
#    define J_RANGE jstrV,jend
#   else
#    define J_RANGE jstr,jendR
#   endif                          ! Closed BC: free-slip (gamma2=+1)
        do k=1,N                   ! ====== ===   no-slip (gamma2=-1)
          do j=J_RANGE
            v(0,j,k,nnew)=gamma2*v(1,j,k,nnew)
#   ifdef MASKING
     &                             *vmask(0,j)
#   endif
          enddo
        enddo
    undef J_RANGE
#  endif
      endif        !<-- WESTERN_EDGE
 
      if (EASTERN_EDGE) then
#  ifdef OBC_EAST
#   ifdef OBC_M3ORLANSKI
                                          ! Eastern edge radiation BC
        do k=1,N                          ! ======= ==== ========= ==
          do j=jstrV-1,jend
            grad(Lm,j)=(v(Lm,j+1,k,nstp)-v(Lm,j,k,nstp))
            grad(Lm+1,j)=(v(Lm+1,j+1,k,nstp)-v(Lm+1,j,k,nstp))
          enddo
          do j=jstrV,jend
            dft=v(Lm,j,k,nstp)-v(Lm,j,k,nnew)
            dfx=v(Lm,j,k,nstp)-v(Lm-1,j,k,nstp)
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(Lm,j-1)+grad(Lm,j)) .gt. 0.) then
              dfy=grad(Lm,j-1)
            else
              dfy=grad(Lm,j  )
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            v(Lm+1,j,k,nnew)=( (1.-cx)*v(Lm+1,j,k,nstp)
     &                                         +cx*v(Lm,j,k,nstp)
     &                                    -max(cy,0.)*grad(Lm+1,j-1)
     &                                    -min(cy,0.)*grad(Lm+1,j  )
     &                                                             )
#    ifdef MASKING
            v(Lm+1,j,k,nnew)=v(Lm+1,j,k,nnew)*vmask(Lm+1,j)
#    endif
          enddo
        enddo
#   else                                  !  Eastern edge gradient BC
        do k=1,N                          !  ======= ==== ======== ==
          do j=jstrV,jend
            v(Lm+1,j,k,nnew)=v(Lm,j,k,nnew)
#    ifdef MASKING
     &                       *vmask(Lm+1,j)
#    endif
          enddo
        enddo
#   endif
#  else
#   ifdef NS_PERIODIC
#    define J_RANGE jstrV,jend
#   else
#    define J_RANGE jstr,jendR
#   endif                          ! Closed BC: free-slip (gamma2=+1)
        do k=1,N                   ! ====== ===   no-slip (gamma2=-1)
          do j=J_RANGE
            v(Lm+1,j,k,nnew)=gamma2*v(Lm,j,k,nnew)
#   ifdef MASKING
     &                              *vmask(Lm+1,j)
#   endif
          enddo
        enddo
#   undef J_RANGE
#  endif
      endif     !<-- EASTERN_EDGE
# endif          /* !EW_PERIODIC */
!                                   Corners (except periodic), if any
!                                   ======= ======= ========== == ===
# if defined OBC_SOUTH && defined OBC_WEST
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          v(0,1,k,nnew)=0.5*(v(0,2,k,nnew)+v(1,1,k,nnew))
        enddo
      endif
# endif
# if defined OBC_SOUTH && defined OBC_EAST
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          v(Lm+1,1,k,nnew)=0.5*(v(Lm+1,2,k,nnew)+v(Lm,1,k,nnew))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_WEST
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          v(0,Mm+1,k,nnew)=0.5*(v(0,Mm,k,nnew)+v(1,Mm+1,k,nnew))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_EAST
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          v(Lm+1,Mm+1,k,nnew)=0.5*(v(Lm+1,Mm  ,k,nnew)
     &                            +v(Lm  ,Mm+1,k,nnew))
        enddo
      endif
# endif
#else
      subroutine v3dbc_empty
#endif /* SOLVE3D */
      return
      end
 
