#include "cppdefs.h"
#ifdef SOLVE3D
 
      subroutine t3dbc_tile (istr,iend,jstr,jend, itrc, grad)
!
! Set lateral boundary conditions for tracer field t(:,:,:,indx,itrc)
!
      implicit none
      integer istr,iend,jstr,jend,  itrc, i,j,k
      real grad(PRIVATE_2D_SCRATCH_ARRAY), eps, cff,
     &                    cx,cy, dft, dfx, dfy,dfyB
      parameter (eps=1.E-20)
# include "param.h"
# include "grid.h"
# include "ocean3d.h"
# include "climat.h"
# include "scalars.h"
!
# include "compute_auxiliary_bounds.h"
!
# ifndef EW_PERIODIC
      if (WESTERN_EDGE) then
#  if defined OBC_WEST && defined OBC_TORLANSKI
!
!                                           Western edge radiation BC
        do k=1,N                          ! ======= ==== ========= ==
          do j=jstr,jend+1
            grad(0,j)=(t(0,j,k,nstp,itrc)-t(0,j-1,k,nstp,itrc))
#   ifdef MASKING
     &                                              *vmask(0,j)
#   endif
            grad(1,j)=(t(1,j,k,nstp,itrc)-t(1,j-1,k,nstp,itrc))
#   ifdef MASKING
     &                                              *vmask(1,j)
#   endif
          enddo
          do j=jstr,jend
            dft=t(1,j,k,nstp,itrc)-t(1,j,k,nnew,itrc)        ! -dT/dt
            dfx=t(1,j,k,nstp,itrc)-t(2,j,k,nstp,itrc)        ! -dT/dx
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(1,j)+grad(1,j+1)) .gt. 0.) then
              dfy=grad(1,j)
            else
              dfy=grad(1,j+1)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            t(0,j,k,nnew,itrc)=( (1.-cx)*t(0,j,k,nstp,itrc)
     &                                 +cx*t(1,j,k,nstp,itrc )
     &                                  -max(cy,0.)*grad(0,j  )
     &                                  -min(cy,0.)*grad(0,j+1)
     &                                                       )
#   ifdef MASKING
     &                                      *rmask(0,j)
#   endif
          enddo
        enddo
#  else                                    ! Western edge gradient BC
        do k=1,N                           ! ======= ==== ======== ==
          do j=jstr,jend
            t(0,j,k,nnew,itrc)=t(1,j,k,nnew,itrc)
#   ifdef MASKING
     &                                *rmask(0,j)
#   endif
          enddo
        enddo
#  endif
      endif     ! <-- WESTERN_EDGE
 
      if (EASTERN_EDGE) then
#  if defined OBC_EAST && defined OBC_TORLANSKI
!
!                                        !  Eastern edge radiation BC
        do k=1,N                         !  ======= ==== ========= ==
          do j=jstr,jend+1
           grad(Lm,j)=(t(Lm,j,k,nstp,itrc)-t(Lm,j-1,k,nstp,itrc))
#   ifdef MASKING
     &                                                *vmask(Lm,j)
#   endif
           grad(Lm+1,j)=(t(Lm+1,j,k,nstp,itrc)
     &                                   -t(Lm+1,j-1,k,nstp,itrc))
#   ifdef MASKING
     &                                              *vmask(Lm+1,j)
#   endif
          enddo
          do j=jstr,jend
            dft=t(Lm,j,k,nstp,itrc)-t(Lm,j,k,nnew,itrc)      ! -dT/dt
            dfx=t(Lm,j,k,nstp,itrc)-t(Lm-1,j,k,nstp,itrc)    ! +dT/dx
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(Lm,j)+grad(Lm,j+1)) .gt. 0.) then
              dfy=grad(Lm,j)
            else
              dfy=grad(Lm,j+1)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            t(Lm+1,j,k,nnew,itrc)=( (1.-cx)*t(Lm+1,j,k,nstp,itrc)
     &                                      +cx*t(Lm,j,k,nstp,itrc)
     &                                    -max(cy,0.)*grad(Lm+1,j  )
     &                                    -min(cy,0.)*grad(Lm+1,j+1)
     &                                                            )
#   ifdef MASKING
     &                                         *rmask(Lm+1,j)
#   endif
          enddo
        enddo
#  else                                    ! Eastern edge gradient BC
        do k=1,N                           ! ======= ==== ======== ==
          do j=jstr,jend
            t(Lm+1,j,k,nnew,itrc)=t(Lm,j,k,nnew,itrc)
#   ifdef MASKING
     &                                 *rmask(Lm+1,j)
#   endif
          enddo
        enddo
#  endif
      endif    ! <-- EASTERN_EDGE
# endif        /* !EW_PERIODIC */
 
# ifndef NS_PERIODIC
      if (SOUTHERN_EDGE) then
#  if defined OBC_SOUTH && defined OBC_TORLANSKI
!
!                                       !  Southern edge radiation BC
        do k=1,N                        !  ======== ==== ========= ==
          do i=istr,iend+1
            grad(i,1)=(t(i,1,k,nstp,itrc)-t(i-1,1,k,nstp,itrc))
#   ifdef MASKING
     &                                              *umask(i,1)
#   endif
            grad(i,0)=(t(i,0,k,nstp,itrc)-t(i-1,0,k,nstp,itrc))
#   ifdef MASKING
     &                                              *umask(i,0)
#   endif
          enddo
          do i=istr,iend
            dft=t(i,1,k,nstp,itrc)-t(i,1,k,nnew,itrc)        ! -dT/dt
            dfx=t(i,1,k,nstp,itrc)-t(i,2,k,nstp,itrc)        ! -dT/dx
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(i,1)+grad(i+1,1)) .gt. 0.) then
              dfy=grad(i,1)
            else
              dfy=grad(i+1,1)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            t(i,0,k,nnew,itrc)=( (1.-cx)*t(i,0,k,nstp,itrc)
     &                                 +cx*t(i,1,k,nstp,itrc )
     &                                  -max(cy,0.)*grad(i  ,0)
     &                                  -min(cy,0.)*grad(i+1,0)
     &                                                       )
#   ifdef MASKING
     &                                      *rmask(i,0)
#   endif
          enddo
        enddo
#  else                                  !  Southern edge gradient BC
        do k=1,N                         !  ======== ==== ======== ==
          do i=istr,iend
            t(i,0,k,nnew,itrc)=t(i,1,k,nnew,itrc)
#   ifdef MASKING
     &                                *rmask(i,0)
#   endif
          enddo
        enddo
#  endif
      endif    ! <-- SOUTHERN_EDGE
 
      if (NORTHERN_EDGE) then
#  if defined OBC_NORTH && defined OBC_TORLANSKI
!
!                                        ! Northern edge radiation BC
        do k=1,N                         ! ======== ==== ========= ==
          do i=istr,iend+1
            grad(i,Mm)=(t(i,Mm,k,nstp,itrc)-t(i-1,Mm,k,nstp,itrc))
#   ifdef MASKING
     &                                                 *umask(i,Mm)
#   endif
            grad(i,Mm+1)=(t(i,Mm+1,k,nstp,itrc)
     &                                    -t(i-1,Mm+1,k,nstp,itrc))
#   ifdef MASKING
     &                                               *umask(i,Mm+1)
#   endif
          enddo
          do i=istr,iend
            dft=t(i,Mm,k,nstp,itrc)-t(i,Mm,k,nnew,itrc)      ! -dT/dt
            dfx=t(i,Mm,k,nstp,itrc)-t(i,Mm-1,k,nstp,itrc)    ! +dT/dx
 
            if (dfx*dft .lt. 0.) dft=0.   ! <--  SUPPRESS INFLOW
 
            if (dft*(grad(i,Mm)+grad(i+1,Mm)) .gt. 0.) then
              dfy=grad(i,Mm)
            else
              dfy=grad(i+1,Mm)
            endif
 
            cff=dft/max(dfx*dfx+dfy*dfy, eps)
            cx=min(1.,cff*dfx)
            cy=min(1.,max(cff*dfy,-1.))
 
            t(i,Mm+1,k,nnew,itrc)=( (1.-cx)*t(i,Mm+1,k,nstp,itrc)
     &                                     +cx*t(i,Mm  ,k,nstp,itrc)
     &                                      -max(cy,0)*grad(i  ,Mm+1)
     &                                      -min(cy,0)*grad(i+1,Mm+1)
     &                                                             )
#   ifdef MASKING
     &                                         *rmask(i,Mm+1)
#   endif
          enddo
        enddo
#  else                                   ! Northern edge gradient BC
        do k=1,N                          ! ======== ==== ======== ==
          do i=istr,iend
            t(i,Mm+1,k,nnew,itrc)=t(i,Mm,k,nnew,itrc)
#   ifdef MASKING
     &                                 *rmask(i,Mm+1)
#   endif
          enddo
        enddo
#  endif
      endif
# endif /* ! NS_PERIODIC */

                           ! Corners between adjacent open boundaries
                           ! ======= ======= ======== ==== ==========

# if defined OBC_SOUTH && defined OBC_WEST
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          t(istr-1,jstr-1,k,nnew,itrc)=0.5*( t(istr,jstr-1,k,nnew,
     &                           itrc)+t(istr-1,jstr,k,nnew,itrc))
        enddo
      endif
# endif
# if defined OBC_SOUTH && defined OBC_EAST
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          t(iend+1,jstr-1,k,nnew,itrc)=0.5*(t(iend,jstr-11,k,nnew,
     &                           itrc)+t(iend+1,jstr,k,nnew,itrc))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_WEST
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=1,N
          t(istr-1,jend+1,k,nnew,itrc)=0.5*( t(istr,jend+1,k,nnew,
     &                           itrc)+t(istr-1,jend,k,nnew,itrc))
        enddo
      endif
# endif
# if defined OBC_NORTH && defined OBC_EAST
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=1,N
          t(iend+1,jend+1,k,nnew,itrc)=0.5*( t(iend,jend+1,k,nnew,
     &                           itrc)+t(iend+1,jend,k,nnew,itrc))
        enddo
      endif
# endif
      return
      end
#else
      subroutine t3dbc_empty
      end
#endif /* SOLVE3D */
 
