#include "cppdefs.h"
#ifdef SMOLARKIEWICZ
      subroutine smol_ups (itrc,ta,ua,va,wa)
c
c====================================================================
c                                                                 ===
c  This subroutine computes a first-order upstream differencing   ===
c  operator for the 3D advection of a tracer (scalar) field. It   ===
c  is used when the Smolarkiewicz advection scheme is activated.  ===
c                                                                 ===
c  On Input:                                                      ===
c                                                                 ===
c     itrc      Tracer type array index.                          ===
c     ta        Tracer (scalar) field to advect.                  ===
c     ua        Advection velocity component in XI-direction.     ===
c     va        Advection velocity component in ETA-direction.    ===
c     wa        Advection S-coordinate vertical velocity.         ===
c                                                                 ===
c  On output:                                                     ===
c                                                                 ===
c     ta        Advected tracer field.                            ===
c                                                                 ===
c  Calls:  t3dbc                                                  ===
c                                                                 ===
c====================================================================
c
      implicit none
# include "param.h"
# include "grid.h"
# include "scalars.h"
# include "work.h"
c
      integer i, itrc, j, k
      real ta(0:L,0:M,N), ua(L,0:M,N), va(0:L,M,N), wa(0:L,0:M,0:N)
      real AFh(Lm,Mm,N), AFv(Lm,Mm,0:N), Feta(Lm,M), Fxi(L,Mm)
      equivalence (AFh,e3d), (AFv,f3d), (Feta,b2d), (Fxi,c2d)
c
c
      real a1, a2, a3, a4, av2, av4
      real AFLUX, b1, b2, b3
# include "avg.h"
      AFLUX(b1,b2,b3)=((b3+abs(b3))*b1+(b3-abs(b3))*b2)
c
c  Evaluate upwind horizontal advection of tracer.
c--------------------------------------------------------------------
c
      do k=1,N
c
c  Compute upwind advection flux of tracer in the XI-direction.
c
        do j=1,Mm
          do i=1,L
            a2d(i,j)=ua(i,j,k)*av2(Hz(i,j,k),Hz(i-1,j,k))/
     &                         av2(pn(i,j),pn(i-1,j))
          enddo
        enddo
        do j=1,Mm
          do i=1,L
            Fxi(i,j)=0.5*AFLUX(ta(i-1,j,k),ta(i,j,k),a2d(i,j))
          enddo
        enddo
# ifdef MASKING
        do j=1,Mm
          do i=1,L
            Fxi(i,j)=Fxi(i,j)*umask(i,j)
          enddo
        enddo
# endif /* MASKING */
c
c  Compute upwind advection flux of tracer in the ETA-direction.
c
        do j=1,M
          do i=1,Lm
            a2d(i,j)=va(i,j,k)*av2(Hz(i,j,k),Hz(i,j-1,k))/
     &                         av2(pm(i,j),pm(i,j-1))
          enddo
        enddo
        do j=1,M
          do i=1,Lm
            Feta(i,j)=0.5*AFLUX(ta(i,j-1,k),ta(i,j,k),a2d(i,j))
          enddo
        enddo
# ifdef MASKING
        do j=1,M
          do i=1,Lm
            Feta(i,j)=Feta(i,j)*vmask(i,j)
          enddo
        enddo
# endif /* MASKING */
c
c  Compute upwind horizontal advection of tracer.
c
        do j=1,Mm
          do i=1,Lm
            AFh(i,j,k)=ta(i,j,k)-dt*pm(i,j)*pn(i,j)*
     &                           ((Fxi (i+1,j  )-Fxi (i,j))+
     &                            (Feta(i  ,j+1)-Feta(i,j)))/Hz(i,j,k)
          enddo
        enddo
      enddo
c
c  Evaluate upwind vertical advection of tracer.
c--------------------------------------------------------------------
c
c  Compute upwind vertical advection flux of tracer.
c
      do k=1,Nm
        do j=1,Mm
          do i=1,Lm
            a2d(i,j)=wa(i,j,k)/(pm(i,j)*pn(i,j))
          enddo
        enddo
        do j=1,Mm
          do i=1,Lm
            AFv(i,j,k)=0.5*AFLUX(ta(i,j,k),ta(i,j,k+1),a2d(i,j))
          enddo
        enddo
      enddo
      do j=1,Mm
        do i=1,Lm
          AFv(i,j,0)=0.
          AFv(i,j,N)=0.
        enddo
      enddo
c
c  Compute and add in upwind vertical advection of tracer.  Update "ta"
c  with new advected values.
c
      do k=1,N
        do j=1,Mm
          do i=1,Lm
            ta(i,j,k)=AFh(i,j,k)-dt*pm(i,j)*pn(i,j)*
     &                           (AFv(i,j,k)-AFv(i,j,k-1))*ods/Hz(i,j,k)
          enddo
        enddo
      enddo
# ifdef MASKING
c
c  Apply Land/Sea masking.
c
      do k=1,N
        do j=0,M
          do i=0,L
            ta(i,j,k)=ta(i,j,k)*rmask(i,j)
          enddo
        enddo
      enddo
# endif /* MASKING */
c
c  Set boundary conditions.
c
      call t3dbc (ta,itrc,ibcTa)
#else
      subroutine smol_ups
#endif /* SMOLARKIEWICZ */
      return
      end
 
