#include "cppdefs.h"
#ifdef SOLVE3D
                                    ! Define S-coordinate system:
      subroutine set_scoord         ! input:  theta_s, theta_b, hc
                                    ! output: sc_w(0:N),  Cs_w(0:N)
      implicit none                 !         sc_r(1:N),  Cs_r(1:N)
# include "param.h"
# include "scalars.h"
      integer k
      real cff,cff1,cff2
 
      if (hc.le.hmin) then          ! Setup vertical S-Curves at  W-
        cff=1./float(N)             ! and RHO-points, -1 < sc,Cs < 0,
        cff1=1./sinh(theta_s)       ! then report information about
        cff2=0.5/tanh(0.5*theta_s)  ! vertical S-levels over three
                                    ! representative depths: minumal,
        sc_w(N)=0.                  ! maximum and half-way over slope
        Cs_w(N)=0.
        do k=N-1,1,-1
          sc_w(k)=cff*float(k-N)
          Cs_w(k)=(1.-theta_b)*cff1*sinh(theta_s*sc_w(k))
     &               +theta_b*(cff2*tanh(theta_s*(sc_w(k)+0.5))-0.5)
        enddo
        sc_w(0)=-1.
        Cs_w(0)=-1.
 
        do k=1,N
          sc_r(k)=cff*(float(k-N)-0.5)
          Cs_r(k)=(1.-theta_b)*cff1*sinh(theta_s*sc_r(k))
     &               +theta_b*(cff2*tanh(theta_s*(sc_r(k)+0.5))-0.5)
        enddo
 
        MPI_master_only write(stdout,'(/1x,A/,/1x,A,10x,A/)')
     &                         'Vertical S-coordinate System:',
     &                         'level   S-coord     Cs-curve',
     &                         'at_hc  over_slope     at_hmax'
        do k=N,0,-1
          cff=sc_w(k)*hc
          cff1=cff+0.5*(hmax+hc)*Cs_w(k)
          cff2=cff  +  (hmax-hc)*Cs_w(k)
          MPI_master_only write(stdout,'(I6,2F12.7,4x,3F12.3)')
     &                        k, sc_w(k),Cs_w(k), cff,cff1,cff2
        enddo
      else
        write(stdout,'(/1x,2A,F7.2/8x,A,F7.2/)') 'ERROR: ',
     &    'Specified S-coordinate critical depth   hc   =',  hc,
     &    'exceeds minimum unmasked topography.    hmin =',  hmin
        may_day_flag=8
      endif
      return
      end
#else
      subroutine set_scoord_empty
      end
#endif /* SOLVE3D */
 
