#include "cppdefs.h"
#if !defined GRID_LEVEL || GRID_LEVEL == 1
 
!!    program main             ! Open MP version of ROMS main with
      implicit none            ! single parallel region and using
      integer ierr             ! explicit barrier synchronization.
# ifdef MPI
#  include "mpif.h"
#  include "param.h"
#  include "scalars.h"
      real*8 tstart,tend
      call MPI_Init (ierr)
      call MPI_Setup (ierr)
      tstart=MPI_Wtime()
c**   call MPI_Test
      if (ierr.eq.0) then
# endif
        call init_scalars (ierr)     ! Initialize global scalars,
        if (ierr.eq.0) then          ! model tunable paparameters,
C$OMP PARALLEL                       ! fast-time averaging weights
          call roms_thread           ! for barotropic mode, and
C$OMP END PARALLEL                   ! launch the model in OpenMP
        endif                        ! parallel regime.
# ifdef MPI
      endif
      call MPI_Barrier(MPI_COMM_WORLD, ierr)
      tend=MPI_Wtime()
      MPI_master_only write(*,*) 'run_time =', tend-tstart
      call MPI_Finalize (ierr)
# endif
      stop
      end
 
      subroutine roms_thread
      implicit none
      integer trd, tile, my_first, my_last, range, ierr, my_iic
C$    integer omp_get_thread_num, omp_get_num_threads
# include "param.h"
# include "scalars.h"
!
! Find how many threads are requested and check that number of
! tiles is divisible by requested number of threads (this takes
! place inside start_timers), hence job can be evenly partitioned,
! complain and quit, if something goes wrong.
!
      ierr=0
      numthreads=1
C$    numthreads=omp_get_num_threads()
      trd=0
C$    trd=omp_get_thread_num()         ! Note: here proc(1) plays
      proc(1)=0                        ! role of a trigger variable
      proc(2)=trd                      ! inside start_timers() 
      call start_timers (ierr)         ! start timers for each thread
      if (ierr.eq.0) then
        call roms_init
        if (may_day_flag.ne.0) goto 99
        do my_iic=ntstart,ntimes+1
          call roms_step
          if (may_day_flag.ne.0) goto 99
        enddo
  99    call stop_timers()             ! SHUTDOWN: stop timers
C$OMP BARRIER
C$OMP MASTER
      call closecdf                    ! and close netCDF files
C$OMP END MASTER
      endif
      return
      end
#endif
 
 
 
      subroutine roms_init
      implicit none
      integer trd, tile, my_first, my_last, range
C$    integer omp_get_thread_num, omp_get_num_threads
#include "param.h"
#include "scalars.h"
#include "ncscrum.h"
 
      numthreads=1
C$    numthreads=omp_get_num_threads()
      trd=0
C$    trd=omp_get_thread_num()
      proc(2)=trd
 
      iic=0                     ! WARNING: This code is written
      kstp=1                    ! under assumption that the scalars
      knew=1                    ! on the left -- numthreads, iic,
#ifdef SOLVE3D
      iif=1                     ! kstp, knew, iif, nstp, nnew --
      nstp=1                    ! belong to a  THREADPRIVATE common
      nrhs=1                    ! block, so there no false sharing
      nnew=1                    ! here.
      nnew=1
#endif
      range=(NSUB_X*NSUB_E+numthreads-1)/numthreads
      my_first=trd*range
      my_last=min(my_first + range-1, NSUB_X*NSUB_E-1)
#define my_tile_range my_first,my_last
 
      do tile=my_tile_range      ! Initialize (FIRST-TOUCH) model
        call init_arrays (tile)  ! global arrays (most of them are
      enddo                      ! just set to to zero).
C$OMP BARRIER
 
c--#define CR
CR      write(*,*) '-11' MYID
 
 
#ifdef ANA_GRID
      do tile=my_tile_range       ! Set horizontal curvilinear grid
        call ana_grid (tile)      ! and model bathymetry (analyticaly
      enddo                       ! or read from GRID netCDF file).
C$OMP BARRIER
#else
C$OMP MASTER
      call get_grid
C$OMP END MASTER
C$OMP BARRIER
      if (may_day_flag.ne.0) goto 99 !-->  EXIT
#endif
      do tile=my_tile_range          ! Compute various metric terms
        call setup_grid1 (tile)      ! and their combinations.
      enddo
C$OMP BARRIER
CR      write(*,*) '-10' MYID
      do tile=my_tile_range
        call setup_grid2 (tile)
      enddo
C$OMP BARRIER
CR      write(*,*) '-9' MYID
 
#ifdef SOLVE3D
C$OMP MASTER
      call set_scoord               !  Set up vertical S-coordinates
C$OMP END MASTER
C$OMP BARRIER
      if (may_day_flag.ne.0) goto 99
#endif
CR      write(*,*) ' -8' MYID
 
#if defined VIS_GRID || defined DIF_GRID
      do tile=my_tile_range          ! Rescale horizontal mixing
        call visc_rescale (tile)     ! coefficients according to
      enddo                          ! local grid size.
C$OMP BARRIER
CR      write(*,*) ' -7' MYID
#endif
#ifdef SOLVE3D
      do tile=my_tile_range      ! Create three-dimensional S-coor-
        call set_depth (tile)    ! dinate system, which may be neded
      enddo                      ! ana_initial it is assumed here
C$OMP BARRIER
      do tile=my_tile_range        ! that surface zeta=0 is at rest
        call grid_stiffness (tile) ! state.) Also find extremal values
      enddo                        ! for topographic slopes rx0, rx1.
C$OMP BARRIER
CR      write(*,*) ' -6' MYID
#endif
 
#ifdef ANA_INITIAL
      if (nrrec.eq.0) then         ! Set initial conditions for model
        do tile=my_tile_range      ! variables analytically or read
          call ana_initial (tile)  ! from initial netCDF file.
        enddo
      else
#endif
C$OMP MASTER
        call get_initial           ! Read initial conditions file
C$OMP END MASTER
#ifdef ANA_INITIAL
      endif
#endif
C$OMP BARRIER
      if (may_day_flag.ne.0) goto 99      !--> ERROR
CR      write(*,*) ' -5' MYID
                              ! Set initial model clock: at this
      time=start_time         ! moment "start_time" (global scalar)
      tdays=time*sec2day      ! is set by get_initial or analytically
                              ! --> copy it into threadprivate "time"
#ifdef SOLVE3D
      do tile=my_tile_range       ! Re-compute three-dimensional S-
        call set_depth (tile)     ! coordinate system: at this moment
      enddo                       ! free surface has non-zero status
C$OMP BARRIER
CR      write(*,*)  ' -4' MYID
      do tile=my_tile_range
        call set_HUV (tile)
      enddo
C$OMP BARRIER
CR      write(*,*)  ' -3' MYID
 
      do tile=my_tile_range
        call omega (tile)
        call rho_eos (tile)
      enddo
C$OMP BARRIER
CR      write(*,*)  ' -2' MYID
#endif
!
! Set up climatological environment: Set nudging coefficient for
!==== == ============== ============ sea-surface hight and tracer
! climatology; create analytical tracer and sea-surface hight
! climatology fields (if applicable); set bottom sediment grain
! size [m] and density [kg/m^3] used for bottom boundary layer
! formulation;
!
#if defined TNUDGING || defined ZNUDGING \
  || (defined SG_BBL96 && defined ANA_BSEDIM)\
  || (defined TCLIMATOLOGY && defined ANA_TCLIMA)\
  || (defined ZNUDGING && defined ANA_SSH)
 
      do tile=my_tile_range
# if defined TNUDGING || defined ZNUDGING
        call set_nudgcof (tile)
# endif
# if defined TCLIMATOLOGY && defined ANA_TCLIMA
        call ana_tclima (tile)
# endif
# if defined ZNUDGING && defined ANA_SSH
        call ana_ssh (tile)
# endif
# if defined SG_BBL96 && defined ANA_BSEDIM
        call ana_bsedim (tile)
# endif
      enddo
C$OMP BARRIER
#endif
CR      write(*,*) ' -1' MYID
!
! Read initial input data for forcing fields; tracer and sea surface
! climatology; bottom sediment grain size and density (if applicable)
! from input netCDF files. Recall that CPP-logic here is mutually
! exclussive with respect to cals ana_tclima, ana_ssh, and ana_bsedim
! just above.
!
C$OMP MASTER
        if (ldefhis .and. wrthis(indxTime)) call wrt_his
#ifdef STATIONS
        if (nstation.gt.0) def_station
#endif
C$OMP END MASTER
C$OMP BARRIER
CR      write(*,*) '  0' MYID
      if (may_day_flag.ne.0) goto 99     !-->  EXIT
C$OMP MASTER
        MPI_master_only write(stdout,'(/1x,A/)')
     &               'MAIN: started time-steping.'
C$OMP END MASTER
c--#undef CR
      iic=ntstart-1
      next_kstp=kstp
!
! Initialize child-grid model, if any. Note that this call
! introduces recursive sequence, since child-grid model may
! also have child on its own.
!
#ifdef GRID_LEVEL
# if GRID_LEVEL < MAX_GRID_LEVEL
#  if GRID_LEVEL == 1
        call roms_init_2
#  elif GRID_LEVEL == 2
        call roms_init_3
#  elif GRID_LEVEL == 3
        call roms_init_4
#  endif
# endif
#endif
  99  return
      end
 
!
!          *****   ********   *****   ******  ********
!         **   **  *  **  *  *   **   **   ** *  **  *
!         **          **    **   **   **   **    **
!          *****      **    **   **   **   *     **
!              **     **    *******   *****      **
!         **   **     **    **   **   **  **     **
!          *****      **    **   **   **   **    **
!
 
 
      subroutine roms_step
      implicit none
      integer trd, tile, my_first, my_last, range, iter
#include "param.h"
#include "scalars.h"
#include "ncscrum.h"
 
      trd=proc(2)
      range=(NSUB_X*NSUB_E+numthreads-1)/numthreads
      my_first=trd*range
      my_last=min(my_first + range-1, NSUB_X*NSUB_E-1)

                                 ! increment time index anc clock
      iic=iic+1 
      time=start_time+dt*float(iic-ntstart)
      tdays=time*sec2day
#ifdef SOLVE3D
      nstp=1+mod(iic-ntstart,2)
      nrhs=nstp
      nnew=3
#endif
      if (synchro_flag) then
C$OMP MASTER
        call get_forces               ! Read forcing/climatology data
C$OMP END MASTER
C$OMP BARRIER
C$OMP MASTER
        synchro_flag=.false.
C$OMP END MASTER
        if (may_day_flag.ne.0) goto 99  !-->  EXIT
      endif
 
#ifdef SOLVE3D
      do tile=my_tile_range             ! Interpolate forcing data
        call set_forces (tile)          ! to model time and compute
        call    rho_eos (tile)          ! surface fluxes.
        call    set_HUV (tile)
        call       diag (tile)
#ifdef BIOLOGY
        call   bio_diag (tile)
#endif
      enddo
C$OMP BARRIER
      if (may_day_flag.ne.0) go to 99  !-->  EXIT
 
 
      do tile=my_tile_range
# if defined ANA_VMIX
        call ana_vmix (tile)
# elif defined LMD_MIXING
        call lmd_vmix (tile)
c        call lmd_kmix (tile)
# elif defined BVF_MIXING
        call bvf_mix (tile)
# endif
        call omega (tile)
      enddo
C$OMP BARRIER
 
      do tile=my_tile_range
        call     prsgrd (tile)
        call      rhs3d (tile)
        call pre_step3d (tile)
c**# if defined UV_VIS2 || defined UV_VIS4
c**        call     visc3d (tile)
c**# endif
# ifdef AVERAGES
        call    set_avg (tile)
# endif
      enddo
C$OMP BARRIER
 
c**
c**
      do tile=my_tile_range
        call set_HUV1 (tile)
      enddo
C$OMP BARRIER
 
      nrhs=3
      nnew=3-nstp   !!! WARNING
 
      do tile=my_tile_range
        call omega (tile)
        call rho_eos (tile)
      enddo
C$OMP BARRIER
 
      do tile=my_tile_range  ! sensitive
        call     prsgrd (tile)
        call      rhs3d (tile)
        call step3d_uv1 (tile)
# if defined UV_VIS2 || defined UV_VIS4
        call     visc3d (tile)
# endif
      enddo
C$OMP BARRIER
c**
c**
 
#endif  /* SOLVE3D */
!
! Output block: write restart/history files.
!======= ====== ===== =============== ======
!
      if ( iic.gt.ntstart .and. ( mod(iic-1,nrst).eq.0
     &   .or. (mod(iic-1,nwrt).eq.0 .and. wrthis(indxTime))
#ifdef AVERAGES
     &.or. (mod(iic-ntsavg,navg).eq.0 .and. wrtavg(indxTime))
#endif
#ifdef STATIONS
     &   .or. (mod(iic-1,nsta).eq.0 .and. nstation.gt.0)
#endif
     &                                                  )) then
C$OMP MASTER
        if (mod(iic-1,nrst).eq.0) nrecrst=nrecrst+1
        if (mod(iic-1,nwrt).eq.0) nrechis=nrechis+1
#ifdef AVERAGES
        if (mod(iic-ntsavg,navg).eq.0) nrecavg=nrecavg+1
#endif
#ifdef STATIONS
        if (mod(iic-1,nsta).eq.0) nrecsta=nrecsta+1
#endif
        if (mod(iic-1,nrst).eq.0) call wrt_rst
        if (mod(iic-1,nwrt).eq.0 .and. wrthis(indxTime)) call wrt_his
#ifdef AVERAGES
        if (mod(iic-ntsavg,navg).eq.0 .and.
     &                                 wrtavg(indxTime)) call wrt_avg
#endif
#ifdef STATIONS
        if (mod(iic-1,nsta).eq.0 .and.nstation.gt.0) call wrt_station
#endif
C$OMP END MASTER
C$OMP BARRIER
        if (may_day_flag.ne.0) goto 99 !-->  EXIT
        if (iic.eq.ntimes+1) goto 99   !-->  DONE
      endif
!
! Solve the 2D primitive equations for the barotropic mode.
!------ --- -- --------- --------- --- --- ---------- -----
!
#ifdef SOLVE3D
      do iif=1,nfast
#endif
#define FORW_BAK
#ifdef FORW_BAK
        kstp=knew                   ! This might look a bit silly,
        knew=kstp+1                 ! since both branches of this
        if (knew.gt.4) knew=1       ! if statement are identical.
        if (mod(knew,2).eq.0) then  ! Nevertheless, it makes sense,
          do tile=my_tile_range     ! since mpc will reverse one of
# ifndef SOLVE3D
            call set_forces (tile)  ! these loops to make zig-zag
# endif
            call     step2d (tile)  ! tile-processing sequence.
          enddo
        else
          do tile=my_tile_range
# ifndef SOLVE3D
            call set_forces (tile)
# endif
            call     step2d (tile)
          enddo
        endif
C$OMP BARRIER
#else
        kstp=next_kstp
        knew=3
        do tile=my_tile_range
# ifndef SOLVE3D
          call set_forces (tile)
# endif
          call     step2d (tile)
        enddo
C$OMP BARRIER
        knew=3-kstp
        next_kstp=knew
        do tile=my_tile_range
           call step2d (tile)
        enddo
C$OMP BARRIER
#endif
#ifndef SOLVE3D
        if (may_day_flag.ne.0) goto 99 !-->  EXIT
#else
      enddo    ! <-- iif
 
 
c**       do tile=my_tile_range      ! This code segment is for
c**         call set_HUV1 (tile)     ! predictor-coupled version.
c**       enddo                      ! It is kept here for
c**  C$OMP BARRIER                   ! reference purposes only.
c** 
c**      nrhs=3
c**      nnew=3-nstp
c** 
c**      do tile=my_tile_range
c**        call omega (tile)
c**        call rho_eos (tile)
c**      enddo
c** C$OMP BARRIER
c**      do tile=my_tile_range
c**        call     prsgrd (tile)
c**        call      rhs3d (tile)
c**        call step3d_uv1 (tile)
c**      enddo
c** C$OMP BARRIER
 
                                   ! Continue solution of
      do tile=my_tile_range        ! the three-dimensional
        call step3d_uv2 (tile)     ! equations: finalize
      enddo                        ! time step for momenta
C$OMP BARRIER                      ! and tracers
      do tile=my_tile_range
        call omega (tile)
        call step3d_t (tile)
# if defined TS_DIF2 || defined TS_DIF4
        call t3dmix (tile)
# endif
      enddo
C$OMP BARRIER
#endif /* SOLVE3D */
 
#ifdef GRID_LEVEL
# if GRID_LEVEL < MAX_GRID_LEVEL
      do iter=1,3
#  if GRID_LEVEL == 1
        call roms_step_2
#  elif GRID_LEVEL == 2
        call roms_step_3
#  elif GRID_LEVEL == 3
        call roms_step_4
#  endif
      enddo
# endif
#endif
  99  return
      end
 
 
