/* Auxiliary module "compute_extended_bounds.h":
------------------------------------------------------
 Bounds designed to cover interior points of an array and
 ghost points associated with PHYSICAL side boundaries AND
 also ghost points of internal computational boundaries of
 MPI-subdomains.    */
 
#ifdef istrR
# undef istrR
#endif
#ifdef iendR
# undef iendR
#endif
#ifdef jstrR
# undef jstrR
#endif
#ifdef jendR
# undef jendR
#endif
      integer istrR,iendR,jstrR,jendR
      if (istr.eq.1) then
# ifdef EW_PERIODIC
        istrR=istr-2
# else
#  ifdef MPI
        if (WEST_INTER) then
          istrR=istr-2
        else
          istrR=istr-1
        endif
#  else
        istrR=istr-1
#  endif
# endif
      else
        istrR=istr
      endif
 
      if (iend.eq.Lm) then
# ifdef EW_PERIODIC
        iendR=iend+2
# else
#  ifdef MPI
        if (EAST_INTER) then
          iendR=iend+2
        else
          iendR=iend+1
        endif
#  else
        iendR=iend+1
#  endif
# endif
      else
        iendR=iend
      endif
 
      if (jstr.eq.1) then
# ifdef NS_PERIODIC
        jstrR=jstr-2
# else
#  ifdef MPI
        if (SOUTH_INTER) then
          jstrR=jstr-2
        else
          jstrR=jstr-1
        endif
#  else
        jstrR=jstr-1
#  endif
# endif
      else
        jstrR=jstr
      endif
 
      if (jend.eq.Mm) then
# ifdef NS_PERIODIC
        jendR=jend+2
# else
#  ifdef MPI
        if (NORTH_INTER) then
          jendR=jend+2
        else
          jendR=jend+1
        endif
#  else
        jendR=jend+1
#  endif
# endif
      else
        jendR=jend
      endif
 
 
