#include "cppdefs.h"
#ifdef ANA_GRID
 
      subroutine ana_grid (tile)
      implicit none
      integer tile
# include "param.h"
# include "compute_tile_bounds.h"
      call ana_grid_tile (istr,iend,jstr,jend)
      return
      end
 
      subroutine ana_grid_tile (istr,iend,jstr,jend)
!
! Set up model grid using analytical expressions:
!---- -- ----- ---- ----- ---------- ------------
! output: stored in common blocks, see files "scalars.h" "grid.h"
!
! xl,el      Physical dimensions of the computational domain
!                                    [usually measured in  meters];
! h          Model bathymetry [meters, positive] at RHO-points.
! hmin,hmax  Minimum and maximum values of depth of bathymetry [m].
! f          Coriolis parameter (1/seconds) at RHO-points.
! pm,pn      Coordinate transformation metric "m" [1/meters]
!                   associated with the differential distances in
!                   XI- and ETA-directions, both are at RHO-points.
! xp,xr      XI-coordinates [m] at PSI- and RHO-points.
! yp,yr      ETA-coordinates [m] at PSI- and RHO-points.
!
      implicit none
      integer istr,iend,jstr,jend, i,j, imax,jchn
# include "param.h"
!
! Grid configuration parameters:
!----- ------------- -----------
! Size_XI, Size_ETA  are the physical dimensions of the computational
!                               domain [usually measured in  meters];
! depth      is the maximum depth [meters, positive];
! f0,beta    are coriolis parameters which set up a beta-plane
!                                                     [1/s, 1/(m*s)].
!
      real Size_XI,Size_ETA, depth, f0,beta, cff,y, x0,y0,dx,dy
      parameter (
# if defined BASIN
     &               Size_XI=3600.0E+3,      depth=5000.,
     &               Size_ETA=2800.0E+3,     f0=1.E-4, beta=2.E-11
# elif defined CANYON_A || defined CANYON_B
     &               Size_XI=128.0e+3,       depth=4000.,
     &               Size_ETA=96.0e+3,       f0=1.E-4,      beta=0.
# elif defined GRAV_ADJ
     &               Size_XI=64.0E+3,        depth=20.,
     &               Size_ETA=2.0E+3,        f0=0.,         beta=0.
# elif defined OVERFLOW
     &               Size_XI=2.0E+3,         depth=40.,
     &               Size_ETA=64.0E+3,       f0=0.,         beta=0.
# elif defined SEAMOUNT
     &               Size_ETA=320.0e+3,      depth=5000.,   beta=0.,
     &            Size_XI=LLm*Size_ETA/MMm,  f0=1.0E-4
# elif defined SHELFRONT
     &               Size_XI=20.0e+3,        depth=1660.,
     &               Size_ETA=200.0e+3,      f0=1.E-4,      beta=0.
# elif defined SOLITON
     &               Size_XI=48.,            depth=1.,
     &               Size_ETA=16.,           f0=0.,         beta=1.
# elif defined UPWELLING
     &               Size_ETA=8.E+4,         depth=150.,
     &            Size_XI=LLm*Size_ETA/MMm,  f0=-8.26E-5,   beta=0.
# elif defined RIVER
     &               Size_XI=60.e+3,         depth=150.,
     &            Size_ETA=MMm*Size_XI/LLm,  f0=1.E-4,      beta=0.
# else
     &               Size_XI=???             depth=???
     &               Size_ETA=???            f0=???       beta=???
# endif
     &                                                           )
# include "grid.h"
# include "scalars.h"
!
# include "compute_extended_bounds.h"
!
      if (ZEROTH_TILE) then               ! Copy physical dimensions
        xl=Size_XI                        ! of the grid into glabally
        el=Size_ETA                       ! vizible  variables (ONE
      endif                               ! THREAD ONLY).
 
      dx=Size_XI/float(LLm)               ! Set grid spacings
      dy=Size_ETA/float(MMm)              ! for rectangular grids
#ifdef MPI
      x0=float(ii)*Size_XI/float(NP_XI)   ! Coordinate of south-west
      y0=float(jj)*Size_ETA/float(NP_ETA) ! corner of the PI subdomain
#else
      x0=0.
      y0=0.
#endif
CR      write(*,'(4(A3,pe15.9,1x),I3)') 'dx=',dx, 'dy=',dy,
CR     &                         'x0=',x0, 'y0=',y0, mynode
 
      do j=jstrR,jendR
        do i=istrR,iendR
          xp(i,j)=x0+dx*float(i-1)        ! Setup rectangulag grid:
          xr(i,j)=x0+dx*(float(i-1)+0.5)  ! coordinates (XI,ETA) at
          yp(i,j)=y0+dy*float(j-1)        ! PSI- and RHO-points.
          yr(i,j)=y0+dy*(float(j-1)+0.5)
        enddo
      enddo
!
! Compute coordinate transformation metrics at RHO-points "pm" and
! "pn"  (1/m) associated with the differential distances in XI and
! ETA, respectively.
!
      do j=jstrR,jendR
        do i=istrR,iendR
          pm(i,j)=1./dx
          pn(i,j)=1./dy
        enddo
      enddo
!
!  Set Coriolis parameter [1/s] at RHO-points.
!
      x0=Size_XI/2.
      y0=Size_ETA/2.
      do j=jstrR,jendR
        do i=istrR,iendR
          f(i,j)=f0+beta*( yr(i,j)-y0 )
c     &                    +(0.1)*(xr(i,j)-x0))
        enddo
      enddo
!
!  Set bathymetry [meters; positive] at RHO-points.
!
# if defined BASIN || defined GRAV_ADJ || defined SOLITON
      do j=jstrR,jendR
        do i=istrR,iendR
          h(i,j)=depth
        enddo
      enddo
# elif defined CANYON_A || defined CANYON_B
      do j=jstrR,jendR
        do i=istrR,iendR
          cff=32000.-16000.*(sin(pi*xr(i,j)/size_XI))**24
          h(i,j)=20.+0.5*(depth-20.)*(1.+tanh((yr(i,j)-cff)/10000.))
        enddo
      enddo
# elif defined OVERFLOW
      do j=jstrR,jendR
        do i=istrR,iendR
           h(i,j)=20.+0.5*(depth-20.)*( 1.+tanh(( yr(i,j)
     &                                    -40000.)/5000.))
        enddo
      enddo
# elif defined SEAMOUNT
      y0=Size_ETA/2.        ! Seamount topography: the seamount is
      x0=y0                 ! in the middle of the domain in both
      cff=(1./40000.0)**2   ! directions, if it is a square (unforced
      do j=jstrR,jendR      ! PGF error test) or closer to the west
        do i=istrR,iendR
          h(i,j)=depth-4500.0*exp(-cff*( (xr(i,j)-x0)**2
     &                                  +(yr(i,j)-y0)**2))
        enddo
      enddo                 ! if the domain is rectangular (forced)
# elif defined SHELFRONT
      do j=jstrR,jendR
        do i=istrR,iendR
          cff=yr(i,j)/1000.
          if (cff.lt.50.) then
            h(i,j)=50.+2.*cff
          elseif (cff.lt.60.) then
            h(i,j)=160.+1.5*(cff-50.)**2-0.1*(cff-60.0)**2
          elseif (cff.lt.100.) then
            h(i,j)=310.+30.*(cff-60.)
          elseif (cff.lt.110.) then
            h(i,j)=1660.-1.5*(cff-110.)**2
          else
            h(i,j)=1660.
          endif
        enddo
      enddo


# elif defined UPWELLING
      do j=jstrR,jendR
#  ifdef MPI
        y=dy*float(j+jj*Mm)
#  else
        y=dy*float(j)
#  endif
        if (y.gt.Size_ETA/2.) y=Size_ETA-y+dy
        cff=min(depth,84.5+66.526*tanh(0.00015*(y-0.125*Size_ETA)))
        do i=istrR,iendR
          h(i,j)=cff
        enddo
      enddo

# elif defined RIVER
      do i=istrR,iendR
# ifdef MPI
        cff=(float(i +ii*Lm)-0.5)/float(LLm)
# else
        cff=(float(i       )-0.5)/float(LLm)
# endif
        if (cff.lt.0.05) then
          h(i,jstrR)=15.
        elseif (cff.lt.0.15) then
          h(i,jstrR)=15.+843.75*(cff-0.05)**2
        elseif (cff.lt.0.85) then
          h(i,jstrR)=15.+168.75*(cff-0.1)
        elseif (cff.lt.0.95) then
          h(i,jstrR)=150.-843.75*(cff-0.95)**2
        else
          h(i,jstrR)=150.
        endif
      enddo
      do j=jstrR+1,jendR
        do i=istrR,iendR
          h(i,j)=h(i,jstrR)
        enddo
      enddo

# else
      ERROR ###  'ANA_GRID' is defined, but no code is provided.
# endif

# ifdef MASKING
#  if defined RIVER
      do j=jstrR,jendR             ! Set mask to all-water status,
        do i=istrR,iendR           ! then mask out 5-point wide strip
          rmask(i,j)=1.            ! of land on the west, and finally
        enddo                      ! carve a 1-point wide channel
      enddo                        ! through that strip.
#   ifdef MPI
      imax=min(LLm/15-ii*Lm,iendR) ! Thanslation of "absolute" index
      jchn=3*MMm/4 -jj*Mm          ! into index within MPI subdomain.
#   else
      imax=min(LLm/15,iendR)
      jchn=3*MMm/4
#   endif
      do j=jstrR,jendR
        do i=istrR,imax
          rmask(i,j)=0.            ! <-- strip of land
        enddo
      enddo
      do j=jchn-1,jchn+1
        if (j.ge.jstrR .and. j.le.jendR) then
          do i=istrR,imax
            rmask(i,j)=1.          ! <-- channel
          enddo
        endif
      enddo
#  else
      ERROR ###  CPP-key 'MASKING' is defined along with 'ANA_GRID',
      ERROR ###  but no code is provided to create mask analytically
#  endif
# endif
      return
      end
#else
      subroutine ana_grid_empty
      end
#endif /* ANA_GRID */
 
 
 
 
