#include "cppdefs.h"
      subroutine zetabc (tile)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine sets lateral boundary conditions for free-surface.   !
!                                                                    !
!=====================================================================
!
      implicit none
      INTEGER_TYPE
     &        tile
#include "param.h"
#include "scratch.h"
#include "tile.h"
!
      call zetabc_tile (Istr,Iend,Jstr,Jend,
     &                  A2d(1,1))
      return
      end
!
!*********************************************************************
      subroutine zetabc_tile (Istr,Iend,Jstr,Jend,grad)
!*********************************************************************
!
      implicit none
#include "param.h"
#include "boundary.h"
#include "grid.h"
#include "mask.h"
#include "ocean.h"
#include "scalars.h"
!
      INTEGER_TYPE
     &       Iend, Istr, Jend, Jstr, i, j, know
      REAL_TYPE
     &        Ce, Cx, cff, dt2d, dZde, dZdt, dZdx, eps, tau
      REAL_TYPE
     &        grad(PRIVATE_2D_SCRATCH_ARRAY)
      parameter (eps=1.0_e8-20)
!
#include "set_bounds.h"
!
      i=0
      j=0
      Ce=0.0_r8
      Cx=0.0_r8
      cff=0.0_r8
      dZdx=0.0_r8
      dZde=0.0_r8
      dZdt=0.0_r8
      tau=0.0_r8
!
!---------------------------------------------------------------------
!  Set time-indices
!---------------------------------------------------------------------
!
      if (FIRST_2D_STEP) then
        know=krhs
        dt2d=dtfast
      elseif (PREDICTOR_2D_STEP) then
        know=krhs
        dt2d=2.0_r8*dtfast
      else
        know=kstp
        dt2d=dtfast
      endif
!
#ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the western edge.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE) then
!
# if defined WEST_FSRADIATION
!
!  Western edge, implicit upstream radiation condition.
!
        do j=Jstr,Jend+1
          grad(0,j)=(zeta(0,j,know)-zeta(0,j-1,know))
#  ifdef MASKING
     &             *vmask(0,j)
#  endif
          grad(1,j)=(zeta(1,j,know)-zeta(1,j-1,know))
#  ifdef MASKING
     &             *vmask(1,j)
#  endif
        enddo
        do j=Jstr,Jend
          dZdt=zeta(1,j,know)-zeta(1,j,knew)
          dZdx=zeta(1,j,knew)-zeta(2,j,knew)
#  ifdef WEST_FSNUDGING
          tau=FSobc_out(iwest)
          if ((dZdt*dZdx).lt.0.0_r8) tau=FSobc_in(iwest)
          tau=tau*dt2d
#  endif
          if ((dZdt*dZdx).lt.0.0_r8) dZdt=0.0_r8
          if ((dZdt*(grad(1,j)+grad(1,j+1))).gt.0.0_r8) then
            dZde=grad(1,j  )
          else
            dZde=grad(1,j+1)
          endif
          cff=MAX(dZdx*dZdx+dZde*dZde,eps)
          Cx=dZdt*dZdx
#  ifdef RADIATION_2D
          Ce=MIN(cff,MAX(dZdt*dZde,-cff))
#  else
          Ce=0.0_r8
#  endif
          zeta(0,j,knew)=(cff*zeta(0,j,know)+
     &                    Cx*zeta(1,j,knew)-
     &                    MAX(Ce,0.0_r8)*grad(0,j  )-
     &                    MIN(Ce,0.0_r8)*grad(0,j+1))/(cff+Cx)
#  ifdef WEST_FSNUDGING
     &                  +tau*(zeta_west(j)-zeta(0,j,know))
#  endif
#  ifdef MASKING
          zeta(0,j,knew)=zeta(0,j,knew)*rmask(0,j)
#  endif
        enddo
# elif defined WEST_FSCHAPMAN
!
!  Western edge, Chapman boundary condition.
!
        do j=Jstr,Jend
          Cx=dt2d*pm(1,j)*SQRT(g*h(1,j))
          zeta(0,j,knew)=(zeta(0,j,know)+Cx*zeta(1,j,knew))/
     &                   (1.0_r8+Cx)
#  ifdef MASKING
     &                  *rmask(0,j)
#  endif
        enddo
# elif defined WEST_FSCLAMPED
!
!  Western edge, clamped boundary condition.
!
        do j=Jstr,Jend
          zeta(0,j,knew)=zeta_west(j)
#  ifdef MASKING
     &                  *rmask(0,j)
#  endif /* MASKING */
        enddo
# elif defined WEST_FSGRADIENT
!
!  Western edge, gradient boundary condition.
!
        do j=Jstr,Jend
          zeta(0,j,knew)=zeta(1,j,knew)
#  ifdef MASKING
     &                  *rmask(0,j)
#  endif /* MASKING */
        enddo
# else
!
!  Western edge, closed boundary condition.
!
        do j=Jstr,Jend
          zeta(0,j,knew)=zeta(1,j,knew)
#  ifdef MASKING
     &                  *rmask(0,j)
#  endif
        enddo
# endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the eastern edge.
!---------------------------------------------------------------------
!
      if (EASTERN_EDGE) then
!
# if defined EAST_FSRADIATION
!
!  Eastern edge, implicit upstream radiation condition.
!
        do j=Jstr,Jend+1
          grad(Lm,j)=(zeta(Lm,j,know)-zeta(Lm,j-1,know))
#  ifdef MASKING
     &              *vmask(Lm,j)
#  endif
          grad(L ,j)=(zeta(L ,j,know)-zeta(L ,j-1,know))
#  ifdef MASKING
     &              *vmask(L ,j)
#  endif
        enddo
        do j=Jstr,Jend
          dZdt=zeta(Lm,j,know)-zeta(Lm,j,knew)
          dZdx=zeta(Lm,j,knew)-zeta(Lm-1,j,knew)
#  ifdef EAST_FSNUDGING
          tau=FSobc_out(ieast)
          if ((dZdt*dZdx).lt.0.0_r8) tau=FSobc_in(ieast)
          tau=tau*dt2d
#  endif
          if ((dZdt*dZdx).lt.0.0_r8) dZdt=0.0_r8
          if ((dZdt*(grad(Lm,j)+grad(Lm,j+1))).gt.0.0_r8) then
            dZde=grad(Lm,j  )
          else
            dZde=grad(Lm,j+1)
          endif
          cff=MAX(dZdx*dZdx+dZde*dZde,eps)
          Cx=dZdt*dZdx
#  ifdef RADIATION_2D
          Ce=MIN(cff,MAX(dZdt*dZde,-cff))
#  else
          Ce=0.0_r8
#  endif
          zeta(L,j,knew)=(cff*zeta(L,j,know)+
     &                    Cx*zeta(Lm,j,knew)-
     &                    MAX(Ce,0.0_r8)*grad(L,j  )-
     &                    MIN(Ce,0.0_r8)*grad(L,j+1))/(cff+Cx)
#  ifdef EAST_FSNUDGING
     &                  +tau*(zeta_east(j)-zeta(L,j,know))
#  endif
#  ifdef MASKING
          zeta(L,j,knew)=zeta(L,j,knew)*rmask(L,j)
#  endif
        enddo
# elif defined EAST_FSCHAPMAN
!
!  Eastern edge, Chapman boundary condition.
!
        do j=Jstr,Jend
          Cx=dt2d*pm(Lm,j)*SQRT(g*h(Lm,j))
          zeta(L,j,knew)=(zeta(L,j,know)+Cx*zeta(Lm,j,knew))/
     &                   (1.0_r8+Cx)
#  ifdef MASKING
     &                  *rmask(L,j)
#  endif
        enddo
# elif defined EAST_FSCLAMPED
!
!  Eastern edge, clamped boundary condition.
!
        do j=Jstr,Jend
          zeta(L,j,knew)=zeta_east(j)
#  ifdef MASKING
     &                  *rmask(L,j)
#  endif
        enddo
# elif defined EAST_FSGRADIENT
!
!  Eastern edge, gradient boundary condition.
!
        do j=Jstr,Jend
          zeta(L,j,knew)=zeta(Lm,j,knew)
#  ifdef MASKING
     &                  *rmask(L,j)
#  endif
        enddo
# else
!
!  Eastern edge, closed boundary condition.
!
        do j=Jstr,Jend
          zeta(L,j,knew)=zeta(Lm,j,knew)
#  ifdef MASKING
     &                  *rmask(L,j)
#  endif
        enddo
# endif
      endif
#endif /* !EW_PERIODIC */
#ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the southern edge.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE) then
!
# if defined SOUTH_FSRADIATION
!
!  Southern edge, implicit upstream radiation condition.
!
        do i=Istr,Iend+1
          grad(i,1)=(zeta(i,1,know)-zeta(i-1,1,know))
#  ifdef MASKING
     &             *umask(i,1)
#  endif
          grad(i,0)=(zeta(i,0,know)-zeta(i-1,0,know))
#  ifdef MASKING
     &             *umask(i,0)
#  endif
        enddo
        do i=Istr,Iend
          dZdt=zeta(i,1,know)-zeta(i,1,knew)
          dZde=zeta(i,1,knew)-zeta(i,2,knew)
#  ifdef SOUTH_FSNUDGING
          tau=FSobc_out(isouth)
          if ((dZdt*dZde).lt.0.0_r8) tau=FSobc_in(isouth)
          tau=tau*dt2d
#  endif
          if ((dZdt*dZde).lt.0.0_r8) dZdt=0.0_r8
          if ((dZdt*(grad(i,1)+grad(i+1,1))).gt.0.0_r8) then
            dZdx=grad(i  ,1)
          else
            dZdx=grad(i+1,1)
          endif
          cff=MAX(dZdx*dZdx+dZde*dZde,eps)
#  ifdef RADIATION_2D
          Cx=MIN(cff,MAX(dZdt*dZdx,-cff))
#  else
          Cx=0.0_r8
#  endif
          Ce=dZdt*dZde
          zeta(i,0,knew)=(cff*zeta(i,0,know)+
     &                    Ce*zeta(i,1,knew)-
     &                    MAX(Cx,0.0_r8)*grad(i  ,0)-
     &                    MIN(Cx,0.0_r8)*grad(i+1,0))/(cff+Ce)
#  ifdef SOUTH_FSNUDGING
     &                  +tau*(zeta_south(i)-zeta(i,0,know))
#  endif
#  ifdef MASKING
          zeta(i,0,knew)=zeta(i,0,knew)*rmask(i,0)
#  endif
        enddo
# elif defined SOUTH_FSCHAPMAN
!
!  Southern edge, Chapman boundary condition.
!
        do i=Istr,Iend
          Ce=dt2d*pn(i,1)*SQRT(g*h(i,1))
          zeta(i,0,knew)=(zeta(i,0,know)+Ce*zeta(i,1,knew))/
     &                   (1.0_r8+Ce)
#  ifdef MASKING
     &                  *rmask(i,0)
#  endif
        enddo
# elif defined SOUTH_FSCLAMPED
!
!  Southern edge, clamped boundary condition.
!
        do i=Istr,Iend
          zeta(i,0,knew)=zeta_south(i)
#  ifdef MASKING
     &                  *rmask(i,0)
#  endif
        enddo
# elif defined SOUTH_FSGRADIENT
!
!  Southern edge, gradient boundary condition.
!
        do i=Istr,Iend
          zeta(i,0,knew)=zeta(i,1,knew)
#  ifdef MASKING
     &                  *rmask(i,0)
#  endif
        enddo
# else
!
!  Southern edge, closed boundary condition.
!
        do i=Istr,Iend
          zeta(i,0,knew)=zeta(i,1,knew)
#  ifdef MASKING
     &                  *rmask(i,0)
#  endif
        enddo
# endif
      endif
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the northern edge.
!---------------------------------------------------------------------
!
      if (NORTHERN_EDGE) then
!
# if defined NORTH_FSRADIATION
!
!  Northern edge, implicit upstream radiation condition.
!
        do i=Istr,Iend+1
          grad(i,Mm)=(zeta(i,Mm,know)-zeta(i-1,Mm,know))
#  ifdef MASKING
     &              *umask(i,Mm)
#  endif
          grad(i,M )=(zeta(i,M ,know)-zeta(i-1,M ,know))
#  ifdef MASKING
     &              *umask(i,M )
#  endif
        enddo
        do i=Istr,Iend
          dZdt=zeta(i,Mm,know)-zeta(i,Mm,knew)
          dZde=zeta(i,Mm,knew)-zeta(i,Mm-1,knew)
#  ifdef NORTH_FSNUDGING
          tau=FSobc_out(inorth)
          if ((dZdt*dZde).lt.0.0_r8) tau=FSobc_in(inorth)
          tau=tau*dt2d
#  endif
          if ((dZdt*dZde).lt.0.0_r8) dZdt=0.0_r8
          if ((dZdt*(grad(i,Mm)+grad(i+1,Mm))).gt.0.0_r8) then
            dZdx=grad(i  ,Mm)
          else
            dZdx=grad(i+1,Mm)
          endif
          cff=MAX(dZdx*dZdx+dZde*dZde,eps)
#  ifdef RADIATION_2D
          Cx=MIN(cff,MAX(dZdt*dZdx,-cff))
#  else
          Cx=0.0_r8
#  endif
          Ce=dZdt*dZde
          zeta(i,M,knew)=(cff*zeta(i,M,know)+
     &                    Ce*zeta(i,Mm,knew)-
     &                    MAX(Cx,0.0_r8)*grad(i  ,M)-
     &                    MIN(Cx,0.0_r8)*grad(i+1,M))/(cff+Ce)
#  ifdef NORTH_FSNUDGING
     &                  +tau*(zeta_north(i)-zeta(i,M,know))
#  endif
#  ifdef MASKING
          zeta(i,M,knew)=zeta(i,M,knew)*rmask(i,M)
#  endif
        enddo
# elif defined NORTH_FSCHAPMAN
!
!  Northern edge, Chapman boundary condition.
!
        do i=Istr,Iend
          Ce=dt2d*pn(i,Mm)*SQRT(g*h(i,Mm))
          zeta(i,M,knew)=(zeta(i,M,know)+Ce*zeta(i,Mm,knew))/
     &                   (1.0_r8+Ce)
#  ifdef MASKING
     &                  *rmask(i,M)
#  endif
        enddo
# elif defined NORTH_FSCLAMPED
!
!  Northern edge, clamped boundary condition.
!
        do i=Istr,Iend
          zeta(i,M,knew)=zeta_north(i)
#  ifdef MASKING
     &                  *rmask(i,M)
#  endif
        enddo
# elif defined NORTH_FSGRADIENT
!
!  Northern edge, gradient boundary condition.
!
        do i=Istr,Iend
          zeta(i,M,knew)=zeta(i,Mm,knew)
#  ifdef MASKING
     &                  *rmask(i,M)
#  endif
        enddo
# else
!
!  Northern edge, closed boundary condition.
!
        do i=Istr,Iend
          zeta(i,M,knew)=zeta(i,Mm,knew)
#  ifdef MASKING
     &                  *rmask(i,M)
#  endif
        enddo
# endif
      endif
#endif /* !NS_PERIODIC */
#if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        zeta(0,0,knew)=0.5_r8*(zeta(1,0,knew)+zeta(0,1,knew))
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        zeta(L,0,knew)=0.5_r8*(zeta(L,1,knew)+zeta(Lm,0,knew))
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        zeta(0,M,knew)=0.5_r8*(zeta(0,Mm,knew)+zeta(1 ,M,knew))
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        zeta(L,M,knew)=0.5_r8*(zeta(L,Mm,knew)+zeta(Lm,M,knew))
      endif
#endif
      return
      end
