#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine wvelocity (wvel,tile)
!
!======================================== Alexander F. Shchepetkin ===
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutines computes vertical velocity (m/s) at W-points     !
!  from the vertical mass flux (omega*hz/m*n).  This computation     !
!  is done solely for output purposes.                               !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
      INTEGER_TYPE
     &        tile
      REAL_TYPE
     &        wvel(GLOBAL_2D_ARRAY,0:N)
# include "scratch.h"
# include "tile.h"
!
      call wvelocity_tile (Istr,Iend,Jstr,Jend,wvel,
     &                     A3d(1,1),A2d(1,1))
      return
      end
!
!*********************************************************************
      subroutine wvelocity_tile (Istr,Iend,Jstr,Jend,wvel,vert,wrk)
!*********************************************************************
!
      implicit none
# include "param.h"
# include "coupling.h"
# include "grid.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
      REAL_TYPE
     &        cff1, cff2, cff3
      REAL_TYPE
     &        wvel(GLOBAL_2D_ARRAY,0:N),
     &        vert(PRIVATE_2D_SCRATCH_ARRAY,N),
     &         wrk(PRIVATE_2D_SCRATCH_ARRAY)
!
# include "set_bounds.h"
!
!  Compute contribution due to quasi-horizontal motions along
!  S-coordinate surfaces:  (Ui +Vj)*GRADs(z).
!
      do k=1,N
        do j=Jstr,Jend
          do i=Istr,Iend+1
            wrk(i,j)=u(i,j,k,nstp)*(z_r(i,j,k)-z_r(i-1,j,k))*
     &                             (pm(i-1,j)+pm(i,j))
          enddo
          do i=Istr,Iend
            vert(i,j,k)=0.25_r8*(wrk(i,j)+wrk(i+1,j))
          enddo
        enddo
        do j=Jstr,Jend+1
          do i=Istr,Iend
            wrk(i,j)=v(i,j,k,nstp)*(z_r(i,j,k)-z_r(i,j-1,k))*
     &                             (pn(i,j-1)+pn(i,j))
          enddo
        enddo
        do j=Jstr,Jend
          do i=Istr,Iend
            vert(i,j,k)=vert(i,j,k)+0.25_r8*(wrk(i,j)+wrk(i,j+1))
          enddo
        enddo
      enddo
!
!  Compute contribution due to time tendency of the free-surface,
!  d(zeta)/d(t), which is the vertical velocity at the free-surface
!  and it is expressed in terms of barotropic mass flux divergence.
!  Notice that it is divided by the total depth of the water column.
!  This is needed because this contribution is linearly distributed
!  throughout the water column by multiplying it by the distance from
!  the bottom to the depth at which the vertical velocity is computed.
!
      do j=Jstr,Jend
        do i=Istr,Iend
          wrk(i,j)=(DU_avg1(i,j)-DU_avg1(i+1,j)+
     &              DV_avg1(i,j)-DV_avg1(i,j+1))/
     &             (z_w(i,j,N)-z_w(i,j,0))
        enddo
!
!  Notice that a cubic interpolation is used to shift the "vert"
!  contribution from vertical RHO- to W-points.
!
        cff1=3.0_r8/8.0_r8
        cff2=3.0_r8/4.0_r8
        cff3=1.0_r8/8.0_r8
        do i=Istr,Iend
!!        wvel(i,j,0)=0.0_r8
          wvel(i,j,0)=cff1*(vert(i,j,1)-
     &                      (vert(i,j,2)-vert(i,j,1))*
     &                      2.0_r8*(z_r(i,j,1)-z_w(i,j,0)))+
     &                cff2*vert(i,j,1)-
     &                cff3*vert(i,j,2)
          wvel(i,j,1)=pm(i,j)*pn(i,j)*
     &                (W(i,j,1)+
     &                 wrk(i,j)*(z_w(i,j,1)-z_w(i,j,0)))+
     &                cff1*vert(i,j,1)+
     &                cff2*vert(i,j,2)-
     &                cff3*vert(i,j,3)
        enddo
        cff1=9.0_r8/16.0_r8
        cff2=1.0_r8/16.0_r8
        do k=2,N-2
          do i=Istr,Iend
            wvel(i,j,k)=pm(i,j)*pn(i,j)*
     &                  (W(i,j,k)+
     &                   wrk(i,j)*(z_w(i,j,k)-z_w(i,j,0)))+
     &                  cff1*(vert(i,j,k  )+vert(i,j,k+1))-
     &                  cff2*(vert(i,j,k-1)+vert(i,j,k+2))
          enddo
        enddo
        cff1=3.0_r8/8.0_r8
        cff2=3.0_r8/4.0_r8
        cff3=1.0_r8/8.0_r8
        do i=Istr,Iend
          wvel(i,j,N  )=pm(i,j)*pn(i,j)*
     &                  wrk(i,j)*(z_w(i,j,N)-z_w(i,j,0))+
     &                  cff1*(vert(i,j,N)+
     &                        (vert(i,j,N)-vert(i,j,N-1))*
     &                        2.0_r8*(z_w(i,j,N)-z_r(i,j,N)))+
     &                  cff2*vert(i,j,N  )-
     &                  cff3*vert(i,j,N-1)
          wvel(i,j,N-1)=pm(i,j)*pn(i,j)*
     &                  (W(i,j,Nm)+
     &                   wrk(i,j)*(z_w(i,j,N-1)-z_w(i,j,0)))+
     &                  cff1*vert(i,j,N  )+
     &                  cff2*vert(i,j,N-1)-
     &                  cff3*vert(i,j,N-2)
        enddo
      enddo
!
!  Set lateral boundary conditions.
!
# ifndef EW_PERIODIC
      if (WESTERN_EDGE) then
        do k=0,N
          do j=Jstr,Jend
            wvel(0,j,k)=wvel(1,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=0,N
          do j=Jstr,Jend
            wvel(Lm+1,j,k)=wvel(Lm,j,k)
          enddo
        enddo
      endif
# endif
# ifndef NS_PERIODIC
#  ifdef EW_PERIODIC
#   define I_RANGE Istr,Iend
#  else
#   define I_RANGE IstrR,IendR
#  endif
      if (SOUTHERN_EDGE) then
        do k=0,N
          do i=I_RANGE
            wvel(i,0,k)=wvel(i,1,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=0,N
          do i=I_RANGE
            wvel(i,Mm+1,k)=wvel(i,Mm,k)
          enddo
        enddo
      endif
#  undef I_RANGE
# endif
# if defined EW_PERIODIC || defined NS_PERIODIC
      call exchange_w3d_tile (Istr,Iend,Jstr,Jend,wvel)
# endif
#else
      subroutine wvelocity
#endif
      return
      end
