#include "cppdefs.h"
      subroutine wrt_station
#ifdef STATIONS
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine writes out data into stations NetCDF file.           !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "bbl.h"
# include "forces.h"
# include "grid.h"
# include "iounits.h"
# include "mixing.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "ocean.h"
# include "scalars.h"
# include "scratch.h"
!
      INTEGER_TYPE
     &        i, ist, j, lsvar, status, tile
      INTEGER_TYPE
     &        start(3), count(3)
      INTEGER_TYPE
     &        lenstr
      REAL_TYPE
     &        scale, psta(NS)
# ifdef SOLVE3D
      INTEGER_TYPE
     &        itrc, k
      REAL_TYPE
     &        rsta(N,NS),
     &        wvel(GLOBAL_2D_ARRAY,0:N)
      equivalence (wvel,B3d)
# endif
!
!---------------------------------------------------------------------
!  Write out station data at RHO-points.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
!
!  Set time record index.
!
      tstaindx=tstaindx+1
      nrecsta=nrecsta+1
!
      start(1)=1
      count(1)=N
      start(2)=1
      count(2)=nstation
      start(3)=tstaindx
      count(3)=1
!
!  Write out model time (s).
!
      status=nf_put_var1_FTYPE(ncstaid,staVid(idtime),tstaindx,time)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idtime))
        write(stdout,10) Vname(1,idtime)(1:lsvar), tstaindx
        exit_flag=3
        return
      endif
!
!  Write out free-surface (m).
!
      if (Sout(idFsur)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=zeta(i,j,KOUT)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idFsur),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idFsur))
          write(stdout,10) Vname(1,idFsur)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 2D momentum component (m/s) in the XI-direction.
!
      if (Sout(idUbar)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(ubar(i,j,KOUT)+ubar(i+1,j,KOUT))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idUbar),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbar))
          write(stdout,10) Vname(1,idUbar)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 2D momentum component (m/s) in the ETA-direction.
!
      if (Sout(idVbar)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(vbar(i,j,KOUT)+vbar(i,j+1,KOUT))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idVbar),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbar))
          write(stdout,10) Vname(1,idVbar)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
# ifdef SOLVE3D
!
!  Write out 3D momentum component (m/s) in the XI-direction.
!
      if (Sout(idUvel)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=0.5_r8*(u(i,j,k,NOUT)+u(i+1,j,k,NOUT))*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idUvel),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUvel))
          write(stdout,10) Vname(1,idUvel)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 3D momentum component (m/s) in the ETA-direction.
!
      if (Sout(idVvel)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=0.5_r8*(v(i,j,k,NOUT)+v(i,j+1,k,NOUT))*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idVvel),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVvel))
          write(stdout,10) Vname(1,idVvel)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out vertical velocity (m/s).
!
      if (Sout(idWvel)) then
        scale=1.0_r8
        do tile=0,NSUB_X*NSUB_E-1
          call wvelocity (wvel,tile)
        enddo
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=wvel(i,j,k)*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idWvel),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idWvel))
          write(stdout,10) Vname(1,idWvel)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out tracer type variables.
!
      do itrc=1,NT
        if (Sout(idTvar(itrc))) then
          scale=1.0_r8
          do ist=1,nstation
            i=ispos(ist)
            j=jspos(ist)
            do k=1,N
              rsta(k,ist)=t(i,j,k,NOUT,itrc)*scale
            enddo
          enddo
          status=nf_put_vara_FTYPE(ncstaid,staTid(itrc),start,count,
     &                             rsta)
          if (status.ne.nf_noerr) then
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            write(stdout,10) Vname(1,idTvar(itrc))(1:lsvar), tstaindx
            exit_flag=3
            return
          endif
        endif
      enddo
!
!  Write out density anomaly.
!
      if (Sout(idDano)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=rho(i,j,k)*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idDano),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idDano))
          write(stdout,10) Vname(1,idDano)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  ifdef LMD_SKPP
!
!  Write out depth of surface boundary layer.
!
      if (Sout(idHsbl)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=hsbl(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idHsbl),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idHsbl))
          write(stdout,10) Vname(1,idHsbl)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  endif /* LMD_SKPP */
#  ifdef LMD_BKPP
!
!  Write out depth of bottom boundary layer.
!
      if (Sout(idHbbl)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=hbbl(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idHbbl),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idHbbl))
          write(stdout,10) Vname(1,idHbbl)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  endif /* LMD_BKPP */
!
!  Write out vertical viscosity coefficient.
!
      if (Sout(idVvis)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=Akv(i,j,k)*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idVvis),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVvis))
          write(stdout,10) Vname(1,idVvis)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out vertical diffusion coefficient for potential temperature.
!
      if (Sout(idTdif)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=Akt(i,j,k,itemp)*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idTdif),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idTdif))
          write(stdout,10) Vname(1,idTdif)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  ifdef SALINITY
!
!  Write out vertical diffusion coefficient for salinity.
!
      if (Sout(idSdif)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=Akt(i,j,k,isalt)*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idSdif),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idSdif))
          write(stdout,10) Vname(1,idSdif)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  endif /* SALINITY */
#  if defined MY25_MIXING || defined GLS_MIXING
!
!  Write out turbulent kinetic energy.
!
      if (Sout(idMtke)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=tke(i,j,k,NOUT)*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idMtke),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idMtke))
          write(stdout,10) Vname(1,idMtke)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out turbulent kinetic energy times length scale.
!
      if (Sout(idMtls)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          do k=1,N
            rsta(k,ist)=gls(i,j,k,NOUT)*scale
          enddo
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idMtls),start,count,
     &                           rsta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idMtls))
          write(stdout,10) Vname(1,idMtls)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  endif /* MY25_MIXING || GLS_MIXING */
!
!  Write out surface net heat flux.
!
      if (Sout(idTsur(itemp))) then
        scale=rho0*Cp
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=stflx(i,j,itemp)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idTsur(itemp)),
     &                           start(2),count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idTsur(itemp)))
          write(stdout,10) Vname(1,idTsur(itemp))(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  ifdef BULK_FLUXES
!
!  Write out latent heat flux.
!
      if (Sout(idLhea)) then
        scale=rho0*Cp
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=lhflx(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idLhea),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idLhea))
          write(stdout,10) Vname(1,idLhea)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out sensible heat flux.
!
      if (Sout(idShea)) then
        scale=rho0*Cp
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=shflx(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idShea),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idShea))
          write(stdout,10) Vname(1,idShea)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out longwave radiation flux.
!
      if (Sout(idLrad)) then
        scale=rho0*Cp
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=lrflx(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idLrad),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idLrad))
          write(stdout,10) Vname(1,idLrad)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  endif /* BULK_FLUXES */
#  ifdef SHORTWAVE
!
!  Write out shortwave radiation flux.
!
      if (Sout(idSrad)) then
        scale=rho0*Cp
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=srflx(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idSrad),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idSrad))
          write(stdout,10) Vname(1,idSrad)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#  endif /* SHORTWAVE */
# endif /* SOLVE3D */
!
!  Write out surface U-momentum stress.
!
      if (Sout(idUsms)) then
        scale=rho0
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(sustr(i,j)+sustr(i+1,j))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idUsms),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUsms))
          write(stdout,10) Vname(1,idUsms)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out surface V-momentum stress.
!
      if (Sout(idVsms)) then
        scale=rho0
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(svstr(i,j)+svstr(i,j+1))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idVsms),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVsms))
          write(stdout,10) Vname(1,idVsms)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bottom U-momentum stress.
!
      if (Sout(idUbms)) then
        scale=-rho0
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(bustr(i,j)+bustr(i+1,j))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idUbms),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbms))
          write(stdout,10) Vname(1,idUbms)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bottom V-momentum stress.
!
      if (Sout(idVbms)) then
        scale=-rho0
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(bvstr(i,j)+bvstr(i,j+1))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idVbms),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbms))
          write(stdout,10) Vname(1,idVbms)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#ifdef BBL
!
!  Write out wind-induced, bottom U-wave stress.
!
      if (Sout(idUbws)) then
        scale=rho0
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(bustrw(i,j)+bustrw(i+1,j))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idUbws),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbws))
          write(stdout,10) Vname(1,idUbws)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out wind-induced, bottom V-wave stress.
!
      if (Sout(idVbws)) then
        scale=rho0
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(bvstrw(i,j)+bvstrw(i,j+1))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idVbws),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbws))
          write(stdout,10) Vname(1,idVbws)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out wind-induced, bed wave excursion amplitude.
!
      if (Sout(idAbed)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=Abed(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idAbed),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idAbed))
          write(stdout,10) Vname(1,idAbed)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out wind-induced, bed wave orbital U-velocity.
!
      if (Sout(idUbed)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(Ubed(i,j)+Ubed(i+1,j))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idUbed),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbed))
          write(stdout,10) Vname(1,idUbed)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out wind-induced, bed wave orbital V-velocity.
!
      if (Sout(idVbed)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(Vbed(i,j)+Vbed(i,j+1))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idVbed),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbed))
          write(stdout,10) Vname(1,idVbed)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bottom U-momentum above bed.
!
      if (Sout(idUbot)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(Ubot(i,j)+Ubot(i+1,j))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idUbot),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbot))
          write(stdout,10) Vname(1,idUbot)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bottom V-momentum above bed.
!
      if (Sout(idVbot)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=0.5_r8*(Vbot(i,j)+Vbot(i,j+1))*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idVbot),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbot))
          write(stdout,10) Vname(1,idVbot)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bed ripple height.
!
      if (Sout(idHrip)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=Hripple(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idHrip),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idHrip))
          write(stdout,10) Vname(1,idHrip)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bed ripple length.
!
      if (Sout(idLrip)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=Lripple(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idLrip),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idLrip))
          write(stdout,10) Vname(1,idLrip)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out hydraulic bottom roughness.
!
      if (Sout(idZnot)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=Zbnot(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idZnot),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idZnot))
          write(stdout,10) Vname(1,idZnot)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out apparent hydraulic bottom roughness.
!
      if (Sout(idZapp)) then
        scale=1.0_r8
        do ist=1,nstation
          i=ispos(ist)
          j=jspos(ist)
          psta(ist)=Zbnotc(i,j)*scale
        enddo
        status=nf_put_vara_FTYPE(ncstaid,staVid(idZapp),start(2),
     &                           count(2),psta)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idZapp))
          write(stdout,10) Vname(1,idZapp)(1:lsvar), tstaindx
          exit_flag=3
          return
        endif
      endif
#endif /* BBL */
!
!  Synchronize restart NetCDF file to disk.
!
      status=nf_sync(ncstaid)
      if (status.ne.nf_noerr) then
        write(stdout,20)
        exit_flag=3
        return
      endif
!
  10  format(/,' WRT_STATION - error while writing variable: ',a,/,
     &       15x,'into stations NetCDF file for time record: ',i4)
  20  format(/,' WRT_STATION - unable to synchronize stations',
     &       1x,'NetCDF file to disk.')
#endif /* STATIONS */
      return
      end
