#include "cppdefs.h"
      subroutine wrt_rst
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine writes fields into restart NetCDF file.              !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "iounits.h"
#include "mixing.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "ocean.h"
#include "scalars.h"
#include "sediment.h"
!
      INTEGER_TYPE
     &        gfactor, gtype, lsvar, status
#ifdef SOLVE3D
      INTEGER_TYPE
     &        itrc
#endif
      INTEGER_TYPE
     &        lenstr, nf_fwrite
      REAL_TYPE
     &        scale
!
!---------------------------------------------------------------------
!  Write out restart fields.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
!
!  Set grid type factor to write full (gfactor=1) fields or water
!  points (gfactor=-1) fields only.
!
#if defined WRITE_WATER && defined MASKING
        gfactor=-1
#else
        gfactor=1
#endif
!
!  Set time record index.
!
      trstindx=trstindx+1
      nrecrst=nrecrst+1
!
!  If requested, set time index to recycle time records in restart
!  file.
!
      if (lcycle) then
        trstindx=MOD(trstindx-1,2)+1
      endif
!
!  Write out model time (s).
!
      status=nf_put_var1_FTYPE(ncrstid,rstVid(idtime),trstindx,time)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idtime))
        write(stdout,10) Vname(1,idtime)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
!
!  Write out free-surface (m)
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_fwrite(zeta(START_2D_ARRAY,KOUT),scale,ncrstid,
     &                 rstVid(idFsur),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idFsur))
        write(stdout,10) Vname(1,idFsur)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
!
!  Write out 2D momentum component (m/s) in the XI-direction.
!
      scale=1.0_r8
      gtype=gfactor*u2dvar
      status=nf_fwrite(ubar(START_2D_ARRAY,KOUT),scale,ncrstid,
     &                 rstVid(idUbar),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idUbar))
        write(stdout,10) Vname(1,idUbar)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
!
!  Write out 2D momentum component (m/s) in the ETA-direction.
!
      scale=1.0_r8
      gtype=gfactor*v2dvar
      status=nf_fwrite(vbar(START_2D_ARRAY,KOUT),scale,ncrstid,
     &                 rstVid(idVbar),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idVbar))
        write(stdout,10) Vname(1,idVbar)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
#ifdef SOLVE3D
!
!  Write out 3D momentum component (m/s) in the XI-direction.
!
      scale=1.0_r8
      gtype=gfactor*u3dvar
      status=nf_fwrite(u(START_2D_ARRAY,1,NOUT),scale,ncrstid,
     &                 rstVid(idUvel),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idUvel))
        write(stdout,10) Vname(1,idUvel)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
!
!  Write out momentum component (m/s) in the ETA-direction.
!
      scale=1.0_r8
      gtype=gfactor*v3dvar
      status=nf_fwrite(v(START_2D_ARRAY,1,NOUT),scale,ncrstid,
     &                 rstVid(idVvel),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idVvel))
        write(stdout,10) Vname(1,idVvel)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
!
!  Write out tracer type variables.
!
      do itrc=1,NT
        scale=1.0_r8
        gtype=gfactor*r3dvar
        status=nf_fwrite(t(START_2D_ARRAY,1,NOUT,itrc),scale,ncrstid,
     &                   rstTid(itrc),trstindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idTvar(itrc)))
          write(stdout,10) Vname(1,idTvar(itrc))(1:lsvar), trstindx
          exit_flag=3
          return
        endif
      enddo
!
!  Write out density anomaly.
!
      scale=1.0_r8
      gtype=gfactor*r3dvar
      status=nf_fwrite(rho(START_2D_ARRAY,1),scale,ncrstid,
     &                 rstVid(idDano),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idDano))
        write(stdout,10) Vname(1,idDano)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
# ifdef LMD_SKPP
!
!  Write out depth of surface boundary layer.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_fwrite(hsbl(START_2D_ARRAY),scale,ncrstid,
     &                 rstVid(idHsbl),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idHsbl))
        write(stdout,10) Vname(1,idHsbl)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
# endif
# ifdef LMD_BKPP
!
!  Write out depth of bottom boundary layer.
!
      scale=1.0_r8
      gtype=gfactor*r2dvar
      status=nf_fwrite(hbbl(START_2D_ARRAY),scale,ncrstid,
     &                 rstVid(idHbbl),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idHbbl))
        write(stdout,10) Vname(1,idHbbl)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
# endif
# if defined BVF_MIXING   || defined GLS_MIXING || \
     defined MY25_MIXING || defined LMD_MIXING
!
!  Write out vertical viscosity coefficient.
!
      scale=1.0_r8
      gtype=gfactor*r3dvar
      status=nf_fwrite(Akv(START_2D_ARRAY,0),scale,ncrstid,
     &                 rstVid(idVvis),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idVvis))
        write(stdout,10) Vname(1,idVvis)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
!
!  Write out vertical diffusion coefficient for potential temperature.
!
      scale=1.0_r8
      gtype=gfactor*r3dvar
      status=nf_fwrite(Akt(START_2D_ARRAY,0,itemp),scale,ncrstid,
     &                 rstVid(idTdif),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idTdif))
        write(stdout,10) Vname(1,idTdif)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
#  ifdef SALINITY
!
!  Write out vertical diffusion coefficient for salinity.
!
      scale=1.0_r8
      gtype=gfactor*r3dvar
      status=nf_fwrite(Akt(START_2D_ARRAY,0,isalt),scale,ncrstid,
     &                 rstVid(idSdif),trstindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idSdif))
        write(stdout,10) Vname(1,idSdif)(1:lsvar), trstindx
        exit_flag=3
        return
      endif
#  endif
# endif
# ifdef SEDIMENT
!
!  Write out bed layer sediment fraction for each size class.
!
      do itrc=1,NST
        scale=1.0_r8
        gtype=gfactor*b3dvar
        status=nf_fwrite(bed_frac(START_2D_ARRAY,1,itrc),scale,ncrstid,
     &                   rstVid(idfrac(itrc)),trstindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idfrac(itrc)))
          write(stdout,10) Vname(1,idfrac(itrc))(1:lsvar), trstindx
          exit_flag=3
          return
        endif
      enddo
!
!  Write out bed layer sediment properties.
!
      do itrc=1,MBEDP
        scale=1.0_r8
        gtype=gfactor*b3dvar
        status=nf_fwrite(bed(START_2D_ARRAY,1,itrc),scale,ncrstid,
     &                   rstVid(idSbed(itrc)),trstindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idSbed(itrc)))
          write(stdout,10) Vname(1,idSbed(itrc))(1:lsvar), trstindx
          exit_flag=3
          return
        endif
      enddo
# endif
#endif
!
!  Synchronize restart NetCDF file to disk.
!
      status=nf_sync(ncrstid)
      if (status.ne.nf_noerr) then
        write(stdout,20)
        exit_flag=3
        return
      endif
      write(stdout,30) trstindx
!
  10  format(/,' WRT_RST - error while writing variable: ',a,/,11x,
     &       'into restart NetCDF file for time record: ',i4)
  20  format(/,' WRT_RST - unable to synchronize restart NetCDF to ',
     &       'disk.')
  30  format(6x,'WRT_RST - wrote re-start fields into time record = ',
     &       i10.10)
      return
      end
