#include "cppdefs.h"
      subroutine wrt_his
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This routine writes requested model fields at requested levels    !
!  into history NetCDF file.                                         !
!                                                                    !
!=====================================================================
!
      implicit none
#include "param.h"
#include "bbl.h"
#include "forces.h"
#include "grid.h"
#include "iounits.h"
#include "mixing.h"
#include "ncparam.h"
#include "netcdf.inc"
#include "ocean.h"
#include "scalars.h"
#include "scratch.h"
#include "sediment.h"
!
      INTEGER_TYPE
     &        gfactor, gtype, lsvar, status
      INTEGER_TYPE
     &        lenstr, nf_fwrite
#ifdef SOLVE3D
      INTEGER_TYPE
     &        i, itrc, j, k, tile
      REAL_TYPE
     &        wvel(GLOBAL_2D_ARRAY,0:N)
      equivalence (wvel,B3d)
#endif /* SOLVE3D */
      REAL_TYPE
     &        scale
!
!---------------------------------------------------------------------
!  Write out history fields.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
!
!  Set grid type factor to write full (gfactor=1) fields or water
!  points (gfactor=-1) fields only.
!
#if defined WRITE_WATER && defined MASKING
        gfactor=-1
#else
        gfactor=1
#endif
!
!  Set time record index.
!
      thisindx=thisindx+1
      nrechis=nrechis+1
!
!  Write out model time (s).
!
      status=nf_put_var1_FTYPE(nchisid,hisVid(idtime),thisindx,time)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idtime))
        write(stdout,10) Vname(1,idtime)(1:lsvar), thisindx
        exit_flag=3
        return
      endif
!
!  Write out free-surface (m)
!
      if (Hout(idFsur)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(zeta(START_2D_ARRAY,KOUT),scale,nchisid,
     &                   hisVid(idFsur),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idFsur))
          write(stdout,10) Vname(1,idFsur)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 2D momentum component (m/s) in the XI-direction.
!
      if (Hout(idUbar)) then
        scale=1.0_r8
        gtype=gfactor*u2dvar
        status=nf_fwrite(ubar(START_2D_ARRAY,KOUT),scale,nchisid,
     &                   hisVid(idUbar),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbar))
          write(stdout,10) Vname(1,idUbar)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 2D momentum component (m/s) in the ETA-direction.
!
      if (Hout(idVbar)) then
        scale=1.0_r8
        gtype=gfactor*v2dvar
        status=nf_fwrite(vbar(START_2D_ARRAY,KOUT),scale,nchisid,
     &                   hisVid(idVbar),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbar))
          write(stdout,10) Vname(1,idVbar)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
#ifdef SOLVE3D
!
!  Write out 3D momentum component (m/s) in the XI-direction.
!
      if (Hout(idUvel)) then
        scale=1.0_r8
        gtype=gfactor*u3hvar
        status=nf_fwrite(u(START_2D_ARRAY,1,NOUT),scale,nchisid,
     &                   hisVid(idUvel),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUvel))
          write(stdout,10) Vname(1,idUvel)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 3D momentum component (m/s) in the ETA-direction.
!
      if (Hout(idVvel)) then
        scale=1.0_r8
        gtype=gfactor*v3hvar
        status=nf_fwrite(v(START_2D_ARRAY,1,NOUT),scale,nchisid,
     &                   hisVid(idVvel),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVvel))
          write(stdout,10) Vname(1,idVvel)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out S-coordinate omega vertical velocity (m/s).
!
      if (Hout(idOvel)) then
        scale=1.0_r8
        gtype=gfactor*w3hvar
        do k=0,N
          do j=0,M
            do i=0,L
              wvel(i,j,k)=W(i,j,k)*pm(i,j)*pn(i,j)
            enddo
          enddo
        enddo
        status=nf_fwrite(wvel(START_2D_ARRAY,1),scale,nchisid,
     &                   hisVid(idOvel),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idOvel))
          write(stdout,10) Vname(1,idOvel)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out vertical velocity (m/s).
!
      if (Hout(idWvel)) then
        scale=1.0_r8
        gtype=gfactor*w3hvar
        do tile=0,NSUB_X*NSUB_E-1
          call wvelocity (wvel,tile)
        enddo
        status=nf_fwrite(wvel(START_2D_ARRAY,1),scale,nchisid,
     &                   hisVid(idWvel),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idWvel))
          write(stdout,10) Vname(1,idWvel)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out tracer type variables.
!
      do itrc=1,NT
        if (Hout(idTvar(itrc))) then
          scale=1.0_r8
          gtype=gfactor*r3hvar
          status=nf_fwrite(t(START_2D_ARRAY,1,NOUT,itrc),scale,
     &                     nchisid,hisTid(itrc),thisindx,gtype)
          if (status.ne.nf_noerr) then
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            write(stdout,10) Vname(1,idTvar(itrc))(1:lsvar), thisindx
            exit_flag=3
            return
          endif
        endif
      enddo
!
!  Write out density anomaly.
!
      if (Hout(idDano)) then
        scale=1.0_r8
        gtype=gfactor*r3hvar
        status=nf_fwrite(rho(START_2D_ARRAY,1),scale,nchisid,
     &                   hisVid(idDano),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idDano))
          write(stdout,10) Vname(1,idDano)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# ifdef LMD_SKPP
!
!  Write out depth surface boundary layer.
!
      if (Hout(idHsbl)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(hsbl(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idHsbl),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idHsbl))
          write(stdout,10) Vname(1,idHsbl)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# endif /* LMD_SKPP */
# ifdef LMD_BKPP
!
!  Write out depth surface boundary layer.
!
      if (Hout(idHbbl)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(hbbl(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idHbbl),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idHbbl))
          write(stdout,10) Vname(1,idHbbl)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# endif /* LMD_BKPP */
!
!  Write out vertical viscosity coefficient.
!
      if (Hout(idVvis)) then
        scale=1.0_r8
        gtype=gfactor*w3hvar
        status=nf_fwrite(Akv(START_2D_ARRAY,1),scale,nchisid,
     &                   hisVid(idVvis),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVvis))
          write(stdout,10) Vname(1,idVvis)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out vertical diffusion coefficient for potential temperature.
!
      if (Hout(idTdif)) then
        scale=1.0_r8
        gtype=gfactor*w3hvar
        status=nf_fwrite(Akt(START_2D_ARRAY,1,itemp),scale,nchisid,
     &                   hisVid(idTdif),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idTdif))
          write(stdout,10) Vname(1,idTdif)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# ifdef SALINITY
!
!  Write out vertical diffusion coefficient for salinity.
!
      if (Hout(idSdif)) then
        scale=1.0_r8
        gtype=gfactor*w3hvar
        status=nf_fwrite(Akt(START_2D_ARRAY,1,isalt),scale,nchisid,
     &                   hisVid(idSdif),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idSdif))
          write(stdout,10) Vname(1,idSdif)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# endif /* SALINITY */
# if defined MY25_MIXING || defined GLS_MIXING
!
!  Write out turbulent kinetic energy.
!
      if (Hout(idMtke)) then
        scale=1.0_r8
        gtype=gfactor*w3hvar
        status=nf_fwrite(tke(START_2D_ARRAY,1,NOUT),scale,nchisid,
     &                   hisVid(idMtke),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idMtke))
          write(stdout,10) Vname(1,idMtke)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out turbulent length scale field.
!
      if (Hout(idMtls)) then
        scale=1.0_r8
        gtype=gfactor*w3hvar
        status=nf_fwrite(gls(START_2D_ARRAY,1,NOUT),scale,nchisid,
     &                   hisVid(idMtls),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idMtls))
          write(stdout,10) Vname(1,idMtls)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# endif /* GLS_MIXING || MY25_MIXING */
!
!  Write out surface net heat flux.
!
      if (Hout(idTsur(itemp))) then
        scale=rho0*Cp
        gtype=gfactor*r2dvar
        status=nf_fwrite(stflx(START_2D_ARRAY,itemp),scale,nchisid,
     &                   hisVid(idTsur(itemp)),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idTsur(itemp)))
          write(stdout,10) Vname(1,idTsur(itemp))(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# ifdef BULK_FLUXES
!
!  Write out latent heat flux.
!
      if (Hout(idLhea)) then
        scale=rho0*Cp
        gtype=gfactor*r2dvar
        status=nf_fwrite(lhflx(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idLhea),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idLhea))
          write(stdout,10) Vname(1,idLhea)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out sensible heat flux.
!
      if (Hout(idShea)) then
        scale=rho0*Cp
        gtype=gfactor*r2dvar
        status=nf_fwrite(shflx(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idShea),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idShea))
          write(stdout,10) Vname(1,idShea)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out longwave radiation flux.
!
      if (Hout(idLrad)) then
        scale=rho0*Cp
        gtype=gfactor*r2dvar
        status=nf_fwrite(lrflx(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idLrad),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idLrad))
          write(stdout,10) Vname(1,idLrad)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# endif /* BULK_FLUXES */
# ifdef SHORTWAVE
!
!  Write out shortwave radiation flux.
!
      if (Hout(idSrad)) then
        scale=rho0*Cp
        gtype=gfactor*r2dvar
        status=nf_fwrite(srflx(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idSrad),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idSrad))
          write(stdout,10) Vname(1,idSrad)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
# endif /* SHORTWAVE */
#endif /* SOLVE3D */
!
!  Write out surface U-momentum stress.
!
      if (Hout(idUsms)) then
        scale=rho0
        gtype=gfactor*u2dvar
        status=nf_fwrite(sustr(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idUsms),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUsms))
          write(stdout,10) Vname(1,idUsms)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out surface V-momentum stress.
!
      if (Hout(idVsms)) then
        scale=rho0
        gtype=gfactor*v2dvar
        status=nf_fwrite(svstr(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idVsms),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVsms))
          write(stdout,10) Vname(1,idVsms)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bottom U-momentum stress.
!
      if (Hout(idUbms)) then
        scale=-rho0
        gtype=gfactor*u2dvar
        status=nf_fwrite(bustr(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idUbms),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbms))
          write(stdout,10) Vname(1,idUbms)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bottom V-momentum stress.
!
      if (Hout(idVbms)) then
        scale=-rho0
        gtype=gfactor*v2dvar
        status=nf_fwrite(bvstr(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idVbms),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbms))
          write(stdout,10) Vname(1,idVbms)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
#ifdef BBL
!
!  Write out wind-induced, bottom U-wave stress.
!
      if (Hout(idUbws)) then
        scale=rho0
        gtype=gfactor*u2dvar
        status=nf_fwrite(bustrw(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idUbws),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbws))
          write(stdout,10) Vname(1,idUbws)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out wind-induced, bottom V-wave stress.
!
      if (Hout(idVbws)) then
        scale=rho0
        gtype=gfactor*v2dvar
        status=nf_fwrite(bvstrw(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idVbws),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbws))
          write(stdout,10) Vname(1,idVbws)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out wind-induced, bed wave excursion amplitude.
!
      if (Hout(idAbed)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(Abed(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idAbed),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idAbed))
          write(stdout,10) Vname(1,idAbed)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out wind-induced, bed wave orbital U-velocity.
!
      if (Hout(idUbed)) then
        scale=1.0_r8
        gtype=gfactor*u2dvar
        status=nf_fwrite(Ubed(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idUbed),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbed))
          write(stdout,10) Vname(1,idUbed)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out wind-induced, bed wave orbital V-velocity.
!
      if (Hout(idVbed)) then
        scale=1.0_r8
        gtype=gfactor*v2dvar
        status=nf_fwrite(Vbed(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idVbed),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbed))
          write(stdout,10) Vname(1,idVbed)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bottom U-momentum above bed.
!
      if (Hout(idUbot)) then
        scale=1.0_r8
        gtype=gfactor*u2dvar
        status=nf_fwrite(Ubot(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idUbot),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbot))
          write(stdout,10) Vname(1,idUbot)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bottom V-momentum above bed.
!
      if (Hout(idVbot)) then
        scale=1.0_r8
        gtype=gfactor*v2dvar
        status=nf_fwrite(Vbot(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idVbot),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbot))
          write(stdout,10) Vname(1,idVbot)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bed ripple height.
!
      if (Hout(idHrip)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(Hripple(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idHrip),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idHrip))
          write(stdout,10) Vname(1,idHrip)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out bed ripple length.
!
      if (Hout(idLrip)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(Lripple(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idLrip),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idLrip))
          write(stdout,10) Vname(1,idLrip)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out hydraulic bottom roughness.
!
      if (Hout(idZnot)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(Zbnot(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idZnot),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idZnot))
          write(stdout,10) Vname(1,idZnot)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out apparent hydraulic bottom roughness.
!
      if (Hout(idZapp)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(Zbnotc(START_2D_ARRAY),scale,nchisid,
     &                   hisVid(idZapp),thisindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idZapp))
          write(stdout,10) Vname(1,idZapp)(1:lsvar), thisindx
          exit_flag=3
          return
        endif
      endif
#endif /* BBL */
#ifdef SEDIMENT
!
!  Write out bed layer sediment fraction for each size class.
!
      do i=1,NST
        if (Hout(idfrac(i))) then
          scale=1.0_r8
          gtype=gfactor*b3dvar
          status=nf_fwrite(bed_frac(START_2D_ARRAY,1,i),scale,nchisid,
     &                     hisVid(idfrac(i)),thisindx,gtype)
          if (status.ne.nf_noerr) then
            lsvar=lenstr(Vname(1,idfrac(i)))
            write(stdout,10) Vname(1,idfrac(i))(1:lsvar), thisindx
            exit_flag=3
            return
          endif
        endif
      enddo
!
!  Write out bed layer sediment properties.
!
      do i=1,MBEDP
        if (Hout(idSbed(i))) then
          scale=1.0_r8
          gtype=gfactor*b3dvar
          status=nf_fwrite(bed(START_2D_ARRAY,1,i),scale,nchisid,
     &                     hisVid(idSbed(i)),thisindx,gtype)
          if (status.ne.nf_noerr) then
            lsvar=lenstr(Vname(1,idSbed(i)))
            write(stdout,10) Vname(1,idSbed(i))(1:lsvar), thisindx
            exit_flag=3
            return
          endif
        endif
      enddo
!
!  Write out bottom sediment properties.
!
      do i=1,MBOTP
        if (Hout(idBott(i))) then
          scale=1.0_r8
          gtype=gfactor*r2dvar
          status=nf_fwrite(bottom(START_2D_ARRAY,i),scale,nchisid,
     &                     hisVid(idBott(i)),thisindx,gtype)
          if (status.ne.nf_noerr) then
            lsvar=lenstr(Vname(1,idBott(i)))
            write(stdout,10) Vname(1,idBott(i))(1:lsvar), thisindx
            exit_flag=3
            return
          endif
        endif
      enddo
#endif /* SEDIMENT */
!
!  Synchronize restart NetCDF file to disk to allow other processes
!  to access data immediately after it is written.
!
      status=nf_sync(nchisid)
      if (status.ne.nf_noerr) then
        write(stdout,20)
        exit_flag=3
        return
      endif
      write(stdout,30) thisindx
!
  10  format(/,' WRT_HIS - error while writing variable: ',a,/,11x,
     &       'into history NetCDF file for time record: ',i4)
  20  format(/,' WRT_HIS - unable to synchronize history NetCDF to ',
     &       'disk.')
  30  format(6x,'WRT_HIS - wrote history  fields into time record = ',
     &       i10.10)
      return
      end
