#include "cppdefs.h"
      subroutine wrt_floats
#ifdef FLOATS
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine writes simulated drifter trajectories into floats !
!  NetCDF file.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "floats.h"
# include "grid.h"
# include "iounits.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "ocean.h"
# include "scalars.h"
# include "scratch.h"
!
      INTEGER_TYPE
     &        iflt, lsvar, status
      INTEGER_TYPE
     &        start(2), count(2)
      INTEGER_TYPE
     &        lenstr
      REAL_TYPE
     &        Tout(Mfloats)
# ifdef SOLVE3D
      INTEGER_TYPE
     &        itrc
# endif
!
!---------------------------------------------------------------------
!  Write out station data at RHO-points.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
!
!  Set time record index.
!
      tfltindx=tfltindx+1
      nrecflt=nrecflt+1
!
      start(1)=1
      count(1)=nfloats
      start(2)=tfltindx
      count(2)=1
!
!  Write out model time (s).
!
      status=nf_put_var1_FTYPE(ncfltid,fltVid(idtime),tfltindx,time)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idtime))
        write(stdout,10) Vname(1,idtime)(1:lsvar), tfltindx
        exit_flag=3
        return
      endif
!
!  Write out floats X-grid locations.
!
      do iflt=1,nfloats
        if (bounded(iflt)) then
          Tout(iflt)=track(ixgrd,nf,iflt)
        else
          Tout(iflt)=spval
        endif
      enddo
      status=nf_put_vara_FTYPE(ncfltid,fltVid(idXgrd),start,count,
     &                         Tout)
      if (status.ne.nf_noerr) then
        write(stdout,10) 'Xgrid', tfltindx
        exit_flag=3
        return
      endif
!
!  Write out floats Y-grid locations.
!
      do iflt=1,nfloats
        if (bounded(iflt)) then
          Tout(iflt)=track(iygrd,nf,iflt)
        else
          Tout(iflt)=spval
        endif
      enddo
      status=nf_put_vara_FTYPE(ncfltid,fltVid(idYgrd),start,count,
     &                         Tout)
      if (status.ne.nf_noerr) then
        write(stdout,10) 'Ygrid', tfltindx
        exit_flag=3
        return
      endif
# ifdef SOLVE3D
!
!  Write out floats Z-grid locations.
!
      do iflt=1,nfloats
        if (bounded(iflt)) then
          Tout(iflt)=track(izgrd,nf,iflt)
        else
          Tout(iflt)=spval
        endif
      enddo
      status=nf_put_vara_FTYPE(ncfltid,fltVid(idZgrd),start,count,
     &                         Tout)
      if (status.ne.nf_noerr) then
        write(stdout,10) 'Zgrid', tfltindx
        exit_flag=3
        return
      endif
# endif /* SOLVE3D */
!
!  Write out floats (lon,lat) or (x,y) locations.
!
      do iflt=1,nfloats
        Tout(iflt)=track(iflon,nf,iflt)
      enddo
      status=nf_put_vara_FTYPE(ncfltid,fltVid(idglon),start,count,
     &                         Tout)
      if (status.ne.nf_noerr) then
        if (spherical) then
          write(stdout,10) 'lon', tfltindx
        else
          write(stdout,10) 'x', tfltindx
        endif
        exit_flag=3
        return
      endif
      do iflt=1,nfloats
        Tout(iflt)=track(iflat,nf,iflt)
      enddo
      status=nf_put_vara_FTYPE(ncfltid,fltVid(idglat),start,count,
     &                         Tout)
      if (status.ne.nf_noerr) then
        if (spherical) then
          write(stdout,10) 'lat', tfltindx
        else
          write(stdout,10) 'y', tfltindx
        endif
        exit_flag=3
        return
      endif
# ifdef SOLVE3D
!
!  Write out floats depths.
!
      do iflt=1,nfloats
        if (bounded(iflt)) then
          Tout(iflt)=track(idpth,nf,iflt)
        else
          Tout(iflt)=spval
        endif
      enddo
      status=nf_put_vara_FTYPE(ncfltid,fltVid(iddpth),start,count,
     &                         Tout)
      if (status.ne.nf_noerr) then
        write(stdout,10) 'depth', tfltindx
        exit_flag=3
        return
      endif
!
!  Write out density anomaly.
!
      do iflt=1,nfloats
        if (bounded(iflt)) then
          Tout(iflt)=track(ifden,nf,iflt)
        else
          Tout(iflt)=spval
        endif
      enddo
      status=nf_put_vara_FTYPE(ncfltid,fltVid(idDano),start,count,
     &                         Tout)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idDano))
        write(stdout,10) Vname(1,idDano)(1:lsvar), tfltindx
        exit_flag=3
        return
      endif
!
!  Write out tracer type variables.
!
      do itrc=1,NT
        do iflt=1,nfloats
          if (bounded(iflt)) then
            Tout(iflt)=track(itrc+10,nf,iflt)
          else
            Tout(iflt)=spval
          endif
        enddo
        status=nf_put_vara_FTYPE(ncfltid,fltTid(itrc),start,count,
     &                           Tout)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idTvar(itrc)))
          write(stdout,10) Vname(1,idTvar(itrc))(1:lsvar), tfltindx
          exit_flag=3
          return
        endif
      enddo
# endif /* SOLVE3D */
!
!  Synchronize float NetCDF file to disk.
!
      status=nf_sync(ncfltid)
      if (status.ne.nf_noerr) then
        write(stdout,20)
        exit_flag=3
        return
      endif
!
  10  format(/,' WRT_FLOATS - error while writing variable: ',a,/,
     &       14x,'into floats NetCDF file for time record: ',i4)
  20  format(/,' WRT_FLOATS - unable to synchronize stations',
     &       1x,'NetCDF file to disk.')
#endif /* FLOATS */
      return
      end
