#include "cppdefs.h"
      subroutine wrt_avg
#ifdef AVERAGES
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine writes model time-averaged fields into averages   !
!  NetCDF file.                                                      !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "averages.h"
# include "iounits.h"
# include "ncparam.h"
# include "netcdf.inc"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        gfactor, gtype, lsvar, status
# ifdef SOLVE3D
      INTEGER_TYPE
     &        itrc
# endif

      INTEGER_TYPE
     &        lenstr, nf_fwrite
      REAL_TYPE
     &        scale
!
!---------------------------------------------------------------------
!  Write out time-averaged fields when appropriate.
!---------------------------------------------------------------------
!
      if (exit_flag.ne.0) return
!
!  Set grid type factor to write full (gfactor=1) fields or water
!  points (gfactor=-1) fields only.
!
# if defined WRITE_WATER && defined MASKING
        gfactor=-1
# else
        gfactor=1
# endif
!
!  Set time record index.
!
      tavgindx=tavgindx+1
      nrecavg=nrecavg+1
!
!  Write out averaged time.
!
      status=nf_put_var1_FTYPE(ncavgid,avgVid(idtime),tavgindx,
     &                         avgtime)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idtime))
        write(stdout,10) Vname(1,idtime)(1:lsvar), tavgindx
        exit_flag=3
        return
      endif
!
! Write out free-surface (m).
!
      if (Hout(idFsur)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(avgzeta(START_2D_ARRAY),scale,ncavgid,
     &                   avgVid(idFsur),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idFsur))
          write(stdout,10) Vname(1,idFsur)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 2D momentum component (m/s) in the XI-direction.
!
      if (Hout(idUbar)) then
        scale=1.0_r8
        gtype=gfactor*u2dvar
        status=nf_fwrite(avgu2d(START_2D_ARRAY),scale,ncavgid,
     &                   avgVid(idUbar),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUbar))
          write(stdout,10) Vname(1,idUbar)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 2D momentum component (m/s) in the ETA-direction.
!
      if (Hout(idVbar)) then
        scale=1.0_r8
        gtype=gfactor*v2dvar
        status=nf_fwrite(avgv2d(START_2D_ARRAY),scale,ncavgid,
     &                   avgVid(idVbar),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVbar))
          write(stdout,10) Vname(1,idVbar)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
# ifdef SOLVE3D
!
!  Write out 3D momentum component (m/s) in the XI-direction.
!
      if (Hout(idUvel)) then
        scale=1.0_r8
        gtype=gfactor*u3dvar
        status=nf_fwrite(avgu3d(START_2D_ARRAY,1),scale,ncavgid,
     &                   avgVid(idUvel),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idUvel))
          write(stdout,10) Vname(1,idUvel)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out 3D momentum component (m/s) in the ETA-direction.
!
      if (Hout(idVvel)) then
        scale=1.0_r8
        gtype=gfactor*v3dvar
        status=nf_fwrite(avgv3d(START_2D_ARRAY,1),scale,ncavgid,
     &                   avgVid(idVvel),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idVvel))
          write(stdout,10) Vname(1,idVvel)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out S-coordinate omega vertical velocity (m/s).
!
      if (Hout(idOvel)) then
        scale=1.0_r8
        gtype=gfactor*r3dvar
        status=nf_fwrite(avgw3d(START_2D_ARRAY,1),scale,ncavgid,
     &                   avgVid(idOvel),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idOvel))
          write(stdout,10) Vname(1,idOvel)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
!
!  Write out tracer type variables.
!
      do itrc=1,NT
        if (Hout(idTvar(itrc))) then
          scale=1.0_r8
          gtype=gfactor*r3dvar
          status=nf_fwrite(avgt(START_2D_ARRAY,1,itrc),scale,ncavgid,
     &                     avgTid(itrc),tavgindx,gtype)
          if (status.ne.nf_noerr) then
            lsvar=lenstr(Vname(1,idTvar(itrc)))
            write(stdout,10) Vname(1,idTvar(itrc))(1:lsvar), tavgindx
            exit_flag=3
            return
          endif
        endif
      enddo
!
!  Write out density anomaly.
!
      if (Hout(idDano)) then
        scale=1.0_r8
        gtype=gfactor*r3dvar
        status=nf_fwrite(avgrho(START_2D_ARRAY,1),scale,ncavgid,
     &                   avgVid(idDano),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idDano))
          write(stdout,10) Vname(1,idDano)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
#  ifdef LMD_SKPP
!
!  Write out depth of surface boundary layer.
!
      if (Hout(idHsbl)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(avghsbl(START_2D_ARRAY),scale,ncavgid,
     &                   avgVid(idHsbl),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idHsbl))
          write(stdout,10) Vname(1,idHsbl)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
#  endif
#  ifdef LMD_BKPP
!
!  Write out depth of bottom boundary layer.
!
      if (Hout(idHbbl)) then
        scale=1.0_r8
        gtype=gfactor*r2dvar
        status=nf_fwrite(avghbbl(START_2D_ARRAY),scale,ncavgid,
     &                   avgVid(idHbbl),tavgindx,gtype)
        if (status.ne.nf_noerr) then
          lsvar=lenstr(Vname(1,idHbbl))
          write(stdout,10) Vname(1,idHbbl)(1:lsvar), tavgindx
          exit_flag=3
          return
        endif
      endif
#  endif
#  ifdef AVERAGES_AKV
!
!  Write out vertical viscosity coefficient.
!
      scale=1.0_r8
      gtype=gfactor*w3dvar
      status=nf_fwrite(avgAKv(START_2D_ARRAY,0),scale,ncavgid,
     &                 avgVid(idVvis),tavgindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idVvis))
        write(stdout,10) Vname(1,idVvis)(1:lsvar), tavgindx
        exit_flag=3
        return
      endif
#  endif
#  ifdef AVERAGES_AKT
!
!  Write out vertical diffusion coefficient for potential temperature.
!
      scale=1.0_r8
      gtype=gfactor*w3dvar
      status=nf_fwrite(avgAKt(START_2D_ARRAY,0),scale,ncavgid,
     &                 avgVid(idTdif),tavgindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idTdif))
        write(stdout,10) Vname(1,idTdif)(1:lsvar), tavgindx
        exit_flag=3
        return
      endif
#  endif
#  ifdef AVERAGES_AKS
!
!  Write out vertical diffusion coefficient for salinity.
!
      scale=1.0_r8
      gtype=gfactor*w3dvar
      status=nf_fwrite(avgAKs(START_2D_ARRAY,0),scale,ncavgid,
     &                 avgVid(idSdif),tavgindx,gtype)
      if (status.ne.nf_noerr) then
        lsvar=lenstr(Vname(1,idSdif))
        write(stdout,10) Vname(1,idSdif)(1:lsvar), tavgindx
        exit_flag=3
        return
      endif
#  endif
# endif /* SOLVE3D */
!
!  Synchronize restart NetCDF file to disk to allow other processes
!  to access data immediately after it is written.
!
      status=nf_sync(ncavgid)
      if (status.ne.nf_noerr) then
        write(stdout,20)
        exit_flag=3
        return
      endif
      write(stdout,30) tavgindx
!
  10  format(/,' WRT_AVG - error while writing variable: ',a,/,11x,
     &       'into averages NetCDF file for time record: ',i4)
  20  format(/,' WRT_AVG - unable to synchronize averages NetCDF to ',
     &       'disk.')
  30  format(6x,'WRT_AVG - wrote averaged fields into time record = ',
     &       i10.10)
#endif /* AVERAGES */
      return
      end
