/*
** Include file "wclock.h"
**********************************************************************
** Copyright (c) 2002 Rutgers/UCLA                                  **
************************************************* Hernan G. Arango ***
**                                                                  **
** lock      Lock flag used for parallel threads in critical areas. **
** trd_count Parallel threads counter.                              **
** proc      Parallel process ID.                                   **
** CPUtime   Elapsed time for region and parallel thread.           **
** Pregion   Model regions identifiers used for time profiling.     **
**                                                                  **
**********************************************************************
*/

      common /my_lock/
     &        lock,              trd_count
      POINTER_TYPE
     &        lock
      INTEGER_TYPE
     &        trd_count

      common /Iwclock/
     &        proc
      INTEGER_TYPE
     &        proc(0:1)
!$OMP THREADPRIVATE (/Iwclock/)

      common /Fwclock/
     &        Cend,              Cstr
      REAL_TYPE
     &        Cend(0:35),        Cstr(0:35)
!$OMP THREADPRIVATE (/Fwclock/)

      common /wclock/
     &        Csum
      REAL_TYPE
     &        Csum(0:35)

#ifdef PROFILE
      common /Cwclock/
     &        Pregion
      character*50 Pregion(35)
#endif
