#include "cppdefs.h"
#ifdef SOLVE3D
      subroutine w3dbc_tile (Istr,Iend,Jstr,Jend)
!
!=====================================================================
!  Copyright (c) 2002 Rutgers/UCLA                                   !
!================================================ Hernan G. Arango ===
!                                                                    !
!  This subroutine sets lateral boundary conditions for the omega    !
!  vertical velocity.                                                !
!                                                                    !
!=====================================================================
!
      implicit none
# include "param.h"
# include "ocean.h"
# include "scalars.h"
!
      INTEGER_TYPE
     &        Iend, Istr, Jend, Jstr, i, j, k
!
# include "set_bounds.h"
!
      i=0
      j=0
      k=0
!
# ifndef EW_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the western and eastern edges.
!---------------------------------------------------------------------
!
      if (WESTERN_EDGE) then
        do k=0,N
          do j=Jstr,Jend
            W(0,j,k)=W(1,j,k)
          enddo
        enddo
      endif
      if (EASTERN_EDGE) then
        do k=0,N
          do j=Jstr,Jend
            W(L,j,k)=W(Lm,j,k)
          enddo
        enddo
      endif
# endif
# ifndef NS_PERIODIC
!
!---------------------------------------------------------------------
!  Lateral boundary conditions at the southern and northern edges.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE) then
        do k=0,N
          do i=Istr,Iend
            W(i,0,k)=W(i,1,k)
          enddo
        enddo
      endif
      if (NORTHERN_EDGE) then
        do k=0,N
          do i=Istr,Iend
            W(i,M,k)=W(i,Mm,k)
          enddo
        enddo
      endif
# endif
# if !defined EW_PERIODIC && !defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Boundary corners.
!---------------------------------------------------------------------
!
      if (SOUTHERN_EDGE .and. WESTERN_EDGE) then
        do k=0,N
          W(0,0,k)=0.5_r8*(W(1,0,k)+W(0,1,k))
        enddo
      endif
      if (SOUTHERN_EDGE .and. EASTERN_EDGE) then
        do k=0,N
          W(L,0,k)=0.5_r8*(W(Lm,0,k)+W(L,1,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. WESTERN_EDGE) then
        do k=0,N
          W(0,M,k)=0.5_r8*(W(1,M,k)+W(0,Mm,k))
        enddo
      endif
      if (NORTHERN_EDGE .and. EASTERN_EDGE) then
        do k=0,N
          W(L,M,k)=0.5_r8*(W(Lm,M,k)+W(L,Mm,k))
        enddo
      endif
# endif
# if defined EW_PERIODIC || defined NS_PERIODIC
!
!---------------------------------------------------------------------
!  Set periodic boundary conditions.
!---------------------------------------------------------------------
!
      call exchange_w3d_tile (Istr,Iend,Jstr,Jend,W)
# endif
#else
      subroutine w3dbc
#endif /* SOLVE3D */
      return
      end
